
    create table ACQUISITION_LEVEL (
        CODE VARCHAR(40) not null,
        NAME VARCHAR(100) not null,
        UPDATE_DATE TIMESTAMP,
        primary key (CODE)
    );

    create table ACTIVITY_CALENDAR (
        ID integer not null,
        SYNCHRONIZATION_STATUS VARCHAR(256) not null,
        YEAR INTEGER(4) not null,
        DIRECT_SURVEY_INVESTIGATION BIT not null,
        COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        RECORDER_DEPARTMENT_FK integer not null,
        RECORDER_PERSON_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        VESSEL_FK VARCHAR(12) not null,
        PROGRAM_FK VARCHAR(40) not null,
        FISHING_EFFORT_CALENDAR_FK integer,
        primary key (ID)
    );

    create table AGE_READER_QUAL2LOCATION (
        AGE_READER_QUALIFICATION_FK integer not null,
        LOCATION_FK integer not null,
        primary key (AGE_READER_QUALIFICATION_FK, LOCATION_FK)
    );

    create table AGE_READER_QUAL2PERSON (
        AGE_READER_QUALIFICATION_FK integer not null,
        PERSON_FK integer not null,
        primary key (AGE_READER_QUALIFICATION_FK, PERSON_FK)
    );

    create table AGE_READER_QUALIFICATION (
        ID integer not null,
        START_DATE TIMESTAMP not null,
        END_DATE TIMESTAMP,
        QUALIFICATION_LEVEL integer not null,
        REFERENCE_TAXON_FK integer not null,
        primary key (ID)
    );

    create table AGGREGATION_LEVEL (
        ID integer not null,
        NAME VARCHAR(100) not null,
        RANK_ORDER integer not null,
        UPDATE_DATE TIMESTAMP,
        primary key (ID)
    );

    create table ANALYSIS_INSTRUMENT (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table APPLIED_PERIOD (
        START_DATE TIMESTAMP not null,
        APPLIED_STRATEGY_FK integer not null,
        END_DATE TIMESTAMP not null,
        primary key (START_DATE, APPLIED_STRATEGY_FK)
    );

    create table APPLIED_QUALIFICATION_RULE (
        ID integer not null,
        MESSAGE VARCHAR(255) not null,
        REMOTE_ID integer,
        PROCESSING_HISTORY_FK integer not null,
        QUALIFIED_ITEM_FK integer not null,
        QUALIFICATION_RULE_FK integer not null,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table APPLIED_SIZE_CATEGORY (
        ID integer not null,
        START_DATE TIMESTAMP not null,
        END_DATE TIMESTAMP,
        DESCRIPTION VARCHAR(255),
        COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        SIZE_CATEGORY_FK integer not null,
        LOCATION_FK integer not null,
        DRESSING_FK integer not null,
        TAXON_GROUP_FK integer not null,
        primary key (ID)
    );

    create table APPLIED_STRATEGY (
        ID integer not null,
        STRATEGY_FK integer not null,
        LOCATION_FK integer not null,
        primary key (ID)
    );

    create table AUTHOR (
        ID integer not null,
        NAME VARCHAR(255),
        LOCATION VARCHAR(255),
        COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table BATCH (
        ID integer not null,
        IS_CATCH_BATCH integer not null,
        RANK_ORDER SMALLINT not null,
        SUBGROUP_COUNT REAL,
        INDIVIDUAL_COUNT integer,
        CHILD_BATCHS_REPLICATION BIT not null,
        EXHAUSTIVE_INVENTORY BIT not null,
        COMMENTS VARCHAR(2000),
        LABEL VARCHAR(40),
        REMOTE_ID integer,
        LOCATION_FK integer,
        PARENT_BATCH_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        SYNCHRONIZATION_STATUS VARCHAR(256),
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        SAMPLING_RATIO REAL,
        SAMPLING_RATIO_TEXT VARCHAR(50),
        REFERENCE_TAXON_FK integer,
        ROOT_BATCH_FK integer,
        TAXON_GROUP_FK integer,
        primary key (ID)
    );

    create table BATCH_EXHAUSTIVE_INVENTORY (
        ID integer not null,
        PRIORITY_LEVEL SMALLINT not null,
        REMOTE_ID integer,
        BATCH_FK integer not null,
        primary key (ID)
    );

    create table BATCH_MODEL (
        ID integer not null,
        NAME VARCHAR(100) not null,
        IS_GLOBAL BIT not null,
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        CATCH_BATCH_FK integer not null,
        RECORDER_PERSON_FK integer,
        RECORDER_DEPARTMENT_FK integer not null,
        primary key (ID)
    );

    create table BATCH_MODEL_APPLIED_STRATEGY (
        APPLIED_STRATEGY_FK integer not null,
        ACQUISITION_LEVEL_FK VARCHAR(40) not null,
        BATCH_MODEL_FK integer not null,
        primary key (APPLIED_STRATEGY_FK, ACQUISITION_LEVEL_FK)
    );

    create table BUYER (
        ID integer not null,
        REGISTRATION_CODE VARCHAR(40),
        NAME VARCHAR(100),
        STREET VARCHAR(255),
        ZIP_CODE VARCHAR(255),
        CITY VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        BUYER_TYPE_FK SMALLINT not null,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table BUYER_TYPE (
        ID SMALLINT not null,
        NAME VARCHAR(100) not null,
        LABEL VARCHAR(40),
        primary key (ID)
    );

    create table CITATION (
        ID integer not null,
        NAME VARCHAR(255) not null,
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table CORPUS (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        START_DATE TIMESTAMP not null,
        END_DATE TIMESTAMP,
        UPDATE_DATE TIMESTAMP,
        CORPUS_TYPE_FK integer not null,
        primary key (ID)
    );

    create table CORPUS2FISHERY (
        CORPUS_FK integer not null,
        FISHERY_FK integer not null,
        primary key (FISHERY_FK, CORPUS_FK)
    );

    create table CORPUS_TYPE (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        primary key (ID)
    );

    create table DAILY_ACTIVITY_CALENDAR (
        ID integer not null,
        SYNCHRONIZATION_STATUS VARCHAR(256) not null,
        START_DATE TIMESTAMP not null,
        END_DATE TIMESTAMP not null,
        COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        OBSERVED_LOCATION_FK integer,
        RECORDER_PERSON_FK integer,
        RECORDER_DEPARTMENT_FK integer not null,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        VESSEL_FK VARCHAR(12) not null,
        PROGRAM_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table DECLARED_DOCUMENT_REFERENCE (
        ID integer not null,
        SYNCHRONIZATION_STATUS VARCHAR(256) not null,
        REFERENCE VARCHAR(100),
        FILE_NAME VARCHAR(255),
        DOCUMENT_DATE TIMESTAMP not null,
        OTHER_DOCUMENT_REFERENCE VARCHAR(255),
        FIRST_SHEET_NUMBER VARCHAR(40),
        LAST_SHEET_NUMBER VARCHAR(20),
        SHEET_COUNT SMALLINT,
        COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        PARENT_FK integer,
        RECORDER_DEPARTMENT_FK integer not null,
        RECORDER_PERSON_FK integer,
        PROGRAM_FK VARCHAR(40) not null,
        VESSEL_FK VARCHAR(12) not null,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table DELETED_ITEM_HISTORY (
        ID BIGINT not null,
        VESSEL_FK VARCHAR(12),
        OBJECT_ID BIGINT,
        COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        OBJECT_CODE VARCHAR(40),
        REMOTE_ID integer,
        OBJECT_TYPE_FK VARCHAR(40) not null,
        PROGRAM_FK VARCHAR(40),
        RECORDER_DEPARTMENT_FK integer,
        RECORDER_PERSON_FK integer,
        PROCESSING_HISTORY_FK integer,
        primary key (ID)
    );

    create table DENORMALIZED_BATCH (
        ID BIGINT not null,
        RANK_ORDER SMALLINT not null,
        FLAT_RANK_ORDER SMALLINT not null,
        WEIGHT REAL,
        INDIRECT_WEIGHT REAL,
        ELEVATE_WEIGHT REAL,
        INDIVIDUAL_COUNT integer,
        INDIRECT_INDIVIDUAL_COUNT integer,
        ELEVATE_INDIVIDUAL_COUNT integer,
        ELEVATE_CONTEXT_WEIGHT REAL,
        INDIRECT_CONTEXT_WEIGHT REAL,
        SAMPLING_RATIO REAL,
        SAMPLING_RATIO_TEXT VARCHAR(50),
        EXHAUSTIVE_INVENTORY BIT,
        CHILD_BATCHS_REPLICATION BIT,
        COMMENTS VARCHAR(2000),
        TREE_LEVEL SMALLINT not null,
        TREE_INDENT VARCHAR(256),
        SORTING_VALUES_TEXT VARCHAR(255),
        IS_LANDING BIT not null,
        IS_DISCARD BIT not null,
        UPDATE_DATE TIMESTAMP,
        LABEL VARCHAR(40),
        REMOTE_ID integer,
        WEIGHT_METHOD_FK integer,
        SALE_FK integer,
        INHERITED_TAXON_GROUP_FK integer,
        CALCULATED_TAXON_GROUP_FK integer,
        INHERITED_REFERENCE_TAXON_FK integer,
        PARENT_BATCH_FK BIGINT,
        OPERATION_FK integer,
        REFERENCE_TAXON_FK integer,
        TAXON_GROUP_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table DENORMALIZED_BATCH_SORT_VAL (
        ID integer not null,
        RANK_ORDER integer not null,
        IS_INHERITED BIT not null,
        NUMERICAL_VALUE REAL,
        REMOTE_ID integer,
        PMFM_FK integer not null,
        UNIT_FK integer not null,
        BATCH_FK BIGINT not null,
        QUALITATIVE_VALUE_FK integer,
        PARAMETER_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table DENORMALIZED_OPERATION (
        ID BIGINT not null,
        RANK_ORDER SMALLINT not null,
        IS_LANDING_SAMPLING BIT not null,
        IS_DISCARD_SAMPLING BIT not null,
        GEAR_MESH_SIZE REAL,
        GEAR_DEPTH REAL,
        MAIN_WATER_DEPTH REAL,
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        FISHING_TRIP_FK integer not null,
        SELECTIVE_DEVICE_FK integer,
        RECTANGLE_LOCATION_FK integer,
        AREA_LOCATION_FK integer,
        SUBPOLYGON_LOCATION_FK integer,
        GEAR_FK integer,
        METIER_FK integer,
        primary key (ID)
    );

    create table DENORMALIZED_SAMPLING_STRATA (
        ID integer not null,
        LABEL VARCHAR(40) not null,
        START_DATE TIMESTAMP,
        END_DATE TIMESTAMP,
        DESCRIPTION VARCHAR(255),
        COMMENTS VARCHAR(2000),
        OBSERVATION_LOCATION_COMMENTS VARCHAR(100),
        SAMPLING_STRATEGY VARCHAR(100),
        TAXON_GROUP_NAME VARCHAR(100),
        SAMPLING_SCHEME_LABEL VARCHAR(40) not null,
        SAMPLING_SCHEME_NAME VARCHAR(100) not null,
        SAMPLING_SCHEME_DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        GEAR_MESH_RANGE VARCHAR(100),
        VESSEL_LENGTH_RANGE VARCHAR(100),
        METIER VARCHAR(255),
        AREA_NAME VARCHAR(100),
        SUB_AREA_LOCATION_IDS VARCHAR(255),
        PERSON_FK integer,
        OBSERVATION_LOCATION_FK integer,
        PROGRAM_FK VARCHAR(40) not null,
        DEPARTMENT_FK integer,
        primary key (ID)
    );

    create table DENORMALIZED_VESSEL (
        ID integer not null,
        REGISTRATION_START_DATE TIMESTAMP not null,
        REGISTRATION_END_DATE TIMESTAMP,
        NAME VARCHAR(100),
        REGISTRATION_CODE VARCHAR(40),
        INT_REGISTRATION_CODE VARCHAR(40),
        EXTERIOR_MARKING VARCHAR(100),
        RANK_ORDER SMALLINT not null,
        UPDATE_DATE TIMESTAMP,
        REGISTRATION_LOCATION_FK integer not null,
        REGISTRATION_COUNTRY_FK integer not null,
        VESSEL_FK VARCHAR(12) not null,
        BASE_PORT_LOCATION_FK integer,
        PROGRAM_FK VARCHAR(40) not null,
        VESSEL_OWNER_FK integer,
        primary key (ID)
    );

    create table DEPARTMENT (
        ID integer not null,
        CODE VARCHAR(40) not null,
        NAME VARCHAR(255) not null,
        EMAIL VARCHAR(255),
        ADDRESS VARCHAR(255),
        PHONE VARCHAR(255),
        IS_LDAP BIT not null,
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        PARENT_DEPARTMENT_FK integer,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table DEPARTMENT_HIERARCHY (
        PARENT_DEPARTMENT_FK integer not null,
        CHILD_DEPARTMENT_FK integer not null,
        primary key (PARENT_DEPARTMENT_FK, CHILD_DEPARTMENT_FK)
    );

    create table DEPARTMENT_PRIVILEGE_TRANSFERT (
        FROM_DEPARTMENT_FK integer not null,
        TO_DEPARTMENT_FK integer not null,
        TRANSFERT_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (FROM_DEPARTMENT_FK, TO_DEPARTMENT_FK)
    );

    create table DEPTH_GRADIENT (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255) not null,
        RANK_ORDER SMALLINT not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table DISTANCE_TO_COAST_GRADIENT (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255) not null,
        RANK_ORDER SMALLINT not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table ECONOMICAL_SURVEY (
        ID integer not null,
        SYNCHRONISATION_STATUS VARCHAR(256) not null,
        COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        RECORDER_DEPARTMENT_FK integer not null,
        RECORDER_PERSON_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PROGRAM_FK VARCHAR(40) not null,
        VESSEL_OWNER_FK integer,
        VESSEL_FK VARCHAR(12),
        primary key (ID)
    );

    create table EDUCATION_GRADE (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        primary key (ID)
    );

    create table EXPECTED_SALE (
        ID integer not null,
        REMOTE_ID integer,
        SALE_LOCATION_FK integer,
        FISHING_TRIP_FK integer,
        SALE_TYPE_FK integer,
        OBSERVED_LANDING_FK integer,
        primary key (ID)
    );

    create table FISHERY (
        ID integer not null,
        LABEL VARCHAR(40) not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        primary key (ID)
    );

    create table FISHING_AREA (
        ID integer not null,
        REMOTE_ID integer,
        SALE_FK integer,
        SAMPLE_FK integer,
        DEPTH_GRADIENT_FK integer,
        LOCATION_FK integer,
        DISTANCE_TO_COAST_GRADIENT_FK integer,
        NEARBY_SPECIFIC_AREA_FK integer,
        PRODUCE_FK integer,
        VESSEL_USE_FEATURES_FK integer,
        GEAR_USE_FEATURES_FK integer,
        primary key (ID)
    );

    create table FISHING_AREA2REG_LOCATION (
        FISHING_AREA_FK integer not null,
        LOCATION_FK integer not null,
        primary key (FISHING_AREA_FK, LOCATION_FK)
    );

    create table FISHING_EFFORT_CALENDAR (
        ID integer not null,
        YEAR INTEGER(4) not null,
        DIRECT_SURVEY_INVESTIGATION BIT not null,
        COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        RECORDER_DEPARTMENT_FK integer not null,
        RECORDER_PERSON_FK integer,
        PROGRAM_FK VARCHAR(40) not null,
        VESSEL_FK VARCHAR(12) not null,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table FISHING_TRIP (
        ID integer not null,
        IS_OBSERVED integer not null,
        SYNCHRONIZATION_STATUS VARCHAR(256) not null,
        DEPARTURE_DATE_TIME TIMESTAMP,
        RETURN_DATE_TIME TIMESTAMP,
        COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        RETURN_LOCATION_FK integer,
        DEPARTURE_LOCATION_FK integer,
        RECORDER_DEPARTMENT_FK integer not null,
        RECORDER_PERSON_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PROGRAM_FK VARCHAR(40) not null,
        VESSEL_FK VARCHAR(12) not null,
        SCIENTIFIC_CRUISE_FK integer,
        DECLARED_DOCUMENT_REFERENCE_FK integer,
        SAMPLING_STRATA_FK integer,
        primary key (ID)
    );

    create table FISHING_TRIP2OBSERVER_PERSON (
        FISHING_TRIP_FK integer not null,
        PERSON_FK integer not null,
        primary key (FISHING_TRIP_FK, PERSON_FK)
    );

    create table FISHING_TRIP_ORIGIN (
        ID integer not null,
        REMOTE_ID integer,
        PROGRAM_FK VARCHAR(40) not null,
        ORIGIN_FISHING_TRIP_FK integer,
        FISHING_TRIP_FK integer not null,
        primary key (ID)
    );

    create table FRACTION (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table FRACTION2MATRIX (
        FRACTION_FK integer not null,
        MATRIX_FK integer not null,
        primary key (MATRIX_FK, FRACTION_FK)
    );

    create table GEAR (
        ID integer not null,
        IS_FISHING_GEAR integer not null,
        LABEL VARCHAR(50) not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        PARENT_GEAR_FK integer,
        STATUS_FK VARCHAR(1) not null,
        GEAR_CLASSIFICATION_FK integer not null,
        IS_ACTIVE BIT,
        IS_TOWED BIT,
        primary key (ID)
    );

    create table GEAR_ASSOCIATION (
        TO_GEAR_FK integer not null,
        FROM_GEAR_FK integer not null,
        UPDATE_DATE TIMESTAMP,
        primary key (TO_GEAR_FK, FROM_GEAR_FK)
    );

    create table GEAR_CLASSIFICATION (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        IS_AGGREGATION BIT not null,
        UPDATE_DATE TIMESTAMP,
        primary key (ID)
    );

    create table GEAR_CLASSIFICATION_ASSOCIATIO (
        TO_GEAR_CLASSIFICATION_FK integer not null,
        FROM_GEAR_CLASSIFICATION_FK integer not null,
        UPDATE_DATE TIMESTAMP,
        primary key (TO_GEAR_CLASSIFICATION_FK, FROM_GEAR_CLASSIFICATION_FK)
    );

    create table GEAR_PHYSICAL_FEATURES (
        ID integer not null,
        START_DATE TIMESTAMP,
        END_DATE TIMESTAMP,
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        PROGRAM_FK VARCHAR(40) not null,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        VESSEL_FK VARCHAR(12) not null,
        RANK_ORDER SMALLINT not null,
        FISHING_TRIP_FK integer,
        OTHER_GEAR_FK integer,
        PHYSICAL_GEAR_SURVEY_FK integer,
        GEAR_FK integer not null,
        primary key (ID)
    );

    create table GEAR_PHYSICAL_FEATURES_ORIGIN (
        PROGRAM_FK VARCHAR(40) not null,
        GEAR_PHYSICAL_FEATURES_FK integer not null,
        ACQUISITION_LEVEL_FK VARCHAR(40),
        primary key (PROGRAM_FK, GEAR_PHYSICAL_FEATURES_FK)
    );

    create table GEAR_PHYSICAL_MEASUREMENT (
        ID integer not null,
        NUMERICAL_VALUE REAL,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        DIGIT_COUNT integer,
        PRECISION_VALUE REAL,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        AGGREGATION_LEVEL_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PRECISION_TYPE_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        NUMERICAL_PRECISION_FK integer,
        DEPARTMENT_FK integer,
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer,
        GEAR_PHYSICAL_FEATURES_FK integer not null,
        primary key (ID)
    );

    create table GEAR_USE_FEATURES (
        ID integer not null,
        START_DATE TIMESTAMP,
        END_DATE TIMESTAMP,
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        PROGRAM_FK VARCHAR(40) not null,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        VESSEL_FK VARCHAR(12) not null,
        RANK_ORDER SMALLINT not null,
        ECONOMICAL_SURVEY_FK integer,
        OTHER_GEAR_FK integer,
        OPERATION_FK integer,
        DAILY_ACTIVITY_CALENDAR_FK integer,
        ACTIVITY_CALENDAR_FK integer,
        FISHING_EFFORT_CALENDAR_FK integer,
        GEAR_FK integer,
        METIER_FK integer,
        primary key (ID)
    );

    create table GEAR_USE_FEATURES_ORIGIN (
        GEAR_USE_FEATURES_FK integer not null,
        PROGRAM_FK VARCHAR(40) not null,
        ACQUISITION_LEVEL_FK VARCHAR(40),
        primary key (GEAR_USE_FEATURES_FK, PROGRAM_FK)
    );

    create table GEAR_USE_MEASUREMENT (
        ID integer not null,
        NUMERICAL_VALUE REAL,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        DIGIT_COUNT integer,
        PRECISION_VALUE REAL,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        AGGREGATION_LEVEL_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PRECISION_TYPE_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        NUMERICAL_PRECISION_FK integer,
        DEPARTMENT_FK integer,
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer,
        GEAR_USE_FEATURES_FK integer not null,
        primary key (ID)
    );

    create table GROUPING (
        ID integer not null,
        LABEL VARCHAR(50) not null,
        NAME VARCHAR(100) not null,
        MIN_VALUE DOUBLE,
        MAX_VALUE DOUBLE,
        UPDATE_DATE TIMESTAMP,
        PARENT_GROUPING_FK integer,
        GROUPING_CLASSIFICATION_FK integer not null,
        GROUPING_LEVEL_FK integer not null,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table GROUPING_CLASSIFICATION (
        ID integer not null,
        LABEL VARCHAR(40) not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        OBJECT_TYPE_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table GROUPING_ITEM (
        ID integer not null,
        OBJECT_ID integer,
        OBJECT_CODE VARCHAR(40),
        GROUPING_FK integer not null,
        primary key (ID)
    );

    create table GROUPING_ITEM_HIERARCHY (
        OBJECT_ID integer not null,
        GROUPING_FK integer not null,
        GROUPING_CLASSIFICATION_FK integer not null,
        primary key (OBJECT_ID, GROUPING_FK)
    );

    create table GROUPING_LEVEL (
        ID integer not null,
        LABEL VARCHAR(40) not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        PARENT_GROUPING_LEVEL_FK integer,
        PMFM_FK integer,
        GROUPING_CLASSIFICATION_FK integer not null,
        primary key (ID)
    );

    create table GROUPING_VESSEL_HIERARCHY (
        ID integer not null,
        START_DATE TIMESTAMP not null,
        END_DATE TIMESTAMP,
        UPDATE_DATE TIMESTAMP,
        GROUPING_FK integer not null,
        ORIGIN_PROGRAM_FK VARCHAR(40) not null,
        ORIGIN_OBJECT_TYPE_FK VARCHAR(40) not null,
        GROUPING_CLASSIFICATION_FK integer not null,
        LOCATION_FK integer not null,
        VESSEL_FK VARCHAR(12) not null,
        primary key (ID)
    );

    create table INSERTED_ITEM_HISTORY (
        ID BIGINT not null,
        OBJECT_ID integer,
        UPDATE_DATE TIMESTAMP,
        OBJECT_CODE VARCHAR(40),
        REMOTE_ID integer,
        OBJECT_TYPE_FK VARCHAR(40) not null,
        PROCESSING_HISTORY_FK integer,
        primary key (ID)
    );

    create table LANDING (
        ID integer not null,
        IS_OBSERVED integer not null,
        SYNCHRONIZATION_STATUS VARCHAR(256) not null,
        LANDING_DATE_TIME TIMESTAMP not null,
        RANK_ORDER SMALLINT,
        COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        LANDING_LOCATION_FK integer not null,
        OBSERVED_LOCATION_FK integer,
        RECORDER_DEPARTMENT_FK integer not null,
        RECORDER_PERSON_FK integer,
        CATCH_BATCH_FK integer,
        FISHING_TRIP_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PROGRAM_FK VARCHAR(40) not null,
        VESSEL_FK VARCHAR(12) not null,
        primary key (ID)
    );

    create table LANDING2OBSERVER_PERSON (
        LANDING_FK integer not null,
        PERSON_FK integer not null,
        primary key (LANDING_FK, PERSON_FK)
    );

    create table LANDING_MEASUREMENT (
        ID integer not null,
        NUMERICAL_VALUE REAL,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        DIGIT_COUNT integer,
        PRECISION_VALUE REAL,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        AGGREGATION_LEVEL_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PRECISION_TYPE_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        NUMERICAL_PRECISION_FK integer,
        DEPARTMENT_FK integer,
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer,
        LANDING_FK integer not null,
        primary key (ID)
    );

    create table LANDING_ORIGIN (
        LANDING_FK integer not null,
        PROGRAM_FK VARCHAR(40) not null,
        primary key (LANDING_FK, PROGRAM_FK)
    );

    create table LINKED_ITEM (
        ID integer not null,
        FROM_OBJECT_ID integer,
        FROM_OBJECT_CODE VARCHAR(40),
        TO_OBJECT_ID integer,
        TO_OBJECT_CODE VARCHAR(40),
        START_DATE TIMESTAMP,
        END_DATE TIMESTAMP,
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        LINKED_ITEM_TYPE_FK integer not null,
        primary key (ID)
    );

    create table LINKED_ITEM_TYPE (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        FROM_OBJECT_TYPE_FK VARCHAR(40) not null,
        TO_OBJECT_TYPE_FK VARCHAR(40) not null,
        STATUS_FK VARCHAR(1) not null,
        FROM_PROGRAM_FK VARCHAR(40) not null,
        TO_PROGRAM_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table LOCATION (
        ID integer not null,
        LABEL VARCHAR(50),
        NAME VARCHAR(100) not null,
        UPDATE_DATE TIMESTAMP,
        BATHYMETRY REAL,
        UT_FORMAT SMALLINT,
        DAYLIGHT_SAVING_TIME BIT,
        LOCATION_LEVEL_FK integer not null,
        LOCATION_CLASSIFICATION_FK integer not null,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table LOCATION_AREA (
        ID integer not null,
        UPDATE_DATE TIMESTAMP,
        primary key (ID)
    );

    create table LOCATION_ASSOCIATION (
        PARENT_LOCATION_FK integer not null,
        CHILD_LOCATION_FK integer not null,
        CHILD_SURFACE_RATIO REAL not null,
        UPDATE_DATE TIMESTAMP,
        primary key (PARENT_LOCATION_FK, CHILD_LOCATION_FK)
    );

    create table LOCATION_CLASSIFICATION (
        ID integer not null,
        NAME VARCHAR(100) not null,
        UPDATE_DATE TIMESTAMP,
        primary key (ID)
    );

    create table LOCATION_HIERARCHY (
        CHILD_LOCATION_FK integer not null,
        PARENT_LOCATION_FK integer not null,
        CHILD_SURFACE_RATIO REAL not null,
        IS_MAIN_ASSOCIATION BIT not null,
        primary key (CHILD_LOCATION_FK, PARENT_LOCATION_FK)
    );

    create table LOCATION_HIERARCHY_EXCEPTION (
        CHILD_LOCATION_FK integer not null,
        PARENT_LOCATION_FK integer not null,
        CHILD_SURFACE_RATIO REAL not null,
        primary key (CHILD_LOCATION_FK, PARENT_LOCATION_FK)
    );

    create table LOCATION_LEVEL (
        ID integer not null,
        NAME VARCHAR(100) not null,
        UPDATE_DATE TIMESTAMP,
        PARENT_LOCATION_LEVEL_FK integer,
        LOCATION_CLASSIFICATION_FK integer not null,
        primary key (ID)
    );

    create table LOCATION_LINE (
        ID integer not null,
        UPDATE_DATE TIMESTAMP,
        primary key (ID)
    );

    create table LOCATION_POINT (
        ID integer not null,
        UPDATE_DATE TIMESTAMP,
        primary key (ID)
    );

    create table MANAGED_DATA (
        ID integer not null,
        UPDATE_DATE TIMESTAMP,
        MANAGER_PERSON_FK integer not null,
        SUPERVISOR_PERSON_FK integer,
        MANAGED_DATA_TYPE_FK integer not null,
        primary key (ID)
    );

    create table MANAGED_DATA2VIEWER_USER (
        MANAGED_DATA_FK integer not null,
        PERSON_FK integer not null,
        primary key (MANAGED_DATA_FK, PERSON_FK)
    );

    create table MANAGED_DATA_TRANSFER (
        MANAGED_DATA_FK integer not null,
        NEW_MANAGER_PERSON_FK integer not null,
        TRANSFER_DATE TIMESTAMP not null,
        primary key (MANAGED_DATA_FK, NEW_MANAGER_PERSON_FK)
    );

    create table MANAGED_DATA_TYPE (
        ID integer not null,
        NAME VARCHAR(100) not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table MATRIX (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table MEASUREMENT_FILE (
        ID integer not null,
        OBJECT_ID integer not null,
        PATH VARCHAR(255) not null,
        NAME VARCHAR(100),
        COMMENTS VARCHAR(2000),
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        PMFM_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        DEPARTMENT_FK integer,
        OBJECT_TYPE_FK VARCHAR(40) not null,
        ANALYSIS_INSTRUMENT_FK integer,
        primary key (ID)
    );

    create table METHOD (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        CONDITIONING VARCHAR(2000),
        PREPARATION VARCHAR(2000),
        CONSERVATION VARCHAR(2000),
        REFERENCE VARCHAR(2000),
        RANK VARCHAR(100) not null,
        HANDBOOK_PATH VARCHAR(255),
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table METIER (
        ID integer not null,
        LABEL VARCHAR(100),
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        TAXON_GROUP_FK integer,
        GEAR_FK integer,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table MINIMUM_SIZE_ALLOWED (
        ID integer not null,
        MINIMUM_SIZE REAL not null,
        UPDATE_DATE TIMESTAMP,
        CORPUS_FK integer not null,
        UNIT_FK integer not null,
        TAXON_GROUP_FK integer not null,
        primary key (ID)
    );

    create table MINIMUM_SIZE_ALLOWED2LOCATION (
        MINIMUM_SIZE_ALLOWED_FK integer not null,
        LOCATION_FK integer not null,
        primary key (MINIMUM_SIZE_ALLOWED_FK, LOCATION_FK)
    );

    create table NEARBY_SPECIFIC_AREA (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255) not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table NUMERICAL_PRECISION (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255) not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table OBJECT_TYPE (
        CODE VARCHAR(40) not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        primary key (CODE)
    );

    create table OBSERVED_LOCATION (
        ID integer not null,
        SYNCHRONIZATION_STATUS VARCHAR(256) not null,
        START_DATE_TIME TIMESTAMP not null,
        END_DATE_TIME TIMESTAMP,
        COMMENTS VARCHAR(2000),
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        SAMPLING_STRATA_REFERENCE VARCHAR(256),
        REMOTE_ID integer,
        RECORDER_PERSON_FK integer,
        RECORDER_DEPARTMENT_FK integer not null,
        LOCATION_FK integer not null,
        PROGRAM_FK VARCHAR(40) not null,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table OBSERVED_LOCATION2PERSON (
        OBSERVED_LOCATION_FK integer not null,
        OBSERVER_PERSON_FK integer not null,
        primary key (OBSERVED_LOCATION_FK, OBSERVER_PERSON_FK)
    );

    create table OBSERVED_LOCATION_FEATURES (
        ID integer not null,
        START_DATE TIMESTAMP not null,
        END_DATE TIMESTAMP,
        RANK_ORDER SMALLINT not null,
        UPDATE_DATE TIMESTAMP,
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        METIER_FK integer,
        OBSERVED_LOCATION_FK integer not null,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PROGRAM_FK VARCHAR(40) not null,
        VESSEL_TYPE_FK integer not null,
        primary key (ID)
    );

    create table OBSERVED_LOCATION_MEASUREMENT (
        ID integer not null,
        NUMERICAL_VALUE REAL,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        DIGIT_COUNT integer,
        PRECISION_VALUE REAL,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        AGGREGATION_LEVEL_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PRECISION_TYPE_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        NUMERICAL_PRECISION_FK integer,
        DEPARTMENT_FK integer,
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer,
        OBSERVED_LOCATION_FEATURES_FK integer not null,
        primary key (ID)
    );

    create table OPERATION (
        ID integer not null,
        IS_FISHING_OPERATION integer not null,
        NAME VARCHAR(100),
        RANK_ORDER_ON_PERIOD SMALLINT,
        START_DATE_TIME TIMESTAMP,
        END_DATE_TIME TIMESTAMP,
        IS_MAIN_OPERATION BIT,
        COMMENTS VARCHAR(2000),
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        VESSEL_FK VARCHAR(12) not null,
        FISHING_TRIP_FK integer,
        GEAR_PHYSICAL_FEATURES_FK integer,
        FISHING_START_DATE_TIME TIMESTAMP,
        FISHING_END_DATE_TIME TIMESTAMP,
        HAS_CATCH BIT,
        CATCH_BATCH_FK integer,
        primary key (ID)
    );

    create table OPERATION_VESSEL_ASSOCIATION (
        VESSEL_FK VARCHAR(12) not null,
        OPERATION_FK integer not null,
        IS_CATCH_ON_OPERATION_VESSEL BIT,
        COMMENTS VARCHAR(2000),
        primary key (VESSEL_FK, OPERATION_FK)
    );

    create table ORDER_ITEM (
        ID integer not null,
        OBJECT_ID integer not null,
        RANK integer not null,
        UPDATE_DATE TIMESTAMP,
        ORDER_TYPE_FK integer not null,
        primary key (ID)
    );

    create table ORDER_TYPE (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        OBJECT_TYPE_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table PARAMETER (
        CODE VARCHAR(40) not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        IS_QUALITATIVE BIT not null,
        IS_TAXINOMIC BIT not null,
        IS_CALCULATED BIT not null,
        IS_ALPHANUMERIC BIT not null,
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        PARAMETER_GROUP_FK integer not null,
        STATUS_FK VARCHAR(1) not null,
        primary key (CODE)
    );

    create table PARAMETER_GROUP (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        PARENT_PARAMETER_GROUP_FK integer,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table PERSON (
        ID integer not null,
        LASTNAME VARCHAR(100) not null,
        FIRSTNAME VARCHAR(100) not null,
        ADDRESS VARCHAR(255),
        CREATION_DATE TIMESTAMP not null,
        PHONE_NUMBER VARCHAR(50),
        MOBILE_NUMBER VARCHAR(50),
        FAX_NUMBER VARCHAR(50),
        EMAIL VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        CRYPT_PASSWORD VARCHAR(255),
        EMPLOYEE_NUMBER VARCHAR(40),
        USERNAME VARCHAR(40),
        USERNAME_EXTRANET VARCHAR(40),
        STATUS_FK VARCHAR(1) not null,
        DEPARTMENT_FK integer not null,
        primary key (ID)
    );

    create table PERSON2USER_PROFIL (
        PERSON_FK integer not null,
        USER_PROFIL_FK integer not null,
        primary key (PERSON_FK, USER_PROFIL_FK)
    );

    create table PERSON_SESSION (
        ID integer not null,
        UPDATE_DATE TIMESTAMP,
        PERSON_FK integer not null,
        primary key (ID)
    );

    create table PERSON_SESSION_VESSEL (
        ID BIGINT not null,
        READ_VESSEL BIT not null,
        READ_DATA BIT not null,
        WRITE_DATA BIT not null,
        VALIDATE_DATA BIT,
        START_DATE_TIME TIMESTAMP not null,
        END_DATE_TIME TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        PERSON_SESSION_FK integer not null,
        VESSEL_FK VARCHAR(12) not null,
        PROGRAM_FK VARCHAR(40) not null,
        OBJECT_TYPE_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table PHOTO (
        ID integer not null,
        OBJECT_ID integer not null,
        NAME VARCHAR(100),
        DIRECTION_DESCRIPTION VARCHAR(255),
        COMMENTS VARCHAR(2000),
        PATH VARCHAR(255) not null,
        PHOTO_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PHOTO_TYPE_FK VARCHAR(40) not null,
        OBJECT_TYPE_FK VARCHAR(40) not null,
        DEPARTMENT_FK integer,
        primary key (ID)
    );

    create table PHOTO_TYPE (
        CODE VARCHAR(40) not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255) not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (CODE)
    );

    create table PHYSICAL_GEAR_SURVEY (
        ID integer not null,
        SYNCHRONIZATION_STATUS VARCHAR(256) not null,
        YEAR INTEGER(4) not null,
        DIRECT_SURVEY_INVESTIGATION BIT not null,
        COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        RECORDER_DEPARTMENT_FK integer not null,
        RECORDER_PERSON_FK integer,
        PROGRAM_FK VARCHAR(40) not null,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        VESSEL_FK VARCHAR(12) not null,
        primary key (ID)
    );

    create table PMFM (
        ID integer not null,
        SIGNIF_FIGURES_NUMBER integer,
        MAXIMUM_NUMBER_DECIMALS integer,
        DETECTION_THRESHOLD REAL,
        MIN_VALUE REAL,
        MAX_VALUE REAL,
        PRECISION REAL,
        DEFAULT_VALUE REAL,
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        DESCRIPTION VARCHAR(255),
        AGGREGATION_LEVEL_FK integer not null,
        FRACTION_FK integer not null,
        METHOD_FK integer not null,
        MATRIX_FK integer not null,
        PARAMETER_FK VARCHAR(40) not null,
        UNIT_FK integer not null,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table PMFM2QUALITATIVE_VALUE (
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer not null,
        primary key (PMFM_FK, QUALITATIVE_VALUE_FK)
    );

    create table PMFM_APPLIED_STRATEGY (
        PMFM_FK integer not null,
        APPLIED_STRATEGY_FK integer not null,
        REFERENCE_TAXON_FK integer,
        GEAR_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        METIER_FK integer,
        primary key (PMFM_FK, APPLIED_STRATEGY_FK)
    );

    create table PMFM_STRATEGY (
        ID integer not null,
        ACQUISITION_NUMBER integer not null,
        RANK_ORDER integer not null,
        IS_MANDATORY BIT not null,
        MIN_VALUE REAL,
        MAX_VALUE REAL,
        REFERENCE_TAXON_FK integer,
        PRECISION_TYPE_FK integer,
        ACQUISITION_LEVEL_FK VARCHAR(40) not null,
        METIER_FK integer,
        GEAR_FK integer,
        STRATEGY_FK integer not null,
        PMFM_FK integer not null,
        primary key (ID)
    );

    create table PRECISION_TYPE (
        ID integer not null,
        NAME VARCHAR(100) not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table PROCESSING_HISTORY (
        ID integer not null,
        NAME VARCHAR(100) not null,
        PROCESSING_DATE TIMESTAMP not null,
        DATA_TRANSFERT_TYPE VARCHAR(255),
        DATA_TRANSFERT_DATE TIMESTAMP,
        DATA_TRANSFERT_ADDRESS VARCHAR(255),
        CONFIGURATION VARCHAR(255),
        XML_CONFIGURATION VARCHAR(3000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        PROCESSING_TYPE_FK VARCHAR(40) not null,
        PROCESSING_STATUS_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table PROCESSING_STATUS (
        CODE VARCHAR(40) not null,
        NAME VARCHAR(100) not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (CODE)
    );

    create table PROCESSING_TYPE (
        CODE VARCHAR(40) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (CODE)
    );

    create table PRODUCE (
        ID integer not null,
        IS_DISCARD BIT not null,
        SUBGROUP_COUNT REAL,
        INDIVIDUAL_COUNT SMALLINT,
        TAXON_GROUP_OTHER_INFORMATION VARCHAR(255),
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        WEIGHT REAL,
        COST REAL,
        REMOTE_ID integer,
        OTHER_TAXON_GROUP_FK integer,
        TAXON_GROUP_FK integer not null,
        SALE_TYPE_FK integer,
        OTHER_GEAR_FK integer,
        DRESSING_FK integer,
        PRESERVATION_FK integer,
        TRANSACTION_FK integer,
        FRESHNESS_CATEGORY_FK integer,
        SIZE_CATEGORY_FK integer,
        WEIGHT_METHOD_FK integer,
        FISHING_OPERATION_FK integer,
        EXPECTED_SALE_FK integer,
        BATCH_FK integer,
        BUYER_FK integer,
        SALE_FK integer,
        GEAR_FK integer,
        LANDING_FK integer,
        TAKE_OVER_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        TRANSSHIPMENT_FK integer,
        primary key (ID)
    );

    create table PROGRAM (
        CODE VARCHAR(40) not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255) not null,
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        TAXON_GROUP_TYPE_FK VARCHAR(40) not null,
        GEAR_CLASSIFICATION_FK integer not null,
        primary key (CODE)
    );

    create table PROGRAM2DEPARTMENT (
        ID integer not null,
        PROGRAM_PRIVILEGE_FK integer not null,
        PROGRAM_FK VARCHAR(40) not null,
        LOCATION_FK integer,
        DEPARTMENT_FK integer not null,
        primary key (ID)
    );

    create table PROGRAM2LOCATION (
        PROGRAM_FK VARCHAR(40) not null,
        LOCATION_FK integer not null,
        primary key (PROGRAM_FK, LOCATION_FK)
    );

    create table PROGRAM2LOCATION_CLASSIF (
        PROGRAM_FK VARCHAR(40) not null,
        LOCATION_CLASSIFICATION_FK integer not null,
        primary key (PROGRAM_FK, LOCATION_CLASSIFICATION_FK)
    );

    create table PROGRAM2PERSON (
        ID integer not null,
        PROGRAM_FK VARCHAR(40) not null,
        PROGRAM_PRIVILEGE_FK integer not null,
        LOCATION_FK integer,
        PERSON_FK integer not null,
        primary key (ID)
    );

    create table PROGRAM2PERSON_EXCEPTION (
        VESSEL_FK VARCHAR(12) not null,
        PROGRAM2PERSON_FK integer not null,
        IS_EXCLUDE BIT not null,
        DESCRIPTION VARCHAR(255),
        primary key (VESSEL_FK, PROGRAM2PERSON_FK)
    );

    create table PROGRAM_PRIVILEGE (
        ID integer not null,
        LABEL VARCHAR(100) not null,
        NAME VARCHAR(255) not null,
        UPDATE_DATE TIMESTAMP,
        primary key (ID)
    );

    create table QUALIFICATION_RULE (
        ID integer not null,
        LABEL VARCHAR(60) not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        JAVA_CLASS VARCHAR(255) not null,
        VERSION VARCHAR(255) not null,
        UPDATE_DATE TIMESTAMP,
        DEFAULT_QUALITY_FLAG_FK VARCHAR(40) not null,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table QUALIFIED_ITEM (
        ID integer not null,
        OBJECT_ID integer not null,
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        OBJECT_TYPE_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table QUALITATIVE_VALUE (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        STATUS_FK VARCHAR(1) not null,
        PARAMETER_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table QUALITY_FLAG (
        CODE VARCHAR(40) not null,
        NAME VARCHAR(100) not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (CODE)
    );

    create table QUANTIFICATION_MEASUREMENT (
        ID integer not null,
        NUMERICAL_VALUE REAL,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        DIGIT_COUNT integer,
        PRECISION_VALUE REAL,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        AGGREGATION_LEVEL_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PRECISION_TYPE_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        NUMERICAL_PRECISION_FK integer,
        DEPARTMENT_FK integer,
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer,
        SUBGROUP_NUMBER SMALLINT,
        IS_REFERENCE_QUANTIFICATION BIT,
        BATCH_FK integer not null,
        primary key (ID)
    );

    create table QUANTIFICATION_MEASUREMENT_P (
        ID integer not null,
        NUMERICAL_VALUE REAL,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        DIGIT_COUNT integer,
        PRECISION_VALUE REAL,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        AGGREGATION_LEVEL_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PRECISION_TYPE_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        NUMERICAL_PRECISION_FK integer,
        DEPARTMENT_FK integer,
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer,
        SUBGROUP_NUMBER SMALLINT,
        IS_REFERENCE_QUANTIFICATION BIT,
        PRODUCE_FK integer not null,
        primary key (ID)
    );

    create table REFERENCE_DOCUMENT (
        ID integer not null,
        REFERENCE VARCHAR(255) not null,
        PUBLICATION_DATE TIMESTAMP,
        COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table REFERENCE_DOCUMENT2AUTHOR (
        AUTHOR_FK integer not null,
        REFERENCE_DOCUMENT_FK integer not null,
        primary key (REFERENCE_DOCUMENT_FK, AUTHOR_FK)
    );

    create table REFERENCE_TAXON (
        ID integer not null,
        UPDATE_DATE TIMESTAMP,
        primary key (ID)
    );

    create table REFERENCE_TAXON_STRATEGY (
        REFERENCE_TAXON_FK integer not null,
        STRATEGY_FK integer not null,
        PRIORITY_LEVEL SMALLINT,
        primary key (REFERENCE_TAXON_FK, STRATEGY_FK)
    );

    create table REGULATION_AREA (
        ID integer not null,
        GROUPING_FK integer,
        DISTANCE_TO_COAST_GRADIENT_FK integer,
        FISHERY_FK integer not null,
        NEARBY_SPECIFIC_AREA_FK integer,
        DEPTH_GRADIENT_FK integer,
        LOCATION_FK integer,
        primary key (ID)
    );

    create table REGULATION_AREA2REG_LOCATION (
        LOCATION_FK integer not null,
        REGULATION_AREA_FK integer not null,
        primary key (LOCATION_FK, REGULATION_AREA_FK)
    );

    create table RIGHT_TO_PRODUCE (
        ID integer not null,
        START_DATE TIMESTAMP not null,
        RANK_ORDER_ON_PERIOD SMALLINT,
        END_DATE TIMESTAMP,
        REFERENCE VARCHAR(100),
        UPDATE_DATE TIMESTAMP,
        PROGRAM_FK VARCHAR(40) not null,
        CORPUS_FK integer,
        primary key (ID)
    );

    create table RIGHT_TO_PRODUCE2FISHERY (
        RIGHT_TO_PRODUCE_FK integer not null,
        FISHERY_FK integer not null,
        primary key (RIGHT_TO_PRODUCE_FK, FISHERY_FK)
    );

    create table ROUND_WEIGHT_CONVERSION (
        ID integer not null,
        CONVERSION_COEFFICIENT REAL not null,
        START_DATE TIMESTAMP not null,
        END_DATE TIMESTAMP,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        LOCATION_FK integer not null,
        PRESERVING_FK integer not null,
        DRESSING_FK integer not null,
        TAXON_GROUP_FK integer not null,
        primary key (ID)
    );

    create table SALE (
        ID integer not null,
        IS_OBSERVED integer not null,
        SALE_START_DATE TIMESTAMP,
        SALE_END_DATE TIMESTAMP,
        SYNCHRONIZATION_STATUS VARCHAR(256) not null,
        COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        SALE_LOCATION_FK integer,
        SALE_TYPE_FK integer,
        RECORDER_DEPARTMENT_FK integer not null,
        RECORDER_PERSON_FK integer,
        CATCH_BATCH_FK integer,
        FISHING_TRIP_FK integer,
        PROGRAM_FK VARCHAR(40) not null,
        VESSEL_FK VARCHAR(12) not null,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        SELLER_FK integer,
        DECLARED_DOCUMENT_REFERENCE_FK integer,
        LANDING_FK integer,
        TAKE_OVER_FK integer,
        SAMPLING_STRATA_FK integer,
        primary key (ID)
    );

    create table SALE2OBSERVER_PERSON (
        SALE_FK integer not null,
        PERSON_FK integer not null,
        primary key (SALE_FK, PERSON_FK)
    );

    create table SALE_MEASUREMENT (
        ID integer not null,
        NUMERICAL_VALUE REAL,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        DIGIT_COUNT integer,
        PRECISION_VALUE REAL,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        AGGREGATION_LEVEL_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PRECISION_TYPE_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        NUMERICAL_PRECISION_FK integer,
        DEPARTMENT_FK integer,
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer,
        SALE_FK integer,
        EXPECTED_SALE_FK integer,
        primary key (ID)
    );

    create table SALE_ORIGIN (
        SALE_FK integer not null,
        PROGRAM_FK VARCHAR(40) not null,
        primary key (SALE_FK, PROGRAM_FK)
    );

    create table SALE_TYPE (
        ID integer not null,
        NAME VARCHAR(100) not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table SAMPLE (
        ID integer not null,
        LABEL VARCHAR(100) not null,
        SAMPLE_DATE TIMESTAMP,
        INDIVIDUAL_COUNT SMALLINT,
        SAMPLE_SIZE REAL,
        SYNCHRONIZATION_STATUS VARCHAR(256) not null,
        COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        SIZE_UNIT_FK integer,
        RECORDER_DEPARTMENT_FK integer not null,
        PARENT_SAMPLE_FK integer,
        RECORDER_PERSON_FK integer,
        MATRIX_FK integer not null,
        REFERENCE_TAXON_FK integer,
        PROGRAM_FK VARCHAR(40) not null,
        TAXON_GROUP_FK integer,
        BATCH_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        FISHING_OPERATION_FK integer,
        primary key (ID)
    );

    create table SAMPLE_MEASUREMENT (
        ID integer not null,
        NUMERICAL_VALUE REAL,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        DIGIT_COUNT integer,
        PRECISION_VALUE REAL,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        AGGREGATION_LEVEL_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PRECISION_TYPE_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        NUMERICAL_PRECISION_FK integer,
        DEPARTMENT_FK integer,
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer,
        INDIVIDUAL_NUMBER SMALLINT,
        IS_REFERENCE_MEASUREMENT BIT not null,
        SAMPLE_FK integer not null,
        primary key (ID)
    );

    create table SCIENTIFIC_CRUISE (
        ID integer not null,
        SYNCHRONIZATION_STATUS VARCHAR(256) not null,
        NAME VARCHAR(100) not null,
        DEPARTURE_DATE_TIME TIMESTAMP not null,
        RETURN_DATE_TIME TIMESTAMP,
        REFERENCE VARCHAR(255),
        COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        MANAGER_PERSON_FK integer not null,
        VESSEL_FK VARCHAR(12) not null,
        RECORDER_DEPARTMENT_FK integer not null,
        RECORDER_PERSON_FK integer,
        PROGRAM_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table SELLER (
        ID integer not null,
        REGISTRATION_CODE VARCHAR(40),
        NAME VARCHAR(100),
        UPDATE_DATE TIMESTAMP,
        SELLER_TYPE_FK SMALLINT not null,
        BASE_SALE_LOCATION_FK integer,
        primary key (ID)
    );

    create table SELLER_TYPE (
        ID SMALLINT not null,
        NAME VARCHAR(100),
        UPDATE_DATE TIMESTAMP,
        LABEL VARCHAR(40),
        primary key (ID)
    );

    create table SORTING_MEASUREMENT (
        ID integer not null,
        NUMERICAL_VALUE REAL,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        DIGIT_COUNT integer,
        PRECISION_VALUE REAL,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        AGGREGATION_LEVEL_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PRECISION_TYPE_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        NUMERICAL_PRECISION_FK integer,
        DEPARTMENT_FK integer,
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer,
        RANK_ORDER integer not null,
        SORTING_BATCH_FK integer not null,
        primary key (ID)
    );

    create table SORTING_MEASUREMENT_P (
        ID integer not null,
        NUMERICAL_VALUE REAL,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        DIGIT_COUNT integer,
        PRECISION_VALUE REAL,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        AGGREGATION_LEVEL_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PRECISION_TYPE_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        NUMERICAL_PRECISION_FK integer,
        DEPARTMENT_FK integer,
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer,
        RANK_ORDER integer not null,
        PRODUCE_FK integer not null,
        primary key (ID)
    );

    create table SPATIAL_ITEM (
        ID integer not null,
        OBJECT_ID integer not null,
        UPDATE_DATE TIMESTAMP,
        SPATIAL_ITEM_TYPE_FK integer not null,
        primary key (ID)
    );

    create table SPATIAL_ITEM2LOCATION (
        LOCATION_FK integer not null,
        SPATIAL_ITEM_FK integer not null,
        LOCALIZED_NAME VARCHAR(255),
        primary key (LOCATION_FK, SPATIAL_ITEM_FK)
    );

    create table SPATIAL_ITEM_AREA (
        ID integer not null,
        LOCALIZED_NAME VARCHAR(100),
        SPATIAL_ITEM_FK integer not null,
        primary key (ID)
    );

    create table SPATIAL_ITEM_LINE (
        ID integer not null,
        LOCALIZED_NAME VARCHAR(100),
        SPATIAL_ITEM_FK integer not null,
        primary key (ID)
    );

    create table SPATIAL_ITEM_POINT (
        ID integer not null,
        LOCALIZED_NAME VARCHAR(100),
        SPATIAL_ITEM_FK integer not null,
        primary key (ID)
    );

    create table SPATIAL_ITEM_TYPE (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        LABEL VARCHAR(40) not null,
        STATUS_FK VARCHAR(1) not null,
        OBJECT_TYPE_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table STATUS (
        CODE VARCHAR(1) not null,
        NAME VARCHAR(100) not null,
        UPDATE_DATE TIMESTAMP,
        primary key (CODE)
    );

    create table STRATEGY (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255) not null,
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        PROGRAM_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table STRATEGY2GEAR (
        STRATEGY_FK integer not null,
        GEAR_FK integer not null,
        primary key (STRATEGY_FK, GEAR_FK)
    );

    create table STRATEGY2MANAGER_PERSON (
        STRATEGY_FK integer not null,
        PERSON_FK integer not null,
        primary key (STRATEGY_FK, PERSON_FK)
    );

    create table SURVEY_MEASUREMENT (
        ID integer not null,
        NUMERICAL_VALUE REAL,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        DIGIT_COUNT integer,
        PRECISION_VALUE REAL,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        AGGREGATION_LEVEL_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PRECISION_TYPE_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        NUMERICAL_PRECISION_FK integer,
        DEPARTMENT_FK integer,
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer,
        DECLARED_DOCUMENT_REFERENCE_FK integer,
        FISHING_TRIP_FK integer,
        PHYSICAL_GEAR_SURVEY_FK integer,
        SALE_FK integer,
        DAILY_ACTIVITY_CALENDAR_FK integer,
        ACTIVITY_CALENDAR_FK integer,
        ECONOMICAL_SURVEY_FK integer,
        FISHING_EFFORT_CALENDAR_FK integer,
        LANDING_FK integer,
        TRANSSHIPMENT_FK integer,
        primary key (ID)
    );

    create table SYSTEM_VERSION (
        ID integer not null,
        LABEL VARCHAR(40) not null,
        DESCRIPTION VARCHAR(255),
        CREATION_DATE TIMESTAMP not null,
        COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        primary key (ID)
    );

    create table TAKE_OVER (
        ID integer not null,
        SYNCHRONIZATION_STATUS VARCHAR(256) not null,
        TAKE_OVER_DATE_TIME TIMESTAMP not null,
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        RECORDER_DEPARTMENT_FK integer not null,
        RECORDER_PERSON_FK integer,
        TAKE_OVER_LOCATION_FK integer not null,
        STORAGE_FACILITY_FK integer,
        FISHING_TRIP_FK integer,
        SELLER_FK integer not null,
        VESSEL_FK VARCHAR(12) not null,
        LANDING_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PROGRAM_FK VARCHAR(40) not null,
        DECLARED_DOCUMENT_REFERENCE_FK integer,
        primary key (ID)
    );

    create table TAKE_OVER_MEASUREMENT (
        ID integer not null,
        NUMERICAL_VALUE REAL,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        DIGIT_COUNT integer,
        PRECISION_VALUE REAL,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        AGGREGATION_LEVEL_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PRECISION_TYPE_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        NUMERICAL_PRECISION_FK integer,
        DEPARTMENT_FK integer,
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer,
        TAKE_OVER_FK integer not null,
        primary key (ID)
    );

    create table TAXONOMIC_LEVEL (
        CODE VARCHAR(40) not null,
        RANK integer not null,
        NAME VARCHAR(100) not null,
        LABEL VARCHAR(100),
        COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (CODE)
    );

    create table TAXON_GROUP (
        ID integer not null,
        LABEL VARCHAR(100),
        NAME VARCHAR(100) not null,
        COMMENTS VARCHAR(2000),
        IS_CHILD_GROUP_EXCLUSIVE BIT not null,
        IS_UPDATABLE BIT not null,
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        PARENT_TAXON_GROUP_FK integer,
        TAXON_GROUP_TYPE_FK VARCHAR(40) not null,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table TAXON_GROUP2TAXON_HIERARCHY (
        START_DATE TIMESTAMP not null,
        CHILD_REFERENCE_TAXON_FK integer not null,
        PARENT_TAXON_GROUP_FK integer not null,
        END_DATE TIMESTAMP,
        IS_INHERITED BIT not null,
        primary key (START_DATE, CHILD_REFERENCE_TAXON_FK, PARENT_TAXON_GROUP_FK)
    );

    create table TAXON_GROUP_HIERARCHY (
        PARENT_TAXON_GROUP_FK integer not null,
        CHILD_TAXON_GROUP_FK integer not null,
        primary key (PARENT_TAXON_GROUP_FK, CHILD_TAXON_GROUP_FK)
    );

    create table TAXON_GROUP_HISTORICAL_RECORD (
        ID integer not null,
        START_DATE TIMESTAMP not null,
        END_DATE TIMESTAMP,
        COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REFERENCE_TAXON_FK integer not null,
        TAXON_GROUP_FK integer not null,
        primary key (ID)
    );

    create table TAXON_GROUP_INFORMATION (
        TAXON_GROUP_FK integer not null,
        REFERENCE_DOCUMENT_FK integer not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        primary key (TAXON_GROUP_FK, REFERENCE_DOCUMENT_FK)
    );

    create table TAXON_GROUP_TYPE (
        CODE VARCHAR(40) not null,
        NAME VARCHAR(100) not null,
        UPDATE_DATE TIMESTAMP,
        primary key (CODE)
    );

    create table TAXON_INFORMATION (
        REFERENCE_DOCUMENT_FK integer not null,
        TAXON_NAME_FK integer not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        primary key (REFERENCE_DOCUMENT_FK, TAXON_NAME_FK)
    );

    create table TAXON_INFORMATION_HISTORY (
        TAXON_NAME_HISTORY_FK integer not null,
        REFERENCE_DOCUMENT_FK integer not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        primary key (TAXON_NAME_HISTORY_FK, REFERENCE_DOCUMENT_FK)
    );

    create table TAXON_NAME (
        ID integer not null,
        NAME VARCHAR(255) not null,
        COMPLETE_NAME VARCHAR(255),
        IS_NAMING BIT not null,
        IS_REFERENT BIT not null,
        UPPER_RANK integer not null,
        IS_VIRTUAL BIT not null,
        IS_OBSOLETE BIT not null,
        IS_TEMPORARY BIT not null,
        START_DATE TIMESTAMP not null,
        END_DATE TIMESTAMP,
        COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        CITATION_FK integer,
        PARENT_TAXON_NAME_FK integer,
        TAXONOMIC_LEVEL_FK VARCHAR(40) not null,
        REFERENCE_TAXON_FK integer not null,
        primary key (ID)
    );

    create table TAXON_NAME_HISTORY (
        ID integer not null,
        NAME VARCHAR(255),
        COMMENTS VARCHAR(2000),
        UPPER_RANK integer,
        IS_REFERENT BIT,
        IS_VIRTUAL BIT,
        IS_OBSOLETE BIT,
        IS_TEMPORARY BIT,
        UPDATE_DATE TIMESTAMP,
        CITATION_FK integer,
        TAXON_NAME_FK integer,
        PARENT_TAXON_NAME_FK integer,
        primary key (ID)
    );

    create table TEMP_QUERY_PARAMETER (
        ID integer not null,
        PARAMETER_NAME VARCHAR(40) not null,
        NUMERICAL_VALUE DOUBLE,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        PERSON_FK integer not null,
        REMOTE_ID integer,
        primary key (ID)
    );

    create table TRANSCRIBING_ITEM (
        ID integer not null,
        OBJECT_ID integer,
        EXTERNAL_CODE VARCHAR(100) not null,
        OBJECT_CODE VARCHAR(40),
        UPDATE_DATE TIMESTAMP,
        TRANSCRIBING_ITEM_TYPE_FK integer not null,
        primary key (ID)
    );

    create table TRANSCRIBING_ITEM_TYPE (
        ID integer not null,
        LABEL VARCHAR(40) not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        OBJECT_TYPE_FK VARCHAR(40) not null,
        TRANSCRIBING_SIDE_FK integer not null,
        TRANSCRIBING_SYSTEM_FK integer,
        primary key (ID)
    );

    create table TRANSCRIBING_SIDE (
        ID integer not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        primary key (ID)
    );

    create table TRANSCRIBING_SYSTEM (
        ID integer not null,
        LABEL VARCHAR(40) not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table TRANSSHIPMENT (
        ID integer not null,
        TRANSSHIPMENT_DATE_TIME TIMESTAMP not null,
        RANK_ORDER SMALLINT,
        COMMENTS VARCHAR(2000),
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        TO_VESSEL_FK VARCHAR(12) not null,
        TRANSSHIPMENT_LOCATION_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        RECORDER_DEPARTMENT_FK integer not null,
        FROM_VESSEL_FK VARCHAR(12) not null,
        RECORDER_PERSON_FK integer,
        FISHING_TRIP_FK integer,
        PROGRAM_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table UNIT (
        ID integer not null,
        SYMBOL VARCHAR(100) not null,
        NAME VARCHAR(100) not null,
        CREATION_DATE TIMESTAMP not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table UNIT_CONVERSION (
        FROM_UNIT_FK integer not null,
        TO_UNIT_FK integer not null,
        CONVERSION_COEFFICIENT REAL not null,
        UPDATE_DATE TIMESTAMP,
        primary key (FROM_UNIT_FK, TO_UNIT_FK)
    );

    create table UPDATED_ITEM_HISTORY (
        ID BIGINT not null,
        OBJECT_ID integer,
        OBJECT_CODE VARCHAR(40),
        IS_POST_VALIDATION BIT not null,
        COMMENTS VARCHAR(2000) not null,
        NUMERICAL_VALUE REAL,
        PREVIOUS_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        PROCESSING_HISTORY_FK integer,
        RECORDER_PERSON_FK integer,
        RECORDER_DEPARTMENT_FK integer not null,
        METIER_FK integer,
        REFERENCE_TAXON_FK integer,
        TAXON_GROUP_FK integer,
        PMFM_FK integer,
        GEAR_FK integer,
        QUALITATIVE_VALUE_FK integer,
        QUALITY_FLAG_FK VARCHAR(40),
        OBJECT_TYPE_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table USER_PROFIL (
        ID integer not null,
        LABEL VARCHAR(50) not null,
        NAME VARCHAR(100) not null,
        UPDATE_DATE TIMESTAMP,
        primary key (ID)
    );

    create table VESSEL (
        CODE VARCHAR(12) not null,
        UPDATE_DATE TIMESTAMP,
        VESSEL_TYPE_FK integer not null,
        PROGRAM_FK VARCHAR(40) not null,
        STATUS_FK VARCHAR(1) not null,
        primary key (CODE)
    );

    create table VESSEL2RIGHT_TO_PRODUCE (
        VESSEL_FK VARCHAR(12) not null,
        RIGHT_TO_PRODUCE_FK integer not null,
        primary key (RIGHT_TO_PRODUCE_FK, VESSEL_FK)
    );

    create table VESSEL_COMMISSIONING_PERIOD (
        START_DATE TIMESTAMP not null,
        VESSEL_FK VARCHAR(12) not null,
        COMMISSIONING_LOCATION_FK integer not null,
        END_DATE TIMESTAMP,
        primary key (START_DATE, VESSEL_FK, COMMISSIONING_LOCATION_FK)
    );

    create table VESSEL_FEATURES (
        ID integer not null,
        START_DATE_TIME TIMESTAMP not null,
        END_DATE_TIME TIMESTAMP,
        NAME VARCHAR(100),
        EXTERIOR_MARKING VARCHAR(100),
        ADMINISTRATIVE_POWER REAL,
        AUXILIARY_POWER REAL,
        GROSS_TONNAGE_GT integer,
        GROSS_TONNAGE_GRT integer,
        LOA integer,
        LBP integer,
        CONSTRUCTION_YEAR INTEGER(4),
        IRCS VARCHAR(40),
        HAS_VMS BIT,
        IS_FPC BIT not null,
        UPDATE_DATE TIMESTAMP,
        BASE_PORT_LOCATION_FK integer,
        HULL_MATERIAL_QV_FK integer,
        VESSEL_FK VARCHAR(12) not null,
        primary key (ID)
    );

    create table VESSEL_FLEET_EVENT (
        EVENT_DATE TIMESTAMP not null,
        RANK_ORDER SMALLINT not null,
        VESSEL_FK VARCHAR(12) not null,
        EVENT_TYPE_FK integer not null,
        primary key (EVENT_DATE, RANK_ORDER, VESSEL_FK, EVENT_TYPE_FK)
    );

    create table VESSEL_MANAGE_PERIOD (
        START_DATE_TIME TIMESTAMP not null,
        VESSEL_FK VARCHAR(12) not null,
        MANAGED_DATA_FK integer not null,
        END_DATE_TIME TIMESTAMP,
        primary key (START_DATE_TIME, VESSEL_FK, MANAGED_DATA_FK)
    );

    create table VESSEL_OWNER (
        ID integer not null,
        REGISTRATION_CODE VARCHAR(40),
        LASTNAME VARCHAR(100),
        FIRSTNAME VARCHAR(100),
        STREET VARCHAR(255),
        ZIP_CODE VARCHAR(255),
        CITY VARCHAR(255),
        DATE_OF_BIRTH TIMESTAMP,
        RETIREMENT_DATE TIMESTAMP,
        UPDATE_DATE TIMESTAMP,
        PHONE_NUMBER VARCHAR(50),
        MOBILE_NUMBER VARCHAR(50),
        FAX_NUMBER VARCHAR(50),
        EMAIL VARCHAR(255),
        ACTIVITY_START_DATE TIMESTAMP,
        PROGRAM_FK VARCHAR(40) not null,
        COUNTRY_LOCATION_FK integer,
        primary key (ID)
    );

    create table VESSEL_OWNER2RIGHT_TO_PRODUCE (
        VESSEL_OWNER_FK integer not null,
        RIGHT_TO_PRODUCE_FK integer not null,
        primary key (RIGHT_TO_PRODUCE_FK, VESSEL_OWNER_FK)
    );

    create table VESSEL_OWNER_PERIOD (
        START_DATE_TIME TIMESTAMP not null,
        VESSEL_FK VARCHAR(12) not null,
        VESSEL_OWNER_FK integer not null,
        END_DATE_TIME TIMESTAMP,
        primary key (START_DATE_TIME, VESSEL_FK, VESSEL_OWNER_FK)
    );

    create table VESSEL_PERSON (
        ID integer not null,
        REGISTRATION_CODE VARCHAR(40),
        LASTNAME VARCHAR(100),
        FIRSTNAME VARCHAR(100),
        STREET VARCHAR(255),
        ZIP_CODE VARCHAR(255),
        CITY VARCHAR(255),
        DATE_OF_BIRTH TIMESTAMP,
        RETIREMENT_DATE TIMESTAMP,
        PHONE_NUMBER VARCHAR(50),
        MOBILE_NUMBER VARCHAR(50),
        FAX_NUMBER VARCHAR(50),
        EMAIL VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        EDUCATION_GRADE_FK integer,
        COUNTRY_LOCATION_FK integer,
        PROGRAM_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table VESSEL_PERSON_FEATURES (
        ID integer not null,
        START_DATE TIMESTAMP not null,
        END_DATE TIMESTAMP,
        RANK_ORDER SMALLINT,
        CREATION_DATE TIMESTAMP,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        OPERATION_FK integer,
        FISHING_TRIP_FK integer,
        ECONOMICAL_SURVEY_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        VESSEL_PERSON_FK integer,
        PERSON_FK integer,
        PROGRAM_FK VARCHAR(40) not null,
        VESSEL_FK VARCHAR(12) not null,
        primary key (ID)
    );

    create table VESSEL_PERSON_FEATURES2ROLE (
        VESSEL_PERSON_FEATURES_FK integer not null,
        VESSEL_PERSON_ROLES_FK integer not null,
        primary key (VESSEL_PERSON_FEATURES_FK, VESSEL_PERSON_ROLES_FK)
    );

    create table VESSEL_PERSON_MEASUREMENT (
        ID integer not null,
        NUMERICAL_VALUE REAL,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        DIGIT_COUNT integer,
        PRECISION_VALUE REAL,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        AGGREGATION_LEVEL_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PRECISION_TYPE_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        NUMERICAL_PRECISION_FK integer,
        DEPARTMENT_FK integer,
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer,
        VESSEL_PERSON_FEATURES_FK integer not null,
        primary key (ID)
    );

    create table VESSEL_PERSON_ROLE (
        ID integer not null,
        LABEL VARCHAR(40) not null,
        NAME VARCHAR(100) not null,
        DESCRIPTION VARCHAR(255),
        UPDATE_DATE TIMESTAMP,
        primary key (ID)
    );

    create table VESSEL_PHYSICAL_FEATURES (
        ID integer not null,
        START_DATE TIMESTAMP,
        END_DATE TIMESTAMP,
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        PROGRAM_FK VARCHAR(40) not null,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        VESSEL_FK VARCHAR(12) not null,
        RANK_ORDER SMALLINT,
        NAME VARCHAR(100),
        EXTERIOR_MARKING VARCHAR(100),
        IRCS VARCHAR(40),
        COMMENTS VARCHAR(2000),
        RECORDER_DEPARTMENT_FK integer not null,
        BASE_LANDING_LOCATION_FK integer,
        RECORDER_PERSON_FK integer,
        PHYSICAL_GEAR_SURVEY_FK integer,
        primary key (ID)
    );

    create table VESSEL_PHYSICAL_FEATURES_ORIGI (
        VESSEL_PHYSICAL_FEATURES_FK integer not null,
        PROGRAM_FK VARCHAR(40) not null,
        ACQUISITION_LEVEL_FK VARCHAR(40),
        primary key (VESSEL_PHYSICAL_FEATURES_FK, PROGRAM_FK)
    );

    create table VESSEL_PHYSICAL_MEASUREMENT (
        ID integer not null,
        NUMERICAL_VALUE REAL,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        DIGIT_COUNT integer,
        PRECISION_VALUE REAL,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        AGGREGATION_LEVEL_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PRECISION_TYPE_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        NUMERICAL_PRECISION_FK integer,
        DEPARTMENT_FK integer,
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer,
        VESSEL_PHYSICAL_FEATURES_FK integer not null,
        primary key (ID)
    );

    create table VESSEL_POSITION (
        ID BIGINT not null,
        DATE_TIME TIMESTAMP,
        LATITUDE REAL,
        LONGITUDE REAL,
        VESSEL_SPEED DECIMAL(5,2),
        VESSEL_DIRECTION DECIMAL(5,2),
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        PROCESSING_HISTORY_FK integer,
        RECORDER_DEPARTMENT_FK integer not null,
        OPERATION_FK integer,
        VESSEL_FK VARCHAR(12) not null,
        PROGRAM_FK VARCHAR(40) not null,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        primary key (ID)
    );

    create table VESSEL_POSITION_MEASUREMENT (
        ID integer not null,
        NUMERICAL_VALUE REAL,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        DIGIT_COUNT integer,
        PRECISION_VALUE REAL,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        AGGREGATION_LEVEL_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PRECISION_TYPE_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        NUMERICAL_PRECISION_FK integer,
        DEPARTMENT_FK integer,
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer,
        VESSEL_POSITION_FK BIGINT not null,
        primary key (ID)
    );

    create table VESSEL_REGISTRATION_PERIOD (
        START_DATE_TIME TIMESTAMP not null,
        REGISTRATION_LOCATION_FK integer not null,
        VESSEL_FK VARCHAR(12) not null,
        END_DATE_TIME TIMESTAMP,
        REGISTRATION_CODE VARCHAR(40),
        INT_REGISTRATION_CODE VARCHAR(40),
        RANK_ORDER SMALLINT not null,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        primary key (START_DATE_TIME, REGISTRATION_LOCATION_FK, VESSEL_FK)
    );

    create table VESSEL_TYPE (
        ID integer not null,
        NAME VARCHAR(100) not null,
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        primary key (ID)
    );

    create table VESSEL_USE_FEATURES (
        ID integer not null,
        START_DATE TIMESTAMP,
        END_DATE TIMESTAMP,
        CREATION_DATE TIMESTAMP not null,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        REMOTE_ID integer,
        PROGRAM_FK VARCHAR(40) not null,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        VESSEL_FK VARCHAR(12) not null,
        IS_ACTIVE integer,
        DAILY_ACTIVITY_CALENDAR_FK integer,
        BASE_PORT_LOCATION_FK integer,
        OPERATION_FK integer,
        FISHING_TRIP_FK integer,
        ACTIVITY_CALENDAR_FK integer,
        ECONOMICAL_SURVEY_FK integer,
        FISHING_EFFORT_CALENDAR_FK integer,
        primary key (ID)
    );

    create table VESSEL_USE_FEATURES_ORIGIN (
        PROGRAM_FK VARCHAR(40) not null,
        VESSEL_USE_FEATURES_FK integer not null,
        ACQUISITION_LEVEL_FK VARCHAR(40),
        primary key (PROGRAM_FK, VESSEL_USE_FEATURES_FK)
    );

    create table VESSEL_USE_MEASUREMENT (
        ID integer not null,
        NUMERICAL_VALUE REAL,
        ALPHANUMERICAL_VALUE VARCHAR(40),
        DIGIT_COUNT integer,
        PRECISION_VALUE REAL,
        CONTROL_DATE TIMESTAMP,
        VALIDATION_DATE TIMESTAMP,
        QUALIFICATION_DATE TIMESTAMP,
        QUALIFICATION_COMMENTS VARCHAR(2000),
        REMOTE_ID integer,
        AGGREGATION_LEVEL_FK integer,
        QUALITY_FLAG_FK VARCHAR(40) not null,
        PRECISION_TYPE_FK integer,
        ANALYSIS_INSTRUMENT_FK integer,
        NUMERICAL_PRECISION_FK integer,
        DEPARTMENT_FK integer,
        PMFM_FK integer not null,
        QUALITATIVE_VALUE_FK integer,
        VESSEL_USE_FEATURES_FK integer not null,
        primary key (ID)
    );

    create table VIRTUAL_COMPONENT (
        REFERENCE_TAXON_FK integer not null,
        TAXON_NAME_FK integer not null,
        UPDATE_DATE TIMESTAMP,
        primary key (REFERENCE_TAXON_FK, TAXON_NAME_FK)
    );

    create table WEIGHT_LENGTH_CONVERSION (
        ID integer not null,
        CONVERSION_COEFFICIENT_A DOUBLE not null,
        CONVERSION_COEFFICIENT_B DOUBLE not null,
        START_MONTH INTEGER(2) not null,
        END_MONTH INTEGER(2) not null,
        YEAR INTEGER(4),
        DESCRIPTION VARCHAR(255),
        COMMENTS VARCHAR(2000),
        UPDATE_DATE TIMESTAMP,
        STATUS_FK VARCHAR(1) not null,
        SEX_QUALITATIVE_VALUE_FK integer,
        LENGTH_PARAMETER_FK VARCHAR(40) not null,
        LENGTH_UNIT_FK integer not null,
        REFERENCE_TAXON_FK integer not null,
        LOCATION_FK integer not null,
        primary key (ID)
    );

    alter table ACTIVITY_CALENDAR 
        add constraint UK_ca23digiwduuc4bd2olbmb0ev  unique (FISHING_EFFORT_CALENDAR_FK);

    create index ACTIVITY_CALENDAR_NATIDX on ACTIVITY_CALENDAR (YEAR, VESSEL_FK, PROGRAM_FK);

    create index IX_ACTIVITY_CALENDAR_UD on ACTIVITY_CALENDAR (UPDATE_DATE);

    create index IX_APPLIED_SIZE_CATEGORY_UD on APPLIED_SIZE_CATEGORY (UPDATE_DATE);

    create index IX_BATCH_UD on BATCH (UPDATE_DATE);

    create index IX_FK_BATCH_ROOT on BATCH (ROOT_BATCH_FK);

    create index DAILY_ACTIVITY_CALENDAR_NATIDX on DAILY_ACTIVITY_CALENDAR (START_DATE, END_DATE, VESSEL_FK, PROGRAM_FK);

    create index IX_DAILY_ACTIVITY_CALENDAR_UD on DAILY_ACTIVITY_CALENDAR (UPDATE_DATE);

    create index DECLARED_DOCUMENT_RE_NATIDX on DECLARED_DOCUMENT_REFERENCE (REFERENCE, PROGRAM_FK, VESSEL_FK);

    create index IX_DECLARED_DOC_CREATION_DATE on DECLARED_DOCUMENT_REFERENCE (CREATION_DATE);

    create index IX_DECLARED_DOCUMENT_REF_UD on DECLARED_DOCUMENT_REFERENCE (UPDATE_DATE);

    create index DENORMALIZED_VESSEL_NATIDX on DENORMALIZED_VESSEL (REGISTRATION_START_DATE, VESSEL_FK, PROGRAM_FK);

    create index IX_DENORMALIZED_VESSEL_SEARCH on DENORMALIZED_VESSEL (NAME, REGISTRATION_CODE, INT_REGISTRATION_CODE, EXTERIOR_MARKING);

    create index DEPARTMENT_NATIDX on DEPARTMENT (CODE);

    create index FISHING_AREA_NATIDX on FISHING_AREA (SALE_FK, SAMPLE_FK, DEPTH_GRADIENT_FK, LOCATION_FK, DISTANCE_TO_COAST_GRADIENT_FK, PRODUCE_FK, VESSEL_USE_FEATURES_FK, GEAR_USE_FEATURES_FK);

    create index FISHING_EFFORT_CALENDAR_NATIDX on FISHING_EFFORT_CALENDAR (YEAR, PROGRAM_FK, VESSEL_FK);

    create index IX_FISHING_EFFORT_CALENDAR_UD on FISHING_EFFORT_CALENDAR (UPDATE_DATE);

    create index FISHING_TRIP_NATIDX on FISHING_TRIP (DEPARTURE_DATE_TIME, PROGRAM_FK, VESSEL_FK, DECLARED_DOCUMENT_REFERENCE_FK);

    create index IX_FISHING_TRIP_RETURN_DATE on FISHING_TRIP (RETURN_DATE_TIME);

    create index IX_FISHING_TRIP_UD on FISHING_TRIP (UPDATE_DATE);

    create index IX_GEAR_UD on GEAR (UPDATE_DATE);

    create index IX_GEAR_ASSOCIATION_UD on GEAR_ASSOCIATION (UPDATE_DATE);

    create index PHYSICAL_FEATURES_NATIDX on GEAR_PHYSICAL_FEATURES (START_DATE, PROGRAM_FK, VESSEL_FK);

    create index GEAR_PHYSICAL_FEATURES_NATIDX on GEAR_PHYSICAL_FEATURES (RANK_ORDER, FISHING_TRIP_FK, PHYSICAL_GEAR_SURVEY_FK, GEAR_FK);

    create index USE_FEATURES_NATIDX on GEAR_USE_FEATURES (START_DATE, END_DATE, PROGRAM_FK, VESSEL_FK);

    create index GEAR_USE_FEATURES_NATIDX on GEAR_USE_FEATURES (ECONOMICAL_SURVEY_FK, OPERATION_FK, DAILY_ACTIVITY_CALENDAR_FK, ACTIVITY_CALENDAR_FK, FISHING_EFFORT_CALENDAR_FK, GEAR_FK, METIER_FK);

    create index LANDING_NATIDX on LANDING (LANDING_DATE_TIME, RANK_ORDER, PROGRAM_FK, VESSEL_FK);

    create index IX_LANDING_UD on LANDING (UPDATE_DATE);

    create index LINKED_ITEM_NATIDX on LINKED_ITEM (FROM_OBJECT_ID, FROM_OBJECT_CODE, TO_OBJECT_ID, TO_OBJECT_CODE, START_DATE, LINKED_ITEM_TYPE_FK);

    create index IX_LOCATION_UD on LOCATION (UPDATE_DATE);

    create index IX_LOCATION_ASSOCIATION_UD on LOCATION_ASSOCIATION (UPDATE_DATE);

    alter table METIER 
        add constraint UK_mq01kwnxuo51pfsiqvxwfyfyx  unique (LABEL);

    create index IX_MINIMUM_SIZE_ALLOWED_UD on MINIMUM_SIZE_ALLOWED (UPDATE_DATE);

    create index OBSERVED_LOCATION_NATIDX on OBSERVED_LOCATION (START_DATE_TIME, LOCATION_FK, PROGRAM_FK);

    create index IX_OBSERVED_LANDING_UD on OBSERVED_LOCATION (UPDATE_DATE);

    create index OBSERVED_LOCATION_F_NATIDX on OBSERVED_LOCATION_FEATURES (START_DATE, END_DATE, RANK_ORDER, METIER_FK, PROGRAM_FK, VESSEL_TYPE_FK);

    create index OPERATION_NATIDX on OPERATION (RANK_ORDER_ON_PERIOD, START_DATE_TIME, VESSEL_FK, FISHING_TRIP_FK, FISHING_START_DATE_TIME);

    create index IX_ORDER_ITEM_OBJID on ORDER_ITEM (OBJECT_ID);

    create index IX_ORDER_ITEM_UD on ORDER_ITEM (UPDATE_DATE);

    create index IX_PARAMETER_UD on PARAMETER (UPDATE_DATE);

    create index IX_PERSON_UD on PERSON (UPDATE_DATE);

    create index PERSON_SESSION_VESSEL_NATIDX on PERSON_SESSION_VESSEL (START_DATE_TIME, PERSON_SESSION_FK, VESSEL_FK, PROGRAM_FK, OBJECT_TYPE_FK);

    create index PHYSICAL_GEAR_SURVEY_NATIDX on PHYSICAL_GEAR_SURVEY (YEAR, PROGRAM_FK, VESSEL_FK);

    create index IX_PHYSICAL_GEAR_SURVEY_UD on PHYSICAL_GEAR_SURVEY (UPDATE_DATE);

    create index IX_PMFM_UD on PMFM (UPDATE_DATE);

    create index IX_REFERENCE_TAXON_UD on REFERENCE_TAXON (UPDATE_DATE);

    create index REGULATION_AREA_NATIDX on REGULATION_AREA (GROUPING_FK, FISHERY_FK, LOCATION_FK);

    create index IX_ROUND_WEIGHT_CONVERSION_UD on ROUND_WEIGHT_CONVERSION (UPDATE_DATE);

    create index IX_SALE_SALE_START_DATE on SALE (SALE_START_DATE);

    create index IX_SALE_UD on SALE (UPDATE_DATE);

    create index SAMPLE_NATIDX on SAMPLE (LABEL, MATRIX_FK, PROGRAM_FK, FISHING_OPERATION_FK);

    create index SCIENTIFIC_CRUISE_NATIDX on SCIENTIFIC_CRUISE (DEPARTURE_DATE_TIME, VESSEL_FK, PROGRAM_FK);

    create index IX_SCIENTIFIC_CRUISE_UD on SCIENTIFIC_CRUISE (UPDATE_DATE);

    create index IX_SPATIAL_ITEM_OBJID on SPATIAL_ITEM (OBJECT_ID);

    create index IX_SPATIAL_ITEM_UD on SPATIAL_ITEM (UPDATE_DATE);

    create index IX_TAKE_OVER_UD on TAKE_OVER (UPDATE_DATE);

    create index TAXON_GROUP_NATIDX on TAXON_GROUP (NAME, PARENT_TAXON_GROUP_FK, TAXON_GROUP_TYPE_FK);

    create index IX_TAXON_GROUP_UD on TAXON_GROUP (UPDATE_DATE);

    create index TAXON_GROUP_HISTORICAL_NATIDX on TAXON_GROUP_HISTORICAL_RECORD (START_DATE, REFERENCE_TAXON_FK, TAXON_GROUP_FK);

    create index IX_TAXON_NAME_UD on TAXON_NAME (UPDATE_DATE);

    create index IX_TRANSCRIBING_ITEM_ID on TRANSCRIBING_ITEM (OBJECT_ID, EXTERNAL_CODE, TRANSCRIBING_ITEM_TYPE_FK);

    alter table TRANSCRIBING_ITEM_TYPE 
        add constraint UK_iw1acfn9a1xvmjcstig6t70hd  unique (LABEL);

    create index TRANSSHIPMENT_NATIDX on TRANSSHIPMENT (TRANSSHIPMENT_DATE_TIME, RANK_ORDER, FROM_VESSEL_FK, PROGRAM_FK);

    create index IX_VESSEL_UD on VESSEL (UPDATE_DATE);

    create index VESSEL_FEATURES_NATIDX on VESSEL_FEATURES (START_DATE_TIME, VESSEL_FK);

    create index IX_VESSEL_FEATURES_UD on VESSEL_FEATURES (UPDATE_DATE);

    create index VESSEL_OWNER_NATIDX on VESSEL_OWNER (REGISTRATION_CODE, PROGRAM_FK);

    create index IX_VESSEL_OWNER_UD on VESSEL_OWNER (UPDATE_DATE);

    create index VESSEL_PERSON_NATIDX on VESSEL_PERSON (REGISTRATION_CODE);

    create index IX_VESSEL_PERSON_UD on VESSEL_PERSON (UPDATE_DATE);

    create index VESSEL_PERSON_FEATURES_NATIDX on VESSEL_PERSON_FEATURES (START_DATE, RANK_ORDER, OPERATION_FK, FISHING_TRIP_FK, ECONOMICAL_SURVEY_FK, VESSEL_PERSON_FK, PERSON_FK);

    create index IX_VESSEL_PERSON_FEATURES_UD on VESSEL_PERSON_FEATURES (UPDATE_DATE);

    create index PHYSICAL_FEATURES_NATIDX on VESSEL_PHYSICAL_FEATURES (START_DATE, PROGRAM_FK, VESSEL_FK);

    create index VESSEL_PHYSICAL_F_NATIDX on VESSEL_PHYSICAL_FEATURES (RANK_ORDER, PHYSICAL_GEAR_SURVEY_FK);

    create index VESSEL_POSITION_NATIDX on VESSEL_POSITION (DATE_TIME, OPERATION_FK, VESSEL_FK, PROGRAM_FK);

    create index IX_VESSEL_REG_PERIOD_VESSEL on VESSEL_REGISTRATION_PERIOD (END_DATE_TIME);

    create index IX_VESSEL_REG_CODE on VESSEL_REGISTRATION_PERIOD (REGISTRATION_CODE);

    create index IX_INT_REG_CODE on VESSEL_REGISTRATION_PERIOD (INT_REGISTRATION_CODE);

    create index USE_FEATURES_NATIDX on VESSEL_USE_FEATURES (START_DATE, END_DATE, PROGRAM_FK, VESSEL_FK);

    create index VESSEL_USE_FEATURES_NATIDX on VESSEL_USE_FEATURES (DAILY_ACTIVITY_CALENDAR_FK, OPERATION_FK, FISHING_TRIP_FK, ACTIVITY_CALENDAR_FK, ECONOMICAL_SURVEY_FK);

    create index IX_WEIGHT_LENGTH_CONVERSION_UD on WEIGHT_LENGTH_CONVERSION (UPDATE_DATE);

    create index IX_WEIGHT_LENGTH_CONVER_UNIT on WEIGHT_LENGTH_CONVERSION (LENGTH_UNIT_FK);

    alter table ACTIVITY_CALENDAR 
        add constraint ACTIVITY_CALENDAR_RECORDER_DEC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table ACTIVITY_CALENDAR 
        add constraint ACTIVITY_CALENDAR_RECORDER_PEC 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table ACTIVITY_CALENDAR 
        add constraint ACTIVITY_CALENDAR_QUALITY_FLAC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table ACTIVITY_CALENDAR 
        add constraint ACTIVITY_CALENDAR_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table ACTIVITY_CALENDAR 
        add constraint ACTIVITY_CALENDAR_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table ACTIVITY_CALENDAR 
        add constraint ACTIVITY_CALENDAR_FISHING_EFFC 
        foreign key (FISHING_EFFORT_CALENDAR_FK) 
        references FISHING_EFFORT_CALENDAR;

    alter table AGE_READER_QUAL2LOCATION 
        add constraint AGE_READER_QUALIFICATION_LOCAC 
        foreign key (LOCATION_FK) 
        references LOCATION;

    alter table AGE_READER_QUAL2LOCATION 
        add constraint LOCATION_AGE_READER_QUALIFICAC 
        foreign key (AGE_READER_QUALIFICATION_FK) 
        references AGE_READER_QUALIFICATION;

    alter table AGE_READER_QUAL2PERSON 
        add constraint AGE_READER_QUALIFICATION_PERSC 
        foreign key (PERSON_FK) 
        references PERSON;

    alter table AGE_READER_QUAL2PERSON 
        add constraint PERSON_AGE_READER_QUALIFICATIC 
        foreign key (AGE_READER_QUALIFICATION_FK) 
        references AGE_READER_QUALIFICATION;

    alter table AGE_READER_QUALIFICATION 
        add constraint AGE_READER_QUALIFICATION_REFEC 
        foreign key (REFERENCE_TAXON_FK) 
        references REFERENCE_TAXON;

    alter table ANALYSIS_INSTRUMENT 
        add constraint ANALYSIS_INSTRUMENT_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table APPLIED_PERIOD 
        add constraint APPLIED_PERIOD_APPLIED_STRATEC 
        foreign key (APPLIED_STRATEGY_FK) 
        references APPLIED_STRATEGY 
        on delete cascade;

    alter table APPLIED_QUALIFICATION_RULE 
        add constraint APPLIED_QUALIFICATION_RULE_PRC 
        foreign key (PROCESSING_HISTORY_FK) 
        references PROCESSING_HISTORY;

    alter table APPLIED_QUALIFICATION_RULE 
        add constraint APPLIED_QUALIFICATION_RULE_QUC 
        foreign key (QUALIFIED_ITEM_FK) 
        references QUALIFIED_ITEM 
        on delete cascade;

    alter table APPLIED_QUALIFICATION_RULE 
        add constraint APPLIED_QUALIFICATION_RULE_QUL 
        foreign key (QUALIFICATION_RULE_FK) 
        references QUALIFICATION_RULE;

    alter table APPLIED_QUALIFICATION_RULE 
        add constraint APPLIED_QUALIFICATION_RULE_QUR 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table APPLIED_SIZE_CATEGORY 
        add constraint APPLIED_SIZE_CATEGORY_SIZE_CAC 
        foreign key (SIZE_CATEGORY_FK) 
        references QUALITATIVE_VALUE;

    alter table APPLIED_SIZE_CATEGORY 
        add constraint APPLIED_SIZE_CATEGORY_LOCATIOC 
        foreign key (LOCATION_FK) 
        references LOCATION;

    alter table APPLIED_SIZE_CATEGORY 
        add constraint APPLIED_SIZE_CATEGORY_DRESSINC 
        foreign key (DRESSING_FK) 
        references QUALITATIVE_VALUE;

    alter table APPLIED_SIZE_CATEGORY 
        add constraint APPLIED_SIZE_CATEGORY_TAXON_GC 
        foreign key (TAXON_GROUP_FK) 
        references TAXON_GROUP;

    alter table APPLIED_STRATEGY 
        add constraint APPLIED_STRATEGY_STRATEGY_FKC 
        foreign key (STRATEGY_FK) 
        references STRATEGY 
        on delete cascade;

    alter table APPLIED_STRATEGY 
        add constraint APPLIED_STRATEGY_LOCATION_FKC 
        foreign key (LOCATION_FK) 
        references LOCATION;

    alter table AUTHOR 
        add constraint AUTHOR_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table BATCH 
        add constraint BATCH_LOCATION_FKC 
        foreign key (LOCATION_FK) 
        references LOCATION;

    alter table BATCH 
        add constraint BATCH_PARENT_BATCH_FKC 
        foreign key (PARENT_BATCH_FK) 
        references BATCH 
        on delete cascade;

    alter table BATCH 
        add constraint BATCH_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table BATCH 
        add constraint SORTING_BATCH_REFERENCE_TAXONC 
        foreign key (REFERENCE_TAXON_FK) 
        references REFERENCE_TAXON;

    alter table BATCH 
        add constraint SORTING_BATCH_ROOT_BATCH_FKC 
        foreign key (ROOT_BATCH_FK) 
        references BATCH;

    alter table BATCH 
        add constraint SORTING_BATCH_TAXON_GROUP_FKC 
        foreign key (TAXON_GROUP_FK) 
        references TAXON_GROUP;

    alter table BATCH_EXHAUSTIVE_INVENTORY 
        add constraint BATCH_EXHAUSTIVE_INVENTORY_BAC 
        foreign key (BATCH_FK) 
        references BATCH 
        on delete cascade;

    alter table BATCH_MODEL 
        add constraint BATCH_MODEL_CATCH_BATCH_FKC 
        foreign key (CATCH_BATCH_FK) 
        references BATCH;

    alter table BATCH_MODEL 
        add constraint BATCH_MODEL_RECORDER_PERSON_FC 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table BATCH_MODEL 
        add constraint BATCH_MODEL_RECORDER_DEPARTMEC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table BATCH_MODEL_APPLIED_STRATEGY 
        add constraint BATCH_MODEL_APPLIED_STRATEGY_C 
        foreign key (APPLIED_STRATEGY_FK) 
        references APPLIED_STRATEGY 
        on delete cascade;

    alter table BATCH_MODEL_APPLIED_STRATEGY 
        add constraint BATCH_MODEL_APPLIED_STRATEGY_E 
        foreign key (ACQUISITION_LEVEL_FK) 
        references ACQUISITION_LEVEL;

    alter table BATCH_MODEL_APPLIED_STRATEGY 
        add constraint BATCH_MODEL_APPLIED_STRATEGY_T 
        foreign key (BATCH_MODEL_FK) 
        references BATCH_MODEL;

    alter table BUYER 
        add constraint BUYER_BUYER_TYPE_FKC 
        foreign key (BUYER_TYPE_FK) 
        references BUYER_TYPE;

    alter table BUYER 
        add constraint BUYER_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table CITATION 
        add constraint CITATION_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table CORPUS 
        add constraint CORPUS_CORPUS_TYPE_FKC 
        foreign key (CORPUS_TYPE_FK) 
        references CORPUS_TYPE;

    alter table CORPUS2FISHERY 
        add constraint CORPUS_FISHERY_FKC 
        foreign key (FISHERY_FK) 
        references FISHERY;

    alter table CORPUS2FISHERY 
        add constraint FISHERY_CORPUS_FKC 
        foreign key (CORPUS_FK) 
        references CORPUS;

    alter table DAILY_ACTIVITY_CALENDAR 
        add constraint DAILY_ACTIVITY_CALENDAR_OBSERC 
        foreign key (OBSERVED_LOCATION_FK) 
        references OBSERVED_LOCATION 
        on delete cascade;

    alter table DAILY_ACTIVITY_CALENDAR 
        add constraint DAILY_ACTIVITY_CALENDAR_RECORC 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table DAILY_ACTIVITY_CALENDAR 
        add constraint DAILY_ACTIVITY_CALENDAR_RECORA 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table DAILY_ACTIVITY_CALENDAR 
        add constraint DAILY_ACTIVITY_CALENDAR_QUALIC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table DAILY_ACTIVITY_CALENDAR 
        add constraint DAILY_ACTIVITY_CALENDAR_VESSEC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table DAILY_ACTIVITY_CALENDAR 
        add constraint DAILY_ACTIVITY_CALENDAR_PROGRC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table DECLARED_DOCUMENT_REFERENCE 
        add constraint DECLARED_DOCUMENT_REFERENCE_PC 
        foreign key (PARENT_FK) 
        references DECLARED_DOCUMENT_REFERENCE 
        on delete cascade;

    alter table DECLARED_DOCUMENT_REFERENCE 
        add constraint DECLARED_DOCUMENT_REFERENCE_RC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table DECLARED_DOCUMENT_REFERENCE 
        add constraint DECLARED_DOCUMENT_REFERENCE_RT 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table DECLARED_DOCUMENT_REFERENCE 
        add constraint DECLARED_DOCUMENT_REFERENCE_PT 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table DECLARED_DOCUMENT_REFERENCE 
        add constraint DECLARED_DOCUMENT_REFERENCE_VC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table DECLARED_DOCUMENT_REFERENCE 
        add constraint DECLARED_DOCUMENT_REFERENCE_QC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table DELETED_ITEM_HISTORY 
        add constraint DELETED_ITEM_HISTORY_OBJECT_TC 
        foreign key (OBJECT_TYPE_FK) 
        references OBJECT_TYPE;

    alter table DELETED_ITEM_HISTORY 
        add constraint DELETED_ITEM_HISTORY_PROGRAM_C 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table DELETED_ITEM_HISTORY 
        add constraint DELETED_ITEM_HISTORY_RECORDERC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table DELETED_ITEM_HISTORY 
        add constraint DELETED_ITEM_HISTORY_RECORDERT 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table DELETED_ITEM_HISTORY 
        add constraint DELETED_ITEM_HISTORY_PROCESSIC 
        foreign key (PROCESSING_HISTORY_FK) 
        references PROCESSING_HISTORY 
        on delete cascade;

    alter table DENORMALIZED_BATCH 
        add constraint DENORMALIZED_BATCH_WEIGHT_METC 
        foreign key (WEIGHT_METHOD_FK) 
        references METHOD;

    alter table DENORMALIZED_BATCH 
        add constraint DENORMALIZED_BATCH_SALE_FKC 
        foreign key (SALE_FK) 
        references SALE;

    alter table DENORMALIZED_BATCH 
        add constraint DENORMALIZED_BATCH_INHERITED_C 
        foreign key (INHERITED_TAXON_GROUP_FK) 
        references TAXON_GROUP;

    alter table DENORMALIZED_BATCH 
        add constraint DENORMALIZED_BATCH_CALCULATEDC 
        foreign key (CALCULATED_TAXON_GROUP_FK) 
        references TAXON_GROUP;

    alter table DENORMALIZED_BATCH 
        add constraint DENORMALIZED_BATCH_INHERITED__ 
        foreign key (INHERITED_REFERENCE_TAXON_FK) 
        references REFERENCE_TAXON;

    alter table DENORMALIZED_BATCH 
        add constraint DENORMALIZED_BATCH_PARENT_BATC 
        foreign key (PARENT_BATCH_FK) 
        references DENORMALIZED_BATCH 
        on delete cascade;

    alter table DENORMALIZED_BATCH 
        add constraint DENORMALIZED_BATCH_OPERATION_C 
        foreign key (OPERATION_FK) 
        references OPERATION;

    alter table DENORMALIZED_BATCH 
        add constraint DENORMALIZED_BATCH_REFERENCE_C 
        foreign key (REFERENCE_TAXON_FK) 
        references REFERENCE_TAXON;

    alter table DENORMALIZED_BATCH 
        add constraint DENORMALIZED_BATCH_TAXON_GROUC 
        foreign key (TAXON_GROUP_FK) 
        references TAXON_GROUP;

    alter table DENORMALIZED_BATCH 
        add constraint DENORMALIZED_BATCH_QUALITY_FLC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table DENORMALIZED_BATCH_SORT_VAL 
        add constraint DENORMALIZED_BATCH_SORT_VAL_PC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table DENORMALIZED_BATCH_SORT_VAL 
        add constraint DENORMALIZED_BATCH_SORT_VAL_UC 
        foreign key (UNIT_FK) 
        references UNIT;

    alter table DENORMALIZED_BATCH_SORT_VAL 
        add constraint DENORMALIZED_BATCH_SORT_VAL_BC 
        foreign key (BATCH_FK) 
        references DENORMALIZED_BATCH 
        on delete cascade;

    alter table DENORMALIZED_BATCH_SORT_VAL 
        add constraint DENORMALIZED_BATCH_SORT_VAL_QC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table DENORMALIZED_BATCH_SORT_VAL 
        add constraint DENORMALIZED_BATCH_SORT_VAL_PP 
        foreign key (PARAMETER_FK) 
        references PARAMETER;

    alter table DENORMALIZED_OPERATION 
        add constraint DENORMALIZED_OPERATION_FISHINC 
        foreign key (FISHING_TRIP_FK) 
        references FISHING_TRIP;

    alter table DENORMALIZED_OPERATION 
        add constraint DENORMALIZED_OPERATION_SELECTC 
        foreign key (SELECTIVE_DEVICE_FK) 
        references QUALITATIVE_VALUE;

    alter table DENORMALIZED_OPERATION 
        add constraint DENORMALIZED_OPERATION_RECTANC 
        foreign key (RECTANGLE_LOCATION_FK) 
        references LOCATION;

    alter table DENORMALIZED_OPERATION 
        add constraint DENORMALIZED_OPERATION_AREA_LC 
        foreign key (AREA_LOCATION_FK) 
        references LOCATION;

    alter table DENORMALIZED_OPERATION 
        add constraint DENORMALIZED_OPERATION_SUBPOLC 
        foreign key (SUBPOLYGON_LOCATION_FK) 
        references LOCATION;

    alter table DENORMALIZED_OPERATION 
        add constraint DENORMALIZED_OPERATION_GEAR_FC 
        foreign key (GEAR_FK) 
        references GEAR;

    alter table DENORMALIZED_OPERATION 
        add constraint DENORMALIZED_OPERATION_METIERC 
        foreign key (METIER_FK) 
        references METIER;

    alter table DENORMALIZED_SAMPLING_STRATA 
        add constraint DENORMALIZED_SAMPLING_STRATA_C 
        foreign key (PERSON_FK) 
        references PERSON;

    alter table DENORMALIZED_SAMPLING_STRATA 
        add constraint DENORMALIZED_SAMPLING_STRATA_P 
        foreign key (OBSERVATION_LOCATION_FK) 
        references LOCATION;

    alter table DENORMALIZED_SAMPLING_STRATA 
        add constraint DENORMALIZED_SAMPLING_STRATA__ 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table DENORMALIZED_SAMPLING_STRATA 
        add constraint DENORMALIZED_SAMPLING_STRATA_L 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table DENORMALIZED_VESSEL 
        add constraint DENORMALIZED_VESSEL_REGISTRATC 
        foreign key (REGISTRATION_LOCATION_FK) 
        references LOCATION;

    alter table DENORMALIZED_VESSEL 
        add constraint DENORMALIZED_VESSEL_REGISTRATS 
        foreign key (REGISTRATION_COUNTRY_FK) 
        references LOCATION;

    alter table DENORMALIZED_VESSEL 
        add constraint DENORMALIZED_VESSEL_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table DENORMALIZED_VESSEL 
        add constraint DENORMALIZED_VESSEL_BASE_PORTC 
        foreign key (BASE_PORT_LOCATION_FK) 
        references LOCATION;

    alter table DENORMALIZED_VESSEL 
        add constraint DENORMALIZED_VESSEL_PROGRAM_FC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table DENORMALIZED_VESSEL 
        add constraint DENORMALIZED_VESSEL_VESSEL_OWC 
        foreign key (VESSEL_OWNER_FK) 
        references VESSEL_OWNER;

    alter table DEPARTMENT 
        add constraint DEPARTMENT_PARENT_DEPARTMENT_C 
        foreign key (PARENT_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table DEPARTMENT 
        add constraint DEPARTMENT_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table DEPARTMENT_HIERARCHY 
        add constraint DEPARTMENT_HIERARCHY_PARENT_DC 
        foreign key (PARENT_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table DEPARTMENT_HIERARCHY 
        add constraint DEPARTMENT_HIERARCHY_CHILD_DEC 
        foreign key (CHILD_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table DEPARTMENT_PRIVILEGE_TRANSFERT 
        add constraint DEPARTMENT_PRIVILEGE_TRANSFERC 
        foreign key (FROM_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table DEPARTMENT_PRIVILEGE_TRANSFERT 
        add constraint DEPARTMENT_PRIVILEGE_TRANSFERL 
        foreign key (TO_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table DEPARTMENT_PRIVILEGE_TRANSFERT 
        add constraint DEPARTMENT_PRIVILEGE_TRANSFERR 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table DEPTH_GRADIENT 
        add constraint DEPTH_GRADIENT_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table DISTANCE_TO_COAST_GRADIENT 
        add constraint DISTANCE_TO_COAST_GRADIENT_STC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table ECONOMICAL_SURVEY 
        add constraint ECONOMICAL_SURVEY_RECORDER_DEC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table ECONOMICAL_SURVEY 
        add constraint ECONOMICAL_SURVEY_RECORDER_PEC 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table ECONOMICAL_SURVEY 
        add constraint ECONOMICAL_SURVEY_QUALITY_FLAC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table ECONOMICAL_SURVEY 
        add constraint ECONOMICAL_SURVEY_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table ECONOMICAL_SURVEY 
        add constraint ECONOMICAL_SURVEY_VESSEL_OWNEC 
        foreign key (VESSEL_OWNER_FK) 
        references VESSEL_OWNER;

    alter table ECONOMICAL_SURVEY 
        add constraint ECONOMICAL_SURVEY_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table EXPECTED_SALE 
        add constraint EXPECTED_SALE_SALE_LOCATION_FC 
        foreign key (SALE_LOCATION_FK) 
        references LOCATION;

    alter table EXPECTED_SALE 
        add constraint EXPECTED_SALE_FISHING_TRIP_FKC 
        foreign key (FISHING_TRIP_FK) 
        references FISHING_TRIP 
        on delete cascade;

    alter table EXPECTED_SALE 
        add constraint EXPECTED_SALE_SALE_TYPE_FKC 
        foreign key (SALE_TYPE_FK) 
        references SALE_TYPE;

    alter table EXPECTED_SALE 
        add constraint EXPECTED_SALE_OBSERVED_LANDINC 
        foreign key (OBSERVED_LANDING_FK) 
        references LANDING 
        on delete cascade;

    alter table FISHING_AREA 
        add constraint FISHING_AREA_SALE_FKC 
        foreign key (SALE_FK) 
        references SALE 
        on delete cascade;

    alter table FISHING_AREA 
        add constraint FISHING_AREA_SAMPLE_FKC 
        foreign key (SAMPLE_FK) 
        references SAMPLE 
        on delete cascade;

    alter table FISHING_AREA 
        add constraint FISHING_AREA_DEPTH_GRADIENT_FC 
        foreign key (DEPTH_GRADIENT_FK) 
        references DEPTH_GRADIENT;

    alter table FISHING_AREA 
        add constraint FISHING_AREA_LOCATION_FKC 
        foreign key (LOCATION_FK) 
        references LOCATION;

    alter table FISHING_AREA 
        add constraint FISHING_AREA_DISTANCE_TO_COASC 
        foreign key (DISTANCE_TO_COAST_GRADIENT_FK) 
        references DISTANCE_TO_COAST_GRADIENT;

    alter table FISHING_AREA 
        add constraint FISHING_AREA_NEARBY_SPECIFIC_C 
        foreign key (NEARBY_SPECIFIC_AREA_FK) 
        references NEARBY_SPECIFIC_AREA;

    alter table FISHING_AREA 
        add constraint FISHING_AREA_PRODUCE_FKC 
        foreign key (PRODUCE_FK) 
        references PRODUCE 
        on delete cascade;

    alter table FISHING_AREA 
        add constraint FISHING_AREA_VESSEL_USE_FEATUC 
        foreign key (VESSEL_USE_FEATURES_FK) 
        references VESSEL_USE_FEATURES 
        on delete cascade;

    alter table FISHING_AREA 
        add constraint FISHING_AREA_GEAR_USE_FEATUREC 
        foreign key (GEAR_USE_FEATURES_FK) 
        references GEAR_USE_FEATURES 
        on delete cascade;

    alter table FISHING_AREA2REG_LOCATION 
        add constraint FISHING_AREA2REG_LOCATION_FISC 
        foreign key (FISHING_AREA_FK) 
        references FISHING_AREA 
        on delete cascade;

    alter table FISHING_AREA2REG_LOCATION 
        add constraint FISHING_AREA2REG_LOCATION_LOCC 
        foreign key (LOCATION_FK) 
        references LOCATION;

    alter table FISHING_EFFORT_CALENDAR 
        add constraint FISHING_EFFORT_CALENDAR_RECORC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table FISHING_EFFORT_CALENDAR 
        add constraint FISHING_EFFORT_CALENDAR_RECORS 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table FISHING_EFFORT_CALENDAR 
        add constraint FISHING_EFFORT_CALENDAR_PROGRC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table FISHING_EFFORT_CALENDAR 
        add constraint FISHING_EFFORT_CALENDAR_VESSEC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table FISHING_EFFORT_CALENDAR 
        add constraint FISHING_EFFORT_CALENDAR_QUALIC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table FISHING_TRIP 
        add constraint FISHING_TRIP_RETURN_LOCATION_C 
        foreign key (RETURN_LOCATION_FK) 
        references LOCATION;

    alter table FISHING_TRIP 
        add constraint FISHING_TRIP_DEPARTURE_LOCATIC 
        foreign key (DEPARTURE_LOCATION_FK) 
        references LOCATION;

    alter table FISHING_TRIP 
        add constraint FISHING_TRIP_RECORDER_DEPARTMC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table FISHING_TRIP 
        add constraint FISHING_TRIP_RECORDER_PERSON_C 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table FISHING_TRIP 
        add constraint FISHING_TRIP_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table FISHING_TRIP 
        add constraint FISHING_TRIP_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table FISHING_TRIP 
        add constraint FISHING_TRIP_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table FISHING_TRIP 
        add constraint FISHING_TRIP_SCIENTIFIC_CRUISC 
        foreign key (SCIENTIFIC_CRUISE_FK) 
        references SCIENTIFIC_CRUISE 
        on delete cascade;

    alter table FISHING_TRIP 
        add constraint FISHING_TRIP_DECLARED_DOCUMENC 
        foreign key (DECLARED_DOCUMENT_REFERENCE_FK) 
        references DECLARED_DOCUMENT_REFERENCE 
        on delete cascade;

    alter table FISHING_TRIP 
        add constraint OBSERVED_FISHING_TRIP_SAMPLINC 
        foreign key (SAMPLING_STRATA_FK) 
        references DENORMALIZED_SAMPLING_STRATA;

    alter table FISHING_TRIP2OBSERVER_PERSON 
        add constraint OBSERVED_FISHING_TRIP_PERSON_C 
        foreign key (PERSON_FK) 
        references PERSON;

    alter table FISHING_TRIP2OBSERVER_PERSON 
        add constraint PERSON_FISHING_TRIP_FKC 
        foreign key (FISHING_TRIP_FK) 
        references FISHING_TRIP;

    alter table FISHING_TRIP_ORIGIN 
        add constraint FISHING_TRIP_ORIGIN_PROGRAM_FC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table FISHING_TRIP_ORIGIN 
        add constraint FISHING_TRIP_ORIGIN_ORIGIN_FIC 
        foreign key (ORIGIN_FISHING_TRIP_FK) 
        references FISHING_TRIP;

    alter table FISHING_TRIP_ORIGIN 
        add constraint FISHING_TRIP_ORIGIN_FISHING_TC 
        foreign key (FISHING_TRIP_FK) 
        references FISHING_TRIP 
        on delete cascade;

    alter table FRACTION 
        add constraint FRACTION_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table FRACTION2MATRIX 
        add constraint FRACTION_MATRIX_FKC 
        foreign key (MATRIX_FK) 
        references MATRIX;

    alter table FRACTION2MATRIX 
        add constraint MATRIX_FRACTION_FKC 
        foreign key (FRACTION_FK) 
        references FRACTION;

    alter table GEAR 
        add constraint GEAR_PARENT_GEAR_FKC 
        foreign key (PARENT_GEAR_FK) 
        references GEAR 
        on delete cascade;

    alter table GEAR 
        add constraint GEAR_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table GEAR 
        add constraint GEAR_GEAR_CLASSIFICATION_FKC 
        foreign key (GEAR_CLASSIFICATION_FK) 
        references GEAR_CLASSIFICATION;

    alter table GEAR_ASSOCIATION 
        add constraint GEAR_ASSOCIATION_TO_GEAR_FKC 
        foreign key (TO_GEAR_FK) 
        references GEAR;

    alter table GEAR_ASSOCIATION 
        add constraint GEAR_ASSOCIATION_FROM_GEAR_FKC 
        foreign key (FROM_GEAR_FK) 
        references GEAR;

    alter table GEAR_CLASSIFICATION_ASSOCIATIO 
        add constraint GEAR_CLASSIFICATION_ASSOCIATIC 
        foreign key (TO_GEAR_CLASSIFICATION_FK) 
        references GEAR_CLASSIFICATION;

    alter table GEAR_CLASSIFICATION_ASSOCIATIO 
        add constraint GEAR_CLASSIFICATION_ASSOCIATIS 
        foreign key (FROM_GEAR_CLASSIFICATION_FK) 
        references GEAR_CLASSIFICATION;

    alter table GEAR_PHYSICAL_FEATURES 
        add constraint GEAR_PHYSICAL_FEAT_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table GEAR_PHYSICAL_FEATURES 
        add constraint GEAR_PHYSICAL_FEA_QUALITY_FLAC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table GEAR_PHYSICAL_FEATURES 
        add constraint GEAR_PHYSICAL_FEATU_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table GEAR_PHYSICAL_FEATURES 
        add constraint GEAR_PHYSICAL_FEATURES_FISHINC 
        foreign key (FISHING_TRIP_FK) 
        references FISHING_TRIP 
        on delete cascade;

    alter table GEAR_PHYSICAL_FEATURES 
        add constraint GEAR_PHYSICAL_FEATURES_OTHER_C 
        foreign key (OTHER_GEAR_FK) 
        references GEAR;

    alter table GEAR_PHYSICAL_FEATURES 
        add constraint GEAR_PHYSICAL_FEATURES_PHYSICC 
        foreign key (PHYSICAL_GEAR_SURVEY_FK) 
        references PHYSICAL_GEAR_SURVEY 
        on delete cascade;

    alter table GEAR_PHYSICAL_FEATURES 
        add constraint GEAR_PHYSICAL_FEATURES_GEAR_FC 
        foreign key (GEAR_FK) 
        references GEAR;

    alter table GEAR_PHYSICAL_FEATURES_ORIGIN 
        add constraint GEAR_PHYSICAL_FEATURES_ORIGINS 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table GEAR_PHYSICAL_FEATURES_ORIGIN 
        add constraint GEAR_PHYSICAL_FEATURES_ORIGINC 
        foreign key (GEAR_PHYSICAL_FEATURES_FK) 
        references GEAR_PHYSICAL_FEATURES 
        on delete cascade;

    alter table GEAR_PHYSICAL_FEATURES_ORIGIN 
        add constraint GEAR_PHYSICAL_FEATURES_ORIGING 
        foreign key (ACQUISITION_LEVEL_FK) 
        references ACQUISITION_LEVEL;

    alter table GEAR_PHYSICAL_MEASUREMENT 
        add constraint GEAR_PHYSIC_AGGREGATION_LEVELC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table GEAR_PHYSICAL_MEASUREMENT 
        add constraint GEAR_PHYSICAL_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table GEAR_PHYSICAL_MEASUREMENT 
        add constraint GEAR_PHYSIC_PRECISION_TYPE_FKC 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table GEAR_PHYSICAL_MEASUREMENT 
        add constraint GEAR_PHYSIC_ANALYSIS_INSTRUMEC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table GEAR_PHYSICAL_MEASUREMENT 
        add constraint GEAR_PHYSIC_NUMERICAL_PRECISIC 
        foreign key (NUMERICAL_PRECISION_FK) 
        references NUMERICAL_PRECISION;

    alter table GEAR_PHYSICAL_MEASUREMENT 
        add constraint GEAR_PHYSICAL_M_DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table GEAR_PHYSICAL_MEASUREMENT 
        add constraint GEAR_PHYSICAL_MEASURE_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table GEAR_PHYSICAL_MEASUREMENT 
        add constraint GEAR_PHYSIC_QUALITATIVE_VALUEC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table GEAR_PHYSICAL_MEASUREMENT 
        add constraint GEAR_PHYSICAL_MEASUREMENT_GEAC 
        foreign key (GEAR_PHYSICAL_FEATURES_FK) 
        references GEAR_PHYSICAL_FEATURES 
        on delete cascade;

    alter table GEAR_USE_FEATURES 
        add constraint GEAR_USE_FEATURES_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table GEAR_USE_FEATURES 
        add constraint GEAR_USE_FEAT_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table GEAR_USE_FEATURES 
        add constraint GEAR_USE_FEATURES_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table GEAR_USE_FEATURES 
        add constraint GEAR_USE_FEATURES_ECONOMICAL_C 
        foreign key (ECONOMICAL_SURVEY_FK) 
        references ECONOMICAL_SURVEY 
        on delete cascade;

    alter table GEAR_USE_FEATURES 
        add constraint GEAR_USE_FEATURES_OTHER_GEAR_C 
        foreign key (OTHER_GEAR_FK) 
        references GEAR;

    alter table GEAR_USE_FEATURES 
        add constraint GEAR_USE_FEATURES_OPERATION_FC 
        foreign key (OPERATION_FK) 
        references OPERATION 
        on delete cascade;

    alter table GEAR_USE_FEATURES 
        add constraint GEAR_USE_FEATURES_DAILY_ACTIVC 
        foreign key (DAILY_ACTIVITY_CALENDAR_FK) 
        references DAILY_ACTIVITY_CALENDAR 
        on delete cascade;

    alter table GEAR_USE_FEATURES 
        add constraint GEAR_USE_FEATURES_ACTIVITY_CAC 
        foreign key (ACTIVITY_CALENDAR_FK) 
        references ACTIVITY_CALENDAR 
        on delete cascade;

    alter table GEAR_USE_FEATURES 
        add constraint GEAR_USE_FEATURES_FISHING_EFFC 
        foreign key (FISHING_EFFORT_CALENDAR_FK) 
        references FISHING_EFFORT_CALENDAR 
        on delete cascade;

    alter table GEAR_USE_FEATURES 
        add constraint GEAR_USE_FEATURES_GEAR_FKC 
        foreign key (GEAR_FK) 
        references GEAR;

    alter table GEAR_USE_FEATURES 
        add constraint GEAR_USE_FEATURES_METIER_FKC 
        foreign key (METIER_FK) 
        references METIER;

    alter table GEAR_USE_FEATURES_ORIGIN 
        add constraint GEAR_USE_FEATURES_ORIGIN_GEARC 
        foreign key (GEAR_USE_FEATURES_FK) 
        references GEAR_USE_FEATURES 
        on delete cascade;

    alter table GEAR_USE_FEATURES_ORIGIN 
        add constraint GEAR_USE_FEATURES_ORIGIN_PROGC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table GEAR_USE_FEATURES_ORIGIN 
        add constraint GEAR_USE_FEATURES_ORIGIN_ACQUC 
        foreign key (ACQUISITION_LEVEL_FK) 
        references ACQUISITION_LEVEL;

    alter table GEAR_USE_MEASUREMENT 
        add constraint GEAR_USE_ME_AGGREGATION_LEVELC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table GEAR_USE_MEASUREMENT 
        add constraint GEAR_USE_MEAS_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table GEAR_USE_MEASUREMENT 
        add constraint GEAR_USE_ME_PRECISION_TYPE_FKC 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table GEAR_USE_MEASUREMENT 
        add constraint GEAR_USE_ME_ANALYSIS_INSTRUMEC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table GEAR_USE_MEASUREMENT 
        add constraint GEAR_USE_ME_NUMERICAL_PRECISIC 
        foreign key (NUMERICAL_PRECISION_FK) 
        references NUMERICAL_PRECISION;

    alter table GEAR_USE_MEASUREMENT 
        add constraint GEAR_USE_MEASUR_DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table GEAR_USE_MEASUREMENT 
        add constraint GEAR_USE_MEASUREMENT_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table GEAR_USE_MEASUREMENT 
        add constraint GEAR_USE_ME_QUALITATIVE_VALUEC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table GEAR_USE_MEASUREMENT 
        add constraint GEAR_USE_MEASUREMENT_GEAR_USEC 
        foreign key (GEAR_USE_FEATURES_FK) 
        references GEAR_USE_FEATURES 
        on delete cascade;

    alter table GROUPING 
        add constraint GROUPING_PARENT_GROUPING_FKC 
        foreign key (PARENT_GROUPING_FK) 
        references GROUPING 
        on delete cascade;

    alter table GROUPING 
        add constraint GROUPING_GROUPING_CLASSIFICATC 
        foreign key (GROUPING_CLASSIFICATION_FK) 
        references GROUPING_CLASSIFICATION;

    alter table GROUPING 
        add constraint GROUPING_GROUPING_LEVEL_FKC 
        foreign key (GROUPING_LEVEL_FK) 
        references GROUPING_LEVEL;

    alter table GROUPING 
        add constraint GROUPING_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table GROUPING_CLASSIFICATION 
        add constraint GROUPING_CLASSIFICATION_OBJECC 
        foreign key (OBJECT_TYPE_FK) 
        references OBJECT_TYPE;

    alter table GROUPING_ITEM 
        add constraint GROUPING_ITEM_GROUPING_FKC 
        foreign key (GROUPING_FK) 
        references GROUPING 
        on delete cascade;

    alter table GROUPING_ITEM_HIERARCHY 
        add constraint GROUPING_ITEM_HIERARCHY_GROUPC 
        foreign key (GROUPING_FK) 
        references GROUPING;

    alter table GROUPING_ITEM_HIERARCHY 
        add constraint GROUPING_ITEM_HIERARCHY_GROUPH 
        foreign key (GROUPING_CLASSIFICATION_FK) 
        references GROUPING_CLASSIFICATION;

    alter table GROUPING_LEVEL 
        add constraint GROUPING_LEVEL_PARENT_GROUPINC 
        foreign key (PARENT_GROUPING_LEVEL_FK) 
        references GROUPING_LEVEL 
        on delete cascade;

    alter table GROUPING_LEVEL 
        add constraint GROUPING_LEVEL_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table GROUPING_LEVEL 
        add constraint GROUPING_LEVEL_GROUPING_CLASSC 
        foreign key (GROUPING_CLASSIFICATION_FK) 
        references GROUPING_CLASSIFICATION;

    alter table GROUPING_VESSEL_HIERARCHY 
        add constraint GROUPING_VESSEL_HIERARCHY_GROC 
        foreign key (GROUPING_FK) 
        references GROUPING;

    alter table GROUPING_VESSEL_HIERARCHY 
        add constraint GROUPING_VESSEL_HIERARCHY_ORIC 
        foreign key (ORIGIN_PROGRAM_FK) 
        references PROGRAM;

    alter table GROUPING_VESSEL_HIERARCHY 
        add constraint GROUPING_VESSEL_HIERARCHY_ORIR 
        foreign key (ORIGIN_OBJECT_TYPE_FK) 
        references OBJECT_TYPE;

    alter table GROUPING_VESSEL_HIERARCHY 
        add constraint GROUPING_VESSEL_HIERARCHY_GROR 
        foreign key (GROUPING_CLASSIFICATION_FK) 
        references GROUPING_CLASSIFICATION;

    alter table GROUPING_VESSEL_HIERARCHY 
        add constraint GROUPING_VESSEL_HIERARCHY_LOCC 
        foreign key (LOCATION_FK) 
        references LOCATION;

    alter table GROUPING_VESSEL_HIERARCHY 
        add constraint GROUPING_VESSEL_HIERARCHY_VESC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table INSERTED_ITEM_HISTORY 
        add constraint INSERTED_ITEM_HISTORY_OBJECT_C 
        foreign key (OBJECT_TYPE_FK) 
        references OBJECT_TYPE;

    alter table INSERTED_ITEM_HISTORY 
        add constraint INSERTED_ITEM_HISTORY_PROCESSC 
        foreign key (PROCESSING_HISTORY_FK) 
        references PROCESSING_HISTORY 
        on delete cascade;

    alter table LANDING 
        add constraint LANDING_LANDING_LOCATION_FKC 
        foreign key (LANDING_LOCATION_FK) 
        references LOCATION;

    alter table LANDING 
        add constraint LANDING_OBSERVED_LOCATION_FKC 
        foreign key (OBSERVED_LOCATION_FK) 
        references OBSERVED_LOCATION 
        on delete cascade;

    alter table LANDING 
        add constraint LANDING_RECORDER_DEPARTMENT_FC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table LANDING 
        add constraint LANDING_RECORDER_PERSON_FKC 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table LANDING 
        add constraint LANDING_CATCH_BATCH_FKC 
        foreign key (CATCH_BATCH_FK) 
        references BATCH;

    alter table LANDING 
        add constraint LANDING_FISHING_TRIP_FKC 
        foreign key (FISHING_TRIP_FK) 
        references FISHING_TRIP 
        on delete cascade;

    alter table LANDING 
        add constraint LANDING_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table LANDING 
        add constraint LANDING_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table LANDING 
        add constraint LANDING_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table LANDING2OBSERVER_PERSON 
        add constraint OBSERVED_LANDING_PERSON_FKC 
        foreign key (PERSON_FK) 
        references PERSON;

    alter table LANDING2OBSERVER_PERSON 
        add constraint PERSON_LANDING_FKC 
        foreign key (LANDING_FK) 
        references LANDING;

    alter table LANDING_MEASUREMENT 
        add constraint LANDING_MEA_AGGREGATION_LEVELC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table LANDING_MEASUREMENT 
        add constraint LANDING_MEASU_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table LANDING_MEASUREMENT 
        add constraint LANDING_MEA_PRECISION_TYPE_FKC 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table LANDING_MEASUREMENT 
        add constraint LANDING_MEA_ANALYSIS_INSTRUMEC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table LANDING_MEASUREMENT 
        add constraint LANDING_MEA_NUMERICAL_PRECISIC 
        foreign key (NUMERICAL_PRECISION_FK) 
        references NUMERICAL_PRECISION;

    alter table LANDING_MEASUREMENT 
        add constraint LANDING_MEASURE_DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table LANDING_MEASUREMENT 
        add constraint LANDING_MEASUREMENT_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table LANDING_MEASUREMENT 
        add constraint LANDING_MEA_QUALITATIVE_VALUEC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table LANDING_MEASUREMENT 
        add constraint LANDING_MEASUREMENT_LANDING_FC 
        foreign key (LANDING_FK) 
        references LANDING 
        on delete cascade;

    alter table LANDING_ORIGIN 
        add constraint LANDING_ORIGIN_LANDING_FKC 
        foreign key (LANDING_FK) 
        references LANDING 
        on delete cascade;

    alter table LANDING_ORIGIN 
        add constraint LANDING_ORIGIN_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table LINKED_ITEM 
        add constraint LINKED_ITEM_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table LINKED_ITEM 
        add constraint LINKED_ITEM_LINKED_ITEM_TYPE_C 
        foreign key (LINKED_ITEM_TYPE_FK) 
        references LINKED_ITEM_TYPE;

    alter table LINKED_ITEM_TYPE 
        add constraint LINKED_ITEM_TYPE_FROM_OBJECT_C 
        foreign key (FROM_OBJECT_TYPE_FK) 
        references OBJECT_TYPE;

    alter table LINKED_ITEM_TYPE 
        add constraint LINKED_ITEM_TYPE_TO_OBJECT_TYC 
        foreign key (TO_OBJECT_TYPE_FK) 
        references OBJECT_TYPE;

    alter table LINKED_ITEM_TYPE 
        add constraint LINKED_ITEM_TYPE_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table LINKED_ITEM_TYPE 
        add constraint LINKED_ITEM_TYPE_FROM_PROGRAMC 
        foreign key (FROM_PROGRAM_FK) 
        references PROGRAM;

    alter table LINKED_ITEM_TYPE 
        add constraint LINKED_ITEM_TYPE_TO_PROGRAM_FC 
        foreign key (TO_PROGRAM_FK) 
        references PROGRAM;

    alter table LOCATION 
        add constraint LOCATION_LOCATION_LEVEL_FKC 
        foreign key (LOCATION_LEVEL_FK) 
        references LOCATION_LEVEL;

    alter table LOCATION 
        add constraint LOCATION_LOCATION_CLASSIFICATC 
        foreign key (LOCATION_CLASSIFICATION_FK) 
        references LOCATION_CLASSIFICATION;

    alter table LOCATION 
        add constraint LOCATION_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table LOCATION_AREA 
        add constraint LOCATION_AREAIFKC 
        foreign key (ID) 
        references LOCATION;

    alter table LOCATION_ASSOCIATION 
        add constraint LOCATION_ASSOCIATION_PARENT_LC 
        foreign key (PARENT_LOCATION_FK) 
        references LOCATION;

    alter table LOCATION_ASSOCIATION 
        add constraint LOCATION_ASSOCIATION_CHILD_LOC 
        foreign key (CHILD_LOCATION_FK) 
        references LOCATION;

    alter table LOCATION_HIERARCHY 
        add constraint LOCATION_HIERARCHY_CHILD_LOCAC 
        foreign key (CHILD_LOCATION_FK) 
        references LOCATION;

    alter table LOCATION_HIERARCHY 
        add constraint LOCATION_HIERARCHY_PARENT_LOCC 
        foreign key (PARENT_LOCATION_FK) 
        references LOCATION;

    alter table LOCATION_HIERARCHY_EXCEPTION 
        add constraint LOCATION_HIERARCHY_EXCEPTION_C 
        foreign key (CHILD_LOCATION_FK) 
        references LOCATION;

    alter table LOCATION_HIERARCHY_EXCEPTION 
        add constraint LOCATION_HIERARCHY_EXCEPTION_O 
        foreign key (PARENT_LOCATION_FK) 
        references LOCATION;

    alter table LOCATION_LEVEL 
        add constraint LOCATION_LEVEL_PARENT_LOCATIOC 
        foreign key (PARENT_LOCATION_LEVEL_FK) 
        references LOCATION_LEVEL;

    alter table LOCATION_LEVEL 
        add constraint LOCATION_LEVEL_LOCATION_CLASSC 
        foreign key (LOCATION_CLASSIFICATION_FK) 
        references LOCATION_CLASSIFICATION;

    alter table LOCATION_LINE 
        add constraint LOCATION_LINEIFKC 
        foreign key (ID) 
        references LOCATION;

    alter table LOCATION_POINT 
        add constraint LOCATION_POINTIFKC 
        foreign key (ID) 
        references LOCATION;

    alter table MANAGED_DATA 
        add constraint MANAGED_DATA_MANAGER_PERSON_FC 
        foreign key (MANAGER_PERSON_FK) 
        references PERSON;

    alter table MANAGED_DATA 
        add constraint MANAGED_DATA_SUPERVISOR_PERSOC 
        foreign key (SUPERVISOR_PERSON_FK) 
        references PERSON;

    alter table MANAGED_DATA 
        add constraint MANAGED_DATA_MANAGED_DATA_TYPC 
        foreign key (MANAGED_DATA_TYPE_FK) 
        references MANAGED_DATA_TYPE;

    alter table MANAGED_DATA2VIEWER_USER 
        add constraint MANAGED_DATA_PERSON_FKC 
        foreign key (PERSON_FK) 
        references PERSON;

    alter table MANAGED_DATA2VIEWER_USER 
        add constraint PERSON_MANAGED_DATA_FKC 
        foreign key (MANAGED_DATA_FK) 
        references MANAGED_DATA;

    alter table MANAGED_DATA_TRANSFER 
        add constraint MANAGED_DATA_TRANSFER_MANAGEDC 
        foreign key (MANAGED_DATA_FK) 
        references MANAGED_DATA 
        on delete cascade;

    alter table MANAGED_DATA_TRANSFER 
        add constraint MANAGED_DATA_TRANSFER_NEW_MANC 
        foreign key (NEW_MANAGER_PERSON_FK) 
        references PERSON;

    alter table MANAGED_DATA_TYPE 
        add constraint MANAGED_DATA_TYPE_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table MATRIX 
        add constraint MATRIX_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table MEASUREMENT_FILE 
        add constraint MEASUREMENT_FILE_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table MEASUREMENT_FILE 
        add constraint MEASUREMENT_FILE_QUALITY_FLAGC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table MEASUREMENT_FILE 
        add constraint MEASUREMENT_FILE_DEPARTMENT_FC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table MEASUREMENT_FILE 
        add constraint MEASUREMENT_FILE_OBJECT_TYPE_C 
        foreign key (OBJECT_TYPE_FK) 
        references OBJECT_TYPE;

    alter table MEASUREMENT_FILE 
        add constraint MEASUREMENT_FILE_ANALYSIS_INSC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table METHOD 
        add constraint METHOD_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table METIER 
        add constraint METIER_TAXON_GROUP_FKC 
        foreign key (TAXON_GROUP_FK) 
        references TAXON_GROUP;

    alter table METIER 
        add constraint METIER_GEAR_FKC 
        foreign key (GEAR_FK) 
        references GEAR;

    alter table METIER 
        add constraint METIER_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table MINIMUM_SIZE_ALLOWED 
        add constraint MINIMUM_SIZE_ALLOWED_CORPUS_FC 
        foreign key (CORPUS_FK) 
        references CORPUS 
        on delete cascade;

    alter table MINIMUM_SIZE_ALLOWED 
        add constraint MINIMUM_SIZE_ALLOWED_UNIT_FKC 
        foreign key (UNIT_FK) 
        references UNIT;

    alter table MINIMUM_SIZE_ALLOWED 
        add constraint MINIMUM_SIZE_ALLOWED_TAXON_GRC 
        foreign key (TAXON_GROUP_FK) 
        references TAXON_GROUP;

    alter table MINIMUM_SIZE_ALLOWED2LOCATION 
        add constraint MINIMUM_SIZE_ALLOWED_LOCATIONC 
        foreign key (LOCATION_FK) 
        references LOCATION;

    alter table MINIMUM_SIZE_ALLOWED2LOCATION 
        add constraint LOCATION_MINIMUM_SIZE_ALLOWEDC 
        foreign key (MINIMUM_SIZE_ALLOWED_FK) 
        references MINIMUM_SIZE_ALLOWED;

    alter table NEARBY_SPECIFIC_AREA 
        add constraint NEARBY_SPECIFIC_AREA_STATUS_FC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table NUMERICAL_PRECISION 
        add constraint NUMERICAL_PRECISION_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table OBSERVED_LOCATION 
        add constraint OBSERVED_LOCATION_RECORDER_PEC 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table OBSERVED_LOCATION 
        add constraint OBSERVED_LOCATION_RECORDER_DEC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table OBSERVED_LOCATION 
        add constraint OBSERVED_LOCATION_LOCATION_FKC 
        foreign key (LOCATION_FK) 
        references LOCATION;

    alter table OBSERVED_LOCATION 
        add constraint OBSERVED_LOCATION_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table OBSERVED_LOCATION 
        add constraint OBSERVED_LOCATION_QUALITY_FLAC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table OBSERVED_LOCATION2PERSON 
        add constraint OBSERVED_LOCATION_OBSERVER_PEC 
        foreign key (OBSERVER_PERSON_FK) 
        references PERSON;

    alter table OBSERVED_LOCATION2PERSON 
        add constraint PERSON_OBSERVED_LOCATION_FKC 
        foreign key (OBSERVED_LOCATION_FK) 
        references OBSERVED_LOCATION;

    alter table OBSERVED_LOCATION_FEATURES 
        add constraint OBSERVED_LOCATION_FEATURES_MEC 
        foreign key (METIER_FK) 
        references METIER;

    alter table OBSERVED_LOCATION_FEATURES 
        add constraint OBSERVED_LOCATION_FEATURES_OBC 
        foreign key (OBSERVED_LOCATION_FK) 
        references OBSERVED_LOCATION 
        on delete cascade;

    alter table OBSERVED_LOCATION_FEATURES 
        add constraint OBSERVED_LOCATION_FEATURES_QUC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table OBSERVED_LOCATION_FEATURES 
        add constraint OBSERVED_LOCATION_FEATURES_PRC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table OBSERVED_LOCATION_FEATURES 
        add constraint OBSERVED_LOCATION_FEATURES_VEC 
        foreign key (VESSEL_TYPE_FK) 
        references VESSEL_TYPE;

    alter table OBSERVED_LOCATION_MEASUREMENT 
        add constraint OBSERVED_LO_AGGREGATION_LEVELC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table OBSERVED_LOCATION_MEASUREMENT 
        add constraint OBSERVED_LOCA_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table OBSERVED_LOCATION_MEASUREMENT 
        add constraint OBSERVED_LO_PRECISION_TYPE_FKC 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table OBSERVED_LOCATION_MEASUREMENT 
        add constraint OBSERVED_LO_ANALYSIS_INSTRUMEC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table OBSERVED_LOCATION_MEASUREMENT 
        add constraint OBSERVED_LO_NUMERICAL_PRECISIC 
        foreign key (NUMERICAL_PRECISION_FK) 
        references NUMERICAL_PRECISION;

    alter table OBSERVED_LOCATION_MEASUREMENT 
        add constraint OBSERVED_LOCATI_DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table OBSERVED_LOCATION_MEASUREMENT 
        add constraint OBSERVED_LOCATION_MEA_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table OBSERVED_LOCATION_MEASUREMENT 
        add constraint OBSERVED_LO_QUALITATIVE_VALUEC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table OBSERVED_LOCATION_MEASUREMENT 
        add constraint OBSERVED_LOCATION_MEASUREMENTC 
        foreign key (OBSERVED_LOCATION_FEATURES_FK) 
        references OBSERVED_LOCATION_FEATURES 
        on delete cascade;

    alter table OPERATION 
        add constraint OPERATION_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table OPERATION 
        add constraint OPERATION_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table OPERATION 
        add constraint OPERATION_FISHING_TRIP_FKC 
        foreign key (FISHING_TRIP_FK) 
        references FISHING_TRIP;

    alter table OPERATION 
        add constraint OPERATION_GEAR_PHYSICAL_FEATUC 
        foreign key (GEAR_PHYSICAL_FEATURES_FK) 
        references GEAR_PHYSICAL_FEATURES;

    alter table OPERATION 
        add constraint FISHING_OPERATION_CATCH_BATCHC 
        foreign key (CATCH_BATCH_FK) 
        references BATCH;

    alter table OPERATION_VESSEL_ASSOCIATION 
        add constraint OPERATION_VESSEL_ASSOCIATION_N 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table OPERATION_VESSEL_ASSOCIATION 
        add constraint OPERATION_VESSEL_ASSOCIATION_C 
        foreign key (OPERATION_FK) 
        references OPERATION 
        on delete cascade;

    alter table ORDER_ITEM 
        add constraint ORDER_ITEM_ORDER_TYPE_FKC 
        foreign key (ORDER_TYPE_FK) 
        references ORDER_TYPE;

    alter table ORDER_TYPE 
        add constraint ORDER_TYPE_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table ORDER_TYPE 
        add constraint ORDER_TYPE_OBJECT_TYPE_FKC 
        foreign key (OBJECT_TYPE_FK) 
        references OBJECT_TYPE;

    alter table PARAMETER 
        add constraint PARAMETER_PARAMETER_GROUP_FKC 
        foreign key (PARAMETER_GROUP_FK) 
        references PARAMETER_GROUP;

    alter table PARAMETER 
        add constraint PARAMETER_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table PARAMETER_GROUP 
        add constraint PARAMETER_GROUP_PARENT_PARAMEC 
        foreign key (PARENT_PARAMETER_GROUP_FK) 
        references PARAMETER_GROUP 
        on delete cascade;

    alter table PARAMETER_GROUP 
        add constraint PARAMETER_GROUP_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table PERSON 
        add constraint PERSON_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table PERSON 
        add constraint PERSON_DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table PERSON2USER_PROFIL 
        add constraint PERSON_USER_PROFIL_FKC 
        foreign key (USER_PROFIL_FK) 
        references USER_PROFIL;

    alter table PERSON2USER_PROFIL 
        add constraint USER_PROFIL_PERSON_FKC 
        foreign key (PERSON_FK) 
        references PERSON;

    alter table PERSON_SESSION 
        add constraint PERSON_SESSION_PERSON_FKC 
        foreign key (PERSON_FK) 
        references PERSON;

    alter table PERSON_SESSION_VESSEL 
        add constraint PERSON_SESSION_VESSEL_PERSON_C 
        foreign key (PERSON_SESSION_FK) 
        references PERSON_SESSION 
        on delete cascade;

    alter table PERSON_SESSION_VESSEL 
        add constraint PERSON_SESSION_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table PERSON_SESSION_VESSEL 
        add constraint PERSON_SESSION_VESSEL_PROGRAMC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table PERSON_SESSION_VESSEL 
        add constraint PERSON_SESSION_VESSEL_OBJECT_C 
        foreign key (OBJECT_TYPE_FK) 
        references OBJECT_TYPE;

    alter table PHOTO 
        add constraint PHOTO_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table PHOTO 
        add constraint PHOTO_PHOTO_TYPE_FKC 
        foreign key (PHOTO_TYPE_FK) 
        references PHOTO_TYPE;

    alter table PHOTO 
        add constraint PHOTO_OBJECT_TYPE_FKC 
        foreign key (OBJECT_TYPE_FK) 
        references OBJECT_TYPE;

    alter table PHOTO 
        add constraint PHOTO_DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table PHOTO_TYPE 
        add constraint PHOTO_TYPE_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table PHYSICAL_GEAR_SURVEY 
        add constraint PHYSICAL_GEAR_SURVEY_RECORDERC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table PHYSICAL_GEAR_SURVEY 
        add constraint PHYSICAL_GEAR_SURVEY_RECORDERY 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table PHYSICAL_GEAR_SURVEY 
        add constraint PHYSICAL_GEAR_SURVEY_PROGRAM_C 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table PHYSICAL_GEAR_SURVEY 
        add constraint PHYSICAL_GEAR_SURVEY_QUALITY_C 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table PHYSICAL_GEAR_SURVEY 
        add constraint PHYSICAL_GEAR_SURVEY_VESSEL_FC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table PMFM 
        add constraint PMFM_AGGREGATION_LEVEL_FKC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table PMFM 
        add constraint PMFM_FRACTION_FKC 
        foreign key (FRACTION_FK) 
        references FRACTION;

    alter table PMFM 
        add constraint PMFM_METHOD_FKC 
        foreign key (METHOD_FK) 
        references METHOD;

    alter table PMFM 
        add constraint PMFM_MATRIX_FKC 
        foreign key (MATRIX_FK) 
        references MATRIX;

    alter table PMFM 
        add constraint PMFM_PARAMETER_FKC 
        foreign key (PARAMETER_FK) 
        references PARAMETER;

    alter table PMFM 
        add constraint PMFM_UNIT_FKC 
        foreign key (UNIT_FK) 
        references UNIT;

    alter table PMFM 
        add constraint PMFM_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table PMFM2QUALITATIVE_VALUE 
        add constraint PMFM_QUALITATIVE_VALUE_FKC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table PMFM2QUALITATIVE_VALUE 
        add constraint QUALITATIVE_VALUE_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table PMFM_APPLIED_STRATEGY 
        add constraint PMFM_APPLIED_STRATEGY_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table PMFM_APPLIED_STRATEGY 
        add constraint PMFM_APPLIED_STRATEGY_APPLIEDC 
        foreign key (APPLIED_STRATEGY_FK) 
        references APPLIED_STRATEGY 
        on delete cascade;

    alter table PMFM_APPLIED_STRATEGY 
        add constraint PMFM_APPLIED_STRATEGY_REFERENC 
        foreign key (REFERENCE_TAXON_FK) 
        references REFERENCE_TAXON;

    alter table PMFM_APPLIED_STRATEGY 
        add constraint PMFM_APPLIED_STRATEGY_GEAR_FKC 
        foreign key (GEAR_FK) 
        references GEAR;

    alter table PMFM_APPLIED_STRATEGY 
        add constraint PMFM_APPLIED_STRATEGY_ANALYSIC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table PMFM_APPLIED_STRATEGY 
        add constraint PMFM_APPLIED_STRATEGY_METIER_C 
        foreign key (METIER_FK) 
        references METIER;

    alter table PMFM_STRATEGY 
        add constraint PMFM_STRATEGY_REFERENCE_TAXONC 
        foreign key (REFERENCE_TAXON_FK) 
        references REFERENCE_TAXON;

    alter table PMFM_STRATEGY 
        add constraint PMFM_STRATEGY_PRECISION_TYPE_C 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table PMFM_STRATEGY 
        add constraint PMFM_STRATEGY_ACQUISITION_LEVC 
        foreign key (ACQUISITION_LEVEL_FK) 
        references ACQUISITION_LEVEL;

    alter table PMFM_STRATEGY 
        add constraint PMFM_STRATEGY_METIER_FKC 
        foreign key (METIER_FK) 
        references METIER;

    alter table PMFM_STRATEGY 
        add constraint PMFM_STRATEGY_GEAR_FKC 
        foreign key (GEAR_FK) 
        references GEAR;

    alter table PMFM_STRATEGY 
        add constraint PMFM_STRATEGY_STRATEGY_FKC 
        foreign key (STRATEGY_FK) 
        references STRATEGY 
        on delete cascade;

    alter table PMFM_STRATEGY 
        add constraint PMFM_STRATEGY_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table PRECISION_TYPE 
        add constraint PRECISION_TYPE_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table PROCESSING_HISTORY 
        add constraint PROCESSING_HISTORY_PROCESSINGC 
        foreign key (PROCESSING_TYPE_FK) 
        references PROCESSING_TYPE;

    alter table PROCESSING_HISTORY 
        add constraint PROCESSING_HISTORY_PROCESSINGO 
        foreign key (PROCESSING_STATUS_FK) 
        references PROCESSING_STATUS;

    alter table PROCESSING_STATUS 
        add constraint PROCESSING_STATUS_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table PROCESSING_TYPE 
        add constraint PROCESSING_TYPE_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table PRODUCE 
        add constraint PRODUCE_OTHER_TAXON_GROUP_FKC 
        foreign key (OTHER_TAXON_GROUP_FK) 
        references TAXON_GROUP;

    alter table PRODUCE 
        add constraint PRODUCE_TAXON_GROUP_FKC 
        foreign key (TAXON_GROUP_FK) 
        references TAXON_GROUP;

    alter table PRODUCE 
        add constraint PRODUCE_SALE_TYPE_FKC 
        foreign key (SALE_TYPE_FK) 
        references SALE_TYPE;

    alter table PRODUCE 
        add constraint PRODUCE_OTHER_GEAR_FKC 
        foreign key (OTHER_GEAR_FK) 
        references GEAR;

    alter table PRODUCE 
        add constraint PRODUCE_DRESSING_FKC 
        foreign key (DRESSING_FK) 
        references QUALITATIVE_VALUE;

    alter table PRODUCE 
        add constraint PRODUCE_PRESERVATION_FKC 
        foreign key (PRESERVATION_FK) 
        references QUALITATIVE_VALUE;

    alter table PRODUCE 
        add constraint PRODUCE_TRANSACTION_FKC 
        foreign key (TRANSACTION_FK) 
        references QUALITATIVE_VALUE;

    alter table PRODUCE 
        add constraint PRODUCE_FRESHNESS_CATEGORY_FKC 
        foreign key (FRESHNESS_CATEGORY_FK) 
        references QUALITATIVE_VALUE;

    alter table PRODUCE 
        add constraint PRODUCE_SIZE_CATEGORY_FKC 
        foreign key (SIZE_CATEGORY_FK) 
        references QUALITATIVE_VALUE;

    alter table PRODUCE 
        add constraint PRODUCE_WEIGHT_METHOD_FKC 
        foreign key (WEIGHT_METHOD_FK) 
        references METHOD;

    alter table PRODUCE 
        add constraint PRODUCE_FISHING_OPERATION_FKC 
        foreign key (FISHING_OPERATION_FK) 
        references OPERATION 
        on delete cascade;

    alter table PRODUCE 
        add constraint PRODUCE_EXPECTED_SALE_FKC 
        foreign key (EXPECTED_SALE_FK) 
        references EXPECTED_SALE;

    alter table PRODUCE 
        add constraint PRODUCE_BATCH_FKC 
        foreign key (BATCH_FK) 
        references BATCH;

    alter table PRODUCE 
        add constraint PRODUCE_BUYER_FKC 
        foreign key (BUYER_FK) 
        references BUYER;

    alter table PRODUCE 
        add constraint PRODUCE_SALE_FKC 
        foreign key (SALE_FK) 
        references SALE 
        on delete cascade;

    alter table PRODUCE 
        add constraint PRODUCE_GEAR_FKC 
        foreign key (GEAR_FK) 
        references GEAR;

    alter table PRODUCE 
        add constraint PRODUCE_LANDING_FKC 
        foreign key (LANDING_FK) 
        references LANDING 
        on delete cascade;

    alter table PRODUCE 
        add constraint PRODUCE_TAKE_OVER_FKC 
        foreign key (TAKE_OVER_FK) 
        references TAKE_OVER;

    alter table PRODUCE 
        add constraint PRODUCE_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table PRODUCE 
        add constraint PRODUCE_TRANSSHIPMENT_FKC 
        foreign key (TRANSSHIPMENT_FK) 
        references TRANSSHIPMENT;

    alter table PROGRAM 
        add constraint PROGRAM_TAXON_GROUP_TYPE_FKC 
        foreign key (TAXON_GROUP_TYPE_FK) 
        references TAXON_GROUP_TYPE;

    alter table PROGRAM 
        add constraint PROGRAM_GEAR_CLASSIFICATION_FC 
        foreign key (GEAR_CLASSIFICATION_FK) 
        references GEAR_CLASSIFICATION;

    alter table PROGRAM2DEPARTMENT 
        add constraint PROGRAM2DEPARTMENT_PROGRAM_PRC 
        foreign key (PROGRAM_PRIVILEGE_FK) 
        references PROGRAM_PRIVILEGE;

    alter table PROGRAM2DEPARTMENT 
        add constraint PROGRAM2DEPARTMENT_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM 
        on delete cascade;

    alter table PROGRAM2DEPARTMENT 
        add constraint PROGRAM2DEPARTMENT_LOCATION_FC 
        foreign key (LOCATION_FK) 
        references LOCATION;

    alter table PROGRAM2DEPARTMENT 
        add constraint PROGRAM2DEPARTMENT_DEPARTMENTC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table PROGRAM2LOCATION 
        add constraint PROGRAM_LOCATION_FKC 
        foreign key (LOCATION_FK) 
        references LOCATION;

    alter table PROGRAM2LOCATION 
        add constraint LOCATION_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table PROGRAM2LOCATION_CLASSIF 
        add constraint PROGRAM_LOCATION_CLASSIFICATIC 
        foreign key (LOCATION_CLASSIFICATION_FK) 
        references LOCATION_CLASSIFICATION;

    alter table PROGRAM2LOCATION_CLASSIF 
        add constraint LOCATION_CLASSIFICATION_PROGRC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table PROGRAM2PERSON 
        add constraint PROGRAM2PERSON_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM 
        on delete cascade;

    alter table PROGRAM2PERSON 
        add constraint PROGRAM2PERSON_PROGRAM_PRIVILC 
        foreign key (PROGRAM_PRIVILEGE_FK) 
        references PROGRAM_PRIVILEGE;

    alter table PROGRAM2PERSON 
        add constraint PROGRAM2PERSON_LOCATION_FKC 
        foreign key (LOCATION_FK) 
        references LOCATION;

    alter table PROGRAM2PERSON 
        add constraint PROGRAM2PERSON_PERSON_FKC 
        foreign key (PERSON_FK) 
        references PERSON;

    alter table PROGRAM2PERSON_EXCEPTION 
        add constraint PROGRAM2PERSON_EXCEPTION_VESSC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table PROGRAM2PERSON_EXCEPTION 
        add constraint PROGRAM2PERSON_EXCEPTION_PROGC 
        foreign key (PROGRAM2PERSON_FK) 
        references PROGRAM2PERSON 
        on delete cascade;

    alter table QUALIFICATION_RULE 
        add constraint QUALIFICATION_RULE_DEFAULT_QUC 
        foreign key (DEFAULT_QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table QUALIFICATION_RULE 
        add constraint QUALIFICATION_RULE_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table QUALIFIED_ITEM 
        add constraint QUALIFIED_ITEM_OBJECT_TYPE_FKC 
        foreign key (OBJECT_TYPE_FK) 
        references OBJECT_TYPE;

    alter table QUALITATIVE_VALUE 
        add constraint QUALITATIVE_VALUE_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table QUALITATIVE_VALUE 
        add constraint QUALITATIVE_VALUE_PARAMETER_FC 
        foreign key (PARAMETER_FK) 
        references PARAMETER 
        on delete cascade;

    alter table QUALITY_FLAG 
        add constraint QUALITY_FLAG_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table QUANTIFICATION_MEASUREMENT 
        add constraint QUANTIFICAT_AGGREGATION_LEVELC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table QUANTIFICATION_MEASUREMENT 
        add constraint QUANTIFICATIO_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table QUANTIFICATION_MEASUREMENT 
        add constraint QUANTIFICAT_PRECISION_TYPE_FKC 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table QUANTIFICATION_MEASUREMENT 
        add constraint QUANTIFICAT_ANALYSIS_INSTRUMEC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table QUANTIFICATION_MEASUREMENT 
        add constraint QUANTIFICAT_NUMERICAL_PRECISIC 
        foreign key (NUMERICAL_PRECISION_FK) 
        references NUMERICAL_PRECISION;

    alter table QUANTIFICATION_MEASUREMENT 
        add constraint QUANTIFICATION__DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table QUANTIFICATION_MEASUREMENT 
        add constraint QUANTIFICATION_MEASUR_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table QUANTIFICATION_MEASUREMENT 
        add constraint QUANTIFICAT_QUALITATIVE_VALUEC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table QUANTIFICATION_MEASUREMENT 
        add constraint QUANTIFICATION_MEASUREMENT_BAC 
        foreign key (BATCH_FK) 
        references BATCH 
        on delete cascade;

    alter table QUANTIFICATION_MEASUREMENT_P 
        add constraint QUAN_MEAS_P_AGGREGATION_LEVELC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table QUANTIFICATION_MEASUREMENT_P 
        add constraint QUAN_MEAS_P_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table QUANTIFICATION_MEASUREMENT_P 
        add constraint QUAN_MEAS_P_PRECISION_TYPE_FKC 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table QUANTIFICATION_MEASUREMENT_P 
        add constraint QUAN_MEAS_P_ANALYSIS_INSTRUMEC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table QUANTIFICATION_MEASUREMENT_P 
        add constraint QUAN_MEAS_P_NUMERICAL_PRECISIC 
        foreign key (NUMERICAL_PRECISION_FK) 
        references NUMERICAL_PRECISION;

    alter table QUANTIFICATION_MEASUREMENT_P 
        add constraint QUAN_MEAS_P__DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table QUANTIFICATION_MEASUREMENT_P 
        add constraint QUAN_MEAS_P_MEASUR_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table QUANTIFICATION_MEASUREMENT_P 
        add constraint QUAN_MEAS_P_QUALITATIVE_VALUEC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table QUANTIFICATION_MEASUREMENT_P 
        add constraint QUANTIFICATION_MEASUREMENT_P_C 
        foreign key (PRODUCE_FK) 
        references PRODUCE 
        on delete cascade;

    alter table REFERENCE_DOCUMENT 
        add constraint REFERENCE_DOCUMENT_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table REFERENCE_DOCUMENT2AUTHOR 
        add constraint AUTHOR_REFERENCE_DOCUMENT_FKC 
        foreign key (REFERENCE_DOCUMENT_FK) 
        references REFERENCE_DOCUMENT;

    alter table REFERENCE_DOCUMENT2AUTHOR 
        add constraint REFERENCE_DOCUMENT_AUTHOR_FKC 
        foreign key (AUTHOR_FK) 
        references AUTHOR;

    alter table REFERENCE_TAXON_STRATEGY 
        add constraint REFERENCE_TAXON_STRATEGY_REFEC 
        foreign key (REFERENCE_TAXON_FK) 
        references REFERENCE_TAXON;

    alter table REFERENCE_TAXON_STRATEGY 
        add constraint REFERENCE_TAXON_STRATEGY_STRAC 
        foreign key (STRATEGY_FK) 
        references STRATEGY 
        on delete cascade;

    alter table REGULATION_AREA 
        add constraint REGULATION_AREA_GROUPING_FKC 
        foreign key (GROUPING_FK) 
        references GROUPING;

    alter table REGULATION_AREA 
        add constraint REGULATION_AREA_DISTANCE_TO_CC 
        foreign key (DISTANCE_TO_COAST_GRADIENT_FK) 
        references DISTANCE_TO_COAST_GRADIENT;

    alter table REGULATION_AREA 
        add constraint REGULATION_AREA_FISHERY_FKC 
        foreign key (FISHERY_FK) 
        references FISHERY 
        on delete cascade;

    alter table REGULATION_AREA 
        add constraint REGULATION_AREA_NEARBY_SPECIFC 
        foreign key (NEARBY_SPECIFIC_AREA_FK) 
        references NEARBY_SPECIFIC_AREA;

    alter table REGULATION_AREA 
        add constraint REGULATION_AREA_DEPTH_GRADIENC 
        foreign key (DEPTH_GRADIENT_FK) 
        references DEPTH_GRADIENT;

    alter table REGULATION_AREA 
        add constraint REGULATION_AREA_LOCATION_FKC 
        foreign key (LOCATION_FK) 
        references LOCATION;

    alter table REGULATION_AREA2REG_LOCATION 
        add constraint REGULATION_AREA2REG_LOCATION_C 
        foreign key (LOCATION_FK) 
        references LOCATION;

    alter table REGULATION_AREA2REG_LOCATION 
        add constraint REGULATION_AREA2REG_LOCATION_A 
        foreign key (REGULATION_AREA_FK) 
        references REGULATION_AREA 
        on delete cascade;

    alter table RIGHT_TO_PRODUCE 
        add constraint RIGHT_TO_PRODUCE_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table RIGHT_TO_PRODUCE 
        add constraint RIGHT_TO_PRODUCE_CORPUS_FKC 
        foreign key (CORPUS_FK) 
        references CORPUS;

    alter table RIGHT_TO_PRODUCE2FISHERY 
        add constraint RIGHT_TO_PRODUCE_FISHERY_FKC 
        foreign key (FISHERY_FK) 
        references FISHERY;

    alter table RIGHT_TO_PRODUCE2FISHERY 
        add constraint FISHERY_RIGHT_TO_PRODUCE_FKC 
        foreign key (RIGHT_TO_PRODUCE_FK) 
        references RIGHT_TO_PRODUCE;

    alter table ROUND_WEIGHT_CONVERSION 
        add constraint ROUND_WEIGHT_CONVERSION_LOCATC 
        foreign key (LOCATION_FK) 
        references LOCATION;

    alter table ROUND_WEIGHT_CONVERSION 
        add constraint ROUND_WEIGHT_CONVERSION_PRESEC 
        foreign key (PRESERVING_FK) 
        references QUALITATIVE_VALUE;

    alter table ROUND_WEIGHT_CONVERSION 
        add constraint ROUND_WEIGHT_CONVERSION_DRESSC 
        foreign key (DRESSING_FK) 
        references QUALITATIVE_VALUE;

    alter table ROUND_WEIGHT_CONVERSION 
        add constraint ROUND_WEIGHT_CONVERSION_TAXONC 
        foreign key (TAXON_GROUP_FK) 
        references TAXON_GROUP;

    alter table SALE 
        add constraint SALE_SALE_LOCATION_FKC 
        foreign key (SALE_LOCATION_FK) 
        references LOCATION;

    alter table SALE 
        add constraint SALE_SALE_TYPE_FKC 
        foreign key (SALE_TYPE_FK) 
        references SALE_TYPE;

    alter table SALE 
        add constraint SALE_RECORDER_DEPARTMENT_FKC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table SALE 
        add constraint SALE_RECORDER_PERSON_FKC 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table SALE 
        add constraint SALE_CATCH_BATCH_FKC 
        foreign key (CATCH_BATCH_FK) 
        references BATCH;

    alter table SALE 
        add constraint SALE_FISHING_TRIP_FKC 
        foreign key (FISHING_TRIP_FK) 
        references FISHING_TRIP 
        on delete cascade;

    alter table SALE 
        add constraint SALE_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table SALE 
        add constraint SALE_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table SALE 
        add constraint SALE_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table SALE 
        add constraint SALE_SELLER_FKC 
        foreign key (SELLER_FK) 
        references SELLER;

    alter table SALE 
        add constraint SALE_DECLARED_DOCUMENT_REFEREC 
        foreign key (DECLARED_DOCUMENT_REFERENCE_FK) 
        references DECLARED_DOCUMENT_REFERENCE 
        on delete cascade;

    alter table SALE 
        add constraint SALE_LANDING_FKC 
        foreign key (LANDING_FK) 
        references LANDING 
        on delete cascade;

    alter table SALE 
        add constraint SALE_TAKE_OVER_FKC 
        foreign key (TAKE_OVER_FK) 
        references TAKE_OVER;

    alter table SALE 
        add constraint OBSERVED_SALE_SAMPLING_STRATAC 
        foreign key (SAMPLING_STRATA_FK) 
        references DENORMALIZED_SAMPLING_STRATA;

    alter table SALE2OBSERVER_PERSON 
        add constraint OBSERVED_SALE_PERSON_FKC 
        foreign key (PERSON_FK) 
        references PERSON;

    alter table SALE2OBSERVER_PERSON 
        add constraint PERSON_SALE_FKC 
        foreign key (SALE_FK) 
        references SALE;

    alter table SALE_MEASUREMENT 
        add constraint SALE_MEASUR_AGGREGATION_LEVELC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table SALE_MEASUREMENT 
        add constraint SALE_MEASUREM_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table SALE_MEASUREMENT 
        add constraint SALE_MEASUR_PRECISION_TYPE_FKC 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table SALE_MEASUREMENT 
        add constraint SALE_MEASUR_ANALYSIS_INSTRUMEC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table SALE_MEASUREMENT 
        add constraint SALE_MEASUR_NUMERICAL_PRECISIC 
        foreign key (NUMERICAL_PRECISION_FK) 
        references NUMERICAL_PRECISION;

    alter table SALE_MEASUREMENT 
        add constraint SALE_MEASUREMEN_DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table SALE_MEASUREMENT 
        add constraint SALE_MEASUREMENT_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table SALE_MEASUREMENT 
        add constraint SALE_MEASUR_QUALITATIVE_VALUEC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table SALE_MEASUREMENT 
        add constraint SALE_MEASUREMENT_SALE_FKC 
        foreign key (SALE_FK) 
        references SALE 
        on delete cascade;

    alter table SALE_MEASUREMENT 
        add constraint SALE_MEASUREMENT_EXPECTED_SALC 
        foreign key (EXPECTED_SALE_FK) 
        references EXPECTED_SALE 
        on delete cascade;

    alter table SALE_ORIGIN 
        add constraint SALE_ORIGIN_SALE_FKC 
        foreign key (SALE_FK) 
        references SALE 
        on delete cascade;

    alter table SALE_ORIGIN 
        add constraint SALE_ORIGIN_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table SALE_TYPE 
        add constraint SALE_TYPE_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table SAMPLE 
        add constraint SAMPLE_SIZE_UNIT_FKC 
        foreign key (SIZE_UNIT_FK) 
        references UNIT;

    alter table SAMPLE 
        add constraint SAMPLE_RECORDER_DEPARTMENT_FKC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table SAMPLE 
        add constraint SAMPLE_PARENT_SAMPLE_FKC 
        foreign key (PARENT_SAMPLE_FK) 
        references SAMPLE 
        on delete cascade;

    alter table SAMPLE 
        add constraint SAMPLE_RECORDER_PERSON_FKC 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table SAMPLE 
        add constraint SAMPLE_MATRIX_FKC 
        foreign key (MATRIX_FK) 
        references MATRIX;

    alter table SAMPLE 
        add constraint SAMPLE_REFERENCE_TAXON_FKC 
        foreign key (REFERENCE_TAXON_FK) 
        references REFERENCE_TAXON;

    alter table SAMPLE 
        add constraint SAMPLE_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table SAMPLE 
        add constraint SAMPLE_TAXON_GROUP_FKC 
        foreign key (TAXON_GROUP_FK) 
        references TAXON_GROUP;

    alter table SAMPLE 
        add constraint SAMPLE_BATCH_FKC 
        foreign key (BATCH_FK) 
        references BATCH;

    alter table SAMPLE 
        add constraint SAMPLE_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table SAMPLE 
        add constraint SAMPLE_FISHING_OPERATION_FKC 
        foreign key (FISHING_OPERATION_FK) 
        references OPERATION 
        on delete cascade;

    alter table SAMPLE_MEASUREMENT 
        add constraint SAMPLE_MEAS_AGGREGATION_LEVELC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table SAMPLE_MEASUREMENT 
        add constraint SAMPLE_MEASUR_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table SAMPLE_MEASUREMENT 
        add constraint SAMPLE_MEAS_PRECISION_TYPE_FKC 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table SAMPLE_MEASUREMENT 
        add constraint SAMPLE_MEAS_ANALYSIS_INSTRUMEC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table SAMPLE_MEASUREMENT 
        add constraint SAMPLE_MEAS_NUMERICAL_PRECISIC 
        foreign key (NUMERICAL_PRECISION_FK) 
        references NUMERICAL_PRECISION;

    alter table SAMPLE_MEASUREMENT 
        add constraint SAMPLE_MEASUREM_DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table SAMPLE_MEASUREMENT 
        add constraint SAMPLE_MEASUREMENT_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table SAMPLE_MEASUREMENT 
        add constraint SAMPLE_MEAS_QUALITATIVE_VALUEC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table SAMPLE_MEASUREMENT 
        add constraint SAMPLE_MEASUREMENT_SAMPLE_FKC 
        foreign key (SAMPLE_FK) 
        references SAMPLE 
        on delete cascade;

    alter table SCIENTIFIC_CRUISE 
        add constraint SCIENTIFIC_CRUISE_MANAGER_PERC 
        foreign key (MANAGER_PERSON_FK) 
        references PERSON;

    alter table SCIENTIFIC_CRUISE 
        add constraint SCIENTIFIC_CRUISE_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table SCIENTIFIC_CRUISE 
        add constraint SCIENTIFIC_CRUISE_RECORDER_DEC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table SCIENTIFIC_CRUISE 
        add constraint SCIENTIFIC_CRUISE_RECORDER_PEC 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table SCIENTIFIC_CRUISE 
        add constraint SCIENTIFIC_CRUISE_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table SELLER 
        add constraint SELLER_SELLER_TYPE_FKC 
        foreign key (SELLER_TYPE_FK) 
        references SELLER_TYPE;

    alter table SELLER 
        add constraint SELLER_BASE_SALE_LOCATION_FKC 
        foreign key (BASE_SALE_LOCATION_FK) 
        references LOCATION;

    alter table SORTING_MEASUREMENT 
        add constraint SORTING_MEA_AGGREGATION_LEVELC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table SORTING_MEASUREMENT 
        add constraint SORTING_MEASU_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table SORTING_MEASUREMENT 
        add constraint SORTING_MEA_PRECISION_TYPE_FKC 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table SORTING_MEASUREMENT 
        add constraint SORTING_MEA_ANALYSIS_INSTRUMEC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table SORTING_MEASUREMENT 
        add constraint SORTING_MEA_NUMERICAL_PRECISIC 
        foreign key (NUMERICAL_PRECISION_FK) 
        references NUMERICAL_PRECISION;

    alter table SORTING_MEASUREMENT 
        add constraint SORTING_MEASURE_DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table SORTING_MEASUREMENT 
        add constraint SORTING_MEASUREMENT_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table SORTING_MEASUREMENT 
        add constraint SORTING_MEA_QUALITATIVE_VALUEC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table SORTING_MEASUREMENT 
        add constraint SORTING_MEASUREMENT_SORTING_BC 
        foreign key (SORTING_BATCH_FK) 
        references BATCH 
        on delete cascade;

    alter table SORTING_MEASUREMENT_P 
        add constraint SORT_MEAS_P_AGGREGATION_LEVELC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table SORTING_MEASUREMENT_P 
        add constraint SORT_MEAS_P_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table SORTING_MEASUREMENT_P 
        add constraint SORT_MEAS_P_PRECISION_TYPE_FKC 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table SORTING_MEASUREMENT_P 
        add constraint SORT_MEAS_P_ANALYSIS_INSTRUMEC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table SORTING_MEASUREMENT_P 
        add constraint SORT_MEAS_P_NUMERICAL_PRECISIC 
        foreign key (NUMERICAL_PRECISION_FK) 
        references NUMERICAL_PRECISION;

    alter table SORTING_MEASUREMENT_P 
        add constraint SORT_MEAS_P_DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table SORTING_MEASUREMENT_P 
        add constraint SORT_MEAS_P_P_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table SORTING_MEASUREMENT_P 
        add constraint SORT_MEAS_P_QUALITATIVE_VALUEC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table SORTING_MEASUREMENT_P 
        add constraint SORTING_MEASUREMENT_P_PRODUCEC 
        foreign key (PRODUCE_FK) 
        references PRODUCE 
        on delete cascade;

    alter table SPATIAL_ITEM 
        add constraint SPATIAL_ITEM_SPATIAL_ITEM_TYPC 
        foreign key (SPATIAL_ITEM_TYPE_FK) 
        references SPATIAL_ITEM_TYPE;

    alter table SPATIAL_ITEM2LOCATION 
        add constraint SPATIAL_ITEM2LOCATION_LOCATIOC 
        foreign key (LOCATION_FK) 
        references LOCATION;

    alter table SPATIAL_ITEM2LOCATION 
        add constraint SPATIAL_ITEM2LOCATION_SPATIALC 
        foreign key (SPATIAL_ITEM_FK) 
        references SPATIAL_ITEM 
        on delete cascade;

    alter table SPATIAL_ITEM_AREA 
        add constraint SPATIAL_ITEM_AREA_SPATIAL_ITEC 
        foreign key (SPATIAL_ITEM_FK) 
        references SPATIAL_ITEM 
        on delete cascade;

    alter table SPATIAL_ITEM_LINE 
        add constraint SPATIAL_ITEM_LINE_SPATIAL_ITEC 
        foreign key (SPATIAL_ITEM_FK) 
        references SPATIAL_ITEM 
        on delete cascade;

    alter table SPATIAL_ITEM_POINT 
        add constraint SPATIAL_ITEM_POINT_SPATIAL_ITC 
        foreign key (SPATIAL_ITEM_FK) 
        references SPATIAL_ITEM 
        on delete cascade;

    alter table SPATIAL_ITEM_TYPE 
        add constraint SPATIAL_ITEM_TYPE_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table SPATIAL_ITEM_TYPE 
        add constraint SPATIAL_ITEM_TYPE_OBJECT_TYPEC 
        foreign key (OBJECT_TYPE_FK) 
        references OBJECT_TYPE;

    alter table STRATEGY 
        add constraint STRATEGY_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table STRATEGY2GEAR 
        add constraint STRATEGY_GEAR_FKC 
        foreign key (GEAR_FK) 
        references GEAR;

    alter table STRATEGY2GEAR 
        add constraint GEAR_STRATEGY_FKC 
        foreign key (STRATEGY_FK) 
        references STRATEGY;

    alter table STRATEGY2MANAGER_PERSON 
        add constraint STRATEGY_PERSON_FKC 
        foreign key (PERSON_FK) 
        references PERSON;

    alter table STRATEGY2MANAGER_PERSON 
        add constraint PERSON_STRATEGY_FKC 
        foreign key (STRATEGY_FK) 
        references STRATEGY;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEAS_AGGREGATION_LEVELC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEASUR_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEAS_PRECISION_TYPE_FKC 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEAS_ANALYSIS_INSTRUMEC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEAS_NUMERICAL_PRECISIC 
        foreign key (NUMERICAL_PRECISION_FK) 
        references NUMERICAL_PRECISION;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEASUREM_DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEASUREMENT_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEAS_QUALITATIVE_VALUEC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEASUREMENT_DECLARED_DC 
        foreign key (DECLARED_DOCUMENT_REFERENCE_FK) 
        references DECLARED_DOCUMENT_REFERENCE 
        on delete cascade;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEASUREMENT_FISHING_TRC 
        foreign key (FISHING_TRIP_FK) 
        references FISHING_TRIP 
        on delete cascade;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEASUREMENT_PHYSICAL_GC 
        foreign key (PHYSICAL_GEAR_SURVEY_FK) 
        references PHYSICAL_GEAR_SURVEY 
        on delete cascade;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEASUREMENT_SALE_FKC 
        foreign key (SALE_FK) 
        references SALE 
        on delete cascade;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEASUREMENT_DAILY_ACTIC 
        foreign key (DAILY_ACTIVITY_CALENDAR_FK) 
        references DAILY_ACTIVITY_CALENDAR 
        on delete cascade;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEASUREMENT_ACTIVITY_CC 
        foreign key (ACTIVITY_CALENDAR_FK) 
        references ACTIVITY_CALENDAR 
        on delete cascade;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEASUREMENT_ECONOMICALC 
        foreign key (ECONOMICAL_SURVEY_FK) 
        references ECONOMICAL_SURVEY 
        on delete cascade;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEASUREMENT_FISHING_EFC 
        foreign key (FISHING_EFFORT_CALENDAR_FK) 
        references FISHING_EFFORT_CALENDAR 
        on delete cascade;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEASUREMENT_LANDING_FKC 
        foreign key (LANDING_FK) 
        references LANDING 
        on delete cascade;

    alter table SURVEY_MEASUREMENT 
        add constraint SURVEY_MEASUREMENT_TRANSSHIPMC 
        foreign key (TRANSSHIPMENT_FK) 
        references TRANSSHIPMENT 
        on delete cascade;

    alter table TAKE_OVER 
        add constraint TAKE_OVER_RECORDER_DEPARTMENTC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table TAKE_OVER 
        add constraint TAKE_OVER_RECORDER_PERSON_FKC 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table TAKE_OVER 
        add constraint TAKE_OVER_TAKE_OVER_LOCATION_C 
        foreign key (TAKE_OVER_LOCATION_FK) 
        references LOCATION;

    alter table TAKE_OVER 
        add constraint TAKE_OVER_STORAGE_FACILITY_FKC 
        foreign key (STORAGE_FACILITY_FK) 
        references SELLER;

    alter table TAKE_OVER 
        add constraint TAKE_OVER_FISHING_TRIP_FKC 
        foreign key (FISHING_TRIP_FK) 
        references FISHING_TRIP;

    alter table TAKE_OVER 
        add constraint TAKE_OVER_SELLER_FKC 
        foreign key (SELLER_FK) 
        references SELLER;

    alter table TAKE_OVER 
        add constraint TAKE_OVER_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table TAKE_OVER 
        add constraint TAKE_OVER_LANDING_FKC 
        foreign key (LANDING_FK) 
        references LANDING;

    alter table TAKE_OVER 
        add constraint TAKE_OVER_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table TAKE_OVER 
        add constraint TAKE_OVER_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table TAKE_OVER 
        add constraint TAKE_OVER_DECLARED_DOCUMENT_RC 
        foreign key (DECLARED_DOCUMENT_REFERENCE_FK) 
        references DECLARED_DOCUMENT_REFERENCE;

    alter table TAKE_OVER_MEASUREMENT 
        add constraint TAKE_OVER_M_AGGREGATION_LEVELC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table TAKE_OVER_MEASUREMENT 
        add constraint TAKE_OVER_MEA_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table TAKE_OVER_MEASUREMENT 
        add constraint TAKE_OVER_M_PRECISION_TYPE_FKC 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table TAKE_OVER_MEASUREMENT 
        add constraint TAKE_OVER_M_ANALYSIS_INSTRUMEC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table TAKE_OVER_MEASUREMENT 
        add constraint TAKE_OVER_M_NUMERICAL_PRECISIC 
        foreign key (NUMERICAL_PRECISION_FK) 
        references NUMERICAL_PRECISION;

    alter table TAKE_OVER_MEASUREMENT 
        add constraint TAKE_OVER_MEASU_DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table TAKE_OVER_MEASUREMENT 
        add constraint TAKE_OVER_MEASUREMENT_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table TAKE_OVER_MEASUREMENT 
        add constraint TAKE_OVER_M_QUALITATIVE_VALUEC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table TAKE_OVER_MEASUREMENT 
        add constraint TAKE_OVER_MEASUREMENT_TAKE_OVC 
        foreign key (TAKE_OVER_FK) 
        references TAKE_OVER 
        on delete cascade;

    alter table TAXONOMIC_LEVEL 
        add constraint TAXONOMIC_LEVEL_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table TAXON_GROUP 
        add constraint TAXON_GROUP_PARENT_TAXON_GROUC 
        foreign key (PARENT_TAXON_GROUP_FK) 
        references TAXON_GROUP;

    alter table TAXON_GROUP 
        add constraint TAXON_GROUP_TAXON_GROUP_TYPE_C 
        foreign key (TAXON_GROUP_TYPE_FK) 
        references TAXON_GROUP_TYPE;

    alter table TAXON_GROUP 
        add constraint TAXON_GROUP_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table TAXON_GROUP2TAXON_HIERARCHY 
        add constraint TAXON_GROUP2TAXON_HIERARCHY_CC 
        foreign key (CHILD_REFERENCE_TAXON_FK) 
        references REFERENCE_TAXON;

    alter table TAXON_GROUP2TAXON_HIERARCHY 
        add constraint TAXON_GROUP2TAXON_HIERARCHY_PC 
        foreign key (PARENT_TAXON_GROUP_FK) 
        references TAXON_GROUP;

    alter table TAXON_GROUP_HIERARCHY 
        add constraint TAXON_GROUP_HIERARCHY_PARENT_C 
        foreign key (PARENT_TAXON_GROUP_FK) 
        references TAXON_GROUP;

    alter table TAXON_GROUP_HIERARCHY 
        add constraint TAXON_GROUP_HIERARCHY_CHILD_TC 
        foreign key (CHILD_TAXON_GROUP_FK) 
        references TAXON_GROUP;

    alter table TAXON_GROUP_HISTORICAL_RECORD 
        add constraint TAXON_GROUP_HISTORICAL_RECORDC 
        foreign key (REFERENCE_TAXON_FK) 
        references REFERENCE_TAXON;

    alter table TAXON_GROUP_HISTORICAL_RECORD 
        add constraint TAXON_GROUP_HISTORICAL_RECORDS 
        foreign key (TAXON_GROUP_FK) 
        references TAXON_GROUP 
        on delete cascade;

    alter table TAXON_GROUP_INFORMATION 
        add constraint TAXON_GROUP_INFORMATION_TAXONC 
        foreign key (TAXON_GROUP_FK) 
        references TAXON_GROUP 
        on delete cascade;

    alter table TAXON_GROUP_INFORMATION 
        add constraint TAXON_GROUP_INFORMATION_REFERC 
        foreign key (REFERENCE_DOCUMENT_FK) 
        references REFERENCE_DOCUMENT;

    alter table TAXON_INFORMATION 
        add constraint TAXON_INFORMATION_REFERENCE_DC 
        foreign key (REFERENCE_DOCUMENT_FK) 
        references REFERENCE_DOCUMENT;

    alter table TAXON_INFORMATION 
        add constraint TAXON_INFORMATION_TAXON_NAME_C 
        foreign key (TAXON_NAME_FK) 
        references TAXON_NAME;

    alter table TAXON_INFORMATION_HISTORY 
        add constraint TAXON_INFORMATION_HISTORY_TAXC 
        foreign key (TAXON_NAME_HISTORY_FK) 
        references TAXON_NAME_HISTORY;

    alter table TAXON_INFORMATION_HISTORY 
        add constraint TAXON_INFORMATION_HISTORY_REFC 
        foreign key (REFERENCE_DOCUMENT_FK) 
        references REFERENCE_DOCUMENT 
        on delete cascade;

    alter table TAXON_NAME 
        add constraint TAXON_NAME_CITATION_FKC 
        foreign key (CITATION_FK) 
        references CITATION;

    alter table TAXON_NAME 
        add constraint TAXON_NAME_PARENT_TAXON_NAME_C 
        foreign key (PARENT_TAXON_NAME_FK) 
        references TAXON_NAME;

    alter table TAXON_NAME 
        add constraint TAXON_NAME_TAXONOMIC_LEVEL_FKC 
        foreign key (TAXONOMIC_LEVEL_FK) 
        references TAXONOMIC_LEVEL;

    alter table TAXON_NAME 
        add constraint TAXON_NAME_REFERENCE_TAXON_FKC 
        foreign key (REFERENCE_TAXON_FK) 
        references REFERENCE_TAXON;

    alter table TAXON_NAME_HISTORY 
        add constraint TAXON_NAME_HISTORY_CITATION_FC 
        foreign key (CITATION_FK) 
        references CITATION;

    alter table TAXON_NAME_HISTORY 
        add constraint TAXON_NAME_HISTORY_TAXON_NAMEC 
        foreign key (TAXON_NAME_FK) 
        references TAXON_NAME 
        on delete cascade;

    alter table TAXON_NAME_HISTORY 
        add constraint TAXON_NAME_HISTORY_PARENT_TAXC 
        foreign key (PARENT_TAXON_NAME_FK) 
        references TAXON_NAME 
        on delete cascade;

    alter table TRANSCRIBING_ITEM 
        add constraint TRANSCRIBING_ITEM_TRANSCRIBINC 
        foreign key (TRANSCRIBING_ITEM_TYPE_FK) 
        references TRANSCRIBING_ITEM_TYPE;

    alter table TRANSCRIBING_ITEM_TYPE 
        add constraint TRANSCRIBING_ITEM_TYPE_STATUSC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table TRANSCRIBING_ITEM_TYPE 
        add constraint TRANSCRIBING_ITEM_TYPE_OBJECTC 
        foreign key (OBJECT_TYPE_FK) 
        references OBJECT_TYPE;

    alter table TRANSCRIBING_ITEM_TYPE 
        add constraint TRANSCRIBING_ITEM_TYPE_TRANSCC 
        foreign key (TRANSCRIBING_SIDE_FK) 
        references TRANSCRIBING_SIDE;

    alter table TRANSCRIBING_ITEM_TYPE 
        add constraint TRANSCRIBING_ITEM_TYPE_TRANSCT 
        foreign key (TRANSCRIBING_SYSTEM_FK) 
        references TRANSCRIBING_SYSTEM;

    alter table TRANSCRIBING_SYSTEM 
        add constraint TRANSCRIBING_SYSTEM_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table TRANSSHIPMENT 
        add constraint TRANSSHIPMENT_TO_VESSEL_FKC 
        foreign key (TO_VESSEL_FK) 
        references VESSEL;

    alter table TRANSSHIPMENT 
        add constraint TRANSSHIPMENT_TRANSSHIPMENT_LC 
        foreign key (TRANSSHIPMENT_LOCATION_FK) 
        references LOCATION;

    alter table TRANSSHIPMENT 
        add constraint TRANSSHIPMENT_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table TRANSSHIPMENT 
        add constraint TRANSSHIPMENT_RECORDER_DEPARTC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table TRANSSHIPMENT 
        add constraint TRANSSHIPMENT_FROM_VESSEL_FKC 
        foreign key (FROM_VESSEL_FK) 
        references VESSEL;

    alter table TRANSSHIPMENT 
        add constraint TRANSSHIPMENT_RECORDER_PERSONC 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table TRANSSHIPMENT 
        add constraint TRANSSHIPMENT_FISHING_TRIP_FKC 
        foreign key (FISHING_TRIP_FK) 
        references FISHING_TRIP 
        on delete cascade;

    alter table TRANSSHIPMENT 
        add constraint TRANSSHIPMENT_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table UNIT 
        add constraint UNIT_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table UNIT_CONVERSION 
        add constraint UNIT_CONVERSION_FROM_UNIT_FKC 
        foreign key (FROM_UNIT_FK) 
        references UNIT;

    alter table UNIT_CONVERSION 
        add constraint UNIT_CONVERSION_TO_UNIT_FKC 
        foreign key (TO_UNIT_FK) 
        references UNIT;

    alter table UPDATED_ITEM_HISTORY 
        add constraint UPDATED_ITEM_HISTORY_PROCESSIC 
        foreign key (PROCESSING_HISTORY_FK) 
        references PROCESSING_HISTORY 
        on delete cascade;

    alter table UPDATED_ITEM_HISTORY 
        add constraint UPDATED_ITEM_HISTORY_RECORDERC 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table UPDATED_ITEM_HISTORY 
        add constraint UPDATED_ITEM_HISTORY_RECORDER_ 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table UPDATED_ITEM_HISTORY 
        add constraint UPDATED_ITEM_HISTORY_METIER_FC 
        foreign key (METIER_FK) 
        references METIER;

    alter table UPDATED_ITEM_HISTORY 
        add constraint UPDATED_ITEM_HISTORY_REFERENCC 
        foreign key (REFERENCE_TAXON_FK) 
        references REFERENCE_TAXON;

    alter table UPDATED_ITEM_HISTORY 
        add constraint UPDATED_ITEM_HISTORY_TAXON_GRC 
        foreign key (TAXON_GROUP_FK) 
        references TAXON_GROUP;

    alter table UPDATED_ITEM_HISTORY 
        add constraint UPDATED_ITEM_HISTORY_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table UPDATED_ITEM_HISTORY 
        add constraint UPDATED_ITEM_HISTORY_GEAR_FKC 
        foreign key (GEAR_FK) 
        references GEAR;

    alter table UPDATED_ITEM_HISTORY 
        add constraint UPDATED_ITEM_HISTORY_QUALITATC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table UPDATED_ITEM_HISTORY 
        add constraint UPDATED_ITEM_HISTORY_QUALITY_C 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table UPDATED_ITEM_HISTORY 
        add constraint UPDATED_ITEM_HISTORY_OBJECT_TC 
        foreign key (OBJECT_TYPE_FK) 
        references OBJECT_TYPE;

    alter table VESSEL 
        add constraint VESSEL_VESSEL_TYPE_FKC 
        foreign key (VESSEL_TYPE_FK) 
        references VESSEL_TYPE;

    alter table VESSEL 
        add constraint VESSEL_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table VESSEL 
        add constraint VESSEL_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table VESSEL2RIGHT_TO_PRODUCE 
        add constraint VESSEL_RIGHT_TO_PRODUCE_FKC 
        foreign key (RIGHT_TO_PRODUCE_FK) 
        references RIGHT_TO_PRODUCE;

    alter table VESSEL2RIGHT_TO_PRODUCE 
        add constraint RIGHT_TO_PRODUCE_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table VESSEL_COMMISSIONING_PERIOD 
        add constraint VESSEL_COMMISSIONING_PERIOD_VC 
        foreign key (VESSEL_FK) 
        references VESSEL 
        on delete cascade;

    alter table VESSEL_COMMISSIONING_PERIOD 
        add constraint VESSEL_COMMISSIONING_PERIOD_CC 
        foreign key (COMMISSIONING_LOCATION_FK) 
        references LOCATION;

    alter table VESSEL_FEATURES 
        add constraint VESSEL_FEATURES_BASE_PORT_LOCC 
        foreign key (BASE_PORT_LOCATION_FK) 
        references LOCATION;

    alter table VESSEL_FEATURES 
        add constraint VESSEL_FEATURES_HULL_MATERIALC 
        foreign key (HULL_MATERIAL_QV_FK) 
        references QUALITATIVE_VALUE;

    alter table VESSEL_FEATURES 
        add constraint VESSEL_FEATURES_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL 
        on delete cascade;

    alter table VESSEL_FLEET_EVENT 
        add constraint VESSEL_FLEET_EVENT_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL 
        on delete cascade;

    alter table VESSEL_FLEET_EVENT 
        add constraint VESSEL_FLEET_EVENT_EVENT_TYPEC 
        foreign key (EVENT_TYPE_FK) 
        references QUALITATIVE_VALUE;

    alter table VESSEL_MANAGE_PERIOD 
        add constraint FISHING_VESSEL_MANAGE_PER_C  
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table VESSEL_MANAGE_PERIOD 
        add constraint VESSEL_MANAGE_PERIOD_MANAGED_C 
        foreign key (MANAGED_DATA_FK) 
        references MANAGED_DATA 
        on delete cascade;

    alter table VESSEL_OWNER 
        add constraint VESSEL_OWNER_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table VESSEL_OWNER 
        add constraint VESSEL_OWNER_COUNTRY_LOCATIONC 
        foreign key (COUNTRY_LOCATION_FK) 
        references LOCATION;

    alter table VESSEL_OWNER2RIGHT_TO_PRODUCE 
        add constraint VESSEL_OWNER_RIGHT_TO_PRODUCEC 
        foreign key (RIGHT_TO_PRODUCE_FK) 
        references RIGHT_TO_PRODUCE;

    alter table VESSEL_OWNER2RIGHT_TO_PRODUCE 
        add constraint RIGHT_TO_PRODUCE_VESSEL_OWNERC 
        foreign key (VESSEL_OWNER_FK) 
        references VESSEL_OWNER;

    alter table VESSEL_OWNER_PERIOD 
        add constraint VESSEL_OWNER_PERIOD_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL 
        on delete cascade;

    alter table VESSEL_OWNER_PERIOD 
        add constraint VESSEL_OWNER_PERIOD_VESSEL_OWC 
        foreign key (VESSEL_OWNER_FK) 
        references VESSEL_OWNER;

    alter table VESSEL_PERSON 
        add constraint VESSEL_PERSON_EDUCATION_GRADEC 
        foreign key (EDUCATION_GRADE_FK) 
        references EDUCATION_GRADE;

    alter table VESSEL_PERSON 
        add constraint VESSEL_PERSON_COUNTRY_LOCATIOC 
        foreign key (COUNTRY_LOCATION_FK) 
        references LOCATION;

    alter table VESSEL_PERSON 
        add constraint VESSEL_PERSON_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table VESSEL_PERSON_FEATURES 
        add constraint VESSEL_PERSON_FEATURES_OPERATC 
        foreign key (OPERATION_FK) 
        references OPERATION 
        on delete cascade;

    alter table VESSEL_PERSON_FEATURES 
        add constraint VESSEL_PERSON_FEATURES_FISHINC 
        foreign key (FISHING_TRIP_FK) 
        references FISHING_TRIP 
        on delete cascade;

    alter table VESSEL_PERSON_FEATURES 
        add constraint VESSEL_PERSON_FEATURES_ECONOMC 
        foreign key (ECONOMICAL_SURVEY_FK) 
        references ECONOMICAL_SURVEY 
        on delete cascade;

    alter table VESSEL_PERSON_FEATURES 
        add constraint VESSEL_PERSON_FEATURES_QUALITC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table VESSEL_PERSON_FEATURES 
        add constraint VESSEL_PERSON_FEATURES_VESSELS 
        foreign key (VESSEL_PERSON_FK) 
        references VESSEL_PERSON;

    alter table VESSEL_PERSON_FEATURES 
        add constraint VESSEL_PERSON_FEATURES_PERSONC 
        foreign key (PERSON_FK) 
        references PERSON;

    alter table VESSEL_PERSON_FEATURES 
        add constraint VESSEL_PERSON_FEATURES_PROGRAC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table VESSEL_PERSON_FEATURES 
        add constraint VESSEL_PERSON_FEATURES_VESSELE 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table VESSEL_PERSON_FEATURES2ROLE 
        add constraint VESSEL_PERSON_FEATURES_VESSELC 
        foreign key (VESSEL_PERSON_ROLES_FK) 
        references VESSEL_PERSON_ROLE;

    alter table VESSEL_PERSON_FEATURES2ROLE 
        add constraint VESSEL_PERSON_ROLE_VESSEL_PERC 
        foreign key (VESSEL_PERSON_FEATURES_FK) 
        references VESSEL_PERSON_FEATURES;

    alter table VESSEL_PERSON_MEASUREMENT 
        add constraint VESSEL_PERS_AGGREGATION_LEVELC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table VESSEL_PERSON_MEASUREMENT 
        add constraint VESSEL_PERSON_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table VESSEL_PERSON_MEASUREMENT 
        add constraint VESSEL_PERS_PRECISION_TYPE_FKC 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table VESSEL_PERSON_MEASUREMENT 
        add constraint VESSEL_PERS_ANALYSIS_INSTRUMEC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table VESSEL_PERSON_MEASUREMENT 
        add constraint VESSEL_PERS_NUMERICAL_PRECISIC 
        foreign key (NUMERICAL_PRECISION_FK) 
        references NUMERICAL_PRECISION;

    alter table VESSEL_PERSON_MEASUREMENT 
        add constraint VESSEL_PERSON_M_DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table VESSEL_PERSON_MEASUREMENT 
        add constraint VESSEL_PERSON_MEASURE_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table VESSEL_PERSON_MEASUREMENT 
        add constraint VESSEL_PERS_QUALITATIVE_VALUEC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table VESSEL_PERSON_MEASUREMENT 
        add constraint VESSEL_PERSON_MEASUREMENT_VESC 
        foreign key (VESSEL_PERSON_FEATURES_FK) 
        references VESSEL_PERSON_FEATURES 
        on delete cascade;

    alter table VESSEL_PHYSICAL_FEATURES 
        add constraint VESSEL_PHYSICAL_FE_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table VESSEL_PHYSICAL_FEATURES 
        add constraint VESSEL_PHYSICAL_F_QUALITY_FLAC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table VESSEL_PHYSICAL_FEATURES 
        add constraint VESSEL_PHYSICAL_FEA_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table VESSEL_PHYSICAL_FEATURES 
        add constraint VESSEL_PHYSICAL_FEATURES_RECOC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table VESSEL_PHYSICAL_FEATURES 
        add constraint VESSEL_PHYSICAL_FEATURES_BASEC 
        foreign key (BASE_LANDING_LOCATION_FK) 
        references LOCATION;

    alter table VESSEL_PHYSICAL_FEATURES 
        add constraint VESSEL_PHYSICAL_FEATURES_RECOE 
        foreign key (RECORDER_PERSON_FK) 
        references PERSON;

    alter table VESSEL_PHYSICAL_FEATURES 
        add constraint VESSEL_PHYSICAL_FEATURES_PHYSC 
        foreign key (PHYSICAL_GEAR_SURVEY_FK) 
        references PHYSICAL_GEAR_SURVEY 
        on delete cascade;

    alter table VESSEL_PHYSICAL_FEATURES_ORIGI 
        add constraint VESSEL_PHYSICAL_FEATURES_ORIGC 
        foreign key (VESSEL_PHYSICAL_FEATURES_FK) 
        references VESSEL_PHYSICAL_FEATURES 
        on delete cascade;

    alter table VESSEL_PHYSICAL_FEATURES_ORIGI 
        add constraint VESSEL_PHYSICAL_FEATURES_ORIGR 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table VESSEL_PHYSICAL_FEATURES_ORIGI 
        add constraint VESSEL_PHYSICAL_FEATURES_ORIG_ 
        foreign key (ACQUISITION_LEVEL_FK) 
        references ACQUISITION_LEVEL;

    alter table VESSEL_PHYSICAL_MEASUREMENT 
        add constraint VESSEL_PHYS_AGGREGATION_LEVELC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table VESSEL_PHYSICAL_MEASUREMENT 
        add constraint VESSEL_PHYSIC_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table VESSEL_PHYSICAL_MEASUREMENT 
        add constraint VESSEL_PHYS_PRECISION_TYPE_FKC 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table VESSEL_PHYSICAL_MEASUREMENT 
        add constraint VESSEL_PHYS_ANALYSIS_INSTRUMEC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table VESSEL_PHYSICAL_MEASUREMENT 
        add constraint VESSEL_PHYS_NUMERICAL_PRECISIC 
        foreign key (NUMERICAL_PRECISION_FK) 
        references NUMERICAL_PRECISION;

    alter table VESSEL_PHYSICAL_MEASUREMENT 
        add constraint VESSEL_PHYSICAL_DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table VESSEL_PHYSICAL_MEASUREMENT 
        add constraint VESSEL_PHYSICAL_MEASU_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table VESSEL_PHYSICAL_MEASUREMENT 
        add constraint VESSEL_PHYS_QUALITATIVE_VALUEC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table VESSEL_PHYSICAL_MEASUREMENT 
        add constraint VESSEL_PHYSICAL_MEASUREMENT_VC 
        foreign key (VESSEL_PHYSICAL_FEATURES_FK) 
        references VESSEL_PHYSICAL_FEATURES 
        on delete cascade;

    alter table VESSEL_POSITION 
        add constraint VESSEL_POSITION_PROCESSING_HIC 
        foreign key (PROCESSING_HISTORY_FK) 
        references PROCESSING_HISTORY;

    alter table VESSEL_POSITION 
        add constraint VESSEL_POSITION_RECORDER_DEPAC 
        foreign key (RECORDER_DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table VESSEL_POSITION 
        add constraint VESSEL_POSITION_OPERATION_FKC 
        foreign key (OPERATION_FK) 
        references OPERATION 
        on delete cascade;

    alter table VESSEL_POSITION 
        add constraint VESSEL_POSITION_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table VESSEL_POSITION 
        add constraint VESSEL_POSITION_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table VESSEL_POSITION 
        add constraint VESSEL_POSITION_QUALITY_FLAG_C 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table VESSEL_POSITION_MEASUREMENT 
        add constraint VESSEL_POSI_AGGREGATION_LEVELC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table VESSEL_POSITION_MEASUREMENT 
        add constraint VESSEL_POSITI_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table VESSEL_POSITION_MEASUREMENT 
        add constraint VESSEL_POSI_PRECISION_TYPE_FKC 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table VESSEL_POSITION_MEASUREMENT 
        add constraint VESSEL_POSI_ANALYSIS_INSTRUMEC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table VESSEL_POSITION_MEASUREMENT 
        add constraint VESSEL_POSI_NUMERICAL_PRECISIC 
        foreign key (NUMERICAL_PRECISION_FK) 
        references NUMERICAL_PRECISION;

    alter table VESSEL_POSITION_MEASUREMENT 
        add constraint VESSEL_POSITION_DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table VESSEL_POSITION_MEASUREMENT 
        add constraint VESSEL_POSITION_MEASU_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table VESSEL_POSITION_MEASUREMENT 
        add constraint VESSEL_POSI_QUALITATIVE_VALUEC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table VESSEL_POSITION_MEASUREMENT 
        add constraint VESSEL_POSITION_MEASUREMENT_VC 
        foreign key (VESSEL_POSITION_FK) 
        references VESSEL_POSITION 
        on delete cascade;

    alter table VESSEL_REGISTRATION_PERIOD 
        add constraint VESSEL_REGISTRATION_PERIOD_REC 
        foreign key (REGISTRATION_LOCATION_FK) 
        references LOCATION;

    alter table VESSEL_REGISTRATION_PERIOD 
        add constraint VESSEL_REGISTRATION_PERIOD_VEC 
        foreign key (VESSEL_FK) 
        references VESSEL 
        on delete cascade;

    alter table VESSEL_REGISTRATION_PERIOD 
        add constraint VESSEL_REGISTRATION_PERIOD_QUC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table VESSEL_TYPE 
        add constraint VESSEL_TYPE_STATUS_FKC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table VESSEL_USE_FEATURES 
        add constraint VESSEL_USE_FEATURE_PROGRAM_FKC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table VESSEL_USE_FEATURES 
        add constraint VESSEL_USE_FE_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table VESSEL_USE_FEATURES 
        add constraint VESSEL_USE_FEATURES_VESSEL_FKC 
        foreign key (VESSEL_FK) 
        references VESSEL;

    alter table VESSEL_USE_FEATURES 
        add constraint VESSEL_USE_FEATURES_DAILY_ACTC 
        foreign key (DAILY_ACTIVITY_CALENDAR_FK) 
        references DAILY_ACTIVITY_CALENDAR 
        on delete cascade;

    alter table VESSEL_USE_FEATURES 
        add constraint VESSEL_USE_FEATURES_BASE_PORTC 
        foreign key (BASE_PORT_LOCATION_FK) 
        references LOCATION;

    alter table VESSEL_USE_FEATURES 
        add constraint VESSEL_USE_FEATURES_OPERATIONC 
        foreign key (OPERATION_FK) 
        references OPERATION 
        on delete cascade;

    alter table VESSEL_USE_FEATURES 
        add constraint VESSEL_USE_FEATURES_FISHING_TC 
        foreign key (FISHING_TRIP_FK) 
        references FISHING_TRIP 
        on delete cascade;

    alter table VESSEL_USE_FEATURES 
        add constraint VESSEL_USE_FEATURES_ACTIVITY_C 
        foreign key (ACTIVITY_CALENDAR_FK) 
        references ACTIVITY_CALENDAR 
        on delete cascade;

    alter table VESSEL_USE_FEATURES 
        add constraint VESSEL_USE_FEATURES_ECONOMICAC 
        foreign key (ECONOMICAL_SURVEY_FK) 
        references ECONOMICAL_SURVEY 
        on delete cascade;

    alter table VESSEL_USE_FEATURES 
        add constraint VESSEL_USE_FEATURES_FISHING_EC 
        foreign key (FISHING_EFFORT_CALENDAR_FK) 
        references FISHING_EFFORT_CALENDAR;

    alter table VESSEL_USE_FEATURES_ORIGIN 
        add constraint VESSEL_USE_FEATURES_ORIGIN_PRC 
        foreign key (PROGRAM_FK) 
        references PROGRAM;

    alter table VESSEL_USE_FEATURES_ORIGIN 
        add constraint VESSEL_USE_FEATURES_ORIGIN_VEC 
        foreign key (VESSEL_USE_FEATURES_FK) 
        references VESSEL_USE_FEATURES 
        on delete cascade;

    alter table VESSEL_USE_FEATURES_ORIGIN 
        add constraint VESSEL_USE_FEATURES_ORIGIN_ACC 
        foreign key (ACQUISITION_LEVEL_FK) 
        references ACQUISITION_LEVEL;

    alter table VESSEL_USE_MEASUREMENT 
        add constraint VESSEL_USE__AGGREGATION_LEVELC 
        foreign key (AGGREGATION_LEVEL_FK) 
        references AGGREGATION_LEVEL;

    alter table VESSEL_USE_MEASUREMENT 
        add constraint VESSEL_USE_ME_QUALITY_FLAG_FKC 
        foreign key (QUALITY_FLAG_FK) 
        references QUALITY_FLAG;

    alter table VESSEL_USE_MEASUREMENT 
        add constraint VESSEL_USE__PRECISION_TYPE_FKC 
        foreign key (PRECISION_TYPE_FK) 
        references PRECISION_TYPE;

    alter table VESSEL_USE_MEASUREMENT 
        add constraint VESSEL_USE__ANALYSIS_INSTRUMEC 
        foreign key (ANALYSIS_INSTRUMENT_FK) 
        references ANALYSIS_INSTRUMENT;

    alter table VESSEL_USE_MEASUREMENT 
        add constraint VESSEL_USE__NUMERICAL_PRECISIC 
        foreign key (NUMERICAL_PRECISION_FK) 
        references NUMERICAL_PRECISION;

    alter table VESSEL_USE_MEASUREMENT 
        add constraint VESSEL_USE_MEAS_DEPARTMENT_FKC 
        foreign key (DEPARTMENT_FK) 
        references DEPARTMENT;

    alter table VESSEL_USE_MEASUREMENT 
        add constraint VESSEL_USE_MEASUREMEN_PMFM_FKC 
        foreign key (PMFM_FK) 
        references PMFM;

    alter table VESSEL_USE_MEASUREMENT 
        add constraint VESSEL_USE__QUALITATIVE_VALUEC 
        foreign key (QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table VESSEL_USE_MEASUREMENT 
        add constraint VESSEL_USE_MEASUREMENT_VESSELC 
        foreign key (VESSEL_USE_FEATURES_FK) 
        references VESSEL_USE_FEATURES 
        on delete cascade;

    alter table VIRTUAL_COMPONENT 
        add constraint VIRTUAL_COMPONENT_REFERENCE_TC 
        foreign key (REFERENCE_TAXON_FK) 
        references REFERENCE_TAXON;

    alter table VIRTUAL_COMPONENT 
        add constraint VIRTUAL_COMPONENT_TAXON_NAME_C 
        foreign key (TAXON_NAME_FK) 
        references TAXON_NAME;

    alter table WEIGHT_LENGTH_CONVERSION 
        add constraint WEIGHT_LENGTH_CONVERSION_STATC 
        foreign key (STATUS_FK) 
        references STATUS;

    alter table WEIGHT_LENGTH_CONVERSION 
        add constraint WEIGHT_LENGTH_CONVERSION_SEX_C 
        foreign key (SEX_QUALITATIVE_VALUE_FK) 
        references QUALITATIVE_VALUE;

    alter table WEIGHT_LENGTH_CONVERSION 
        add constraint WEIGHT_LENGTH_CONVERSION_LENGC 
        foreign key (LENGTH_PARAMETER_FK) 
        references PARAMETER;

    alter table WEIGHT_LENGTH_CONVERSION 
        add constraint WEIGHT_LENGTH_CONVERSION_LENGO 
        foreign key (LENGTH_UNIT_FK) 
        references UNIT;

    alter table WEIGHT_LENGTH_CONVERSION 
        add constraint WEIGHT_LENGTH_CONVERSION_REFEC 
        foreign key (REFERENCE_TAXON_FK) 
        references REFERENCE_TAXON;

    alter table WEIGHT_LENGTH_CONVERSION 
        add constraint WEIGHT_LENGTH_CONVERSION_LOCAC 
        foreign key (LOCATION_FK) 
        references LOCATION;

    create sequence ACTIVITY_CALENDAR_SEQ start with 1;

    create sequence APPLIED_QUALIFICATION_RULE_SEQ start with 1;

    create sequence BATCH_EXHAUSTIVE_INVENTORY_SEQ start with 1;

    create sequence BATCH_MODEL_SEQ start with 1;

    create sequence BATCH_SEQ start with 1;

    create sequence DAILY_ACTIVITY_CALENDAR_SEQ start with 1;

    create sequence DECLARED_DOCUMENT_REFERENC_SEQ start with 1;

    create sequence DELETED_ITEM_HISTORY_SEQ start with 1;

    create sequence DENORMALIZED_BATCH_SEQ start with 1;

    create sequence DENORMALIZED_BATCH_SORT_VA_SEQ start with 1;

    create sequence DENORMALIZED_OPERATION_SEQ start with 1;

    create sequence DENORMALIZED_VESSEL_SEQ start with 1;

    create sequence ECONOMICAL_SURVEY_SEQ start with 1;

    create sequence EXPECTED_SALE_SEQ start with 1;

    create sequence FISHING_AREA_SEQ start with 1;

    create sequence FISHING_EFFORT_CALENDAR_SEQ start with 1;

    create sequence FISHING_TRIP_ORIGIN_SEQ start with 1;

    create sequence FISHING_TRIP_SEQ start with 1;

    create sequence GEAR_PHYSICAL_FEATURES_SEQ start with 1;

    create sequence GEAR_PHYSICAL_MEASUREMENT_SEQ start with 1;

    create sequence GEAR_USE_FEATURES_SEQ start with 1;

    create sequence GEAR_USE_MEASUREMENT_SEQ start with 1;

    create sequence INSERTED_ITEM_HISTORY_SEQ start with 1;

    create sequence LANDING_MEASUREMENT_SEQ start with 1;

    create sequence LANDING_SEQ start with 1;

    create sequence LINKED_ITEM_SEQ start with 1;

    create sequence MEASUREMENT_FILE_SEQ start with 1;

    create sequence OBSERVED_LOCATION_FEATURES_SEQ start with 1;

    create sequence OBSERVED_LOCATION_MEASUREM_SEQ start with 1;

    create sequence OBSERVED_LOCATION_SEQ start with 1;

    create sequence OPERATION_SEQ start with 1;

    create sequence PHOTO_SEQ start with 1;

    create sequence PHYSICAL_GEAR_SURVEY_SEQ start with 1;

    create sequence PROCESSING_HISTORY_SEQ start with 1;

    create sequence PRODUCE_SEQ start with 1;

    create sequence QUALIFIED_ITEM_SEQ start with 1;

    create sequence QUANTIFICATION_MEASUREMENT_SEQ start with 1;

    create sequence SALE_MEASUREMENT_SEQ start with 1;

    create sequence SALE_SEQ start with 1;

    create sequence SAMPLE_MEASUREMENT_SEQ start with 1;

    create sequence SAMPLE_SEQ start with 1;

    create sequence SCIENTIFIC_CRUISE_SEQ start with 1;

    create sequence SORTING_MEASUREMENT_P_SEQ start with 1;

    create sequence SORTING_MEASUREMENT_SEQ start with 1;

    create sequence SURVEY_MEASUREMENT_SEQ start with 1;

    create sequence SYSTEM_VERSION_SEQ start with 1;

    create sequence TAKE_OVER_MEASUREMENT_SEQ start with 1;

    create sequence TAKE_OVER_SEQ start with 1;

    create sequence TEMP_QUERY_PARAMETER_SEQ start with 1;

    create sequence TRANSSHIPMENT_SEQ start with 1;

    create sequence UPDATED_ITEM_HISTORY_SEQ start with 1;

    create sequence VESSEL_PERSON_FEATURES_SEQ start with 1;

    create sequence VESSEL_PERSON_MEASUREMENT_SEQ start with 1;

    create sequence VESSEL_PERSON_SEQ start with 1;

    create sequence VESSEL_PHYSICAL_FEATURES_SEQ start with 1;

    create sequence VESSEL_PHYSICAL_MEASUREMEN_SEQ start with 1;

    create sequence VESSEL_POSITION_MEASUREMEN_SEQ start with 1;

    create sequence VESSEL_POSITION_SEQ start with 1;

    create sequence VESSEL_USE_FEATURES_SEQ start with 1;

    create sequence VESSEL_USE_MEASUREMENT_SEQ start with 1;
