// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.taxon;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Classe regroupant les taxons. Il s'agit en fait d'une combinaison entre un rang taxinomique, un
 * nom de taxon, un code et éventuellement un auteur et une date.
 * Cette classe regroupe les taxons valides, provisoires, obsolètes, virtuels et les synonymes.
 * On garde l'historique du passage en taxon valide, puis du passage en synonyme (date de fin
 * référent).
 * Dans COST : "Use the FAO reference list ftp://ftp.fao.org/FI/stat/data/ASFIS_sp.zip"
 */
// HibernateEntity.vsl annotations merge-point
public abstract class TaxonName
    implements Serializable, Comparable<TaxonName>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -763889927077388260L;

    // Generate 14 attributes
    private Integer id;

    /**
     * Identifiant système unique du libellé.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant système unique du libellé.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String name;

    /**
     * Nom latin présent dans la nomenclature du libellé. Il obéit aux règles de la concaténation du
     * libellé décrites dans le règle [R0018].
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Nom latin présent dans la nomenclature du libellé. Il obéit aux règles de la concaténation du
     * libellé décrites dans le règle [R0018].
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private String completeName;

    /**
     * 
     * @return this.completeName String
     */
    public String getCompleteName()
    {
        return this.completeName;
    }

    /**
     * 
     * @param completeNameIn String
     */
    public void setCompleteName(String completeNameIn)
    {
        this.completeName = completeNameIn;
    }

    private Boolean isNaming;

    /**
     * Indique si les regles de nomenclature sont à appliquer.
     * @return this.isNaming Boolean
     */
    public Boolean isIsNaming()
    {
        return this.isNaming;
    }

    /**
     * Indique si les regles de nomenclature sont à appliquer.
     * @param isNamingIn Boolean
     */
    public void setIsNaming(Boolean isNamingIn)
    {
        this.isNaming = isNamingIn;
    }

    private Boolean isReferent;

    /**
     * 
     * @return this.isReferent Boolean
     */
    public Boolean isIsReferent()
    {
        return this.isReferent;
    }

    /**
     * 
     * @param isReferentIn Boolean
     */
    public void setIsReferent(Boolean isReferentIn)
    {
        this.isReferent = isReferentIn;
    }

    private Integer upperRank;

    /**
     * Ce numéro d'ordre du taxon dans l'arbre phylogénique permet de classer les fils d'un même
     * taxon père et donc l'ensemble des taxons valides les uns par rapport aux autres. Il permet
     * notamment de gérer les ordre d'affichage suivant l'ordre taxinomique.
     * @return this.upperRank Integer
     */
    public Integer getUpperRank()
    {
        return this.upperRank;
    }

    /**
     * Ce numéro d'ordre du taxon dans l'arbre phylogénique permet de classer les fils d'un même
     * taxon père et donc l'ensemble des taxons valides les uns par rapport aux autres. Il permet
     * notamment de gérer les ordre d'affichage suivant l'ordre taxinomique.
     * @param upperRankIn Integer
     */
    public void setUpperRank(Integer upperRankIn)
    {
        this.upperRank = upperRankIn;
    }

    private Boolean isVirtual;

    /**
     * 
     * @return this.isVirtual Boolean
     */
    public Boolean isIsVirtual()
    {
        return this.isVirtual;
    }

    /**
     * 
     * @param isVirtualIn Boolean
     */
    public void setIsVirtual(Boolean isVirtualIn)
    {
        this.isVirtual = isVirtualIn;
    }

    private Boolean isObsolete;

    /**
     * Indique qu’un taxon est obsolète
     * @return this.isObsolete Boolean
     */
    public Boolean isIsObsolete()
    {
        return this.isObsolete;
    }

    /**
     * Indique qu’un taxon est obsolète
     * @param isObsoleteIn Boolean
     */
    public void setIsObsolete(Boolean isObsoleteIn)
    {
        this.isObsolete = isObsoleteIn;
    }

    private Boolean isTemporary;

    /**
     * Un libellé peut être provisoire (sp1,sp2 etc.)
     * @return this.isTemporary Boolean
     */
    public Boolean isIsTemporary()
    {
        return this.isTemporary;
    }

    /**
     * Un libellé peut être provisoire (sp1,sp2 etc.)
     * @param isTemporaryIn Boolean
     */
    public void setIsTemporary(Boolean isTemporaryIn)
    {
        this.isTemporary = isTemporaryIn;
    }

    private Date startDate;

    /**
     * Date à laquelle le taxon est devenu valide. Cette date peut être vide si le libellé n'a
     * jamais été valide. Cette date est renseignée automatiquement par le système.
     * @return this.startDate Date
     */
    public Date getStartDate()
    {
        return this.startDate;
    }

    /**
     * Date à laquelle le taxon est devenu valide. Cette date peut être vide si le libellé n'a
     * jamais été valide. Cette date est renseignée automatiquement par le système.
     * @param startDateIn Date
     */
    public void setStartDate(Date startDateIn)
    {
        this.startDate = startDateIn;
    }

    private Date endDate;

    /**
     * Date où le libellé n'est plus référent et a été remplacé par un autre libellé. Cette date est
     * renseignée automatiquement par le système.
     * @return this.endDate Date
     */
    public Date getEndDate()
    {
        return this.endDate;
    }

    /**
     * Date où le libellé n'est plus référent et a été remplacé par un autre libellé. Cette date est
     * renseignée automatiquement par le système.
     * @param endDateIn Date
     */
    public void setEndDate(Date endDateIn)
    {
        this.endDate = endDateIn;
    }

    private String comments;

    /**
     * Commentaire associé au libellé du taxon.
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * Commentaire associé au libellé du taxon.
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    private Date creationDate;

    /**
     * Date de création système du libellé. Renseigné automatiquement par le système.
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * Date de création système du libellé. Renseigné automatiquement par le système.
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Timestamp updateDate;

    /**
     * Date de mise à jour système du libellé. Renseigné automatiquement par le système.
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * Date de mise à jour système du libellé. Renseigné automatiquement par le système.
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 9 associations
    private Citation citation;

    /**
     * Deux éléments sont à distinguer dans l'autorité de classification d’un taxon :
     * - La publication qui fait état de la description et de la nomenclature du taxon.
     * - La citation, associée au nom du taxon, pour faire référence à la publication d'origine du
     * taxon.
     * Les règles de nomenclature des taxons et de leurs auteurs sont définies dans The
     * International Code
     * of Zoological Nomenclature (ICZN : http://www.iczn.org/iczn/index.jsp ) pour la faune, et
     * dans The
     * International Code of Botanical Nomenclature (ICBN :
     * http://www.bgbm.fu-berlin.de/iapt/nomenclature/CODE/SaintLouis/0000St.Luistitle.htm) pour la
     * flore.
     * Chaque taxon ne possède qu'une seule publication, et une seule citation. Une publication peut
     * correspondre à plusieurs taxons, et une citation peut être identique pour plusieurs taxons.
     * @return this.citation Citation
     */
    public Citation getCitation()
    {
        return this.citation;
    }

    /**
     * Deux éléments sont à distinguer dans l'autorité de classification d’un taxon :
     * - La publication qui fait état de la description et de la nomenclature du taxon.
     * - La citation, associée au nom du taxon, pour faire référence à la publication d'origine du
     * taxon.
     * Les règles de nomenclature des taxons et de leurs auteurs sont définies dans The
     * International Code
     * of Zoological Nomenclature (ICZN : http://www.iczn.org/iczn/index.jsp ) pour la faune, et
     * dans The
     * International Code of Botanical Nomenclature (ICBN :
     * http://www.bgbm.fu-berlin.de/iapt/nomenclature/CODE/SaintLouis/0000St.Luistitle.htm) pour la
     * flore.
     * Chaque taxon ne possède qu'une seule publication, et une seule citation. Une publication peut
     * correspondre à plusieurs taxons, et une citation peut être identique pour plusieurs taxons.
     * @param citationIn Citation
     */
    public void setCitation(Citation citationIn)
    {
        this.citation = citationIn;
    }

    private TaxonName parentTaxonName;

    /**
     * Classe regroupant les taxons. Il s'agit en fait d'une combinaison entre un rang taxinomique,
     * un nom
     * de taxon, un code et éventuellement un auteur et une date.
     * Cette classe regroupe les taxons valides, provisoires, obsolètes, virtuels et les synonymes.
     * On garde l'historique du passage en taxon valide, puis du passage en synonyme (date de fin
     * référent).
     * Dans COST : "Use the FAO reference list ftp://ftp.fao.org/FI/stat/data/ASFIS_sp.zip"
     * @return this.parentTaxonName TaxonName
     */
    public TaxonName getParentTaxonName()
    {
        return this.parentTaxonName;
    }

    /**
     * Classe regroupant les taxons. Il s'agit en fait d'une combinaison entre un rang taxinomique,
     * un nom
     * de taxon, un code et éventuellement un auteur et une date.
     * Cette classe regroupe les taxons valides, provisoires, obsolètes, virtuels et les synonymes.
     * On garde l'historique du passage en taxon valide, puis du passage en synonyme (date de fin
     * référent).
     * Dans COST : "Use the FAO reference list ftp://ftp.fao.org/FI/stat/data/ASFIS_sp.zip"
     * @param parentTaxonNameIn TaxonName
     */
    public void setParentTaxonName(TaxonName parentTaxonNameIn)
    {
        this.parentTaxonName = parentTaxonNameIn;
    }

    private Collection<TaxonName> childTaxonNames = new HashSet<TaxonName>();

    /**
     * Classe regroupant les taxons. Il s'agit en fait d'une combinaison entre un rang taxinomique,
     * un nom
     * de taxon, un code et éventuellement un auteur et une date.
     * Cette classe regroupe les taxons valides, provisoires, obsolètes, virtuels et les synonymes.
     * On garde l'historique du passage en taxon valide, puis du passage en synonyme (date de fin
     * référent).
     * Dans COST : "Use the FAO reference list ftp://ftp.fao.org/FI/stat/data/ASFIS_sp.zip"
     * @return this.childTaxonNames Collection<TaxonName>
     */
    public Collection<TaxonName> getChildTaxonNames()
    {
        return this.childTaxonNames;
    }

    /**
     * Classe regroupant les taxons. Il s'agit en fait d'une combinaison entre un rang taxinomique,
     * un nom
     * de taxon, un code et éventuellement un auteur et une date.
     * Cette classe regroupe les taxons valides, provisoires, obsolètes, virtuels et les synonymes.
     * On garde l'historique du passage en taxon valide, puis du passage en synonyme (date de fin
     * référent).
     * Dans COST : "Use the FAO reference list ftp://ftp.fao.org/FI/stat/data/ASFIS_sp.zip"
     * @param childTaxonNamesIn Collection<TaxonName>
     */
    public void setChildTaxonNames(Collection<TaxonName> childTaxonNamesIn)
    {
        this.childTaxonNames = childTaxonNamesIn;
    }

    /**
     * Classe regroupant les taxons. Il s'agit en fait d'une combinaison entre un rang taxinomique,
     * un nom
     * de taxon, un code et éventuellement un auteur et une date.
     * Cette classe regroupe les taxons valides, provisoires, obsolètes, virtuels et les synonymes.
     * On garde l'historique du passage en taxon valide, puis du passage en synonyme (date de fin
     * référent).
     * Dans COST : "Use the FAO reference list ftp://ftp.fao.org/FI/stat/data/ASFIS_sp.zip"
     * @param elementToAdd TaxonName
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addChildTaxonNames(TaxonName elementToAdd)
    {
        return this.childTaxonNames.add(elementToAdd);
    }

    /**
     * Classe regroupant les taxons. Il s'agit en fait d'une combinaison entre un rang taxinomique,
     * un nom
     * de taxon, un code et éventuellement un auteur et une date.
     * Cette classe regroupe les taxons valides, provisoires, obsolètes, virtuels et les synonymes.
     * On garde l'historique du passage en taxon valide, puis du passage en synonyme (date de fin
     * référent).
     * Dans COST : "Use the FAO reference list ftp://ftp.fao.org/FI/stat/data/ASFIS_sp.zip"
     * @param elementToRemove TaxonName
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeChildTaxonNames(TaxonName elementToRemove)
    {
        return this.childTaxonNames.remove(elementToRemove);
    }

    private Collection<TaxonNameHistory> parentTaxonNameHistories = new HashSet<TaxonNameHistory>();

    /**
     * 
     * @return this.parentTaxonNameHistories Collection<TaxonNameHistory>
     */
    public Collection<TaxonNameHistory> getParentTaxonNameHistories()
    {
        return this.parentTaxonNameHistories;
    }

    /**
     * 
     * @param parentTaxonNameHistoriesIn Collection<TaxonNameHistory>
     */
    public void setParentTaxonNameHistories(Collection<TaxonNameHistory> parentTaxonNameHistoriesIn)
    {
        this.parentTaxonNameHistories = parentTaxonNameHistoriesIn;
    }

    /**
     * 
     * @param elementToAdd TaxonNameHistory
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addParentTaxonNameHistories(TaxonNameHistory elementToAdd)
    {
        return this.parentTaxonNameHistories.add(elementToAdd);
    }

    /**
     * 
     * @param elementToRemove TaxonNameHistory
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeParentTaxonNameHistories(TaxonNameHistory elementToRemove)
    {
        return this.parentTaxonNameHistories.remove(elementToRemove);
    }

    private Collection<TaxonNameHistory> taxonNamehistories = new HashSet<TaxonNameHistory>();

    /**
     * 
     * @return this.taxonNamehistories Collection<TaxonNameHistory>
     */
    public Collection<TaxonNameHistory> getTaxonNamehistories()
    {
        return this.taxonNamehistories;
    }

    /**
     * 
     * @param taxonNamehistoriesIn Collection<TaxonNameHistory>
     */
    public void setTaxonNamehistories(Collection<TaxonNameHistory> taxonNamehistoriesIn)
    {
        this.taxonNamehistories = taxonNamehistoriesIn;
    }

    /**
     * 
     * @param elementToAdd TaxonNameHistory
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addTaxonNamehistories(TaxonNameHistory elementToAdd)
    {
        return this.taxonNamehistories.add(elementToAdd);
    }

    /**
     * 
     * @param elementToRemove TaxonNameHistory
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeTaxonNamehistories(TaxonNameHistory elementToRemove)
    {
        return this.taxonNamehistories.remove(elementToRemove);
    }

    private TaxonomicLevel taxonomicLevel;

    /**
     * Liste des rangs taxinomiques possibles.
     * C’est le nom du rang dans la classification systématique ; les niveaux systématiques sont
     * désignés
     * par des termes consacrés (ex. : espèce, genre, famille, etc.). Le niveau systématique d’un
     * taxon
     * peut changer avec l’évolution de la classification ; dans ce cas, son libellé est susceptible
     * de
     * changer également car les suffixes notamment obéissent à des règles strictes de nomenclature
     * (règle
     * [R0018]).
     * Les niveaux systématiques pris en compte dans le référentiel taxinomique Quadrige² sont (par
     * ordre
     * de rang) (le nom anglais de chaque niveau est indiqué entre parenthèses) :
     * -	Règne (kingdom)
     * -	Sous-règne (subkingdom)
     * -	Division (division) / Embranchement (phylum)
     * -	Subdivision (subdivision) / Sous-embranchement (subphylum)
     * -	Super-classe (superclass)
     * -	Classe (class)
     * -	Sous-classe (subclass)
     * -	Infra-classe (infraclass)
     * -	Super-ordre (superordo)
     * -	Ordre (ordo)
     * -	Sous-ordre (subordo)
     * -	Infra-ordre (infraordo)
     * -	Section (section)
     * -	Sous-section (subsection)
     * -	Super-famille (superfamily)
     * -	Famille (family)
     * -	Sous-famille (subfamily)
     * -	Tribu (tribe)
     * -	Sous-tribu (subtribe)
     * -	Genre (genus)
     * -	Sous-genre (subgenus)
     * -	Espèce (species)
     * -	Sous-espèce (subspecies)
     * -	Variété (variety)
     * -	Sous-variété (subvariety)
     * -	Forme (forma)
     * -	Sous-forme (subforma)
     * -	Incertae sedis (dummy = taxons inclassables)
     * @return this.taxonomicLevel TaxonomicLevel
     */
    public TaxonomicLevel getTaxonomicLevel()
    {
        return this.taxonomicLevel;
    }

    /**
     * Liste des rangs taxinomiques possibles.
     * C’est le nom du rang dans la classification systématique ; les niveaux systématiques sont
     * désignés
     * par des termes consacrés (ex. : espèce, genre, famille, etc.). Le niveau systématique d’un
     * taxon
     * peut changer avec l’évolution de la classification ; dans ce cas, son libellé est susceptible
     * de
     * changer également car les suffixes notamment obéissent à des règles strictes de nomenclature
     * (règle
     * [R0018]).
     * Les niveaux systématiques pris en compte dans le référentiel taxinomique Quadrige² sont (par
     * ordre
     * de rang) (le nom anglais de chaque niveau est indiqué entre parenthèses) :
     * -	Règne (kingdom)
     * -	Sous-règne (subkingdom)
     * -	Division (division) / Embranchement (phylum)
     * -	Subdivision (subdivision) / Sous-embranchement (subphylum)
     * -	Super-classe (superclass)
     * -	Classe (class)
     * -	Sous-classe (subclass)
     * -	Infra-classe (infraclass)
     * -	Super-ordre (superordo)
     * -	Ordre (ordo)
     * -	Sous-ordre (subordo)
     * -	Infra-ordre (infraordo)
     * -	Section (section)
     * -	Sous-section (subsection)
     * -	Super-famille (superfamily)
     * -	Famille (family)
     * -	Sous-famille (subfamily)
     * -	Tribu (tribe)
     * -	Sous-tribu (subtribe)
     * -	Genre (genus)
     * -	Sous-genre (subgenus)
     * -	Espèce (species)
     * -	Sous-espèce (subspecies)
     * -	Variété (variety)
     * -	Sous-variété (subvariety)
     * -	Forme (forma)
     * -	Sous-forme (subforma)
     * -	Incertae sedis (dummy = taxons inclassables)
     * @param taxonomicLevelIn TaxonomicLevel
     */
    public void setTaxonomicLevel(TaxonomicLevel taxonomicLevelIn)
    {
        this.taxonomicLevel = taxonomicLevelIn;
    }

    private ReferenceTaxon referenceTaxon;

    /**
     * 
     * @return this.referenceTaxon ReferenceTaxon
     */
    public ReferenceTaxon getReferenceTaxon()
    {
        return this.referenceTaxon;
    }

    /**
     * 
     * @param referenceTaxonIn ReferenceTaxon
     */
    public void setReferenceTaxon(ReferenceTaxon referenceTaxonIn)
    {
        this.referenceTaxon = referenceTaxonIn;
    }

    /**
     * Returns <code>true</code> if the argument is an TaxonName instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof TaxonName))
        {
            return false;
        }
        final TaxonName that = (TaxonName)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link TaxonName}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link TaxonName}.
         * @return new TaxonNameImpl()
         */
        public static TaxonName newInstance()
        {
            return new TaxonNameImpl();
        }

        /**
         * Constructs a new instance of {@link TaxonName}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param name String
         * @param isNaming Boolean
         * @param isReferent Boolean
         * @param upperRank Integer
         * @param isVirtual Boolean
         * @param isObsolete Boolean
         * @param isTemporary Boolean
         * @param startDate Date
         * @param creationDate Date
         * @param taxonomicLevel TaxonomicLevel
         * @param referenceTaxon ReferenceTaxon
         * @return newInstance
         */
        public static TaxonName newInstance(String name, Boolean isNaming, Boolean isReferent, Integer upperRank, Boolean isVirtual, Boolean isObsolete, Boolean isTemporary, Date startDate, Date creationDate, TaxonomicLevel taxonomicLevel, ReferenceTaxon referenceTaxon)
        {
            final TaxonName entity = new TaxonNameImpl();
            entity.setName(name);
            entity.setIsNaming(isNaming);
            entity.setIsReferent(isReferent);
            entity.setUpperRank(upperRank);
            entity.setIsVirtual(isVirtual);
            entity.setIsObsolete(isObsolete);
            entity.setIsTemporary(isTemporary);
            entity.setStartDate(startDate);
            entity.setCreationDate(creationDate);
            entity.setTaxonomicLevel(taxonomicLevel);
            entity.setReferenceTaxon(referenceTaxon);
            return entity;
        }

        /**
         * Constructs a new instance of {@link TaxonName}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param name String
         * @param completeName String
         * @param isNaming Boolean
         * @param isReferent Boolean
         * @param upperRank Integer
         * @param isVirtual Boolean
         * @param isObsolete Boolean
         * @param isTemporary Boolean
         * @param startDate Date
         * @param endDate Date
         * @param comments String
         * @param creationDate Date
         * @param updateDate Timestamp
         * @param citation Citation
         * @param parentTaxonName TaxonName
         * @param childTaxonNames Collection<TaxonName>
         * @param parentTaxonNameHistories Collection<TaxonNameHistory>
         * @param taxonNamehistories Collection<TaxonNameHistory>
         * @param taxonomicLevel TaxonomicLevel
         * @param referenceTaxon ReferenceTaxon
         * @return newInstance TaxonName
         */
        public static TaxonName newInstance(String name, String completeName, Boolean isNaming, Boolean isReferent, Integer upperRank, Boolean isVirtual, Boolean isObsolete, Boolean isTemporary, Date startDate, Date endDate, String comments, Date creationDate, Timestamp updateDate, Citation citation, TaxonName parentTaxonName, Collection<TaxonName> childTaxonNames, Collection<TaxonNameHistory> parentTaxonNameHistories, Collection<TaxonNameHistory> taxonNamehistories, TaxonomicLevel taxonomicLevel, ReferenceTaxon referenceTaxon)
        {
            final TaxonName entity = new TaxonNameImpl();
            entity.setName(name);
            entity.setCompleteName(completeName);
            entity.setIsNaming(isNaming);
            entity.setIsReferent(isReferent);
            entity.setUpperRank(upperRank);
            entity.setIsVirtual(isVirtual);
            entity.setIsObsolete(isObsolete);
            entity.setIsTemporary(isTemporary);
            entity.setStartDate(startDate);
            entity.setEndDate(endDate);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setCitation(citation);
            entity.setParentTaxonName(parentTaxonName);
            entity.setChildTaxonNames(childTaxonNames);
            entity.setParentTaxonNameHistories(parentTaxonNameHistories);
            entity.setTaxonNamehistories(taxonNamehistories);
            entity.setTaxonomicLevel(taxonomicLevel);
            entity.setReferenceTaxon(referenceTaxon);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(TaxonName o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getCompleteName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCompleteName().compareTo(o.getCompleteName()));
            }
            if (this.isIsNaming() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isIsNaming().compareTo(o.isIsNaming()));
            }
            if (this.isIsReferent() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isIsReferent().compareTo(o.isIsReferent()));
            }
            if (this.getUpperRank() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpperRank().compareTo(o.getUpperRank()));
            }
            if (this.isIsVirtual() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isIsVirtual().compareTo(o.isIsVirtual()));
            }
            if (this.isIsObsolete() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isIsObsolete().compareTo(o.isIsObsolete()));
            }
            if (this.isIsTemporary() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isIsTemporary().compareTo(o.isIsTemporary()));
            }
            if (this.getStartDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getStartDate().compareTo(o.getStartDate()));
            }
            if (this.getEndDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getEndDate().compareTo(o.getEndDate()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// TaxonName.java merge-point
}