// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.grouping;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.referential.Status;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;

/**
 * <html>
 * <head>
 * <style>
 * p {padding:0px; margin:0px;}
 * </style>
 * </head>
 * <body>
 * <p>
 * Un regroupement représente un groupement d'entités (du référentiel ou
 * bien de navires), correspondant à un niveau de regroupement donné (<i>GroupingLevel</i>).
 * </p>
 * <p>
 * </p>
 * <p>
 * Un regroupement peut faire référence à une ou plusieurs entités du
 * référentiel (<i>GroupingItem</i>). Généralement, surtout les
 * regroupements de plus bas niveau sont liés à des entités du référentiel
 * (plus facile à maintenir), puis une table technique remplie toutes les
 * associations possible avec les ancêtres (cf <i>GroupingItemHierarchy</i>).
 * </p>
 * <p>
 * </p>
 * <p>
 * Un regroupement peut avoir un regroupement parent.
 * </p>
 * </body>
 * </html>
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Grouping
    implements Serializable, Comparable<Grouping>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -7175025509967376115L;

    // Generate 6 attributes
    private Integer id;

    /**
     * Identifiant interne. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant interne. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String label;

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Code mnémotechnique représentant le regroupement.
     * </p>
     * <p>
     * </p>
     * <p>
     * Par exemple :
     * </p>
     * <p>
     * - pour une classe taille de navire : &quot;[0-10[m&quot;, &quot;[10-20[m&quot;, etc.
     * </p>
     * <p>
     * - pour un regroupement de métiers, le code du regroupement, etc.
     * </p>
     * </body>
     * </html>
     * @return this.label String
     */
    public String getLabel()
    {
        return this.label;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Code mnémotechnique représentant le regroupement.
     * </p>
     * <p>
     * </p>
     * <p>
     * Par exemple :
     * </p>
     * <p>
     * - pour une classe taille de navire : &quot;[0-10[m&quot;, &quot;[10-20[m&quot;, etc.
     * </p>
     * <p>
     * - pour un regroupement de métiers, le code du regroupement, etc.
     * </p>
     * </body>
     * </html>
     * @param labelIn String
     */
    public void setLabel(String labelIn)
    {
        this.label = labelIn;
    }

    private String name;

    /**
     * 
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * 
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private Double minValue;

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Valeur minimum de la caractéristique de regroupement.
     * </p>
     * <p>
     * </p>
     * <p>
     * Uniquement dans le cas où une caractéristique a été définie sur le
     * niveau de regroupement parent (uniquement si <i>GroupLevel.featuresPmfm </i>est
     * renseigné).
     * </p>
     * <p>
     * </p>
     * <p>
     * Exemple : Si la caractéristique est &quot;Longueur du navire&quot;, la valeur min
     * vaudra &quot;10&quot;, pour une classe de taille de 10 à 20 m.
     * </p>
     * </body>
     * </html>
     * @return this.minValue Double
     */
    public Double getMinValue()
    {
        return this.minValue;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Valeur minimum de la caractéristique de regroupement.
     * </p>
     * <p>
     * </p>
     * <p>
     * Uniquement dans le cas où une caractéristique a été définie sur le
     * niveau de regroupement parent (uniquement si <i>GroupLevel.featuresPmfm </i>est
     * renseigné).
     * </p>
     * <p>
     * </p>
     * <p>
     * Exemple : Si la caractéristique est &quot;Longueur du navire&quot;, la valeur min
     * vaudra &quot;10&quot;, pour une classe de taille de 10 à 20 m.
     * </p>
     * </body>
     * </html>
     * @param minValueIn Double
     */
    public void setMinValue(Double minValueIn)
    {
        this.minValue = minValueIn;
    }

    private Double maxValue;

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Valeur maximale de la caractéristique de regroupement.
     * </p>
     * <p>
     * </p>
     * <p>
     * Uniquement dans le cas où une caractéristique a été définie sur le
     * niveau de regroupement parent (uniquement si <i>GroupLevel.featuresPmfm </i>est
     * renseigné).
     * </p>
     * <p>
     * </p>
     * <p>
     * Par convention, la valeur maximale du regroupement est EXCLUE.
     * </p>
     * <p>
     * </p>
     * <p>
     * Exemple : Si la caractéristique est &quot;Longueur du navire&quot;, la valeur max
     * vaudra &quot;20&quot;, pour une classe de taille de [10-20[m (20 étant exclu).
     * </p>
     * </body>
     * </html>
     * @return this.maxValue Double
     */
    public Double getMaxValue()
    {
        return this.maxValue;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Valeur maximale de la caractéristique de regroupement.
     * </p>
     * <p>
     * </p>
     * <p>
     * Uniquement dans le cas où une caractéristique a été définie sur le
     * niveau de regroupement parent (uniquement si <i>GroupLevel.featuresPmfm </i>est
     * renseigné).
     * </p>
     * <p>
     * </p>
     * <p>
     * Par convention, la valeur maximale du regroupement est EXCLUE.
     * </p>
     * <p>
     * </p>
     * <p>
     * Exemple : Si la caractéristique est &quot;Longueur du navire&quot;, la valeur max
     * vaudra &quot;20&quot;, pour une classe de taille de [10-20[m (20 étant exclu).
     * </p>
     * </body>
     * </html>
     * @param maxValueIn Double
     */
    public void setMaxValue(Double maxValueIn)
    {
        this.maxValue = maxValueIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 9 associations
    private Collection<Grouping> groupings = new HashSet<Grouping>();

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Un regroupement représente un groupement d'entités (du référentiel ou
     * bien de navires), correspondant à un niveau de regroupement donné (<i>GroupingLevel</i>).
     * </p>
     * <p>
     * </p>
     * <p>
     * Un regroupement peut faire référence à une ou plusieurs entités du
     * référentiel (<i>GroupingItem</i>). Généralement, surtout les
     * regroupements de plus bas niveau sont liés à des entités du référentiel
     * (plus facile à maintenir), puis une table technique remplie toutes les
     * associations possible avec les ancêtres (cf <i>GroupingItemHierarchy</i>).
     * </p>
     * <p>
     * </p>
     * <p>
     * Un regroupement peut avoir un regroupement parent.
     * </p>
     * </body>
     * </html>
     * @return this.groupings Collection<Grouping>
     */
    public Collection<Grouping> getGroupings()
    {
        return this.groupings;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Un regroupement représente un groupement d'entités (du référentiel ou
     * bien de navires), correspondant à un niveau de regroupement donné (<i>GroupingLevel</i>).
     * </p>
     * <p>
     * </p>
     * <p>
     * Un regroupement peut faire référence à une ou plusieurs entités du
     * référentiel (<i>GroupingItem</i>). Généralement, surtout les
     * regroupements de plus bas niveau sont liés à des entités du référentiel
     * (plus facile à maintenir), puis une table technique remplie toutes les
     * associations possible avec les ancêtres (cf <i>GroupingItemHierarchy</i>).
     * </p>
     * <p>
     * </p>
     * <p>
     * Un regroupement peut avoir un regroupement parent.
     * </p>
     * </body>
     * </html>
     * @param groupingsIn Collection<Grouping>
     */
    public void setGroupings(Collection<Grouping> groupingsIn)
    {
        this.groupings = groupingsIn;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Un regroupement représente un groupement d'entités (du référentiel ou
     * bien de navires), correspondant à un niveau de regroupement donné (<i>GroupingLevel</i>).
     * </p>
     * <p>
     * </p>
     * <p>
     * Un regroupement peut faire référence à une ou plusieurs entités du
     * référentiel (<i>GroupingItem</i>). Généralement, surtout les
     * regroupements de plus bas niveau sont liés à des entités du référentiel
     * (plus facile à maintenir), puis une table technique remplie toutes les
     * associations possible avec les ancêtres (cf <i>GroupingItemHierarchy</i>).
     * </p>
     * <p>
     * </p>
     * <p>
     * Un regroupement peut avoir un regroupement parent.
     * </p>
     * </body>
     * </html>
     * @param elementToAdd Grouping
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addGroupings(Grouping elementToAdd)
    {
        return this.groupings.add(elementToAdd);
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Un regroupement représente un groupement d'entités (du référentiel ou
     * bien de navires), correspondant à un niveau de regroupement donné (<i>GroupingLevel</i>).
     * </p>
     * <p>
     * </p>
     * <p>
     * Un regroupement peut faire référence à une ou plusieurs entités du
     * référentiel (<i>GroupingItem</i>). Généralement, surtout les
     * regroupements de plus bas niveau sont liés à des entités du référentiel
     * (plus facile à maintenir), puis une table technique remplie toutes les
     * associations possible avec les ancêtres (cf <i>GroupingItemHierarchy</i>).
     * </p>
     * <p>
     * </p>
     * <p>
     * Un regroupement peut avoir un regroupement parent.
     * </p>
     * </body>
     * </html>
     * @param elementToRemove Grouping
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeGroupings(Grouping elementToRemove)
    {
        return this.groupings.remove(elementToRemove);
    }

    private Grouping parentGrouping;

    /**
     * Le regroupement parent (optionnel).
     * @return this.parentGrouping Grouping
     */
    public Grouping getParentGrouping()
    {
        return this.parentGrouping;
    }

    /**
     * Le regroupement parent (optionnel).
     * @param parentGroupingIn Grouping
     */
    public void setParentGrouping(Grouping parentGroupingIn)
    {
        this.parentGrouping = parentGroupingIn;
    }

    private Collection<GroupingItem> groupingItems = new HashSet<GroupingItem>();

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * <i>GroupingItem</i> permet de lister les entités du référentiel qui
     * appartiennent à un regroupement.
     * </p>
     * </body>
     * </html>
     * @return this.groupingItems Collection<GroupingItem>
     */
    public Collection<GroupingItem> getGroupingItems()
    {
        return this.groupingItems;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * <i>GroupingItem</i> permet de lister les entités du référentiel qui
     * appartiennent à un regroupement.
     * </p>
     * </body>
     * </html>
     * @param groupingItemsIn Collection<GroupingItem>
     */
    public void setGroupingItems(Collection<GroupingItem> groupingItemsIn)
    {
        this.groupingItems = groupingItemsIn;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * <i>GroupingItem</i> permet de lister les entités du référentiel qui
     * appartiennent à un regroupement.
     * </p>
     * </body>
     * </html>
     * @param elementToAdd GroupingItem
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addGroupingItems(GroupingItem elementToAdd)
    {
        return this.groupingItems.add(elementToAdd);
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * <i>GroupingItem</i> permet de lister les entités du référentiel qui
     * appartiennent à un regroupement.
     * </p>
     * </body>
     * </html>
     * @param elementToRemove GroupingItem
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeGroupingItems(GroupingItem elementToRemove)
    {
        return this.groupingItems.remove(elementToRemove);
    }

    private GroupingClassification groupingClassification;

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Classification du regroupement.
     * </p>
     * <p>
     * Lien utilisé pour optimiser les performances, car déjà présent dans le <i>GroupingLevel</i>
     * lié.
     * </p>
     * <p>
     * </p>
     * <p>
     * Doit être identique à la classification du <i>GroupingLevel</i>
     * lié.
     * </p>
     * </body>
     * </html>
     * @return this.groupingClassification GroupingClassification
     */
    public GroupingClassification getGroupingClassification()
    {
        return this.groupingClassification;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Classification du regroupement.
     * </p>
     * <p>
     * Lien utilisé pour optimiser les performances, car déjà présent dans le <i>GroupingLevel</i>
     * lié.
     * </p>
     * <p>
     * </p>
     * <p>
     * Doit être identique à la classification du <i>GroupingLevel</i>
     * lié.
     * </p>
     * </body>
     * </html>
     * @param groupingClassificationIn GroupingClassification
     */
    public void setGroupingClassification(GroupingClassification groupingClassificationIn)
    {
        this.groupingClassification = groupingClassificationIn;
    }

    private GroupingLevel groupingLevel;

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Niveau de regroupement, d'une classification donnée.
     * </p>
     * <p>
     * </p>
     * <p>
     * Exemple : pour les métiers, on peut avoir les niveaux de regroupement
     * suivants : arts, grandes familles d’engins, …
     * </p>
     * <p>
     * </p>
     * <p>
     * Un niveau de regroupement peut avoir un niveau parent.
     * </p>
     * <p>
     * </p>
     * <p>
     * Un niveau de regroupement contient un ou plusieurs regroupements (<i>Grouping</i>).
     * </p>
     * </body>
     * </html>
     * @return this.groupingLevel GroupingLevel
     */
    public GroupingLevel getGroupingLevel()
    {
        return this.groupingLevel;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Niveau de regroupement, d'une classification donnée.
     * </p>
     * <p>
     * </p>
     * <p>
     * Exemple : pour les métiers, on peut avoir les niveaux de regroupement
     * suivants : arts, grandes familles d’engins, …
     * </p>
     * <p>
     * </p>
     * <p>
     * Un niveau de regroupement peut avoir un niveau parent.
     * </p>
     * <p>
     * </p>
     * <p>
     * Un niveau de regroupement contient un ou plusieurs regroupements (<i>Grouping</i>).
     * </p>
     * </body>
     * </html>
     * @param groupingLevelIn GroupingLevel
     */
    public void setGroupingLevel(GroupingLevel groupingLevelIn)
    {
        this.groupingLevel = groupingLevelIn;
    }

    private Status status;

    /**
     * Etat de saisie (actif/Inactif) du regroupement.
     * @return this.status Status
     */
    public Status getStatus()
    {
        return this.status;
    }

    /**
     * Etat de saisie (actif/Inactif) du regroupement.
     * @param statusIn Status
     */
    public void setStatus(Status statusIn)
    {
        this.status = statusIn;
    }

    /**
     * Returns <code>true</code> if the argument is an Grouping instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Grouping))
        {
            return false;
        }
        final Grouping that = (Grouping)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Grouping}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Grouping}.
         * @return new GroupingImpl()
         */
        public static Grouping newInstance()
        {
            return new GroupingImpl();
        }

        /**
         * Constructs a new instance of {@link Grouping}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param label String
         * @param name String
         * @param groupingClassification GroupingClassification
         * @param groupingLevel GroupingLevel
         * @param status Status
         * @return newInstance
         */
        public static Grouping newInstance(String label, String name, GroupingClassification groupingClassification, GroupingLevel groupingLevel, Status status)
        {
            final Grouping entity = new GroupingImpl();
            entity.setLabel(label);
            entity.setName(name);
            entity.setGroupingClassification(groupingClassification);
            entity.setGroupingLevel(groupingLevel);
            entity.setStatus(status);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Grouping}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param label String
         * @param name String
         * @param minValue Double
         * @param maxValue Double
         * @param updateDate Timestamp
         * @param groupings Collection<Grouping>
         * @param parentGrouping Grouping
         * @param groupingItems Collection<GroupingItem>
         * @param groupingClassification GroupingClassification
         * @param groupingLevel GroupingLevel
         * @param status Status
         * @return newInstance Grouping
         */
        public static Grouping newInstance(String label, String name, Double minValue, Double maxValue, Timestamp updateDate, Collection<Grouping> groupings, Grouping parentGrouping, Collection<GroupingItem> groupingItems, GroupingClassification groupingClassification, GroupingLevel groupingLevel, Status status)
        {
            final Grouping entity = new GroupingImpl();
            entity.setLabel(label);
            entity.setName(name);
            entity.setMinValue(minValue);
            entity.setMaxValue(maxValue);
            entity.setUpdateDate(updateDate);
            entity.setGroupings(groupings);
            entity.setParentGrouping(parentGrouping);
            entity.setGroupingItems(groupingItems);
            entity.setGroupingClassification(groupingClassification);
            entity.setGroupingLevel(groupingLevel);
            entity.setStatus(status);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Grouping o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getLabel() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getLabel().compareTo(o.getLabel()));
            }
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getMinValue() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getMinValue().compareTo(o.getMinValue()));
            }
            if (this.getMaxValue() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getMaxValue().compareTo(o.getMaxValue()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Grouping.java merge-point
}