/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.application.swing.table;

import javax.swing.AbstractAction;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import org.nuiton.jaxx.application.swing.util.ApplicationUIUtil;

public abstract class AbstractSelectTableAction<M extends AbstractApplicationTableModel>
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractSelectTableAction.class);
    private final M model;
    private final JTable table;

    public AbstractSelectTableAction(M model, JTable table) {
        this.model = model;
        this.table = table;
    }

    protected void doSelectCell(int rowIndex, int columnIndex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will select cell at " + this.getCellCoordinate(rowIndex, columnIndex)));
        }
        ApplicationUIUtil.doSelectCell(this.table, rowIndex, columnIndex);
    }

    protected int getSelectedRow() {
        int result = this.table.getSelectedRow();
        return result;
    }

    protected int getSelectedColumn() {
        int result = this.table.getSelectedColumn();
        return result;
    }

    protected int getRowCount() {
        return this.table.getRowCount();
    }

    protected int getColumnCount() {
        return this.table.getColumnCount();
    }

    protected boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean result = rowIndex > -1 && columnIndex > -1 && this.table.isCellEditable(rowIndex, columnIndex);
        return result;
    }

    protected boolean isCreateNewRow() {
        return ((AbstractApplicationTableModel)this.model).isCreateNewRow();
    }

    protected String getCellCoordinate(int rowIndex, int columnIndex) {
        return " [" + rowIndex + ", " + columnIndex + "]";
    }

    protected void addNewRow() {
        ((AbstractApplicationTableModel)this.model).addNewRow();
    }
}

