/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.referential.ImportRequestResult;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.SpeciesModel;
import fr.ifremer.tutti.service.referential.SpeciesRow;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ReferentialTemporarySpeciesService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ReferentialTemporarySpeciesService.class);
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
    }

    public ReferentialImportResult<Species> importTemporarySpecies(File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import species from file: " + file));
        }
        List<Species> allSpecies = this.persistenceService.getAllSpecies();
        ImportRequestResult<Species, Integer> requestResult = this.processImportFile(file, allSpecies);
        ReferentialImportResult<Species> result = new ReferentialImportResult<Species>();
        if (requestResult.withEntitiesToDelete()) {
            Collection<Integer> idsToDelete = requestResult.getIdsToDelete();
            this.persistenceService.deleteTemporarySpecies(idsToDelete);
            result.setNbRefDeleted(idsToDelete.size());
        }
        if (requestResult.withEntitiesToAdd()) {
            Collection<Species> entitiesToAdd = requestResult.getEntitiesToAdd();
            Collection<Species> entitiesAdded = this.persistenceService.importTemporarySpecies(entitiesToAdd);
            result.addAllRefsAdded(entitiesAdded);
        }
        if (requestResult.withEntitiesToUpdate()) {
            Collection<Species> entitiesToUpdate = requestResult.getEntitiesToUpdate();
            Collection<Species> entitiesUpdated = this.persistenceService.importTemporarySpecies(entitiesToUpdate);
            result.addAllRefsUpdated(entitiesUpdated);
        }
        return result;
    }

    public void exportExistingTemporarySpecies(File file) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Getting all species from database");
        }
        ArrayList targetList = Lists.newArrayList(this.persistenceService.getAllReferentSpecies());
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + targetList.size() + " species"));
        }
        List<Species> toExport = this.persistenceService.retainTemporarySpeciesList(targetList);
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + toExport.size() + " temporary species"));
        }
        this.exportTemporarySpecies(file, toExport);
    }

    public void exportTemporarySpeciesExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Species s = Speciess.newSpecies();
        s.setName("Temporary Species name 1");
        toExport.add(s);
        s = Speciess.newSpecies();
        s.setName("Temporary Species name 2");
        toExport.add(s);
        s = Speciess.newSpecies();
        s.setName("Temporary Species name 3");
        toExport.add(s);
        this.exportTemporarySpecies(file, toExport);
    }

    protected ImportRequestResult<Species, Integer> processImportFile(File file, List<Species> existingEntities) {
        ImportRequestResult<Species, Integer> requestResult = new ImportRequestResult<Species, Integer>(existingEntities, TuttiEntities.newIdAstIntFunction(), Speciess.GET_NAME);
        try (BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);){
            SpeciesModel csvModel = new SpeciesModel(this.getCsvSeparator());
            try (Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
                for (SpeciesRow bean : importer) {
                    this.importSpecies(bean, requestResult);
                }
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.import.species.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, (Throwable)e);
        }
        return requestResult;
    }

    protected void exportTemporarySpecies(File file, List<Species> toExport) throws IOException {
        SpeciesModel csvModel = new SpeciesModel(this.getCsvSeparator());
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        List toExportRows = Lists.transform(toExport, (Function)new Function<Species, SpeciesRow>(){

            public SpeciesRow apply(Species species) {
                return new SpeciesRow(species);
            }
        });
        try {
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)toExportRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.export.species.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected void importSpecies(SpeciesRow bean, ImportRequestResult<Species, Integer> requestResult) {
        Integer id = bean.getIdAsInt();
        String name = bean.getName();
        boolean delete = BooleanUtils.isTrue((Boolean)bean.getToDelete());
        if (id == null) {
            if (delete) {
                throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.species.cannotDeleteWithoutId.error", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.species.add.noName.error", (Object[])new Object[0]));
            }
            if (!requestResult.addExistingNaturalId(name)) {
                throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.species.existingName.error", (Object[])new Object[]{name}));
            }
            requestResult.addEntityToAdd(bean.toEntity(null));
        } else {
            Species species = requestResult.getExistingEntityById(id);
            if (species == null) {
                throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.species.notExistingId.error", (Object[])new Object[]{id}));
            }
            Integer referenceTaxonId = species.getReferenceTaxonId();
            if (delete) {
                if (this.persistenceService.isTemporarySpeciesUsed(referenceTaxonId)) {
                    String speciesRef = id + " : " + this.decoratorService.getDecoratorByType(Species.class, "withSurveyCode").toString((Object)species);
                    throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.species.used.error", (Object[])new Object[]{speciesRef}));
                }
                requestResult.addIdToDelete(referenceTaxonId);
                requestResult.removeExistingNaturalId(name);
            } else {
                if (StringUtils.isBlank((CharSequence)name)) {
                    throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.species.noName.error", (Object[])new Object[]{id}));
                }
                if (!species.getName().equals(name) && !requestResult.addExistingNaturalId(name)) {
                    throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.species.existingName.error", (Object[])new Object[]{name}));
                }
                requestResult.addEntityToUpdate(bean.toEntity(referenceTaxonId));
            }
        }
    }

    protected char getCsvSeparator() {
        return this.context.getConfig().getCsvSeparator();
    }
}

