/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentId;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.administration.user.PersonExtendDao;
import fr.ifremer.adagio.core.dao.administration.user.UserProfilId;
import fr.ifremer.adagio.core.dao.data.vessel.VesselExtendDao;
import fr.ifremer.adagio.core.dao.referential.StatusCode;
import fr.ifremer.adagio.core.dao.referential.StatusDao;
import fr.ifremer.adagio.core.dao.referential.VesselTypeId;
import fr.ifremer.adagio.core.dao.referential.gear.FishingGear;
import fr.ifremer.adagio.core.dao.referential.gear.FishingGearExtendDao;
import fr.ifremer.adagio.core.dao.referential.gear.GearClassification;
import fr.ifremer.adagio.core.dao.referential.gear.GearClassificationId;
import fr.ifremer.adagio.core.dao.referential.location.LocationClassificationId;
import fr.ifremer.adagio.core.dao.referential.location.LocationExtendDao;
import fr.ifremer.adagio.core.dao.referential.location.LocationLabel;
import fr.ifremer.adagio.core.dao.referential.location.LocationLevelId;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId2;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueId;
import fr.ifremer.adagio.core.dao.referential.pmfm.UnitId;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameExtendDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonRefVO;
import fr.ifremer.adagio.core.dao.referential.transcribing.TranscribingItemTypeId;
import fr.ifremer.adagio.core.service.technical.CacheService;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValues;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristics;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Gears;
import fr.ifremer.tutti.persistence.entities.referential.ObjectType;
import fr.ifremer.tutti.persistence.entities.referential.ObjectTypes;
import fr.ifremer.tutti.persistence.entities.referential.Persons;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.persistence.entities.referential.Status;
import fr.ifremer.tutti.persistence.entities.referential.Statuss;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocations;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Vessels;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.type.DateType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.springframework.cache.Cache;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Service;

@Service(value="referentialPersistenceService")
public class ReferentialPersistenceServiceImpl
extends AbstractPersistenceService
implements ReferentialPersistenceService {
    private static final Log log = LogFactory.getLog(ReferentialPersistenceServiceImpl.class);
    @Resource(name="taxonNameDao")
    protected TaxonNameExtendDao taxonNameDao;
    @Resource(name="statusDao")
    protected StatusDao statusDao;
    @Resource(name="personDao")
    protected PersonExtendDao personDao;
    @Resource(name="fishingGearDao")
    protected FishingGearExtendDao fishingGearDao;
    @Resource(name="vesselExtendDao")
    protected VesselExtendDao vesselExtendDao;
    @Resource(name="locationDao")
    protected LocationExtendDao locationDao;
    @Resource(name="cacheService")
    protected CacheService cacheService;
    @Resource(name="referentialPersistenceService")
    protected ReferentialPersistenceService thisService;
    protected Predicate<SpeciesAbleBatch> batchVracPredicate;
    protected Set<Integer> propertedPmfmIds;

    @Override
    public void init() {
        super.init();
        this.batchVracPredicate = SpeciesAbleBatchs.newSpeciesAbleBatchCategoryPredicate(PmfmId2.SORTED_UNSORTED.getValue(), QualitativeValueId.SORTED_VRAC.getValue());
        this.propertedPmfmIds = Sets.newHashSet((Object[])new Integer[]{PmfmId2.MULTIRIG_AGGREGATION.getValue(), PmfmId2.MULTIRIG_NUMBER.getValue(), PmfmId2.STATION_NUMBER.getValue(), PmfmId2.RECTILINEAR_OPERATION.getValue(), PmfmId2.HAUL_VALID.getValue(), PmfmId2.TRAWL_DISTANCE.getValue(), PmfmId2.SURVEY_PART.getValue(), PmfmId2.SORTED_UNSORTED.getValue(), PmfmId2.ID_PSFM.getValue()});
    }

    protected boolean isProtectedCaracteristic(Integer pmfmId) {
        return this.propertedPmfmIds.contains(pmfmId);
    }

    @Override
    public List<TuttiLocation> getAllProgramZone() {
        Iterator<Object[]> list = this.queryListWithStatus("allLocationsByLevelAndClassificiation", "locationClassificationId", IntegerType.INSTANCE, LocationClassificationId.SECTOR.getValue(), "locationLevelId", IntegerType.INSTANCE, LocationLevelId.SCIENTIFIC_CRUISE_PROGRAM.getValue());
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            TuttiLocation target = this.loadLocation(source);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllCountry() {
        Iterator<Object[]> list = this.queryListWithStatus("allLocationsByLevelAndClassificiation", "locationClassificationId", IntegerType.INSTANCE, LocationClassificationId.TERRITORIAL.getValue(), "locationLevelId", IntegerType.INSTANCE, LocationLevelId.PAYS_ISO3.getValue());
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            TuttiLocation target = this.loadLocation(source);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllHarbour() {
        Iterator<Object[]> list = this.queryListWithStatus("allLocationsByLevelAndClassificiation", "locationClassificationId", IntegerType.INSTANCE, LocationClassificationId.TERRITORIAL.getValue(), "locationLevelId", IntegerType.INSTANCE, LocationLevelId.PORT.getValue());
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            TuttiLocation target = this.loadLocation(source);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationStrata(String zoneId) {
        Preconditions.checkNotNull((Object)zoneId);
        List<TuttiLocation> result = this.getFishingOperationLocationsByParent(LocationLevelId.SCIENTIFIC_CRUISE_STRATA.getValue(), Integer.valueOf(zoneId), LocationLevelId.SCIENTIFIC_CRUISE_PROGRAM.getValue());
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationSubStrata(String zoneId, String strataId) {
        Integer parentLocationLevelId;
        String parentId;
        if (strataId != null) {
            parentId = strataId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_STRATA.getValue();
        } else {
            parentId = zoneId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_PROGRAM.getValue();
        }
        Preconditions.checkNotNull((Object)parentId);
        List<TuttiLocation> result = this.getFishingOperationLocationsByParent(LocationLevelId.SCIENTIFIC_CRUISE_SUB_STRATA.getValue(), Integer.valueOf(parentId), parentLocationLevelId);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationLocation(String zoneId, String strataId, String subStrataId) {
        Integer parentLocationLevelId;
        String parentId;
        if (subStrataId != null) {
            parentId = subStrataId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_SUB_STRATA.getValue();
        } else if (strataId != null) {
            parentId = strataId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_STRATA.getValue();
        } else {
            parentId = zoneId;
            parentLocationLevelId = LocationLevelId.SCIENTIFIC_CRUISE_PROGRAM.getValue();
        }
        Preconditions.checkNotNull((Object)parentId);
        List<TuttiLocation> result = this.getFishingOperationLocationsByParent(LocationLevelId.SCIENTIFIC_CRUISE_LOCALITE.getValue(), Integer.valueOf(parentId), parentLocationLevelId);
        return Collections.unmodifiableList(result);
    }

    @Override
    public TuttiLocation getLocation(String id) {
        Object[] source = this.queryUnique("locationById", "locationId", IntegerType.INSTANCE, Integer.valueOf(id));
        if (source == null) {
            return null;
        }
        TuttiLocation target = this.loadLocation(source);
        return target;
    }

    @Override
    public List<Vessel> getAllScientificVessel() {
        Iterator<Object[]> list = this.queryListWithStatus("allVessels", "refDate", DateType.INSTANCE, new Date(), "vesselTypeId", IntegerType.INSTANCE, VesselTypeId.SCIENTIFIC_RESEARCH_VESSEL.getValue());
        ArrayList result = Lists.newArrayList();
        Cache vesselByCodeCache = this.cacheService.getCache("vesselByCode");
        while (list.hasNext()) {
            Object[] source = list.next();
            Vessel target = this.loadVessel(source, true);
            result.add(target);
            vesselByCodeCache.put((Object)target.getId(), (Object)target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Vessel> getAllFishingVessel() {
        Iterator<Object[]> list = this.queryListWithStatus("allVessels", "refDate", DateType.INSTANCE, new Date(), "vesselTypeId", IntegerType.INSTANCE, VesselTypeId.FISHING_VESSEL.getValue());
        ArrayList result = Lists.newArrayList();
        Cache vesselByCodeCache = this.cacheService.getCache("vesselByCode");
        while (list.hasNext()) {
            Object[] source = list.next();
            Vessel target = this.loadVessel(source, true);
            target.setScientificVessel(false);
            result.add(target);
            vesselByCodeCache.put((Object)target.getId(), (Object)target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Vessel getVessel(String vesselCode) {
        Iterator<Object[]> source;
        if (log.isDebugEnabled()) {
            log.debug((Object)("get vessel: " + vesselCode));
        }
        Vessel result = (source = this.queryListWithStatus("vessel", "vesselCode", StringType.INSTANCE, vesselCode, "refDate", DateType.INSTANCE, new Date())).hasNext() ? this.loadVessel(source.next(), false) : null;
        return result;
    }

    @Override
    public List<Gear> getAllScientificGear() {
        Iterator<Object[]> sources = this.queryListWithStatus("allGears", "gearClassificiationId", IntegerType.INSTANCE, GearClassificationId.SCIENTIFIC_CRUISE.getValue());
        ArrayList result = Lists.newArrayList();
        while (sources.hasNext()) {
            Object[] source = sources.next();
            Gear target = this.loadGear(source);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Gear> getAllFishingGear() {
        Iterator<Object[]> sources = this.queryListWithStatus("allGears", "gearClassificiationId", IntegerType.INSTANCE, GearClassificationId.FAO.getValue());
        ArrayList result = Lists.newArrayList();
        while (sources.hasNext()) {
            Object[] source = sources.next();
            Gear target = this.loadGear(source);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<fr.ifremer.tutti.persistence.entities.referential.Person> getAllPerson() {
        Iterator<Object[]> list = this.queryListWithStatus("allPersons", "observerProfilId", IntegerType.INSTANCE, UserProfilId.OBSERVER.getValue(), "projectMemberProfilId", IntegerType.INSTANCE, UserProfilId.PROJECT_MEMBER.getValue(), "userProfilId", IntegerType.INSTANCE, UserProfilId.USER.getValue(), "departementPrefixCode", StringType.INSTANCE, "PDG-");
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            fr.ifremer.tutti.persistence.entities.referential.Person target = this.loadPerson(source);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public fr.ifremer.tutti.persistence.entities.referential.Person getPerson(Integer personId) {
        Object[] source = this.queryUnique("person", "personId", IntegerType.INSTANCE, personId);
        fr.ifremer.tutti.persistence.entities.referential.Person result = source == null ? null : this.loadPerson(source);
        return result;
    }

    @Override
    public Gear getGear(Integer gearId) {
        Object[] source = this.queryUnique("gear", "gearId", IntegerType.INSTANCE, gearId);
        Gear result = source == null ? null : this.loadGear(source);
        return result;
    }

    @Override
    public List<Species> getAllSpecies() {
        TaxonRefVO[] sources = this.taxonNameDao.getAllTaxonNames(true, TranscribingItemTypeId.TAXON_NAME_REFTAX_CODE.getValue());
        ArrayList result = Lists.newArrayListWithCapacity((int)sources.length);
        ArrayList referenceTaxonsOnly = Lists.newArrayList();
        Cache referentSpeciesByIdCache = this.cacheService.getCache("referentSpeciesById");
        for (TaxonRefVO source : sources) {
            Species target = this.loadSpecies(source);
            target.setRefTaxCode(StringUtils.trim((String)target.getExternalCode()));
            if (target.isReferenceTaxon()) {
                referentSpeciesByIdCache.put((Object)target.getReferenceTaxonId(), (Object)target);
                referenceTaxonsOnly.add(target);
            }
            result.add(target);
        }
        Cache allReferentSpeciesCache = this.cacheService.getCache("referentSpecies");
        allReferentSpeciesCache.put((Object)"", (Object)referenceTaxonsOnly);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Species> getAllReferentSpecies() {
        TaxonRefVO[] sources = this.taxonNameDao.getAllTaxonNames(false, TranscribingItemTypeId.TAXON_NAME_REFTAX_CODE.getValue());
        ArrayList result = Lists.newArrayListWithCapacity((int)sources.length);
        Cache referentSpeciesByIdCache = this.cacheService.getCache("referentSpeciesById");
        for (TaxonRefVO source : sources) {
            Species target = this.loadSpecies(source);
            target.setRefTaxCode(StringUtils.trim((String)target.getExternalCode()));
            referentSpeciesByIdCache.put((Object)target.getReferenceTaxonId(), (Object)target);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Species getSpeciesByReferenceTaxonId(Integer referenceTaxonId) {
        Species result = this.getSpeciesByReferenceTaxonId(referenceTaxonId, TranscribingItemTypeId.TAXON_NAME_REFTAX_CODE.getValue());
        if (result != null) {
            result.setRefTaxCode(result.getExternalCode());
        }
        return result;
    }

    @Override
    public Species getSpeciesByReferenceTaxonIdWithVernacularCode(Integer referenceTaxonId) {
        Species result = this.getSpeciesByReferenceTaxonId(referenceTaxonId, TranscribingItemTypeId.TAXON_NAME_LOCAL_NAME.getValue());
        if (result != null) {
            result.setVernacularCode(result.getExternalCode());
        }
        return result;
    }

    protected Species getSpeciesByReferenceTaxonId(Integer referenceTaxonId, Integer transcribingTypeId) {
        Species target;
        try {
            TaxonRefVO source = this.taxonNameDao.getTaxonNameReferent(referenceTaxonId, transcribingTypeId);
            target = this.loadSpecies(source);
        }
        catch (DataRetrievalFailureException drfe) {
            target = null;
        }
        return target;
    }

    @Override
    public List<Caracteristic> getAllCaracteristic() {
        return this.getAllCaracteristics(false);
    }

    @Override
    public List<Caracteristic> getAllCaracteristicWithProtected() {
        return this.getAllCaracteristics(true);
    }

    @Override
    public List<Caracteristic> getAllCaracteristicForSampleCategory() {
        List<Caracteristic> allCaracteristicWithProtected = this.thisService.getAllCaracteristicWithProtected();
        ArrayList result = Lists.newArrayList((Iterable)Iterables.filter(allCaracteristicWithProtected, Caracteristics.newSampleCategoryModelPredicate()));
        return result;
    }

    protected List<Caracteristic> getAllCaracteristics(boolean withProtected) {
        Iterator<Object[]> sources = this.queryListWithStatus("allPmfm", "unitIdNone", IntegerType.INSTANCE, UnitId.NONE.getValue());
        ArrayList result = Lists.newArrayList();
        Cache pmfmByIdCache = this.cacheService.getCache("pmfmById");
        while (sources.hasNext()) {
            Object[] source = sources.next();
            Integer pmfmId = (Integer)source[0];
            Caracteristic target = this.loadCaracteristic(source);
            if (withProtected || !this.isProtectedCaracteristic(pmfmId)) {
                result.add(target);
            }
            pmfmByIdCache.put((Object)pmfmId, (Object)target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<ObjectType> getAllObjectType() {
        Iterator<Object[]> sources = this.queryList("allObjectType", new Object[0]);
        ArrayList result = Lists.newArrayList();
        Cache cache = this.cacheService.getCache("objectTypeByCode");
        while (sources.hasNext()) {
            Object[] source = sources.next();
            String code = (String)source[0];
            ObjectType target = this.loadObjectType(source);
            cache.put((Object)code, (Object)target);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public ObjectType getObjectType(String objectTypeCode) {
        Object[] source = this.queryUnique("objectType", "objectTypeCode", StringType.INSTANCE, objectTypeCode);
        ObjectType target = this.loadObjectType(source);
        return target;
    }

    @Override
    public List<Caracteristic> getAllNumericCaracteristic() {
        ArrayList result = Lists.newArrayList();
        for (Caracteristic caracteristic : this.getAllCaracteristic()) {
            if (!caracteristic.isNumericType()) continue;
            result.add(caracteristic);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Caracteristic getSizeCategoryCaracteristic() {
        Integer pmfmId = PmfmId2.SIZE_CATEGORY.getValue();
        Caracteristic result = this.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getSexCaracteristic() {
        Integer pmfmId = PmfmId2.SEX.getValue();
        Caracteristic result = this.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getSortedUnsortedCaracteristic() {
        Integer pmfmId = PmfmId2.SORTED_UNSORTED.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        ArrayList qualitativeValue = Lists.newArrayList(result.getQualitativeValue());
        Iterator iterator = qualitativeValue.iterator();
        while (iterator.hasNext()) {
            CaracteristicQualitativeValue qv = (CaracteristicQualitativeValue)iterator.next();
            if (!QualitativeValueId.UNSORTED.getValue().equals(Integer.valueOf(qv.getId()))) continue;
            iterator.remove();
            break;
        }
        result.setQualitativeValue(Collections.unmodifiableList(qualitativeValue));
        return result;
    }

    @Override
    public Caracteristic getMaturityCaracteristic() {
        Integer pmfmId = PmfmId2.MATURITY.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getAgeCaracteristic() {
        Integer pmfmId = PmfmId2.AGE.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getMarineLitterCategoryCaracteristic() {
        Integer pmfmId = PmfmId2.MARINE_LITTER_TYPE.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getMarineLitterSizeCategoryCaracteristic() {
        Integer pmfmId = PmfmId2.MARINE_LITTER_SIZE_CATEGORY.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getVerticalOpeningCaracteristic() {
        Integer pmfmId = PmfmId2.VERTICAL_OPENING.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getHorizontalOpeningWingsCaracteristic() {
        Integer pmfmId = PmfmId2.HORIZONTAL_OPENING_WINGS.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getHorizontalOpeningDoorCaracteristic() {
        Integer pmfmId = PmfmId2.HORIZONTAL_OPENING_DOOR.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getDeadOrAliveCaracteristic() {
        Integer pmfmId = PmfmId2.DEAD_OR_ALIVE.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getPmfmIdCaracteristic() {
        Integer pmfmId = PmfmId2.ID_PSFM.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public Caracteristic getWeightMeasuredCaracteristic() {
        Integer pmfmId = PmfmId2.WEIGHT_MEASURED.getValue();
        Caracteristic result = this.thisService.getCaracteristic(pmfmId);
        return result;
    }

    @Override
    public boolean isTemporary(TuttiReferentialEntity entity) {
        Preconditions.checkNotNull((Object)entity);
        Preconditions.checkNotNull((Object)entity.getStatus());
        return StatusCode.TEMPORARY.getValue().equals(entity.getStatus().getId());
    }

    @Override
    public Caracteristic getCaracteristic(Integer pmfmId) {
        Object[] source = this.queryUniqueWithStatus("pmfmById", "pmfmId", IntegerType.INSTANCE, pmfmId, "unitIdNone", IntegerType.INSTANCE, UnitId.NONE.getValue());
        Caracteristic target = this.loadCaracteristic(source);
        return target;
    }

    @Override
    public boolean isVracBatch(SpeciesAbleBatch speciesBatch) {
        return this.batchVracPredicate.apply((Object)speciesBatch);
    }

    @Override
    public boolean isHorsVracBatch(SpeciesAbleBatch speciesBatch) {
        return !this.batchVracPredicate.apply((Object)speciesBatch);
    }

    @Override
    public Predicate<SpeciesAbleBatch> getVracBatchPredicate() {
        return this.batchVracPredicate;
    }

    @Override
    public List<Species> importTemporarySpecies(List<Species> species) {
        ArrayList result = Lists.newArrayList();
        for (Species source : species) {
            source = this.importTemporarySpecies(source);
            result.add(source);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Vessel> importTemporaryVessel(List<Vessel> vessels) {
        ArrayList result = Lists.newArrayList();
        fr.ifremer.adagio.core.dao.referential.Status status = this.statusDao.load(StatusCode.TEMPORARY.getValue());
        Integer countryLocationId = this.locationDao.getLocationIdByLabelAndLocationLevel(LocationLabel.FRANCE.getValue(), new Integer[]{LocationLevelId.PAYS_ISO3.getValue()});
        if (countryLocationId == null) {
            throw new DataIntegrityViolationException("Default country location not found, with label=" + LocationLabel.FRANCE.getValue());
        }
        for (Vessel source : vessels) {
            source = this.importTemporaryVessel(source, countryLocationId, status);
            result.add(source);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<fr.ifremer.tutti.persistence.entities.referential.Person> importTemporaryPerson(List<fr.ifremer.tutti.persistence.entities.referential.Person> persons) {
        ArrayList result = Lists.newArrayList();
        fr.ifremer.adagio.core.dao.referential.Status status = this.statusDao.load(StatusCode.TEMPORARY.getValue());
        for (fr.ifremer.tutti.persistence.entities.referential.Person source : persons) {
            source = this.importTemporaryPerson(source, status);
            result.add(source);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Gear> importTemporaryGear(List<Gear> gears) {
        ArrayList result = Lists.newArrayList();
        fr.ifremer.adagio.core.dao.referential.Status status = this.statusDao.load(StatusCode.TEMPORARY.getValue());
        for (Gear source : gears) {
            source = this.importTemporaryGear(source, status);
            result.add(source);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void replaceGear(Gear source, Gear target) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkState((boolean)this.isTemporary(source));
        Preconditions.checkState((!this.isTemporary(target) ? 1 : 0) != 0);
        Integer sourceId = source.getIdAsInt();
        Integer targetId = target.getIdAsInt();
        this.queryUpdate("replaceGearInGearPhysicalFeatures", "sourceId", IntegerType.INSTANCE, sourceId, "targetId", IntegerType.INSTANCE, targetId);
        this.queryUpdate("replaceGearInGearUseFeatures", "sourceId", IntegerType.INSTANCE, sourceId, "targetId", IntegerType.INSTANCE, targetId);
    }

    @Override
    public void replacePerson(fr.ifremer.tutti.persistence.entities.referential.Person source, fr.ifremer.tutti.persistence.entities.referential.Person target) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkState((boolean)this.isTemporary(source));
        Preconditions.checkState((!this.isTemporary(target) ? 1 : 0) != 0);
        Integer sourceId = source.getIdAsInt();
        Integer targetId = target.getIdAsInt();
        this.queryUpdate("replaceManagerPersonInScientificCruise", "sourceId", IntegerType.INSTANCE, sourceId, "targetId", IntegerType.INSTANCE, targetId);
        this.queryUpdate("replaceRecorderPersonInScientificCruise", "sourceId", IntegerType.INSTANCE, sourceId, "targetId", IntegerType.INSTANCE, targetId);
        this.queryUpdate("replaceRecorderPersonInFishingTrip", "sourceId", IntegerType.INSTANCE, sourceId, "targetId", IntegerType.INSTANCE, targetId);
        this.queryUpdate("replacePersonInVesselPersonFeatures", "sourceId", IntegerType.INSTANCE, sourceId, "targetId", IntegerType.INSTANCE, targetId);
        this.cacheService.clearAllCaches();
    }

    @Override
    public void replaceSpecies(Species source, Species target) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkState((boolean)this.isTemporary(source));
        Preconditions.checkState((!this.isTemporary(target) ? 1 : 0) != 0);
        Integer sourceId = source.getReferenceTaxonId();
        Integer targetId = target.getReferenceTaxonId();
        this.queryUpdate("replaceReferenceTaxonInSortingBatch", "sourceId", IntegerType.INSTANCE, sourceId, "targetId", IntegerType.INSTANCE, targetId);
        this.queryUpdate("replaceReferenceTaxonInSample", "sourceId", IntegerType.INSTANCE, sourceId, "targetId", IntegerType.INSTANCE, targetId);
    }

    @Override
    public void replaceVessel(Vessel source, Vessel target) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkState((boolean)this.isTemporary(source));
        Preconditions.checkState((!this.isTemporary(target) ? 1 : 0) != 0);
        String sourceId = source.getId();
        String targetId = target.getId();
        this.queryUpdate("replaceVesselInCruise", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        this.queryUpdate("replaceVesselInFishingOperation", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        this.queryUpdate("replaceVesselInOperationVesselAssociation", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        this.queryUpdate("replaceVesselInDailyActivityCalendar", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        this.queryUpdate("replaceVesselInLanding", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        this.queryUpdate("replaceVesselInFishingtrip", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        this.queryUpdate("replaceVesselInVesselUseFeatures", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        this.queryUpdate("replaceVesselInGearUseFeatures", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        this.queryUpdate("replaceVesselInGearPhysicalFeatures", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
    }

    public Vessel importTemporaryVessel(Vessel source, Integer registrationLocationId, fr.ifremer.adagio.core.dao.referential.Status status) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getName());
        Preconditions.checkNotNull((Object)source.getInternationalRegistrationCode());
        Integer vesselTypeId = source.isScientificVessel() ? VesselTypeId.SCIENTIFIC_RESEARCH_VESSEL.getValue() : VesselTypeId.FISHING_VESSEL.getValue();
        fr.ifremer.adagio.core.dao.data.vessel.Vessel target = this.vesselExtendDao.createAsTemporary(null, source.getInternationalRegistrationCode(), registrationLocationId, source.getName(), vesselTypeId, true);
        Vessel result = Vessels.newVessel();
        result.setId(target.getCode());
        result.setName(source.getName());
        result.setRegistrationCode(source.getRegistrationCode());
        result.setInternationalRegistrationCode(source.getInternationalRegistrationCode());
        result.setScientificVessel(source.isScientificVessel());
        this.setStatus(status, result);
        return result;
    }

    public fr.ifremer.tutti.persistence.entities.referential.Person importTemporaryPerson(fr.ifremer.tutti.persistence.entities.referential.Person source, fr.ifremer.adagio.core.dao.referential.Status status) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getFirstName());
        Preconditions.checkNotNull((Object)source.getLastName());
        Person target = this.personDao.createAsTemporary(source.getLastName(), source.getFirstName(), DepartmentId.UNKNOWN_RECORDER_DEPARTMENT.getValue());
        fr.ifremer.tutti.persistence.entities.referential.Person result = Persons.newPerson();
        result.setId(target.getId());
        result.setLastName(source.getLastName());
        result.setFirstName(source.getFirstName());
        this.setStatus(status, result);
        return result;
    }

    protected Species importTemporarySpecies(Species source) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getName());
        TaxonRefVO taxonName = new TaxonRefVO();
        taxonName.setName(source.getName());
        taxonName = this.taxonNameDao.createAsTemporary(taxonName, "Added by tutti (file import).");
        Species result = this.loadSpecies(taxonName);
        result.setRefTaxCode(result.getExternalCode());
        Cache cache = this.cacheService.getCache("referentSpeciesById");
        cache.put((Object)result.getIdAsInt(), (Object)result);
        return result;
    }

    public Gear importTemporaryGear(Gear source, fr.ifremer.adagio.core.dao.referential.Status status) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getLabel());
        Preconditions.checkNotNull((Object)source.getName());
        Integer gearClassificationId = source.isScientificGear() ? GearClassificationId.SCIENTIFIC_CRUISE.getValue() : GearClassificationId.FAO.getValue();
        FishingGear target = this.fishingGearDao.createAsTemporary(source.getLabel(), source.getName(), gearClassificationId);
        Gear result = Gears.newGear();
        result.setId(target.getId());
        result.setLabel(source.getLabel());
        result.setName(source.getName());
        result.setScientificGear(source.isScientificGear());
        this.setStatus(status, result);
        return result;
    }

    protected List<TuttiLocation> getFishingOperationLocationsByParent(Integer locationLevelId, Integer parentId, Integer parentLocationLevelId) {
        Iterator<Object[]> sources = this.queryListWithStatus("allFishingOperationLocationByParent", "parentId", IntegerType.INSTANCE, parentId, "parentLocationLevelId", IntegerType.INSTANCE, parentLocationLevelId, "locationClassificationId", IntegerType.INSTANCE, LocationClassificationId.SECTOR.getValue(), "locationLevelId", IntegerType.INSTANCE, locationLevelId);
        ArrayList result = Lists.newArrayList();
        while (sources.hasNext()) {
            Object[] source = sources.next();
            TuttiLocation target = this.loadLocation(source);
            result.add(target);
        }
        return result;
    }

    protected Caracteristic loadCaracteristic(Object[] source) {
        Integer pmfmId = (Integer)source[0];
        Caracteristic result = Caracteristics.newCaracteristic();
        result.setId(pmfmId);
        result.setParameterName((String)source[1]);
        result.setMatrixName((String)source[2]);
        result.setFractionName((String)source[3]);
        result.setMethodName((String)source[4]);
        CaracteristicType type = Caracteristics.getType((Boolean)source[5], (Boolean)source[6]);
        result.setCaracteristicType(type);
        result.setNumericType(Caracteristics.isNumberCaracteristic(result));
        result.setSignifFiguresNumber((Integer)source[7]);
        result.setMaximumNumberDecimals((Integer)source[8]);
        result.setPrecision((Float)source[9]);
        result.setUnit((String)source[10]);
        this.setStatus((fr.ifremer.adagio.core.dao.referential.Status)source[11], result);
        if (Caracteristics.isQualitativeCaracteristic(result)) {
            Iterator<Object[]> sources = this.queryListWithStatus("pmfmQualitativeValues", "pmfmId", IntegerType.INSTANCE, pmfmId);
            ArrayList values = Lists.newArrayList();
            while (sources.hasNext()) {
                Object[] source2 = sources.next();
                CaracteristicQualitativeValue target2 = CaracteristicQualitativeValues.newCaracteristicQualitativeValue();
                target2.setId(String.valueOf(source2[0]));
                target2.setName(String.valueOf(source2[1]));
                target2.setDescription(String.valueOf(source2[2]));
                this.setStatus((fr.ifremer.adagio.core.dao.referential.Status)source2[3], target2);
                values.add(target2);
            }
            result.setQualitativeValue(Collections.unmodifiableList(values));
        }
        return result;
    }

    protected ObjectType loadObjectType(Object[] source) {
        ObjectType result = ObjectTypes.newObjectType();
        result.setId((String)source[0]);
        result.setName((String)source[1]);
        result.setDescription((String)source[2]);
        return result;
    }

    protected Species loadSpecies(TaxonRefVO source) {
        Species target = Speciess.newSpecies();
        target.setId(source.getTaxonNameId());
        target.setName(source.getName());
        target.setExternalCode(source.getExternalCode());
        target.setReferenceTaxonId(source.getReferenceTaxonId());
        target.setReferenceTaxon(source.getIsReference());
        fr.ifremer.adagio.core.dao.referential.Status status = this.statusDao.load(source.getStatus().getValue());
        this.setStatus(status, target);
        return target;
    }

    protected Vessel loadVessel(Object[] source, boolean scientificVessel) {
        Vessel target = Vessels.newVessel();
        target.setId((String)source[0]);
        target.setRegistrationCode((String)source[1]);
        target.setInternationalRegistrationCode((String)source[2]);
        target.setName((String)source[3]);
        target.setScientificVessel(scientificVessel);
        this.setStatus((fr.ifremer.adagio.core.dao.referential.Status)source[4], target);
        return target;
    }

    protected fr.ifremer.tutti.persistence.entities.referential.Person loadPerson(Object[] source) {
        fr.ifremer.tutti.persistence.entities.referential.Person target = Persons.newPerson();
        target.setId(String.valueOf(source[0]));
        target.setLastName((String)source[1]);
        target.setFirstName((String)source[2]);
        target.setDepartment((String)source[3]);
        this.setStatus((fr.ifremer.adagio.core.dao.referential.Status)source[4], target);
        return target;
    }

    protected Gear loadGear(Object[] source) {
        Gear result = Gears.newGear();
        result.setId(String.valueOf(source[0]));
        result.setLabel((String)source[1]);
        result.setName((String)source[2]);
        GearClassification classification = (GearClassification)source[3];
        boolean scientific = false;
        if (classification != null) {
            scientific = classification.getId().equals(GearClassificationId.SCIENTIFIC_CRUISE.getValue());
        }
        result.setScientificGear(scientific);
        this.setStatus((fr.ifremer.adagio.core.dao.referential.Status)source[4], result);
        return result;
    }

    protected TuttiLocation loadLocation(Object[] source) {
        TuttiLocation target = TuttiLocations.newTuttiLocation();
        target.setId((Integer)source[0]);
        target.setLabel((String)source[1]);
        target.setName((String)source[2]);
        this.setStatus((fr.ifremer.adagio.core.dao.referential.Status)source[3], target);
        return target;
    }

    protected Iterator<Object[]> queryListWithStatus(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        query.setString("statusValidCode", StatusCode.ENABLE.getValue());
        query.setString("statusTemporaryCode", StatusCode.TEMPORARY.getValue());
        Iterator result = query.iterate();
        return result;
    }

    protected Object[] queryUniqueWithStatus(String queryName, Object ... params) {
        Query query = this.createQuery(queryName, params);
        query.setString("statusValidCode", StatusCode.ENABLE.getValue());
        query.setString("statusTemporaryCode", StatusCode.TEMPORARY.getValue());
        Object result = query.uniqueResult();
        return (Object[])result;
    }

    protected <E extends TuttiReferentialEntity> void setStatus(fr.ifremer.adagio.core.dao.referential.Status status, E entity) {
        Status newStatus = Statuss.newStatus();
        newStatus.setId(status.getCode());
        newStatus.setName(status.getName());
        entity.setStatus(newStatus);
    }
}

