/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.javascript;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.exception.CoreException;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.eclipse.birt.core.script.CoreJavaScriptWrapper;
import org.eclipse.birt.core.script.ICompiledScript;
import org.eclipse.birt.core.script.IJavascriptWrapper;
import org.eclipse.birt.core.script.IScriptEngine;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionContext;
import org.eclipse.birt.data.engine.api.IDataScriptEngine;
import org.eclipse.birt.report.engine.javascript.CompiledJavascript;
import org.eclipse.birt.report.engine.javascript.JavascriptContext;
import org.eclipse.birt.report.engine.javascript.JavascriptEngineFactory;
import org.eclipse.birt.report.engine.javascript.ScriptUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.WrapFactory;

public class JavascriptEngine
implements IScriptEngine,
IDataScriptEngine {
    protected static Logger logger = Logger.getLogger(JavascriptEngine.class.getName());
    private static Script cachedScript;
    protected Context context;
    protected ImporterTopLevel global;
    protected ScriptableObject root;
    private Map<String, Object> propertyMap = new HashMap<String, Object>();
    private JavascriptEngineFactory factory;

    static {
        try {
            Context context = Context.enter();
            cachedScript = context.compileString("function writeStatus(msg) { _statusHandle.showStatus(msg); }", "<inline>", 1, null);
            Context.exit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JavascriptEngine(JavascriptEngineFactory factory, ScriptableObject root) throws BirtException {
        this.factory = factory;
        try {
            this.context = Context.enter();
            this.global = new ImporterTopLevel();
            this.root = root;
            if (root != null) {
                new LazilyLoadedCtor((ScriptableObject)this.global, "Packages", "org.mozilla.javascript.NativeJavaTopPackage", false);
                this.global.exportAsJSClass(3, (Scriptable)this.global, false);
                this.global.delete("constructor");
                this.global.setPrototype((Scriptable)root);
            } else {
                this.global.initStandardObjects(this.context, true);
            }
            if (this.global.get("org.eclipse.birt.core.script.functionservice.context.functionBean", (Scriptable)this.global) == UniqueTag.NOT_FOUND) {
                IScriptFunctionContext functionContext = new IScriptFunctionContext(){

                    @Override
                    public Object findProperty(String name) {
                        return JavascriptEngine.this.propertyMap.get(name);
                    }
                };
                Object sObj = Context.javaToJS((Object)functionContext, (Scriptable)this.global);
                this.global.put("org.eclipse.birt.core.script.functionservice.context.functionBean", (Scriptable)this.global, sObj);
            }
            this.initWrapFactory();
        }
        catch (Exception exception) {
            Context.exit();
            throw new BirtException();
        }
    }

    private void initWrapFactory() {
        WrapFactory wrapFactory = new WrapFactory(){
            protected IJavascriptWrapper coreWrapper = new CoreJavaScriptWrapper();

            public Object wrap(Context cx, Scriptable scope, Object obj, Class staticType) {
                Object object = this.coreWrapper.wrap(cx, scope, obj, staticType);
                if (object != obj) {
                    return object;
                }
                return super.wrap(cx, scope, obj, staticType);
            }
        };
        this.context.setWrapFactory(wrapFactory);
        new CoreJavaScriptInitializer().initialize(this.context, (Scriptable)this.global);
    }

    @Override
    public void setTimeZone(TimeZone zone) {
        this.propertyMap.put("org.eclipse.birt.core.script.functionservice.context.timeZone", zone);
    }

    @Override
    public void setLocale(Locale locale) {
        this.context.setLocale(locale);
        this.propertyMap.put("org.eclipse.birt.core.script.functionservice.context.locale", ULocale.forLocale((Locale)locale));
    }

    @Override
    public String getScriptLanguage() {
        return JavascriptEngineFactory.SCRIPT_JAVASCRIPT;
    }

    @Override
    public void close() {
        if (this.root != null) {
            this.factory.releaseRootScope(this.root);
            this.root = null;
        }
        if (this.context != null) {
            Context.exit();
            this.context = null;
        }
    }

    private Scriptable createJsScope(Scriptable parent, Object object) {
        NativeObject jsScope = null;
        if (object != null && !(object instanceof Scriptable)) {
            object = this.javaToJs(parent, object);
        }
        if (object instanceof Scriptable) {
            jsScope = new NativeObject();
            jsScope.setPrototype((Scriptable)object);
        } else {
            jsScope = this.context.newObject(parent);
        }
        jsScope.setParentScope(parent);
        return jsScope;
    }

    @Override
    public JavascriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public CompiledJavascript compile(ScriptContext scriptContext, final String id, final int lineNumber, final String script) throws BirtException {
        Script scriptObject = AccessController.doPrivileged(new PrivilegedAction<Script>(){

            @Override
            public Script run() {
                return JavascriptEngine.this.context.compileString(script, id, lineNumber, ScriptUtil.getSecurityDomain(id));
            }
        });
        return new CompiledJavascript(id, lineNumber, script, scriptObject);
    }

    private JavascriptContext createJsContext(ScriptContext context) {
        ScriptContext parent = context.getParent();
        ImporterTopLevel parentJsScope = this.global;
        if (parent != null) {
            JavascriptContext parentJsContext = (JavascriptContext)parent.getScriptContext(JavascriptEngineFactory.SCRIPT_JAVASCRIPT);
            if (parentJsContext == null) {
                parentJsContext = this.createJsContext(parent);
            }
            parentJsScope = parentJsContext.getScope();
        }
        Object scope = context.getScopeObject();
        Scriptable jsScope = this.createJsScope((Scriptable)parentJsScope, scope);
        JavascriptContext jsContext = new JavascriptContext(context, jsScope);
        if (parent == null) {
            cachedScript.exec(this.context, jsScope);
        }
        Map<String, Object> attrs = context.getAttributes();
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            jsContext.setAttribute(entry.getKey(), entry.getValue());
        }
        context.setScriptContext(JavascriptEngineFactory.SCRIPT_JAVASCRIPT, jsContext);
        return jsContext;
    }

    @Override
    public Object evaluate(ScriptContext scriptContext, ICompiledScript compiledScript) throws BirtException {
        assert (compiledScript instanceof CompiledJavascript);
        String source = ((CompiledJavascript)compiledScript).getScriptText();
        try {
            Script script = ((CompiledJavascript)compiledScript).getCompiledScript();
            Object value = script.exec(this.context, this.getJSScope(scriptContext));
            return this.jsToJava(value);
        }
        catch (Throwable e) {
            throw new CoreException("birt.core.JavascriptCommonError", new Object[]{source, e.getMessage()}, e);
        }
    }

    private Object javaToJs(Scriptable scope, Object value) {
        return Context.javaToJS((Object)value, (Scriptable)scope);
    }

    public Object jsToJava(Object jsValue) {
        return JavascriptEvalUtil.convertJavascriptValue(jsValue);
    }

    @Override
    public void setApplicationClassLoader(final ClassLoader appLoader) {
        if (appLoader == null) {
            return;
        }
        ClassLoader loader = appLoader;
        try {
            appLoader.loadClass("org.mozilla.javascript.Context");
        }
        catch (ClassNotFoundException classNotFoundException) {
            loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return new RhinoClassLoaderDecoration(appLoader, JavascriptEngine.class.getClassLoader());
                }
            });
        }
        this.context.setApplicationClassLoader(loader);
    }

    @Override
    public Context getJSContext(ScriptContext scriptContext) {
        return this.context;
    }

    @Override
    public Scriptable getJSScope(ScriptContext scriptContext) {
        JavascriptContext jsContext = (JavascriptContext)scriptContext.getScriptContext(JavascriptEngineFactory.SCRIPT_JAVASCRIPT);
        if (jsContext == null) {
            jsContext = this.createJsContext(scriptContext);
        }
        return jsContext.getScope();
    }

    private static class RhinoClassLoaderDecoration
    extends ClassLoader {
        private ClassLoader applicationClassLoader;
        private ClassLoader rhinoClassLoader;

        public RhinoClassLoaderDecoration(ClassLoader applicationClassLoader, ClassLoader rhinoClassLoader) {
            this.applicationClassLoader = applicationClassLoader;
            this.rhinoClassLoader = rhinoClassLoader;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return this.applicationClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.rhinoClassLoader.loadClass(name);
            }
        }
    }
}

