/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;

public final class Cascade {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(Cascade.class);
    private final CascadingAction action;
    private final EventSource eventSource;
    private CascadePoint cascadePoint;
    private Stack<String> componentPathStack = new Stack();

    public Cascade(CascadingAction action, CascadePoint cascadePoint, EventSource eventSource) {
        this.cascadePoint = cascadePoint;
        this.eventSource = eventSource;
        this.action = action;
    }

    public void cascade(EntityPersister persister, Object parent) {
        this.cascade(persister, parent, null);
    }

    public void cascade(EntityPersister persister, Object parent, Object anything) {
        if (persister.hasCascades() || this.action.requiresNoCascadeChecking()) {
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Processing cascade {0} for: {1}", this.action, persister.getEntityName());
            }
            Type[] types = persister.getPropertyTypes();
            CascadeStyle[] cascadeStyles = persister.getPropertyCascadeStyles();
            boolean hasUninitializedLazyProperties = persister.hasUninitializedLazyProperties(parent);
            for (int i = 0; i < types.length; ++i) {
                CascadeStyle style = cascadeStyles[i];
                String propertyName = persister.getPropertyNames()[i];
                if (hasUninitializedLazyProperties && persister.getPropertyLaziness()[i] && !this.action.performOnLazyProperty()) continue;
                if (style.doCascade(this.action)) {
                    this.cascadeProperty(parent, persister.getPropertyValue(parent, i), types[i], style, propertyName, anything, false);
                    continue;
                }
                if (!this.action.requiresNoCascadeChecking()) continue;
                this.action.noCascade(this.eventSource, persister.getPropertyValue(parent, i), parent, persister, i);
            }
            if (traceEnabled) {
                LOG.tracev("Done processing cascade {0} for: {1}", this.action, persister.getEntityName());
            }
        }
    }

    private void cascadeProperty(Object parent, Object child, Type type, CascadeStyle style, String propertyName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
        EntityEntry entry;
        if (child != null) {
            if (type.isAssociationType()) {
                AssociationType associationType = (AssociationType)type;
                if (this.cascadeAssociationNow(associationType)) {
                    this.cascadeAssociation(parent, child, type, style, anything, isCascadeDeleteEnabled);
                }
            } else if (type.isComponentType()) {
                this.cascadeComponent(parent, child, (CompositeType)type, propertyName, anything);
            }
        }
        if (this.isLogicalOneToOne(type) && style.hasOrphanDelete() && this.action.deleteOrphans() && (entry = this.eventSource.getPersistenceContext().getEntry(parent)) != null && entry.getStatus() != Status.SAVING) {
            EntityEntry valueEntry;
            Object loadedValue = this.componentPathStack.isEmpty() ? entry.getLoadedValue(propertyName) : null;
            if ((child == null || loadedValue != null && child != loadedValue) && (valueEntry = this.eventSource.getPersistenceContext().getEntry(loadedValue)) != null) {
                String entityName = valueEntry.getPersister().getEntityName();
                if (LOG.isTraceEnabled()) {
                    Serializable id = valueEntry.getPersister().getIdentifier(loadedValue, this.eventSource);
                    String description = MessageHelper.infoString(entityName, id);
                    LOG.tracev("Deleting orphaned entity instance: {0}", description);
                }
                if (type.isAssociationType() && ((AssociationType)type).getForeignKeyDirection().equals(ForeignKeyDirection.FOREIGN_KEY_TO_PARENT)) {
                    this.eventSource.removeOrphanBeforeUpdates(entityName, loadedValue);
                } else {
                    this.eventSource.delete(entityName, loadedValue, isCascadeDeleteEnabled, new HashSet());
                }
            }
        }
    }

    private boolean isLogicalOneToOne(Type type) {
        return type.isEntityType() && ((EntityType)type).isLogicalOneToOne();
    }

    private boolean cascadeAssociationNow(AssociationType associationType) {
        return associationType.getForeignKeyDirection().cascadeNow(this.cascadePoint);
    }

    private void cascadeComponent(Object parent, Object child, CompositeType componentType, String componentPropertyName, Object anything) {
        this.componentPathStack.push(componentPropertyName);
        Object[] children = componentType.getPropertyValues(child, this.eventSource);
        Type[] types = componentType.getSubtypes();
        for (int i = 0; i < types.length; ++i) {
            CascadeStyle componentPropertyStyle = componentType.getCascadeStyle(i);
            String subPropertyName = componentType.getPropertyNames()[i];
            if (!componentPropertyStyle.doCascade(this.action)) continue;
            this.cascadeProperty(parent, children[i], types[i], componentPropertyStyle, subPropertyName, anything, false);
        }
        this.componentPathStack.pop();
    }

    private void cascadeAssociation(Object parent, Object child, Type type, CascadeStyle style, Object anything, boolean isCascadeDeleteEnabled) {
        if (type.isEntityType() || type.isAnyType()) {
            this.cascadeToOne(parent, child, type, style, anything, isCascadeDeleteEnabled);
        } else if (type.isCollectionType()) {
            this.cascadeCollection(parent, child, style, anything, (CollectionType)type);
        }
    }

    private void cascadeCollection(Object parent, Object child, CascadeStyle style, Object anything, CollectionType type) {
        CollectionPersister persister = this.eventSource.getFactory().getCollectionPersister(type.getRole());
        Type elemType = persister.getElementType();
        CascadePoint originalCascadePoint = this.cascadePoint;
        if (this.cascadePoint == CascadePoint.AFTER_INSERT_BEFORE_DELETE) {
            this.cascadePoint = CascadePoint.AFTER_INSERT_BEFORE_DELETE_VIA_COLLECTION;
        }
        if (elemType.isEntityType() || elemType.isAnyType() || elemType.isComponentType()) {
            this.cascadeCollectionElements(parent, child, type, style, elemType, anything, persister.isCascadeDeleteEnabled());
        }
        this.cascadePoint = originalCascadePoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeToOne(Object parent, Object child, Type type, CascadeStyle style, Object anything, boolean isCascadeDeleteEnabled) {
        String entityName;
        String string = entityName = type.isEntityType() ? ((EntityType)type).getAssociatedEntityName() : null;
        if (style.reallyDoCascade(this.action)) {
            this.eventSource.getPersistenceContext().addChildParent(child, parent);
            try {
                this.action.cascade(this.eventSource, child, entityName, anything, isCascadeDeleteEnabled);
            }
            finally {
                this.eventSource.getPersistenceContext().removeChildParent(child);
            }
        }
    }

    private void cascadeCollectionElements(Object parent, Object child, CollectionType collectionType, CascadeStyle style, Type elemType, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
        boolean deleteOrphans;
        boolean reallyDoCascade;
        boolean bl = reallyDoCascade = style.reallyDoCascade(this.action) && child != CollectionType.UNFETCHED_COLLECTION;
        if (reallyDoCascade) {
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Cascade {0} for collection: {1}", this.action, collectionType.getRole());
            }
            Iterator itr = this.action.getCascadableChildrenIterator(this.eventSource, collectionType, child);
            while (itr.hasNext()) {
                this.cascadeProperty(parent, itr.next(), elemType, style, null, anything, isCascadeDeleteEnabled);
            }
            if (traceEnabled) {
                LOG.tracev("Done cascade {0} for collection: {1}", this.action, collectionType.getRole());
            }
        }
        boolean bl2 = deleteOrphans = style.hasOrphanDelete() && this.action.deleteOrphans() && elemType.isEntityType() && child instanceof PersistentCollection;
        if (deleteOrphans) {
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Deleting orphans for collection: {0}", collectionType.getRole());
            }
            String entityName = collectionType.getAssociatedEntityName(this.eventSource.getFactory());
            this.deleteOrphans(entityName, (PersistentCollection)child);
            if (traceEnabled) {
                LOG.tracev("Done deleting orphans for collection: {0}", collectionType.getRole());
            }
        }
    }

    private void deleteOrphans(String entityName, PersistentCollection pc) throws HibernateException {
        CollectionEntry ce;
        Collection orphans = pc.wasInitialized() ? ((ce = this.eventSource.getPersistenceContext().getCollectionEntry(pc)) == null ? Collections.EMPTY_LIST : ce.getOrphans(entityName, pc)) : pc.getQueuedOrphans(entityName);
        for (Object orphan : orphans) {
            if (orphan == null) continue;
            LOG.tracev("Deleting orphaned entity instance: {0}", entityName);
            this.eventSource.delete(entityName, orphan, false, new HashSet());
        }
    }
}

