/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http;

import java.util.Collection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.http.HttpFileObject;
import org.apache.commons.vfs2.provider.http.HttpFileProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpFileSystem
extends AbstractFileSystem
implements FileSystem {
    private final HttpClient client;

    protected HttpFileSystem(GenericFileName rootName, HttpClient client, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        this.client = client;
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(HttpFileProvider.capabilities);
    }

    protected HttpClient getClient() {
        return this.client;
    }

    @Override
    public void closeCommunicationLink() {
        HttpConnectionManager mgr;
        if (this.getClient() != null && (mgr = this.getClient().getHttpConnectionManager()) instanceof MultiThreadedHttpConnectionManager) {
            ((MultiThreadedHttpConnectionManager)mgr).shutdown();
        }
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws Exception {
        return new HttpFileObject(name, this);
    }
}

