/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.IQueryExecutor;
import org.eclipse.birt.data.engine.impl.OdaDataSetAdapter;
import org.eclipse.birt.data.engine.impl.OdaDataSourceRuntime;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;

public class OdaDataSetRuntime
extends DataSetRuntime {
    private String queryText;
    private Map publicProperties;
    private ValidationContext validationContext;
    private static Logger logger = Logger.getLogger(OdaDataSetRuntime.class.getName());

    OdaDataSetRuntime(IOdaDataSetDesign dataSet, IQueryExecutor executor, DataEngineSession session) {
        super(dataSet, executor, session);
        Object[] params = new Object[]{dataSet, executor};
        logger.entering(OdaDataSetRuntime.class.getName(), "OdaDataSetRuntime", params);
        this.queryText = dataSet.getQueryText();
        this.publicProperties = new HashMap();
        this.publicProperties.putAll(dataSet.getPublicProperties());
        DataEngineImpl de = (DataEngineImpl)session.getEngine();
        this.validationContext = de.getValidationContext(de.getDataSourceRuntime(dataSet.getDataSourceName()), dataSet);
        logger.exiting(OdaDataSetRuntime.class.getName(), "OdaDataSetRuntime");
        logger.log(Level.FINER, "OdaDataSetRuntime starts up");
    }

    public IOdaDataSetDesign getSubdesign() {
        return (IOdaDataSetDesign)this.getDesign();
    }

    public OdaDataSourceRuntime getExtendedDataSource() {
        assert (this.getDataSource() instanceof OdaDataSourceRuntime);
        return (OdaDataSourceRuntime)this.getDataSource();
    }

    @Override
    public String getQueryText() {
        return this.queryText;
    }

    @Override
    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    @Override
    public String getExtensionID() {
        return this.getSubdesign().getExtensionID();
    }

    public String getPrimaryResultSetName() {
        return this.getSubdesign().getPrimaryResultSetName();
    }

    public Map getPublicProperties() {
        return this.publicProperties;
    }

    public Map getPrivateProperties() {
        return this.getSubdesign().getPrivateProperties();
    }

    @Override
    public Map getAllExtensionProperties() {
        return this.publicProperties;
    }

    @Override
    public String getExtensionProperty(String name) {
        return (String)this.publicProperties.get(name);
    }

    @Override
    public void setExtensionProperty(String name, String value) {
        this.publicProperties.put(name, value);
    }

    public ValidationContext getValidationContext() {
        return this.validationContext;
    }

    @Override
    public void close() throws DataException {
        super.close();
    }

    public QuerySpecification getCombinedQuerySpecification() {
        if (this.dataSetDesign instanceof OdaDataSetAdapter) {
            return ((OdaDataSetAdapter)this.dataSetDesign).getCombinedQuerySpecification();
        }
        return null;
    }
}

