package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: ExportMarineLitterMultiPostAction.java 1566 2014-02-04 08:31:02Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.4.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/ExportMarineLitterMultiPostAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUIModel;

import static org.nuiton.i18n.I18n.t;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.2
 */
public class ExportMarineLitterMultiPostAction extends AbstractExportMultiPostAction<MarineLitterBatchUIModel, MarineLitterBatchUI, MarineLitterBatchUIHandler> {

    public ExportMarineLitterMultiPostAction(MarineLitterBatchUIHandler handler) {
        super(handler);
    }

    @Override
    protected String getFileExtension() {
        return "tuttiMarineLitter";
    }

    @Override
    protected String getFileExtensionDescription() {
        return t("tutti.common.file.tuttiMarineLitter");
    }

    @Override
    protected String getFileChooserTitle() {
        return t("tutti.editMarineLitterBatch.action.exportMultiPost.destinationFile.title");
    }

    @Override
    protected String getFileChooserButton() {
        return t("tutti.editMarineLitterBatch.action.exportMultiPost.destinationFile.button");
    }

    @Override
    public void doAction() throws Exception {
        multiPostImportExportService.exportMarineLitter(file, currentOperation);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        sendMessage(t("tutti.editMarineLitterBatch.action.exportMultiPost.success", file));
    }
}
