/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.opensymphony.xwork2.util.ValueStack;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.RessourceClassLoader;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.TuttiService;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.validator.xwork2.XWork2ValidatorUtil;

public class TuttiServiceContext
implements Closeable {
    private static final Log log = LogFactory.getLog(TuttiServiceContext.class);
    protected final TuttiConfiguration config;
    protected final TuttiDataContext dataContext;
    protected final RessourceClassLoader resourceLoader;
    protected final LoadingCache<Class<? extends TuttiService>, TuttiService> services;

    public TuttiServiceContext(RessourceClassLoader resourceLoader, TuttiConfiguration config) {
        this(resourceLoader, config, new TuttiDataContext());
    }

    public TuttiServiceContext(RessourceClassLoader resourceLoader, TuttiConfiguration config, TuttiDataContext dataContext) {
        this.resourceLoader = resourceLoader;
        this.config = config;
        this.dataContext = dataContext;
        ValueStack sharedValueStack = XWork2ValidatorUtil.getSharedValueStack();
        sharedValueStack.push((Object)dataContext.getValidationContext());
        this.services = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class<? extends TuttiService>, TuttiService>(){

            public TuttiService load(Class<? extends TuttiService> key) throws Exception {
                Preconditions.checkNotNull(key);
                Constructor<? extends TuttiService> constructor = key.getConstructor(new Class[0]);
                Preconditions.checkNotNull(constructor);
                TuttiService service = constructor.newInstance(new Object[0]);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("New service " + service));
                }
                service.setServiceContext(TuttiServiceContext.this);
                return service;
            }
        });
    }

    public TuttiConfiguration getConfig() {
        return this.config;
    }

    public RessourceClassLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public TuttiDataContext getDataContext() {
        return this.dataContext;
    }

    public Date currentDate() {
        return new Date();
    }

    public <S extends TuttiService> S getService(Class<S> serviceType) {
        if (serviceType == null) {
            return null;
        }
        try {
            TuttiService s = (TuttiService)this.services.get(serviceType);
            return (S)s;
        }
        catch (ExecutionException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.context.serviceInstanciation.error", (Object[])new Object[]{serviceType}), (Throwable)e);
        }
    }

    public <S extends TuttiService> S reloadService(Class<S> serviceType) {
        TuttiService service = (TuttiService)this.services.getIfPresent(serviceType);
        if (service != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Close service " + service));
            }
            IOUtils.closeQuietly((Closeable)service);
        }
        this.services.invalidate(serviceType);
        S result = this.getService(serviceType);
        return result;
    }

    @Override
    public void close() throws IOException {
        for (TuttiService service : this.services.asMap().values()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Close service " + service));
            }
            IOUtils.closeQuietly((Closeable)service);
        }
        this.services.invalidateAll();
    }

    public SampleCategoryModel getSampleCategoryModel() {
        SampleCategoryModel result = this.getDataContext().getSampleCategoryModel();
        Preconditions.checkNotNull((Object)result, (Object)"Need a not null sample category model");
        return result;
    }

    public String generateId(Class<?> type) {
        return UUID.randomUUID().toString();
    }
}

