/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.bean;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.converter.ConverterUtil;
import org.nuiton.validator.NuitonValidator;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;

public abstract class AbstractNuitonValidatorContext<O, V, E> {
    private static final Log log = LogFactory.getLog(AbstractNuitonValidatorContext.class);
    protected O bean;
    protected NuitonValidatorResult messages;
    protected NuitonValidator<O> validator;
    protected final Map<String, String> conversionErrors = Maps.newTreeMap();
    protected boolean canValidate;

    protected abstract E createEvent(V var1, O var2, String var3, NuitonValidatorScope var4, String[] var5, String[] var6);

    public O getBean() {
        return this.bean;
    }

    public void setBean(O bean) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + " : " + bean));
        }
        this.conversionErrors.clear();
        this.bean = bean;
        this.setCanValidate(!this.validator.getEffectiveFields().isEmpty() && bean != null);
    }

    public NuitonValidator<O> getValidator() {
        return this.validator;
    }

    public NuitonValidatorResult getMessages() {
        return this.messages;
    }

    public boolean isCanValidate() {
        return this.canValidate;
    }

    public void setCanValidate(boolean canValidate) {
        this.canValidate = canValidate;
    }

    public boolean isValid() {
        return this.messages == null || this.messages.isValid();
    }

    public boolean hasFatalErrors() {
        boolean result = this.messages != null && this.messages.hasFatalMessages();
        return result;
    }

    public boolean hasErrors() {
        boolean result = this.messages != null && this.messages.hasErrorMessagess();
        return result;
    }

    public boolean hasWarnings() {
        boolean result = this.messages != null && this.messages.hasWarningMessages();
        return result;
    }

    public boolean hasInfos() {
        boolean result = this.messages != null && this.messages.hasInfoMessages();
        return result;
    }

    public boolean isValid(String fieldName) {
        boolean result = !this.messages.hasMessagesForScope(fieldName, NuitonValidatorScope.FATAL) && !this.messages.hasMessagesForScope(fieldName, NuitonValidatorScope.ERROR);
        return result;
    }

    public NuitonValidatorScope getHighestScope(String field) {
        NuitonValidatorScope scope = this.messages.getFieldHighestScope(field);
        return scope;
    }

    public void setValidator(NuitonValidator<O> validator) {
        this.validator = validator;
    }

    public NuitonValidatorResult validate() {
        NuitonValidatorResult result = this.validator.validate(this.bean);
        for (Map.Entry<String, String> entry : this.conversionErrors.entrySet()) {
            String field = entry.getKey();
            List<String> errors = result.getErrorMessages(field);
            String conversionError = entry.getValue();
            if (errors != null) {
                errors.clear();
                errors.add(conversionError);
            } else {
                errors = Collections.singletonList(conversionError);
            }
            result.setMessagesForScope(NuitonValidatorScope.ERROR, field, errors);
        }
        return result;
    }

    public <T> T convert(String fieldName, String value, Class<T> valueClass) {
        Object result;
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName can not be null");
        }
        if (valueClass == null) {
            throw new IllegalArgumentException("valueClass can not be null");
        }
        if (!this.isCanValidate() || value == null) {
            return null;
        }
        this.conversionErrors.remove(fieldName);
        try {
            Converter converter = ConverterUtil.getConverter(valueClass);
            if (converter == null) {
                throw new RuntimeException("could not find converter for the type " + valueClass);
            }
            result = converter.convert(valueClass, (Object)value);
        }
        catch (ConversionException e) {
            String s = Introspector.decapitalize(valueClass.getSimpleName());
            this.conversionErrors.put(fieldName, "error.convertor." + s);
            throw e;
        }
        return (T)result;
    }

    public List<E> mergeMessages(V beanValidator, NuitonValidatorResult newMessages) {
        if (newMessages == null && this.messages == null) {
            return null;
        }
        Set<NuitonValidatorScope> scopes = this.getValidator().getEffectiveScopes();
        ArrayList events = Lists.newArrayList();
        for (NuitonValidatorScope scope : scopes) {
            this.mergeMessages(beanValidator, scope, newMessages, events);
        }
        if (newMessages != null) {
            this.messages = newMessages;
        }
        return events;
    }

    protected void mergeMessages(V beanValidator, NuitonValidatorScope scope, NuitonValidatorResult newMessages, List<E> events) {
        if (newMessages == null) {
            List<String> fieldsForScope = this.messages.getFieldsForScope(scope);
            for (String field : fieldsForScope) {
                List<String> messagesForScope = this.messages.getMessagesForScope(field, scope);
                events.add(this.createEvent(beanValidator, this.bean, field, scope, null, messagesForScope.toArray(new String[messagesForScope.size()])));
            }
            this.messages.clearMessagesForScope(scope);
        } else {
            List<String> messagesForScope;
            List<String> newFields = newMessages.getFieldsForScope(scope);
            if (this.messages == null) {
                for (String field : newFields) {
                    List<String> messagesForScope2 = newMessages.getMessagesForScope(field, scope);
                    events.add(this.createEvent(beanValidator, this.bean, field, scope, messagesForScope2.toArray(new String[messagesForScope2.size()]), null));
                }
                return;
            }
            List<String> oldFields = this.messages.getFieldsForScope(scope);
            Iterator<String> itr = newFields.iterator();
            while (itr.hasNext()) {
                String newField = itr.next();
                if (oldFields.contains(newField)) continue;
                messagesForScope = newMessages.getMessagesForScope(newField, scope);
                events.add(this.createEvent(beanValidator, this.bean, newField, scope, messagesForScope.toArray(new String[messagesForScope.size()]), null));
                itr.remove();
            }
            itr = oldFields.iterator();
            while (itr.hasNext()) {
                String oldField = itr.next();
                if (newFields.contains(oldField)) continue;
                messagesForScope = this.messages.getMessagesForScope(oldField, scope);
                events.add(this.createEvent(beanValidator, this.bean, oldField, scope, null, messagesForScope.toArray(new String[messagesForScope.size()])));
                itr.remove();
            }
            for (String field : newFields) {
                List<String> newMessagesForScope = newMessages.getMessagesForScope(field, scope);
                List<String> oldMessagesForScope = this.messages.getMessagesForScope(field, scope);
                HashSet<String> toDelete = new HashSet<String>(oldMessagesForScope);
                toDelete.removeAll(newMessagesForScope);
                HashSet<String> toAdd = new HashSet<String>(newMessagesForScope);
                toAdd.removeAll(oldMessagesForScope);
                events.add(this.createEvent(beanValidator, this.bean, field, scope, toAdd.isEmpty() ? null : toAdd.toArray(new String[toAdd.size()]), toDelete.isEmpty() ? null : toDelete.toArray(new String[toDelete.size()])));
            }
        }
    }
}

