/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import com.ibm.icu.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.script.IBaseDataSetEventHandler;
import org.eclipse.birt.data.engine.api.script.IDataRow;
import org.eclipse.birt.data.engine.api.script.IDataSetInstanceHandle;
import org.eclipse.birt.data.engine.api.script.IDataSourceInstanceHandle;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetDesignHelper;
import org.eclipse.birt.data.engine.impl.IQueryExecutor;
import org.eclipse.birt.data.engine.impl.OdaDataSetRuntime;
import org.eclipse.birt.data.engine.impl.PreparedOdaDSQuery;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.impl.ScriptDataSetRuntime;
import org.eclipse.birt.data.engine.odi.IPreparedDSQuery;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.DataRow;
import org.eclipse.birt.data.engine.script.DataSetJSEventHandler;
import org.eclipse.birt.data.engine.script.JSDataSetImpl;
import org.eclipse.birt.data.engine.script.JSInputParams;
import org.eclipse.birt.data.engine.script.JSOutputParams;
import org.eclipse.birt.data.engine.script.JSResultSetRow;
import org.eclipse.birt.data.engine.script.JSRowObject;
import org.eclipse.birt.data.engine.script.JSRows;
import org.eclipse.birt.data.engine.script.ScriptDataSetJSEventHandler;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class DataSetRuntime
implements IDataSetInstanceHandle {
    private Mode mode = Mode.DataSet;
    private JSResultSetRow resultSetRow;
    protected IBaseDataSetDesign dataSetDesign;
    private Scriptable jsDataSetObject;
    protected IQueryExecutor queryExecutor;
    protected static Logger logger = Logger.getLogger(DataSetRuntime.class.getName());
    protected IResultObject resultObj;
    protected IResultIterator resultSet;
    protected int currentRowIndex = -1;
    protected boolean allowUpdateRowData = false;
    protected IResultMetaData rowMetaData;
    private JSRowObject jsRowObject;
    private JSRows jsRowsObject;
    private DataRow dataRow;
    private JSOutputParams jsOutputParamsObject;
    private JSInputParams jsInputParamsObject;
    private Scriptable jsAggrValueObject;
    private Scriptable jsTempAggrValueObject;
    private IBaseDataSetEventHandler eventHandler;
    protected boolean isOpen;
    private DataEngineSession session;
    private Map inParamValues = new LinkedHashMap();
    private Map outParamValues = new LinkedHashMap();
    private boolean fromCache = false;
    private Collator comparableLocator;
    private String nullOrdering;
    public static final Object UNSET_VALUE = Scriptable.NOT_FOUND;

    public void setCompareLocale(Collator compareLocale) {
        this.comparableLocator = compareLocale;
    }

    public Collator getCompareLocator() {
        return this.comparableLocator;
    }

    public void setNullest(String nullOrdering) {
        this.nullOrdering = nullOrdering;
    }

    public String getNullest() {
        return this.nullOrdering;
    }

    protected DataSetRuntime(IBaseDataSetDesign dataSetDesign, IQueryExecutor queryExecutor, DataEngineSession session) {
        List params;
        Object[] parameters = new Object[]{dataSetDesign, queryExecutor};
        logger.entering(DataSetRuntime.class.getName(), "DataSetRuntime", parameters);
        this.dataSetDesign = dataSetDesign;
        this.queryExecutor = queryExecutor;
        this.session = session;
        this.isOpen = true;
        if (dataSetDesign != null) {
            this.eventHandler = dataSetDesign.getEventHandler();
        }
        if (dataSetDesign != null && (params = dataSetDesign.getParameters()) != null) {
            for (IParameterDefinition param : params) {
                String name = param.getName();
                if (name == null) continue;
                if (param.isInputMode()) {
                    this.inParamValues.put(name, UNSET_VALUE);
                }
                if (!param.isOutputMode()) continue;
                this.outParamValues.put(name, UNSET_VALUE);
            }
        }
        if (this.eventHandler == null) {
            if (dataSetDesign instanceof IScriptDataSetDesign) {
                this.eventHandler = new ScriptDataSetJSEventHandler(this.getSession().getEngineContext().getScriptContext(), (IScriptDataSetDesign)dataSetDesign);
            } else if (dataSetDesign instanceof IOdaDataSetDesign) {
                this.eventHandler = new DataSetJSEventHandler(this.getSession().getEngineContext().getScriptContext(), dataSetDesign);
            }
        }
        logger.exiting(DataSetRuntime.class.getName(), "DataSetRuntime");
    }

    public DataEngineSession getSession() {
        return this.session;
    }

    public Scriptable getJSRowObject() {
        if (!this.isOpen) {
            return null;
        }
        if (this.jsRowObject == null) {
            this.jsRowObject = new JSRowObject(this);
        }
        return this.jsRowObject;
    }

    public Scriptable getJSInputParamsObject() {
        if (this.jsInputParamsObject == null) {
            this.jsInputParamsObject = new JSInputParams(this);
        }
        return this.jsInputParamsObject;
    }

    public Scriptable getJSOutputParamsObject() {
        if (this.jsOutputParamsObject == null) {
            this.jsOutputParamsObject = new JSOutputParams(this);
        }
        return this.jsOutputParamsObject;
    }

    public Scriptable getJSRowsObject() throws DataException {
        if (!this.isOpen) {
            return null;
        }
        if (this.jsRowsObject == null) {
            int size = this.queryExecutor.getNestedLevel();
            IQueryExecutor executor = this.queryExecutor;
            DataSetRuntime[] dataSets = new DataSetRuntime[size];
            dataSets[size - 1] = executor.getDataSet();
            if (size - 1 > 0) {
                DataSetRuntime[] innerDSs = executor.getNestedDataSets(size - 1);
                int i = 0;
                while (i < size - 1) {
                    dataSets[i] = innerDSs[i];
                    ++i;
                }
            }
            this.jsRowsObject = new JSRows(dataSets);
        }
        return this.jsRowsObject;
    }

    public IDataRow getDataRow() {
        if (!this.isOpen) {
            return null;
        }
        if (this.dataRow == null) {
            this.dataRow = new DataRow(this);
        }
        return this.dataRow;
    }

    protected IBaseDataSetEventHandler getEventHandler() {
        return this.eventHandler;
    }

    protected IBaseDataSetDesign getDesign() {
        return this.dataSetDesign;
    }

    @Override
    public String getName() {
        if (this.dataSetDesign != null) {
            return this.dataSetDesign.getName();
        }
        return null;
    }

    public int getCacheRowCount() {
        if (this.dataSetDesign != null) {
            return this.dataSetDesign.getCacheRowCount();
        }
        return 0;
    }

    public boolean needDistinctValue() {
        if (this.dataSetDesign != null) {
            return this.dataSetDesign.needDistinctValue();
        }
        return false;
    }

    public String getDataSourceName() {
        if (this.dataSetDesign != null) {
            return this.dataSetDesign.getDataSourceName();
        }
        return null;
    }

    @Override
    public IDataSourceInstanceHandle getDataSource() {
        return this.queryExecutor.getDataSourceInstanceHandle();
    }

    public static DataSetRuntime newInstance(IBaseDataSetDesign dataSetDefn, IQueryExecutor queryExecutor, DataEngineSession session) throws DataException {
        DataSetRuntime dataSet = null;
        if (dataSetDefn instanceof IOdaDataSetDesign) {
            IOdaDataSetDesign odaDsetDesign = (IOdaDataSetDesign)dataSetDefn;
            dataSet = new OdaDataSetRuntime(odaDsetDesign, queryExecutor, session);
        } else if (dataSetDefn instanceof IScriptDataSetDesign) {
            dataSet = new ScriptDataSetRuntime((IScriptDataSetDesign)dataSetDefn, queryExecutor, session);
        } else if (dataSetDefn instanceof IJointDataSetDesign) {
            dataSet = new DataSetRuntime(dataSetDefn, queryExecutor, session);
        } else {
            dataSet = DataSetDesignHelper.createExtenalInstance(dataSetDefn, queryExecutor, session);
            if (dataSet == null) {
                throw new DataException("data.engine.UnsupportedDataSetType");
            }
        }
        return dataSet;
    }

    public Scriptable getSharedScope() throws DataException {
        return this.queryExecutor.getSharedScope();
    }

    public Scriptable getJSDataSetObject() throws DataException {
        if (this.jsDataSetObject == null) {
            Scriptable topScope = this.queryExecutor.getSharedScope();
            this.jsDataSetObject = (Scriptable)Context.javaToJS((Object)new JSDataSetImpl(this), (Scriptable)topScope);
            this.jsDataSetObject.setParentScope(topScope);
            this.jsDataSetObject.setPrototype(topScope);
        }
        return this.jsDataSetObject;
    }

    public Scriptable getJSDataSetRowObject() {
        return this.getJSRowObject();
    }

    public void setJSResultSetRow(JSResultSetRow resultSetRow) {
        this.resultSetRow = resultSetRow;
    }

    public void setMode(Mode m) {
        this.mode = m;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Scriptable getJSResultRowObject() {
        if (!this.isOpen) {
            return null;
        }
        if (this.resultSetRow == null || this.mode == Mode.DataSet) {
            return this.getJSRowObject();
        }
        return this.resultSetRow;
    }

    public Scriptable getJSAggrValueObject() {
        if (!this.isOpen) {
            return null;
        }
        if (this.jsAggrValueObject == null) {
            this.jsAggrValueObject = this.queryExecutor.getJSAggrValueObject();
        }
        return this.jsAggrValueObject;
    }

    public Scriptable getJSTempAggrValueObject() {
        return this.jsTempAggrValueObject;
    }

    public void setJSTempAggrValueObject(Scriptable obj) {
        this.jsTempAggrValueObject = obj;
    }

    @Override
    public Scriptable getScriptScope() throws DataException {
        return this.getJSDataSetObject();
    }

    @Override
    public IResultMetaData getResultMetaData() throws DataException {
        if (!this.isOpen) {
            return null;
        }
        return new ResultMetaData(this.queryExecutor.getOdiResultClass());
    }

    public Collection getInputParamBindings() {
        if (this.dataSetDesign != null) {
            return this.dataSetDesign.getInputParamBindings();
        }
        return null;
    }

    public List getComputedColumns() {
        if (this.dataSetDesign != null) {
            return this.dataSetDesign.getComputedColumns();
        }
        return null;
    }

    public List getFilters() {
        if (this.dataSetDesign != null) {
            return this.dataSetDesign.getFilters();
        }
        return null;
    }

    public List<ISortDefinition> getSortHints() {
        if (this.dataSetDesign != null) {
            return this.dataSetDesign.getSortHints();
        }
        return null;
    }

    public List getParameters() {
        if (this.dataSetDesign != null) {
            return this.dataSetDesign.getParameters();
        }
        return null;
    }

    public List getResultSetHints() {
        if (this.dataSetDesign != null) {
            return this.dataSetDesign.getResultSetHints();
        }
        return null;
    }

    public void beforeOpen() throws DataException {
        if (this.fromCache) {
            return;
        }
        if (this.getEventHandler() != null) {
            try {
                this.getEventHandler().handleBeforeOpen(this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }

    public void beforeClose() throws DataException {
        if (this.fromCache) {
            return;
        }
        if (this.getEventHandler() != null) {
            try {
                this.getEventHandler().handleBeforeClose(this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }

    public void afterOpen() throws DataException {
        if (this.fromCache) {
            return;
        }
        if (this.getEventHandler() != null) {
            try {
                this.getEventHandler().handleAfterOpen(this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }

    public void afterClose() throws DataException {
        if (this.fromCache) {
            return;
        }
        if (this.getEventHandler() != null) {
            try {
                this.getEventHandler().handleAfterClose(this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }

    public void onFetch() throws DataException {
        if (this.fromCache) {
            return;
        }
        if (this.getEventHandler() != null) {
            Mode temp = this.getMode();
            this.setMode(Mode.DataSet);
            try {
                try {
                    this.getEventHandler().handleOnFetch(this, this.getDataRow());
                }
                catch (BirtException e) {
                    throw DataException.wrap(e);
                }
            }
            finally {
                this.setMode(temp);
            }
        }
    }

    public void close() throws DataException {
        this.isOpen = false;
    }

    public void setResultSet(IResultIterator resultSet, boolean allowUpdate) {
        assert (resultSet != null);
        this.resultSet = resultSet;
        this.resultObj = null;
        this.allowUpdateRowData = allowUpdate;
        this.rowMetaData = null;
    }

    public void setRowObject(IResultObject resultObj, boolean allowUpdate) {
        assert (resultObj != null);
        this.resultObj = resultObj;
        this.resultSet = null;
        this.allowUpdateRowData = allowUpdate;
        this.rowMetaData = null;
    }

    public IResultIterator getResultSet() {
        return this.resultSet;
    }

    public void setFromCache(boolean fromCache) {
        this.fromCache = fromCache;
    }

    public void setCurrentRowIndex(int currentRowIndex) {
        this.currentRowIndex = currentRowIndex;
    }

    public IResultObject getCurrentRow() {
        IResultObject resultObject;
        if (!this.isOpen) {
            return null;
        }
        if (this.resultSet != null) {
            try {
                resultObject = this.resultSet.getCurrentResult();
            }
            catch (DataException dataException) {
                resultObject = null;
            }
        } else {
            resultObject = this.resultObj;
        }
        return resultObject;
    }

    public int getCurrentRowIndex() throws DataException {
        int rowID = this.resultSet != null ? this.resultSet.getCurrentResultIndex() : this.currentRowIndex;
        return rowID;
    }

    public boolean allowUpdateRowData() {
        return this.allowUpdateRowData;
    }

    @Override
    public String getExtensionID() {
        return "";
    }

    @Override
    public Map getAllExtensionProperties() {
        return null;
    }

    @Override
    public String getExtensionProperty(String name) {
        return null;
    }

    @Override
    public String getQueryText() throws BirtException {
        return null;
    }

    @Override
    public void setExtensionProperty(String name, String value) {
    }

    @Override
    public void setQueryText(String queryText) throws BirtException {
    }

    public boolean hasInputParameter(String name) {
        return this.inParamValues.containsKey(name);
    }

    @Override
    public Object getInputParameterValue(String name) throws BirtException {
        if (this.inParamValues.containsKey(name)) {
            return this.inParamValues.get(name);
        }
        throw new DataException("data.engine.BadDataSetParamName", name);
    }

    @Override
    public void setInputParameterValue(String name, Object value) throws BirtException {
        if (!this.inParamValues.containsKey(name)) {
            throw new DataException("data.engine.BadDataSetParamName", name);
        }
        this.inParamValues.put(name, value);
    }

    public boolean hasOutputParameter(String name) {
        return this.outParamValues.containsKey(name);
    }

    @Override
    public Object getOutputParameterValue(String name) throws BirtException {
        if (!this.outParamValues.containsKey(name)) {
            throw new DataException("data.engine.BadDataSetParamName", name);
        }
        Object value = this.outParamValues.get(name);
        if (value == UNSET_VALUE) {
            IPreparedDSQuery pq;
            if (this.queryExecutor instanceof PreparedOdaDSQuery.OdaDSQueryExecutor && (pq = ((PreparedOdaDSQuery.OdaDSQueryExecutor)this.queryExecutor).getPreparedOdiQuery()) != null) {
                value = pq.getOutputParameterValue(name);
            }
            if (value == UNSET_VALUE) {
                throw new DataException("data.engine.FailComputeOutputParameterValue", name);
            }
            this.outParamValues.put(name, value);
        }
        return value;
    }

    @Override
    public void setOutputParameterValue(String name, Object value) throws BirtException {
        if (!this.outParamValues.containsKey(name)) {
            throw new DataException("data.engine.BadDataSetParamName", name);
        }
        this.outParamValues.put(name, value);
    }

    @Override
    public Map getInputParameters() {
        return Collections.unmodifiableMap(this.inParamValues);
    }

    @Override
    public Map getOutputParameters() {
        return Collections.unmodifiableMap(this.outParamValues);
    }

    public static enum Mode {
        DataSet,
        Query;

    }
}

