/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.ActionChainResult;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionEventListener;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.UnknownHandlerManager;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import com.opensymphony.xwork2.ognl.OgnlUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.profiling.UtilTimerStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ognl.MethodFailedException;
import ognl.NoSuchPropertyException;
import ognl.OgnlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultActionInvocation
implements ActionInvocation {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultActionInvocation.class);
    protected Object action;
    protected ActionProxy proxy;
    protected List<PreResultListener> preResultListeners;
    protected Map<String, Object> extraContext;
    protected ActionContext invocationContext;
    protected Iterator<InterceptorMapping> interceptors;
    protected ValueStack stack;
    protected Result result;
    protected Result explicitResult;
    protected String resultCode;
    protected boolean executed = false;
    protected boolean pushAction = true;
    protected ObjectFactory objectFactory;
    protected ActionEventListener actionEventListener;
    protected ValueStackFactory valueStackFactory;
    protected Container container;
    protected UnknownHandlerManager unknownHandlerManager;
    protected OgnlUtil ognlUtil;

    public DefaultActionInvocation(Map<String, Object> extraContext, boolean pushAction) {
        this.extraContext = extraContext;
        this.pushAction = pushAction;
    }

    @Inject
    public void setUnknownHandlerManager(UnknownHandlerManager unknownHandlerManager) {
        this.unknownHandlerManager = unknownHandlerManager;
    }

    @Inject
    public void setValueStackFactory(ValueStackFactory fac) {
        this.valueStackFactory = fac;
    }

    @Inject
    public void setObjectFactory(ObjectFactory fac) {
        this.objectFactory = fac;
    }

    @Inject
    public void setContainer(Container cont) {
        this.container = cont;
    }

    @Override
    @Inject(required=false)
    public void setActionEventListener(ActionEventListener listener) {
        this.actionEventListener = listener;
    }

    @Inject
    public void setOgnlUtil(OgnlUtil ognlUtil) {
        this.ognlUtil = ognlUtil;
    }

    @Override
    public Object getAction() {
        return this.action;
    }

    @Override
    public boolean isExecuted() {
        return this.executed;
    }

    @Override
    public ActionContext getInvocationContext() {
        return this.invocationContext;
    }

    @Override
    public ActionProxy getProxy() {
        return this.proxy;
    }

    @Override
    public Result getResult() throws Exception {
        Result proxyResult;
        ActionProxy aProxy;
        Result returnResult = this.result;
        while (returnResult instanceof ActionChainResult && (aProxy = ((ActionChainResult)returnResult).getProxy()) != null && (proxyResult = aProxy.getInvocation().getResult()) != null && aProxy.getExecuteResult()) {
            returnResult = proxyResult;
        }
        return returnResult;
    }

    @Override
    public String getResultCode() {
        return this.resultCode;
    }

    @Override
    public void setResultCode(String resultCode) {
        if (this.isExecuted()) {
            throw new IllegalStateException("Result has already been executed.");
        }
        this.resultCode = resultCode;
    }

    @Override
    public ValueStack getStack() {
        return this.stack;
    }

    @Override
    public void addPreResultListener(PreResultListener listener) {
        if (this.preResultListeners == null) {
            this.preResultListeners = new ArrayList<PreResultListener>(1);
        }
        this.preResultListeners.add(listener);
    }

    public Result createResult() throws Exception {
        ResultConfig resultConfig;
        Map<String, ResultConfig> results;
        block9: {
            if (this.explicitResult != null) {
                Result ret = this.explicitResult;
                this.explicitResult = null;
                return ret;
            }
            ActionConfig config = this.proxy.getConfig();
            results = config.getResults();
            resultConfig = null;
            try {
                resultConfig = results.get(this.resultCode);
            }
            catch (NullPointerException e) {
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug("Got NPE trying to read result configuration for resultCode [#0]", this.resultCode);
            }
        }
        if (resultConfig == null) {
            resultConfig = results.get("*");
        }
        if (resultConfig != null) {
            try {
                return this.objectFactory.buildResult(resultConfig, this.invocationContext.getContextMap());
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("There was an exception while instantiating the result of type #0", e, resultConfig.getClassName());
                }
                throw new XWorkException(e, (Object)resultConfig);
            }
        }
        if (this.resultCode != null && !"none".equals(this.resultCode) && this.unknownHandlerManager.hasUnknownHandlers()) {
            return this.unknownHandlerManager.handleUnknownResult(this.invocationContext, this.proxy.getActionName(), this.proxy.getConfig(), this.resultCode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String invoke() throws Exception {
        String profileKey = "invoke: ";
        try {
            UtilTimerStack.push(profileKey);
            if (this.executed) {
                throw new IllegalStateException("Action has already executed");
            }
            if (this.interceptors.hasNext()) {
                InterceptorMapping interceptor = this.interceptors.next();
                String interceptorMsg = "interceptor: " + interceptor.getName();
                UtilTimerStack.push(interceptorMsg);
                try {
                    this.resultCode = interceptor.getInterceptor().intercept(this);
                }
                finally {
                    UtilTimerStack.pop(interceptorMsg);
                }
            } else {
                this.resultCode = this.invokeActionOnly();
            }
            if (!this.executed) {
                if (this.preResultListeners != null) {
                    Iterator<PreResultListener> i$ = this.preResultListeners.iterator();
                    while (i$.hasNext()) {
                        PreResultListener preResultListener;
                        PreResultListener listener = preResultListener = i$.next();
                        String _profileKey = "preResultListener: ";
                        try {
                            UtilTimerStack.push(_profileKey);
                            listener.beforeResult(this, this.resultCode);
                        }
                        finally {
                            UtilTimerStack.pop(_profileKey);
                        }
                    }
                }
                if (this.proxy.getExecuteResult()) {
                    this.executeResult();
                }
                this.executed = true;
            }
            String string = this.resultCode;
            return string;
        }
        finally {
            UtilTimerStack.pop(profileKey);
        }
    }

    @Override
    public String invokeActionOnly() throws Exception {
        return this.invokeAction(this.getAction(), this.proxy.getConfig());
    }

    protected void createAction(Map<String, Object> contextMap) {
        String timerKey = "actionCreate: " + this.proxy.getActionName();
        try {
            UtilTimerStack.push(timerKey);
            this.action = this.objectFactory.buildAction(this.proxy.getActionName(), this.proxy.getNamespace(), this.proxy.getConfig(), contextMap);
        }
        catch (InstantiationException e) {
            throw new XWorkException("Unable to intantiate Action!", e, this.proxy.getConfig());
        }
        catch (IllegalAccessException e) {
            throw new XWorkException("Illegal access to constructor, is it public?", e, this.proxy.getConfig());
        }
        catch (Exception e) {
            String gripe = this.proxy == null ? "Whoa!  No ActionProxy instance found in current ActionInvocation.  This is bad ... very bad" : (this.proxy.getConfig() == null ? "Sheesh.  Where'd that ActionProxy get to?  I can't find it in the current ActionInvocation!?" : (this.proxy.getConfig().getClassName() == null ? "No Action defined for '" + this.proxy.getActionName() + "' in namespace '" + this.proxy.getNamespace() + "'" : "Unable to instantiate Action, " + this.proxy.getConfig().getClassName() + ",  defined for '" + this.proxy.getActionName() + "' in namespace '" + this.proxy.getNamespace() + "'"));
            gripe = gripe + (" -- " + e.getMessage() != null ? e.getMessage() : " [no message in exception]");
            throw new XWorkException(gripe, e, this.proxy.getConfig());
        }
        finally {
            UtilTimerStack.pop(timerKey);
        }
        if (this.actionEventListener != null) {
            this.action = this.actionEventListener.prepare(this.action, this.stack);
        }
    }

    protected Map<String, Object> createContextMap() {
        Map<String, Object> contextMap;
        if (this.extraContext != null && this.extraContext.containsKey("com.opensymphony.xwork2.util.ValueStack.ValueStack")) {
            this.stack = (ValueStack)this.extraContext.get("com.opensymphony.xwork2.util.ValueStack.ValueStack");
            if (this.stack == null) {
                throw new IllegalStateException("There was a null Stack set into the extra params.");
            }
            contextMap = this.stack.getContext();
        } else {
            this.stack = this.valueStackFactory.createValueStack();
            contextMap = this.stack.getContext();
        }
        if (this.extraContext != null) {
            contextMap.putAll(this.extraContext);
        }
        contextMap.put("com.opensymphony.xwork2.ActionContext.actionInvocation", this);
        contextMap.put("com.opensymphony.xwork2.ActionContext.container", this.container);
        return contextMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeResult() throws Exception {
        this.result = this.createResult();
        String timerKey = "executeResult: " + this.getResultCode();
        try {
            UtilTimerStack.push(timerKey);
            if (this.result != null) {
                this.result.execute(this);
            } else {
                if (this.resultCode != null && !"none".equals(this.resultCode)) {
                    throw new ConfigurationException("No result defined for action " + this.getAction().getClass().getName() + " and result " + this.getResultCode(), (Object)this.proxy.getConfig());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No result returned for action " + this.getAction().getClass().getName() + " at " + this.proxy.getConfig().getLocation(), new String[0]);
                }
            }
        }
        finally {
            UtilTimerStack.pop(timerKey);
        }
    }

    @Override
    public void init(ActionProxy proxy) {
        this.proxy = proxy;
        Map<String, Object> contextMap = this.createContextMap();
        ActionContext actionContext = ActionContext.getContext();
        if (actionContext != null) {
            actionContext.setActionInvocation(this);
        }
        this.createAction(contextMap);
        if (this.pushAction) {
            this.stack.push(this.action);
            contextMap.put("action", this.action);
        }
        this.invocationContext = new ActionContext(contextMap);
        this.invocationContext.setName(proxy.getActionName());
        ArrayList<InterceptorMapping> interceptorList = new ArrayList<InterceptorMapping>(proxy.getConfig().getInterceptors());
        this.interceptors = interceptorList.iterator();
    }

    protected String invokeAction(Object action, ActionConfig actionConfig) throws Exception {
        String methodName = this.proxy.getMethod();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing action method = #0", methodName);
        }
        String timerKey = "invokeAction: " + this.proxy.getActionName();
        try {
            Object methodResult;
            block17: {
                UtilTimerStack.push(timerKey);
                try {
                    methodResult = this.ognlUtil.getValue(methodName + "()", this.getStack().getContext(), action);
                }
                catch (OgnlException e) {
                    try {
                        String altMethodName = "do" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1) + "()";
                        methodResult = this.ognlUtil.getValue(altMethodName, ActionContext.getContext().getContextMap(), action);
                    }
                    catch (OgnlException e1) {
                        if (this.unknownHandlerManager.hasUnknownHandlers()) {
                            try {
                                methodResult = this.unknownHandlerManager.handleUnknownMethod(action, methodName);
                                break block17;
                            }
                            catch (NoSuchMethodException e2) {
                                throw e;
                            }
                        }
                        throw e;
                    }
                }
            }
            String e = this.saveResult(actionConfig, methodResult);
            return e;
        }
        catch (NoSuchPropertyException e) {
            throw new IllegalArgumentException("The " + methodName + "() is not defined in action " + this.getAction().getClass() + "");
        }
        catch (MethodFailedException e) {
            String result;
            Throwable t = e.getCause();
            if (this.actionEventListener != null && (result = this.actionEventListener.handleException(t, this.getStack())) != null) {
                String string = result;
                return string;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
        finally {
            UtilTimerStack.pop(timerKey);
        }
    }

    protected String saveResult(ActionConfig actionConfig, Object methodResult) {
        if (methodResult instanceof Result) {
            this.explicitResult = (Result)methodResult;
            this.container.inject(this.explicitResult);
            return null;
        }
        return (String)methodResult;
    }

    @Override
    public ActionInvocation serialize() {
        DefaultActionInvocation that = this;
        that.container = null;
        return that;
    }

    @Override
    public ActionInvocation deserialize(ActionContext actionContext) {
        DefaultActionInvocation that = this;
        that.container = actionContext.getContainer();
        return that;
    }
}

