/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.service;

import fr.ifremer.adagio.core.service.referential.location.LocationService;
import fr.ifremer.adagio.core.service.technical.CacheService;
import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.context.support.AbstractApplicationContext;

public class ServiceLocator
implements Closeable {
    private static final Log log = LogFactory.getLog(ServiceLocator.class);
    private static final String DEFAULT_BEAN_REFERENCE_LOCATION = "beanRefFactory.xml";
    private static final String DEFAULT_BEAN_REFERENCE_ID = "beanRefFactory";
    private static ServiceLocator instance = new ServiceLocator();
    private boolean open = false;
    private BeanFactoryReference beanFactoryReference;
    private String beanFactoryReferenceLocation;
    private String beanRefFactoryReferenceId;

    protected ServiceLocator() {
        this.init(null, null);
    }

    protected ServiceLocator(String beanFactoryReferenceLocation, String beanRefFactoryReferenceId) {
        this.init(beanFactoryReferenceLocation, beanRefFactoryReferenceId);
    }

    public static void setInstance(ServiceLocator newInstance) {
        instance = newInstance;
    }

    public static ServiceLocator instance() {
        return instance;
    }

    public synchronized void init(String beanFactoryReferenceLocation, String beanRefFactoryReferenceId) {
        if (log.isDebugEnabled() && beanFactoryReferenceLocation != null && beanRefFactoryReferenceId != null) {
            log.debug((Object)String.format("Initializing ServiceLocator to use Spring bean factory [%s] at: %s", beanRefFactoryReferenceId, beanFactoryReferenceLocation));
        }
        this.beanFactoryReferenceLocation = beanFactoryReferenceLocation == null ? DEFAULT_BEAN_REFERENCE_LOCATION : beanFactoryReferenceLocation;
        this.beanRefFactoryReferenceId = beanRefFactoryReferenceId == null ? DEFAULT_BEAN_REFERENCE_ID : beanRefFactoryReferenceId;
        this.beanFactoryReference = null;
    }

    public synchronized void init(String beanFactoryReferenceLocation) {
        this.beanFactoryReferenceLocation = beanFactoryReferenceLocation == null ? DEFAULT_BEAN_REFERENCE_LOCATION : beanFactoryReferenceLocation;
        this.beanFactoryReference = null;
    }

    public synchronized void shutdown() {
        if (!this.open) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Close Spring application context");
        }
        ((AbstractApplicationContext)this.getContext()).close();
        if (this.beanFactoryReference != null) {
            this.beanFactoryReference.release();
            this.beanFactoryReference = null;
        }
        this.open = false;
    }

    public <S> S getService(String name, Class<S> serviceType) {
        return (S)this.getContext().getBean(name, serviceType);
    }

    public final LocationService getLocationService() {
        return this.getService("locationService", LocationService.class);
    }

    public final CacheService getCacheService() {
        return this.getService("cacheService", CacheService.class);
    }

    public boolean isOpen() {
        return this.open;
    }

    protected synchronized ApplicationContext getContext() {
        if (this.beanFactoryReference == null) {
            if (log.isDebugEnabled() && this.beanFactoryReferenceLocation != null && this.beanRefFactoryReferenceId != null) {
                log.debug((Object)String.format("Starting Spring application context using bean factory [%s] from file: %s", this.beanRefFactoryReferenceId, this.beanFactoryReferenceLocation));
            }
            BeanFactoryLocator beanFactoryLocator = ContextSingletonBeanFactoryLocator.getInstance((String)this.beanFactoryReferenceLocation);
            this.beanFactoryReference = beanFactoryLocator.useBeanFactory(this.beanRefFactoryReferenceId);
            this.open = true;
        }
        return (ApplicationContext)this.beanFactoryReference.getFactory();
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }
}

