/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing.unified;

import com.google.common.collect.Maps;
import java.awt.Component;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.unified.UnifiedValidatorMessage;
import jaxx.runtime.validator.swing.unified.UnifiedValidatorMessageTableModel;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class UnifiedValidatorMessageTableRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected final Map<String, String> fieldNameMap = Maps.newHashMap();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel rendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ImageIcon icon = null;
        String text = null;
        String toolTipText = null;
        column = table.convertColumnIndexToModel(column);
        if (table.getRowSorter() != null) {
            row = table.getRowSorter().convertRowIndexToModel(row);
        }
        if (column == 0) {
            NuitonValidatorScope scope = (NuitonValidatorScope)value;
            icon = this.getIcon(row, scope);
            toolTipText = this.getIconTip(row, scope);
        } else {
            UnifiedValidatorMessageTableModel tableModel = (UnifiedValidatorMessageTableModel)table.getModel();
            UnifiedValidatorMessage validatorMessage = tableModel.getRow(row);
            switch (column) {
                case 1: {
                    if (validatorMessage.isSimpleValidator()) {
                        text = this.getSimpleBeanValidatorValue(row, validatorMessage);
                        toolTipText = this.getSimpleBeanValidatorValueTip(row, text);
                        break;
                    }
                    text = this.getListBeanValidatorValue(row, validatorMessage);
                    toolTipText = this.getListBeanValidatorValueTip(row, text);
                    break;
                }
                case 2: {
                    text = this.getFieldName(row, validatorMessage, (String)value);
                    toolTipText = this.getFieldNameTip(row, text);
                    break;
                }
                case 3: {
                    text = this.getMessage(row, validatorMessage);
                    toolTipText = this.getMessageTip(row, text);
                }
            }
        }
        rendererComponent.setText(text);
        rendererComponent.setToolTipText(toolTipText);
        rendererComponent.setIcon(icon);
        return rendererComponent;
    }

    public ImageIcon getIcon(int row, NuitonValidatorScope scope) {
        ImageIcon icon = SwingValidatorUtil.getIcon(scope);
        return icon;
    }

    public String getIconTip(int row, NuitonValidatorScope scope) {
        String label = I18n.t((String)scope.getLabel(), (Object[])new Object[0]);
        String toolTipText = I18n.t((String)"validator.scope.tip", (Object[])new Object[]{label});
        return toolTipText;
    }

    public String getMessage(int row, UnifiedValidatorMessage model) {
        String text = SwingValidatorUtil.getMessage(model);
        return text;
    }

    public String getMessageTip(int row, String message) {
        String tip = I18n.t((String)"validator.message.tip", (Object[])new Object[]{message});
        return tip;
    }

    public String getFieldName(int row, UnifiedValidatorMessage model, String value) {
        String fieldName = SwingValidatorUtil.getFieldName(model, value, this.fieldNameMap.get(value));
        return fieldName;
    }

    public String getFieldNameTip(int row, String fieldName) {
        String tip = I18n.t((String)"validator.field.tip", (Object[])new Object[]{fieldName});
        return tip;
    }

    public String getListBeanValidatorValue(int row, UnifiedValidatorMessage model) {
        String text = this.decorateBean(model.getBean());
        return text;
    }

    public String getListBeanValidatorValueTip(int row, String beanValue) {
        String text = StringUtils.isEmpty((CharSequence)beanValue) ? null : I18n.t((String)"validator.bean.tip", (Object[])new Object[]{row, beanValue});
        return text;
    }

    public String getSimpleBeanValidatorValue(int row, UnifiedValidatorMessage model) {
        String text = this.decorateBean(((SimpleBeanValidator)model.getValidator()).getBean());
        return text;
    }

    public String getSimpleBeanValidatorValueTip(int row, String simpleBeanValue) {
        return null;
    }

    protected String decorateBean(Object bean) {
        return bean == null ? "" : bean.toString();
    }

    public void clearFieldNameMap() {
        this.fieldNameMap.clear();
    }

    public void addFieldName(String field, String name) {
        this.fieldNameMap.put(field, name);
    }
}

