/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.obex.MD5DigestWrapper;
import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import com.intel.bluetooth.obex.OBEXUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import javax.obex.Authenticator;
import javax.obex.PasswordAuthentication;
import javax.obex.ServerRequestHandler;

class OBEXAuthentication {
    private static byte[] privateKey;
    private static long uniqueTimestamp;
    private static final byte[] COLUMN;

    OBEXAuthentication() {
    }

    static byte[] createChallenge(String realm, boolean isUserIdRequired, boolean isFullAccess) {
        Challenge challenge = new Challenge(realm, isUserIdRequired, isFullAccess, OBEXAuthentication.createNonce());
        return challenge.write();
    }

    static boolean handleAuthenticationResponse(OBEXHeaderSetImpl incomingHeaders, Authenticator authenticator, ServerRequestHandler serverHandler, Vector authChallengesSent) throws IOException {
        if (!incomingHeaders.hasAuthenticationResponses()) {
            return false;
        }
        Enumeration iter = incomingHeaders.getAuthenticationResponses();
        while (iter.hasMoreElements()) {
            byte[] authResponse = (byte[])iter.nextElement();
            DigestResponse dr = new DigestResponse();
            dr.read(authResponse);
            DebugLog.debug("got nonce", dr.nonce);
            Challenge challengeSent = null;
            Enumeration challengeIter = authChallengesSent.elements();
            while (challengeIter.hasMoreElements()) {
                Challenge c = (Challenge)challengeIter.nextElement();
                if (!OBEXAuthentication.equals(c.nonce, dr.nonce)) continue;
                challengeSent = c;
                break;
            }
            if (challengeSent == null) {
                throw new IOException("Authentication response for unknown challenge");
            }
            byte[] password = authenticator.onAuthenticationResponse(dr.userName);
            if (password == null) {
                throw new IOException("Authentication request failed, password is not supplied");
            }
            MD5DigestWrapper md5 = new MD5DigestWrapper();
            md5.update(dr.nonce);
            md5.update(COLUMN);
            md5.update(password);
            byte[] claulated = md5.digest();
            if (!OBEXAuthentication.equals(dr.requestDigest, claulated)) {
                DebugLog.debug("got digest", dr.requestDigest);
                DebugLog.debug("  expected", claulated);
                if (serverHandler != null) {
                    serverHandler.onAuthenticationFailure(dr.userName);
                    continue;
                }
                throw new IOException("Authentication failure");
            }
            return true;
        }
        return false;
    }

    static void handleAuthenticationChallenge(OBEXHeaderSetImpl incomingHeaders, OBEXHeaderSetImpl replyHeaders, Authenticator authenticator) throws IOException {
        if (!incomingHeaders.hasAuthenticationChallenge()) {
            return;
        }
        Enumeration iter = incomingHeaders.getAuthenticationChallenges();
        while (iter.hasMoreElements()) {
            byte[] authChallenge = (byte[])iter.nextElement();
            Challenge challenge = new Challenge(authChallenge);
            PasswordAuthentication pwd = authenticator.onAuthenticationChallenge(challenge.getRealm(), challenge.isUserIdRequired(), challenge.isFullAccess());
            DigestResponse dr = new DigestResponse();
            dr.nonce = challenge.nonce;
            DebugLog.debug("got nonce", dr.nonce);
            if (challenge.isUserIdRequired()) {
                dr.userName = pwd.getUserName();
            }
            MD5DigestWrapper md5 = new MD5DigestWrapper();
            md5.update(dr.nonce);
            md5.update(COLUMN);
            md5.update(pwd.getPassword());
            dr.requestDigest = md5.digest();
            DebugLog.debug("send digest", dr.requestDigest);
            replyHeaders.addAuthenticationResponse(dr.write());
        }
    }

    private static synchronized byte[] createNonce() {
        MD5DigestWrapper md5 = new MD5DigestWrapper();
        md5.update(OBEXAuthentication.createTimestamp());
        md5.update(COLUMN);
        md5.update(OBEXAuthentication.getPrivateKey());
        return md5.digest();
    }

    static boolean equals(byte[] digest1, byte[] digest2) {
        for (int i = 0; i < 16; ++i) {
            if (digest1[i] == digest2[i]) continue;
            return false;
        }
        return true;
    }

    private static synchronized byte[] getPrivateKey() {
        if (privateKey != null) {
            return privateKey;
        }
        MD5DigestWrapper md5 = new MD5DigestWrapper();
        md5.update(OBEXAuthentication.createTimestamp());
        privateKey = md5.digest();
        return privateKey;
    }

    private static synchronized byte[] createTimestamp() {
        long t = System.currentTimeMillis();
        if (t <= uniqueTimestamp) {
            t = uniqueTimestamp + 1L;
        }
        uniqueTimestamp = t;
        byte[] buf = new byte[8];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = (byte)(t >> (buf.length - 1 << 3));
            t <<= 8;
        }
        return buf;
    }

    static {
        uniqueTimestamp = 0L;
        COLUMN = new byte[]{58};
    }

    static class DigestResponse {
        byte[] requestDigest;
        byte[] userName;
        byte[] nonce;

        DigestResponse() {
        }

        byte[] write() {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            buf.write(0);
            buf.write(16);
            buf.write(this.requestDigest, 0, 16);
            if (this.userName != null) {
                buf.write(1);
                buf.write(this.userName.length);
                buf.write(this.userName, 0, this.userName.length);
            }
            buf.write(2);
            buf.write(16);
            buf.write(this.nonce, 0, 16);
            return buf.toByteArray();
        }

        void read(byte[] data) throws IOException {
            int len;
            block5: for (int i = 0; i < data.length; i += len) {
                int tag = data[i] & 0xFF;
                len = data[i + 1] & 0xFF;
                i += 2;
                switch (tag) {
                    case 0: {
                        if (len != 16) {
                            throw new IOException("OBEX Digest Response error in tag request-digest");
                        }
                        this.requestDigest = new byte[16];
                        System.arraycopy(data, i, this.requestDigest, 0, 16);
                        continue block5;
                    }
                    case 1: {
                        this.userName = new byte[len];
                        System.arraycopy(data, i, this.userName, 0, this.userName.length);
                        continue block5;
                    }
                    case 2: {
                        if (len != 16) {
                            throw new IOException("OBEX Digest Response error in tag Nonce");
                        }
                        this.nonce = new byte[16];
                        System.arraycopy(data, i, this.nonce, 0, 16);
                    }
                }
            }
        }
    }

    static class Challenge {
        private String realm;
        private boolean isUserIdRequired;
        private boolean isFullAccess;
        byte[] nonce;

        Challenge(byte[] data) throws IOException {
            this.read(data);
        }

        Challenge(String realm, boolean isUserIdRequired, boolean isFullAccess, byte[] nonce) {
            this.realm = realm;
            this.isUserIdRequired = isUserIdRequired;
            this.isFullAccess = isFullAccess;
            this.nonce = nonce;
        }

        byte[] write() {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            buf.write(0);
            buf.write(16);
            buf.write(this.nonce, 0, 16);
            byte options = (byte)((this.isUserIdRequired ? 1 : 0) | (!this.isFullAccess ? 2 : 0));
            buf.write(1);
            buf.write(1);
            buf.write(options);
            if (this.realm != null) {
                int charSetCode;
                byte[] realmArray;
                try {
                    realmArray = OBEXUtils.getUTF16Bytes(this.realm);
                    charSetCode = -1;
                }
                catch (UnsupportedEncodingException e) {
                    try {
                        realmArray = this.realm.getBytes("iso-8859-1");
                    }
                    catch (UnsupportedEncodingException e1) {
                        realmArray = new byte[]{};
                    }
                    charSetCode = 1;
                }
                buf.write(2);
                buf.write(realmArray.length + 1);
                buf.write(charSetCode);
                buf.write(realmArray, 0, realmArray.length);
            }
            return buf.toByteArray();
        }

        void read(byte[] data) throws IOException {
            int len;
            DebugLog.debug("authChallenge", data);
            block5: for (int i = 0; i < data.length; i += len) {
                int tag = data[i] & 0xFF;
                len = data[i + 1] & 0xFF;
                i += 2;
                switch (tag) {
                    case 0: {
                        if (len != 16) {
                            throw new IOException("OBEX Digest Challenge error in tag Nonce");
                        }
                        this.nonce = new byte[16];
                        System.arraycopy(data, i, this.nonce, 0, 16);
                        continue block5;
                    }
                    case 1: {
                        byte options = data[i];
                        DebugLog.debug("authChallenge options", options);
                        this.isUserIdRequired = (options & 1) != 0;
                        this.isFullAccess = (options & 2) == 0;
                        continue block5;
                    }
                    case 2: {
                        int charSetCode = data[i] & 0xFF;
                        byte[] chars = new byte[len - 1];
                        System.arraycopy(data, i + 1, chars, 0, chars.length);
                        if (charSetCode == 255) {
                            this.realm = OBEXUtils.newStringUTF16(chars);
                            continue block5;
                        }
                        if (charSetCode == 0) {
                            this.realm = new String(chars, "ASCII");
                            continue block5;
                        }
                        if (charSetCode <= 9) {
                            this.realm = new String(chars, "ISO-8859-" + charSetCode);
                            continue block5;
                        }
                        DebugLog.error("Unsupported charset code " + charSetCode + " in Challenge");
                        this.realm = new String(chars, 0, len - 1, "ASCII");
                        continue block5;
                    }
                    default: {
                        DebugLog.error("invalid authChallenge tag " + tag);
                    }
                }
            }
        }

        public boolean isUserIdRequired() {
            return this.isUserIdRequired;
        }

        public boolean isFullAccess() {
            return this.isFullAccess;
        }

        public String getRealm() {
            return this.realm;
        }
    }
}

