/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.DataTypeUtil;
import org.eclipse.birt.data.engine.odaconsumer.ExceptionHandler;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSetMetaData
extends ExceptionHandler {
    private IResultSetMetaData m_metadata;
    private String m_driverName;
    private String m_dataSetType;
    private static final String sm_className = ResultSetMetaData.class.getName();

    ResultSetMetaData(IResultSetMetaData metadata, String driverName, String dataSetType) {
        super(sm_className);
        if (ResultSetMetaData.getLogger().isLoggingEnterExitLevel()) {
            ResultSetMetaData.getLogger().entering(sm_className, "ResultSetMetaData", new Object[]{metadata, driverName, dataSetType});
        }
        this.m_metadata = metadata;
        this.m_driverName = driverName;
        this.m_dataSetType = dataSetType;
        ResultSetMetaData.getLogger().exiting(sm_className, "ResultSetMetaData", this);
    }

    public int getColumnCount() throws DataException {
        block4: {
            if (this.m_metadata != null) break block4;
            return 0;
        }
        try {
            return this.m_metadata.getColumnCount();
        }
        catch (OdaException ex) {
            this.throwException(ex, "odaconsumer.CannotGetColumnCount", "getColumnCount");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException(ex, "odaconsumer.CannotGetColumnCount", "getColumnCount");
        }
        return 0;
    }

    public String getColumnName(int index) throws DataException {
        this.verifyHasRuntimeMetaData("getColumnName");
        try {
            return this.m_metadata.getColumnName(index);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetColumnName", index, "getColumnName");
        }
        catch (UnsupportedOperationException ex) {
            ResultSetMetaData.getLogger().logp(Level.WARNING, sm_className, "getColumnName", "Cannot get column name.", ex);
        }
        return "";
    }

    public String getColumnLabel(int index) throws DataException {
        this.verifyHasRuntimeMetaData("getColumnLabel");
        try {
            return this.m_metadata.getColumnLabel(index);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetColumnLabel", index, "getColumnLabel");
        }
        catch (UnsupportedOperationException ex) {
            ResultSetMetaData.getLogger().logp(Level.INFO, sm_className, "getColumnLabel", "Cannot get column label.", ex);
        }
        return "";
    }

    public int getColumnType(int index) throws DataException {
        int odaType;
        int nativeType = this.doGetNativeColumnType(index);
        int n = odaType = nativeType == 0 ? 0 : DataTypeUtil.toOdaType(nativeType, this.m_driverName, this.m_dataSetType);
        if (ResultSetMetaData.getLogger().isLoggable(Level.FINEST)) {
            ResultSetMetaData.getLogger().logp(Level.FINEST, sm_className, "getColumnType", "Column at index {0} has ODA data type {1}.", new Object[]{index, odaType});
        }
        return odaType;
    }

    public String getColumnNativeTypeName(int index) throws DataException {
        this.verifyHasRuntimeMetaData("getColumnNativeTypeName");
        try {
            return this.m_metadata.getColumnTypeName(index);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetColumnNativeDataTypeName", index, "getColumnNativeTypeName");
        }
        catch (UnsupportedOperationException ex) {
            ResultSetMetaData.getLogger().logp(Level.WARNING, sm_className, "getColumnNativeTypeName", "Cannot get column native type name.", ex);
        }
        return "";
    }

    private int doGetNativeColumnType(int index) throws DataException {
        this.verifyHasRuntimeMetaData("doGetNativeColumnType");
        try {
            return this.m_metadata.getColumnType(index);
        }
        catch (OdaException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetColumnType", index, "doGetNativeColumnType");
        }
        catch (UnsupportedOperationException ex) {
            this.throwException((Throwable)ex, "odaconsumer.CannotGetColumnType", index, "doGetNativeColumnType");
        }
        return 0;
    }

    Class getColumnTypeAsJavaClass(int index) throws DataException {
        int odaType = this.getColumnType(index);
        return DataTypeUtil.toTypeClass(odaType);
    }

    private void verifyHasRuntimeMetaData(String methodName) throws DataException {
        if (this.m_metadata == null) {
            this.throwError("odaconsumer.CannotGetResultSetMetaData", null, methodName);
        }
    }

    String getOdaDataSourceId() {
        return this.m_driverName;
    }

    String getDataSetType() {
        return this.m_dataSetType;
    }
}

