/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.validation;

import com.google.common.collect.ImmutableSet;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Cruises;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.validator.NuitonValidatorResult;

public class ValidateCruiseUIModel
extends AbstractSerializableBean {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ValidateCruiseUIModel.class);
    public static final String PROPERTY_SELECTED_FISHING_OPERATION = "selectedFishingOperation";
    public static final String PROPERTY_SELECTED_CRUISE = "selectedCruise";
    public static final String PROPERTY_READY_TO_SYNCH = "readyToSynch";
    protected FishingOperation selectedFishingOperation;
    protected final Map<FishingOperation, NuitonValidatorResult> validator = new HashMap<FishingOperation, NuitonValidatorResult>();
    protected NuitonValidatorResult cruiseValidatorResult;
    protected boolean readyToSynch;
    protected Cruise cruise;
    private Cruise selectedCruise;
    private Object lastSelectedObject;

    public FishingOperation getSelectedFishingOperation() {
        return this.selectedFishingOperation;
    }

    public void setSelectedFishingOperation(FishingOperation selectedFishingOperation) {
        this.selectedFishingOperation = selectedFishingOperation;
        this.lastSelectedObject = selectedFishingOperation;
        this.firePropertyChange(PROPERTY_SELECTED_FISHING_OPERATION, null, selectedFishingOperation);
    }

    public Cruise getSelectedCruise() {
        return this.selectedCruise;
    }

    public void setSelectedCruise(Cruise selectedCruise) {
        this.selectedCruise = selectedCruise;
        this.lastSelectedObject = selectedCruise;
        this.firePropertyChange(PROPERTY_SELECTED_CRUISE, null, selectedCruise);
    }

    public Object getLastSelectedObject() {
        return this.lastSelectedObject;
    }

    public Map<FishingOperation, NuitonValidatorResult> getValidator() {
        return new HashMap<FishingOperation, NuitonValidatorResult>(this.validator);
    }

    public Set<FishingOperation> getFishingOperations() {
        return ImmutableSet.copyOf(this.validator.keySet());
    }

    public NuitonValidatorResult getValidatorResult(FishingOperation fishingOperation) {
        return this.validator.get(fishingOperation);
    }

    public NuitonValidatorResult getCruiseValidatorResult() {
        return this.cruiseValidatorResult;
    }

    public void setCruiseValidatorResult(NuitonValidatorResult cruiseValidatorResult) {
        this.cruiseValidatorResult = cruiseValidatorResult;
    }

    public void addFishingOperationValidatorResults(Map<FishingOperation, NuitonValidatorResult> validatorResultMap) {
        for (Map.Entry<FishingOperation, NuitonValidatorResult> entry : validatorResultMap.entrySet()) {
            this.validator.put(entry.getKey(), entry.getValue());
        }
    }

    public void addValidatorResult(FishingOperation fishingOperation, NuitonValidatorResult validatorResult) {
        this.validator.put(fishingOperation, validatorResult);
    }

    public void computeReadyToSynch() {
        boolean result = true;
        if (this.cruiseValidatorResult != null) {
            if (this.cruiseValidatorResult.hasErrorMessagess()) {
                result = false;
                if (log.isInfoEnabled()) {
                    log.info((Object)("there is some errors in cruise: " + this.cruiseValidatorResult.getFieldsForError()));
                }
            }
            if (this.cruiseValidatorResult.hasFatalMessages()) {
                result = false;
                if (log.isInfoEnabled()) {
                    log.info((Object)("there is some fatal errors in cruise: " + this.cruiseValidatorResult.getFieldsForFatal()));
                }
            }
        }
        for (NuitonValidatorResult nuitonValidatorResult : this.validator.values()) {
            if (nuitonValidatorResult.hasErrorMessagess()) {
                result = false;
                if (!log.isInfoEnabled()) break;
                log.info((Object)("there is some errors in fishing operation: " + nuitonValidatorResult.getFieldsForError()));
                break;
            }
            if (!nuitonValidatorResult.hasFatalMessages()) continue;
            result = false;
            if (!log.isInfoEnabled()) break;
            log.info((Object)("there is some fatal errors in fishing operation: " + nuitonValidatorResult.getFieldsForFatal()));
            break;
        }
        if (result) {
            result = Cruises.isDirty((Cruise)this.cruise);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("New readyToSynch value: " + result));
        }
        this.setReadyToSynch(result);
    }

    public boolean isReadyToSynch() {
        return this.readyToSynch;
    }

    public void setReadyToSynch(boolean readyToSynch) {
        this.readyToSynch = readyToSynch;
        this.firePropertyChange(PROPERTY_READY_TO_SYNCH, null, readyToSynch);
    }

    public void setCruise(Cruise cruise) {
        this.cruise = cruise;
        this.computeReadyToSynch();
    }

    public Cruise getCruise() {
        return this.cruise;
    }
}

