/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.core.SQLiteDatabase;
import liquibase.exception.DatabaseException;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AddColumnGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddColumnStatement;
import liquibase.structure.core.Index;

public class AddColumnGeneratorSQLite
extends AddColumnGenerator {
    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public boolean supports(AddColumnStatement statement, Database database) {
        return database instanceof SQLiteDatabase;
    }

    @Override
    public boolean generateStatementsIsVolatile(Database database) {
        return true;
    }

    @Override
    public Sql[] generateSql(final AddColumnStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ArrayList<Sql> sql = new ArrayList<Sql>();
        SQLiteDatabase.AlterTableVisitor rename_alter_visitor = new SQLiteDatabase.AlterTableVisitor(){

            @Override
            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[]{new ColumnConfig().setName(statement.getColumnName()).setType(statement.getColumnType()).setAutoIncrement(statement.isAutoIncrement())};
            }

            @Override
            public boolean copyThisColumn(ColumnConfig column) {
                return !column.getName().equals(statement.getColumnName());
            }

            @Override
            public boolean createThisColumn(ColumnConfig column) {
                return true;
            }

            @Override
            public boolean createThisIndex(Index index) {
                return true;
            }
        };
        try {
            List<SqlStatement> alterTableStatements = SQLiteDatabase.getAlterTableStatements(rename_alter_visitor, database, statement.getCatalogName(), statement.getSchemaName(), statement.getTableName());
            sql.addAll(Arrays.asList(SqlGeneratorFactory.getInstance().generateSql(alterTableStatements.toArray(new SqlStatement[alterTableStatements.size()]), database)));
        }
        catch (DatabaseException e) {
            System.err.println(e);
            e.printStackTrace();
        }
        return sql.toArray(new Sql[sql.size()]);
    }
}

