/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.build.internal.returns;

import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.build.internal.returns.CollectionFetchableElementAnyGraph;
import org.hibernate.loader.plan.build.internal.returns.CollectionFetchableElementCompositeGraph;
import org.hibernate.loader.plan.build.internal.returns.CollectionFetchableElementEntityGraph;
import org.hibernate.loader.plan.build.internal.returns.CollectionFetchableIndexAnyGraph;
import org.hibernate.loader.plan.build.internal.returns.CollectionFetchableIndexCompositeGraph;
import org.hibernate.loader.plan.build.internal.returns.CollectionFetchableIndexEntityGraph;
import org.hibernate.loader.plan.build.internal.spaces.CompositePropertyMapping;
import org.hibernate.loader.plan.build.internal.spaces.QuerySpaceHelper;
import org.hibernate.loader.plan.build.spi.ExpandingCollectionQuerySpace;
import org.hibernate.loader.plan.build.spi.ExpandingCompositeQuerySpace;
import org.hibernate.loader.plan.build.spi.ExpandingEntityQuerySpace;
import org.hibernate.loader.plan.spi.CollectionFetchableElement;
import org.hibernate.loader.plan.spi.CollectionFetchableIndex;
import org.hibernate.loader.plan.spi.CollectionReference;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public abstract class AbstractCollectionReference
implements CollectionReference {
    private final ExpandingCollectionQuerySpace collectionQuerySpace;
    private final PropertyPath propertyPath;
    private final CollectionFetchableIndex index;
    private final CollectionFetchableElement element;

    protected AbstractCollectionReference(ExpandingCollectionQuerySpace collectionQuerySpace, PropertyPath propertyPath, boolean shouldIncludeJoins) {
        this.collectionQuerySpace = collectionQuerySpace;
        this.propertyPath = propertyPath;
        this.index = this.buildIndexGraph(collectionQuerySpace, shouldIncludeJoins);
        this.element = this.buildElementGraph(collectionQuerySpace, shouldIncludeJoins);
    }

    private CollectionFetchableIndex buildIndexGraph(ExpandingCollectionQuerySpace collectionQuerySpace, boolean shouldIncludeJoins) {
        CollectionPersister persister = collectionQuerySpace.getCollectionPersister();
        if (persister.hasIndex()) {
            Type type = persister.getIndexType();
            if (type.isAssociationType()) {
                if (type.isEntityType()) {
                    EntityPersister indexPersister = persister.getFactory().getEntityPersister(((EntityType)type).getAssociatedEntityName());
                    ExpandingEntityQuerySpace entityQuerySpace = QuerySpaceHelper.INSTANCE.makeEntityQuerySpace(collectionQuerySpace, indexPersister, "indices", (EntityType)persister.getIndexType(), collectionQuerySpace.getExpandingQuerySpaces().generateImplicitUid(), collectionQuerySpace.canJoinsBeRequired(), shouldIncludeJoins);
                    return new CollectionFetchableIndexEntityGraph(this, entityQuerySpace);
                }
                if (type.isAnyType()) {
                    return new CollectionFetchableIndexAnyGraph(this);
                }
            } else if (type.isComponentType()) {
                ExpandingCompositeQuerySpace compositeQuerySpace = QuerySpaceHelper.INSTANCE.makeCompositeQuerySpace(collectionQuerySpace, new CompositePropertyMapping((CompositeType)persister.getIndexType(), (PropertyMapping)((Object)persister), ""), "indices", (CompositeType)persister.getIndexType(), collectionQuerySpace.getExpandingQuerySpaces().generateImplicitUid(), collectionQuerySpace.canJoinsBeRequired(), shouldIncludeJoins);
                return new CollectionFetchableIndexCompositeGraph(this, compositeQuerySpace);
            }
        }
        return null;
    }

    private CollectionFetchableElement buildElementGraph(ExpandingCollectionQuerySpace collectionQuerySpace, boolean shouldIncludeJoins) {
        CollectionPersister persister = collectionQuerySpace.getCollectionPersister();
        Type type = persister.getElementType();
        if (type.isAssociationType()) {
            if (type.isEntityType()) {
                EntityPersister elementPersister = persister.getFactory().getEntityPersister(((EntityType)type).getAssociatedEntityName());
                ExpandingEntityQuerySpace entityQuerySpace = QuerySpaceHelper.INSTANCE.makeEntityQuerySpace(collectionQuerySpace, elementPersister, "elements", (EntityType)persister.getElementType(), collectionQuerySpace.getExpandingQuerySpaces().generateImplicitUid(), collectionQuerySpace.canJoinsBeRequired(), shouldIncludeJoins);
                return new CollectionFetchableElementEntityGraph(this, entityQuerySpace);
            }
            if (type.isAnyType()) {
                return new CollectionFetchableElementAnyGraph(this);
            }
        } else if (type.isComponentType()) {
            ExpandingCompositeQuerySpace compositeQuerySpace = QuerySpaceHelper.INSTANCE.makeCompositeQuerySpace(collectionQuerySpace, new CompositePropertyMapping((CompositeType)persister.getElementType(), (PropertyMapping)((Object)persister), ""), "elements", (CompositeType)persister.getElementType(), collectionQuerySpace.getExpandingQuerySpaces().generateImplicitUid(), collectionQuerySpace.canJoinsBeRequired(), shouldIncludeJoins);
            return new CollectionFetchableElementCompositeGraph(this, compositeQuerySpace);
        }
        return null;
    }

    @Override
    public String getQuerySpaceUid() {
        return this.collectionQuerySpace.getUid();
    }

    @Override
    public CollectionPersister getCollectionPersister() {
        return this.collectionQuerySpace.getCollectionPersister();
    }

    @Override
    public CollectionFetchableIndex getIndexGraph() {
        return this.index;
    }

    @Override
    public CollectionFetchableElement getElementGraph() {
        return this.element;
    }

    @Override
    public PropertyPath getPropertyPath() {
        return this.propertyPath;
    }
}

