/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.operationimport;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.CaracteristicMappingRow;
import fr.ifremer.tutti.persistence.entities.protocol.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.protocol.OperationFieldMappingRow;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.operationimport.ImportFromColumnFileMissingHeaderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.ValueParser;
import org.nuiton.csv.ValueSetter;

public class ImportFromColumnFileModel
extends TuttiCsvUtil.AbstractTuttiImportModel<FishingOperation> {
    private final FishingOperation fishingOperation;

    public ImportFromColumnFileModel(char separator, Set<String> headers, PersistenceService persistenceService, TuttiDataContext dataContext, FishingOperation fishingOperation) throws ImportFromColumnFileMissingHeaderException {
        super(separator);
        this.fishingOperation = fishingOperation;
        TuttiProtocol protocol = dataContext.getProtocol();
        Collection operationFieldMapping = protocol.getOperationFieldMapping();
        String zoneId = dataContext.getProgram().getZone().getId();
        for (OperationFieldMappingRow mappingRow : operationFieldMapping) {
            String importColumn = mappingRow.getImportColumn();
            boolean importColumnsInHeaders = headers.remove(importColumn);
            if (StringUtils.isNotBlank((CharSequence)importColumn) && importColumnsInHeaders) {
                Object valueParser;
                String field;
                switch (field = mappingRow.getField()) {
                    case "fishingOperationNumber": {
                        valueParser = TuttiCsvUtil.INTEGER;
                        break;
                    }
                    case "gearShootingStartLatitude": 
                    case "gearShootingStartLongitude": 
                    case "gearShootingEndLatitude": 
                    case "gearShootingEndLongitude": 
                    case "trawlDistance": {
                        valueParser = TuttiCsvUtil.FLOAT;
                        break;
                    }
                    case "gearShootingStartDate": 
                    case "gearShootingEndDate": {
                        valueParser = TuttiCsvUtil.DAY_TIME;
                        break;
                    }
                    case "fishingOperationRectiligne": {
                        valueParser = TuttiCsvUtil.PRIMITIVE_BOOLEAN;
                        break;
                    }
                    case "fishingOperationValid": {
                        valueParser = TuttiCsvUtil.BOOLEAN;
                        break;
                    }
                    case "gear": {
                        ArrayList<Gear> gears = new ArrayList<Gear>(dataContext.getFishingGears());
                        gears.addAll(dataContext.getScientificGears());
                        Map gearUniverse = TuttiEntities.splitById(gears);
                        valueParser = this.newForeignKeyValue(Gear.class, field, gearUniverse);
                        break;
                    }
                    case "vessel": {
                        ArrayList<Vessel> vessels = new ArrayList<Vessel>(dataContext.getFishingVessels());
                        vessels.addAll(dataContext.getScientificVessels());
                        Map vesselUniverse = TuttiEntities.splitById(vessels);
                        valueParser = this.newForeignKeyValue(Vessel.class, field, vesselUniverse);
                        break;
                    }
                    case "secondaryVessel": {
                        ArrayList<Vessel> vessels = new ArrayList<Vessel>(dataContext.getFishingVessels());
                        vessels.addAll(dataContext.getScientificVessels());
                        Map vesselUniverse = TuttiEntities.splitById(vessels);
                        valueParser = this.newForeignKeyListValue(Vessel.class, field, vesselUniverse);
                        break;
                    }
                    case "strata": {
                        Map strataUniverse = TuttiEntities.splitById(persistenceService.getAllFishingOperationStrata(zoneId));
                        valueParser = this.newForeignKeyValue(TuttiLocation.class, field, strataUniverse);
                        break;
                    }
                    case "subStrata": {
                        Map subStrataUniverse = TuttiEntities.splitById(persistenceService.getAllFishingOperationSubStrata(zoneId, null));
                        valueParser = this.newForeignKeyValue(TuttiLocation.class, field, subStrataUniverse);
                        break;
                    }
                    case "location": {
                        Map locationUniverse = TuttiEntities.splitById(persistenceService.getAllFishingOperationLocation(zoneId, null, null));
                        valueParser = this.newForeignKeyValue(TuttiLocation.class, field, locationUniverse);
                        break;
                    }
                    case "recorderPerson": {
                        Map personUniverse = TuttiEntities.splitById(dataContext.getPersons());
                        valueParser = this.newForeignKeyListValue(Person.class, field, personUniverse);
                        break;
                    }
                    default: {
                        valueParser = TuttiCsvUtil.STRING;
                    }
                }
                this.newMandatoryColumn(importColumn, field, (ValueParser)valueParser);
                continue;
            }
            if (importColumnsInHeaders) continue;
            throw new ImportFromColumnFileMissingHeaderException(importColumn);
        }
        List caracteristicMappingRows = protocol.getCaracteristicMapping();
        for (final CaracteristicMappingRow mappingRow : caracteristicMappingRows) {
            String importColumn = mappingRow.getImportColumn();
            if (!StringUtils.isNotBlank((CharSequence)importColumn) || !headers.remove(importColumn)) continue;
            int pmfmId = Integer.parseInt(mappingRow.getPmfmId());
            final Caracteristic caracteristic = persistenceService.getCaracteristic(pmfmId);
            ValueSetter<FishingOperation, String> setter = new ValueSetter<FishingOperation, String>(){

                public void set(FishingOperation fishingOperation, String value) throws Exception {
                    CaracteristicMap caracteristicMap;
                    Object realValue = null;
                    if (StringUtils.isNotBlank((CharSequence)value)) {
                        block0 : switch (caracteristic.getCaracteristicType()) {
                            case QUALITATIVE: {
                                for (CaracteristicQualitativeValue cqv : caracteristic.getQualitativeValue()) {
                                    if (!value.equals(cqv.getId())) continue;
                                    realValue = cqv;
                                    break block0;
                                }
                                break;
                            }
                            case NUMBER: {
                                realValue = Float.valueOf(Float.parseFloat(value));
                                break;
                            }
                            default: {
                                realValue = value;
                            }
                        }
                    }
                    if (CaracteristicType.GEAR_USE_FEATURE.toString().equals(mappingRow.getTab())) {
                        caracteristicMap = fishingOperation.getGearUseFeatures();
                        if (caracteristicMap == null) {
                            caracteristicMap = new CaracteristicMap();
                            fishingOperation.setGearUseFeatures(caracteristicMap);
                        }
                    } else {
                        caracteristicMap = fishingOperation.getVesselUseFeatures();
                        if (caracteristicMap == null) {
                            caracteristicMap = new CaracteristicMap();
                            fishingOperation.setVesselUseFeatures(caracteristicMap);
                        }
                    }
                    caracteristicMap.put((Object)caracteristic, realValue);
                }
            };
            this.newMandatoryColumn(importColumn, (ValueSetter)setter);
        }
        for (String header : headers) {
            this.newIgnoredColumn(header);
        }
    }

    public FishingOperation newEmptyInstance() {
        return this.fishingOperation;
    }
}

