package fr.ifremer.tutti.ui.swing.util.attachment;

/*
 * #%L
 * Tutti :: UI
 * $Id: SaveAttachmentAction.java 1388 2013-11-26 08:03:42Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-3.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/attachment/SaveAttachmentAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.shared.application.ApplicationIOUtil;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;

import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * To persist a attachment.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.4
 */
public class SaveAttachmentAction extends AbstractTuttiAction<TuttiUIContext, AttachmentEditorUI, AttachmentEditorUIHandler> {

    private Attachment attachment;

    public SaveAttachmentAction(AttachmentEditorUIHandler handler) {
        super(handler, false);
    }

    protected File file;

    protected File attachmentFile;

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {

            attachmentFile = getContext().getPersistenceService().getAttachmentFile(attachment.getId());

            file = saveFile(
                    ApplicationIOUtil.getBaseName(attachment.getName()),
                    ApplicationIOUtil.getExtension(attachmentFile.getName()),
                    _("tutti.attachmentEditor.saveAttachment.title"),
                    _("tutti.attachmentEditor.saveAttachment.button"));
            doAction = file != null;
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {

        AttachmentEditorUI ui = getUI();

        boolean hackDialog = ui.isAlwaysOnTop();
        if (hackDialog) {
            ui.setAlwaysOnTop(false);
        }
        try {

            ApplicationIOUtil.copyFile(attachmentFile, file,
                                       _("tutti.attachmentEditor.saveAttachment.error.message", attachmentFile, file.getName()));
            sendMessage(
                    _("tutti.attachmentEditor.saveAttachment.success.message", file.getName()));

        } finally {
            if (hackDialog) {
                ui.setAlwaysOnTop(true);
            }
        }
    }

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    @Override
    public void releaseAction() {
        super.releaseAction();
        attachmentFile = null;
        attachment = null;
        file = null;
    }
}
