package fr.ifremer.tutti.ui.swing.content.operation.catches.accidental;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n._;

public class AccidentalBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<AccidentalBatchUIModel, AccidentalBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_REMOVE_ACCIDENTAL_BATCH_MENU_ENABLED = "removeAccidentalBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVXzW8bRRSfuLHz5TTQkNCSFpW0hYaPdZCIRBQETVyHODhpFLsoIocwuzuxJ13vbGdnk60sEH8CfwLcufBx44Q4cObApeJfQIgDV8SbWXu9u1nbCSmRMrLfvPd7b96b93vjb/5AWZejV46w72vcswVtEm1zdW/vgX5EDHGfuAanjmAcBX9DGZTZRxNmKHcFurVfkeaFtnmhyJoOs4kdsV6poHFXPLGI2yBECHQjbmG4bqEabq/4jsc7qGFQaahf/fVn5kvzi68zCPkORHcZjnJzkFX3JMMVlKGmQFfA0zEuWNiuQxic2nWId1LKihZ23W3cJI/R52ikgnIO5gAm0PzZj6wwlL3vCDRHTCpWDYOaoI2tNSyMRo05O9gmlkA7h1yjh5w0CdeEJwTVPKq5JxCRZjBbgInGHMKxoMzWDGlLXA2HaFoC+GHZcZTrnEDZJjOli4fP2sWWxO36GTvGFjUxZECgN2K1CDfa7qpy/bgj7CLkdM4eETBf6B1qTX7dAL9rSrdrfA0ncov1GmPwGfBekCX12wibbbG0GwvNZygUkostzxJ0h7liDfxAVtB0zDSQSpOZriXxUyzl5ktxxXGBdYvsMMeD6zAbw1XCLWJ7kfPA8dkxSWRd6oDLmLGUlQVpSsMboX1eeZNn1WUKrsT9yVsXT8Do7UC6KL/fkcutcG/O4ASLZCyJg74aqk8p11WDM8uSmAK9GPPe3YmHkFV24I7xunYEVPNIMCcw8rXNvZrclaqvO9Duc7ErBkSidYmk2+lD+yjLPRALdHX/NPfswlbAOlcTrCMB1e4/s9O//fj7D+sdqsmD75lU1QhTAgU4XHaToNL1VMAznqBWYQs7K/tozCUW0Kyi0espgVXb2xAc+HtemmvSXNvAbgMgsiNPf/p59tNfL6HMOhq3GDbXsdQvozHR4JAFZpm+88E9FVH+ZBTW5+B/WKBhnWC41yMtRQufQd9iT7D2rSy0Gtg2LWi7OhFFZh/S+t0FjbqrHZVtr6kTXgIqY/zugrQGVye7xJXkPiy4B8mfkiKl3WmixR6wVVCMIgb6gOtDRa6nVCRMiz72y9/T1W/vdaoyBFm61lO9W5nsJyhHbYvaRI2ANrunUv6E4xLPZF0WT+N1BEnLR4/QbuAltS6fKsAQ3PKDBtAXTJLWfMBtKYNBkyrzkAaJUlTnk59KqP8ccQZ4vwT1OoTL0u6z7CG2oHAoxxz82IsIJnXGTcJ3MIW5YHbkadH0Zt1BschMWFiXk+nN3nkQVFhE0+XnVUNOJjctigizniEFk0HvAZicYALdaVWoK6pRoaVVy9sfVkoH1VKlVKyVH2zDVR91gebjmZsOodYZJ3XOPBvSNdkqMgum3VpltfhRahEDphsUa062FPGhsxZ7Zwgr91pifEFOgo2ynO1w59U2jIED7DgWNdSUDzIq0Ear97xtw5eVfdd36CjA0AzZE5CjPH37XXvLhtFlU0Og5fPGrTVD2wkBF6lGnZrKwDvnRhLwGgubbblfs/UA6N2D6Y+FZ1nOxJsiWc5g+7+Xs+T/T+VMxH2BciaRzl3OJECfcqa+4AaVMxuWsw9/tWMJ3k9KlChlXnHbW4HCqYQvnQe5Z7IHX7coSizRS2dIdNS4z9zq84YclOoReK8QW1ImsOvLwcsFng+76oWscErBrnqSnLkqvGufXhVwQ2RVUtvs/uA22017wvdvscEVj0R9gYpHUc5d8ahx74r3/gVzhrdBzsJPGMSBLr8HvxLxTZ3aJmT2/VOOhuQ6PhBRir+Ty/fpCLcvjPAaIPwL1lm8TFYRAAA=";
    private static final Log log = LogFactory.getLog(AccidentalBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToolBar accidentalBatchTabToolBar;
    protected TuttiHelpBroker broker;
    protected JButton createAccidentalBatchButton;
    protected AccidentalBatchUI editAccidentalBatchTopPanel = this;
    protected JButton exportMultiPostButton;
    protected final AccidentalBatchUIHandler handler = new AccidentalBatchUIHandler();
    protected JButton importMultiPostButton;
    protected AccidentalBatchUIModel model;
    protected JMenuItem removeAccidentalBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<AccidentalBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AccidentalBatchUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public AccidentalBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccidentalBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccidentalBatchUI() {
        $initialize();
    }

    public AccidentalBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccidentalBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AccidentalBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccidentalBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public AccidentalBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__createAccidentalBatchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createBatch();
    }

    public void doKeyPressed__on__table(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToolBar getAccidentalBatchTabToolBar() {
        return accidentalBatchTabToolBar;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCreateAccidentalBatchButton() {
        return createAccidentalBatchButton;
    }

    public JButton getExportMultiPostButton() {
        return exportMultiPostButton;
    }

    public AccidentalBatchUIHandler getHandler() {
        return handler;
    }

    public JButton getImportMultiPostButton() {
        return importMultiPostButton;
    }

    public AccidentalBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveAccidentalBatchMenu() {
        return removeAccidentalBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<AccidentalBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAccidentalBatchTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalBatchTabToolBar.add(importMultiPostButton);
        accidentalBatchTabToolBar.add(exportMultiPostButton);
    }

    protected void addChildrenToEditAccidentalBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(accidentalBatchTabToolBar);
        add(tableToolbar, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeAccidentalBatchMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAccidentalBatchTabToolBar() {
        $objectMap.put("accidentalBatchTabToolBar", accidentalBatchTabToolBar = new JToolBar());
        
        accidentalBatchTabToolBar.setName("accidentalBatchTabToolBar");
        accidentalBatchTabToolBar.setFloatable(false);
        accidentalBatchTabToolBar.setOpaque(false);
        accidentalBatchTabToolBar.setBorderPainted(false);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editAccidentalBatch.help"));
    }

    protected void createCreateAccidentalBatchButton() {
        $objectMap.put("createAccidentalBatchButton", createAccidentalBatchButton = new JButton());
        
        createAccidentalBatchButton.setName("createAccidentalBatchButton");
        createAccidentalBatchButton.setText(_("tutti.editAccidentalBatch.action.createBatch"));
        createAccidentalBatchButton.setToolTipText(_("tutti.editAccidentalBatch.action.createBatch.tip"));
        createAccidentalBatchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createAccidentalBatchButton"));
        createAccidentalBatchButton.putClientProperty("help", "tutti.editAccidentalBatch.action.createBatch.help");
    }

    protected void createExportMultiPostButton() {
        $objectMap.put("exportMultiPostButton", exportMultiPostButton = new JButton());
        
        exportMultiPostButton.setName("exportMultiPostButton");
        exportMultiPostButton.setText(_("tutti.editAccidentalBatch.action.exportMultiPost"));
        exportMultiPostButton.setToolTipText(_("tutti.editAccidentalBatch.action.exportMultiPost.tip"));
        exportMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportAccidentalMultiPostAction.class);
        exportMultiPostButton.putClientProperty("help", "tutti.editAccidentalBatch.action.exportMultiPost.help");
    }

    protected void createImportMultiPostButton() {
        $objectMap.put("importMultiPostButton", importMultiPostButton = new JButton());
        
        importMultiPostButton.setName("importMultiPostButton");
        importMultiPostButton.setText(_("tutti.editAccidentalBatch.action.importMultiPost"));
        importMultiPostButton.setToolTipText(_("tutti.editAccidentalBatch.action.importMultiPost.tip"));
        importMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ImportAccidentalMultiPostAction.class);
        importMultiPostButton.putClientProperty("help", "tutti.editAccidentalBatch.action.importMultiPost.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(AccidentalBatchUIModel.class));
    }

    protected void createRemoveAccidentalBatchMenu() {
        $objectMap.put("removeAccidentalBatchMenu", removeAccidentalBatchMenu = new JMenuItem());
        
        removeAccidentalBatchMenu.setName("removeAccidentalBatchMenu");
        removeAccidentalBatchMenu.setText(_("tutti.editAccidentalBatch.action.removeBatch"));
        removeAccidentalBatchMenu.setToolTipText(_("tutti.editAccidentalBatch.action.removeBatch.tip"));
        removeAccidentalBatchMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.RemoveAccidentalBatchAction.class);
        removeAccidentalBatchMenu.putClientProperty("help", "tutti.editAccidentalBatch.action.removeBatch.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editAccidentalBatch.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(AccidentalBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditAccidentalBatchTopPanel();
        addChildrenToValidator();
        addChildrenToAccidentalBatchTabToolBar();
        addChildrenToTablePopup();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createAccidentalBatchButton);
        addChildrenToTableScrollPane();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 13 property setters
        importMultiPostButton.setIcon(SwingUtil.createActionIcon("import"));
        importMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editAccidentalBatch.action.importMultiPost.mnemonic"),'Z'));
        exportMultiPostButton.setIcon(SwingUtil.createActionIcon("export"));
        exportMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editAccidentalBatch.action.exportMultiPost.mnemonic"),'Z'));
        removeAccidentalBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeAccidentalBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editAccidentalBatch.action.removeBatch.mnemonic"),'Z'));
        createAccidentalBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        createAccidentalBatchButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editAccidentalBatch.action.createBatch.mnemonic"),'Z'));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editAccidentalBatchTopPanel, "tutti.editAccidentalBatch.help");
        registerHelpId(_broker, importMultiPostButton, "tutti.editAccidentalBatch.action.importMultiPost.help");
        registerHelpId(_broker, exportMultiPostButton, "tutti.editAccidentalBatch.action.exportMultiPost.help");
        registerHelpId(_broker, removeAccidentalBatchMenu, "tutti.editAccidentalBatch.action.removeBatch.help");
        registerHelpId(_broker, createAccidentalBatchButton, "tutti.editAccidentalBatch.action.createBatch.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editAccidentalBatchTopPanel", editAccidentalBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createAccidentalBatchTabToolBar();
        createImportMultiPostButton();
        createExportMultiPostButton();
        createTablePopup();
        createRemoveAccidentalBatchMenu();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateAccidentalBatchButton();
        createTableScrollPane();
        createTable();
        // inline creation of editAccidentalBatchTopPanel
        setName("editAccidentalBatchTopPanel");
        setLayout(new BorderLayout());
        editAccidentalBatchTopPanel.putClientProperty("help", "tutti.editAccidentalBatch.help");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_ACCIDENTAL_BATCH_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeAccidentalBatchMenu.setEnabled(model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
    }

}