package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create;

/*
 * #%L
 * Tutti :: UI
 * $Id: CreateMarineLitterBatchUIHandler.java 1191 2013-09-19 09:41:01Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.8/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/marinelitter/create/CreateMarineLitterBatchUIHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUIModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JComponent;
import java.awt.Dimension;
import java.util.List;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class CreateMarineLitterBatchUIHandler extends AbstractTuttiUIHandler<CreateMarineLitterBatchUIModel, CreateMarineLitterBatchUI> implements Cancelable {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(CreateMarineLitterBatchUIHandler.class);

    private final TuttiPersistence persistenceService;

    public CreateMarineLitterBatchUIHandler(TuttiUI parentUi,
                                            CreateMarineLitterBatchUI ui) {
        super(parentUi.getHandler().getContext(), ui);
        this.persistenceService = context.getPersistenceService();
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    @Override
    public void beforeInitUI() {
        CreateMarineLitterBatchUIModel model = new CreateMarineLitterBatchUIModel();
        ui.setContextValue(model);
        listModelIsModify(model);
    }

    @Override
    public void afterInitUI() {

        initUI(ui);

        Caracteristic marineLitterCategoryCaracteristic =
                persistenceService.getMarineLitterCategoryCaracteristic();
        initBeanFilterableComboBox(ui.getMarineLitterCategoryComboBox(),
                                   Lists.newArrayList(marineLitterCategoryCaracteristic.getQualitativeValue()),
                                   null);

        Caracteristic marineLitterSizeCategoryCaracteristic =
                persistenceService.getMarineLitterSizeCategoryCaracteristic();

        initBeanFilterableComboBox(ui.getMarineLitterSizeCategoryComboBox(),
                                   Lists.newArrayList(marineLitterSizeCategoryCaracteristic.getQualitativeValue()),
                                   null);

        listenValidatorValid(ui.getValidator(), getModel());
    }

    @Override
    protected JComponent getComponentToFocus() {
        return getUI().getMarineLitterCategoryComboBox();
    }

    @Override
    public void onCloseUI() {

        if (log.isDebugEnabled()) {
            log.debug("closing: " + ui);
        }

        // evict model from validator
        ui.getValidator().setBean(null);

        // when canceling always invalid model
        getModel().setValid(false);

        EditCatchesUI parent = SwingUtil.getParentContainer(ui, EditCatchesUI.class);
        parent.getHandler().setMarineLitterSelectedCard(EditCatchesUIHandler.MAIN_CARD);
    }

    @Override
    public SwingValidator<CreateMarineLitterBatchUIModel> getValidator() {
        return ui.getValidator();
    }

    //------------------------------------------------------------------------//
    //-- Cancelable methods                                                 --//
    //------------------------------------------------------------------------//

    @Override
    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug("Cancel UI " + ui);
        }
        closeUI(ui);
    }

    //------------------------------------------------------------------------//
    //-- Public methods                                                     --//
    //------------------------------------------------------------------------//

    public void openUI(MarineLitterBatchUIModel batchModel) {

        CreateMarineLitterBatchUIModel model = getModel();

        // connect model to validator
        ui.getValidator().setBean(model);

        model.reset();

        Multimap<CaracteristicQualitativeValue, CaracteristicQualitativeValue> categoryUsed =
                model.getMarineLitterCategoryUsed();
        categoryUsed.clear();

        if (batchModel != null) {
            categoryUsed.putAll(batchModel.getMarineLitterCategoriesUsed());
        }

    }

    public void saveAndContinue() {

        if (log.isDebugEnabled()) {
            log.debug("Save And Continue UI " + ui);
        }

        EditCatchesUI parent = SwingUtil.getParentContainer(ui, EditCatchesUI.class);
        MarineLitterBatchUI marineLitterTabContent = parent.getMarineLitterTabContent();
        marineLitterTabContent.getHandler().addBatch(getModel());

        // reopen this ui
        openUI(marineLitterTabContent.getModel());
    }

    public void saveAndClose() {

        if (log.isDebugEnabled()) {
            log.debug("Save And Close UI " + ui);
        }

        EditCatchesUI parent = SwingUtil.getParentContainer(ui, EditCatchesUI.class);
        parent.getMarineLitterTabContent().getHandler().addBatch(getModel());

        // close dialog
        closeUI(ui);
    }

    public Species openAddSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUI dialogContent = new SelectSpeciesUI(ui);
        SelectSpeciesUIModel model = dialogContent.getModel();
        model.setSelectedSpecies(null);
        model.setSpecies(species);

        openDialog(dialogContent, title, new Dimension(400, 130));

        Species result = model.getSelectedSpecies();
        return result;
    }

}
