package fr.ifremer.tutti.ui.swing.util;

/*
 * #%L
 * Tutti :: UI
 * $Id: TuttiExceptionHandler.java 931 2013-05-08 15:45:54Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.7/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/TuttiExceptionHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionException;
import jaxx.runtime.swing.JAXXRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Tutti global exception handler.
 * <p/>
 * Catch all application uncaught and display it in a custom JoptionPane
 * or JXErrorPane.
 * <p/>
 * See http://stackoverflow.com/a/4448569/1165234 for details.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class TuttiExceptionHandler implements Thread.UncaughtExceptionHandler {

    private static final Log log =
            LogFactory.getLog(TuttiExceptionHandler.class);

    @Override
    public void uncaughtException(Thread t, Throwable ex) {
        handleException(t.getName(), ex);
    }

    public void handle(Throwable thrown) {
        // for EDT exceptions
        handleException(Thread.currentThread().getName(), thrown);
    }

    protected void handleException(String tname, Throwable ex) {
        if (log.isErrorEnabled()) {
            log.error("Global application exception [" + tname + "]", ex);
        }

        Throwable cause = ex;

        if (cause instanceof TuttiTechnicalException) {
            cause = cause.getCause();
        }

        if (cause instanceof JAXXRuntimeException) {
            cause = cause.getCause();
        }

        boolean backToScreen = false;

        AbstractTuttiAction action = null;

        if (cause instanceof TuttiActionException) {

            TuttiActionException actionException = (TuttiActionException) cause;
            cause = cause.getCause();

            if (log.isDebugEnabled()) {
                log.debug("Action error cause:", cause);
            }

            action = actionException.getAction();

            if (action instanceof AbstractChangeScreenAction) {
                backToScreen = true;
            }
        }

        TuttiUIContext.getErrorHelper().showErrorDialog(cause.getMessage(), cause);

        if (backToScreen) {

            action.getContext().setFallBackScreen();
        }
    }

}
