package fr.ifremer.tutti.ui.swing.content;

/*
 * #%L
 * Tutti :: UI
 * $Id: UpdateDbAction.java 1226 2013-09-25 16:36:22Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.6/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/UpdateDbAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiDbUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.updater.ApplicationInfo;
import org.nuiton.updater.ApplicationUpdater;

import javax.swing.JOptionPane;
import java.io.File;
import java.util.Map;

import static org.nuiton.i18n.I18n._;

/**
 * To update - install database.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class UpdateDbAction extends AbstractMainUITuttiAction {

    /** Logger. */
    private static final Log log = LogFactory.getLog(UpdateDbAction.class);

    protected ApplicationInfo updateDbVersion;

    public UpdateDbAction(MainUIHandler handler) {
        super(handler, true);
        setActionDescription(_("tutti.dbManager.action.upgradeDb.tip"));
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();

        updateDbVersion = null;

        if (doAction) {
            // check db url is reachable
            doAction = getContext().checkUpdateDbReachable();
        }

        if (doAction) {

            // get the next db version
            ApplicationUpdater up = new ApplicationUpdater();

            // get db updates
            Map<String, ApplicationInfo> dbVersions =
                    up.getVersions(getConfig().getUpdateDbUrl(),
                                   getConfig().getDataDirectory());
            updateDbVersion =
                    dbVersions.get(TuttiDbUpdaterCallBack.DB_UPDATE_NAME);

            if (updateDbVersion != null && updateDbVersion.newVersion != null) {

                // ask user if it wants to do the update
                String htmlMessage = String.format(
                        AbstractTuttiUIHandler.CONFIRMATION_FORMAT,
                        _("tutti.dbManager.updatedb.found", updateDbVersion.newVersion),
                        _("tutti.common.askBeforeUpdate.help"));
                int i = JOptionPane.showConfirmDialog(
                        getHandler().getUI(),
                        htmlMessage,
                        _("tutti.dbManager.title.confirm.updatedb"),
                        JOptionPane.OK_CANCEL_OPTION,
                        JOptionPane.QUESTION_MESSAGE);

                doAction = i == JOptionPane.OK_OPTION;
            }
        }
        return doAction;
    }

    @Override
    public void doAction() {
        TuttiUIContext context = getContext();
        TuttiApplicationConfig config = context.getConfig();

        File current = config.getDataDirectory();
        String url = config.getUpdateDbUrl();

        if (log.isInfoEnabled()) {
            log.info(String.format("Try to install / update db (current data location: %s), using update url: %s", current, url));
        }

        File dest = new File(config.getTuttiBasedir(), "NEW");
        ProgressionModel progressionModel = new ProgressionModel();
        context.getActionUI().getModel().setProgressionModel(progressionModel);
        progressionModel.setMessage(_("tutti.dbManager.action.upgradeDb.check"));
        TuttiDbUpdaterCallBack callback =
                new TuttiDbUpdaterCallBack(this, progressionModel);
        ApplicationUpdater up = new ApplicationUpdater();

        up.update(url,
                  current,
                  dest,
                  false,
                  callback,
                  progressionModel);

        if (callback.isDbUpdated()) {

            sendMessage(_("tutti.dbManager.action.upgradeDb.done", updateDbVersion.newVersion));

        } else {
            sendMessage(_("tutti.dbManager.action.upgradeDb.upToDate"));
        }
    }

    @Override
    public void postSuccessAction() {
        handler.reloadDbManagerText();
        super.postSuccessAction();
    }

    @Override
    public void postFailedAction(Throwable error) {
        handler.reloadDbManagerText();
        super.postFailedAction(error);
    }
}