package fr.ifremer.tutti.ui.swing.util.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: TuttiActionUIHandler.java 1208 2013-09-23 13:14:53Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/action/TuttiActionUIHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.StatusMessagePanel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JComponent;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import static org.nuiton.i18n.I18n._;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class TuttiActionUIHandler extends AbstractTuttiUIHandler<TuttiActionUIModel, TuttiActionUI> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(TuttiActionUIHandler.class);

    public TuttiActionUIHandler(TuttiUIContext context, TuttiActionUI ui) {
        super(context, ui);
    }

    protected PropertyChangeListener progressionListener = new PropertyChangeListener() {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {

            String propertyName = evt.getPropertyName();
            if (ProgressionModel.PROPERTY_MESSAGE.equals(propertyName)) {

                // change message
                String newMessage = (String) evt.getNewValue();
                ui.getTaskActionLabel().setText("<html><body>" + newMessage + "</body></html>");
                ui.pack();
            } else if (ProgressionModel.PROPERTY_TOTAL.equals(propertyName)) {

                // change total progressbar max
                ui.getTaskProgressBar().setMaximum((Integer) evt.getNewValue());

            } else if (ProgressionModel.PROPERTY_CURRENT.equals(propertyName)) {

                // change value of progress bar
                ui.getTaskProgressBar().setValue((Integer) evt.getNewValue());
            }
        }
    };

    protected ComponentListener listener = new ComponentAdapter() {
        boolean moving;

        boolean resizing;

        @Override
        public void componentMoved(ComponentEvent e) {

            MainUI mainUI = (MainUI) e.getSource();

            if (!moving && mainUI.isShowing()) {

                moving = true;
                try {
                    setLocation(mainUI);
                } finally {
                    moving = false;
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {

            MainUI mainUI = (MainUI) e.getSource();

            if (!resizing && mainUI.isShowing()) {

                resizing = true;
                try {
                    setSize(mainUI);
                } finally {
                    resizing = false;
                }
            }
        }
    };

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    @Override
    public void beforeInitUI() {
        TuttiActionUIModel model = new TuttiActionUIModel();
        ui.setContextValue(model);

        model.addPropertyChangeListener(TuttiActionUIModel.PROPERTY_ACTION, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {

                // udpate global label
                AbstractTuttiAction action = (AbstractTuttiAction) evt.getNewValue();

                if (log.isDebugEnabled()) {
                    log.debug("Action to use: " + action);
                }
                if (action == null) {

                    // stoping action
                    hideAction();
                } else {

                    // starting action
                    showAction(action);
                }
            }
        });

        model.addPropertyChangeListener(TuttiActionUIModel.PROPERTY_PROGRESSION_MODEL, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {

                // change progression model

                ProgressionModel oldValue = (ProgressionModel) evt.getOldValue();
                ProgressionModel newValue = (ProgressionModel) evt.getNewValue();

                if (log.isDebugEnabled()) {
                    log.debug("progression model: " + newValue);
                }
                if (oldValue != null) {
                    oldValue.removePropertyChangeListener(progressionListener);
                }

                if (newValue == null) {

                    // remove progression model
                    ui.getTaskPanel().setVisible(false);
                } else {

                    // use progression model
                    ui.getTaskPanel().setVisible(true);

                    newValue.addPropertyChangeListener(progressionListener);
                }
            }
        });
    }

    @Override
    public void afterInitUI() {

        initUI(ui);

        // installation layer de blocage en mode busy
        SwingUtil.setLayerUI(ui.getRootPanel(), ui.getBusyBlockLayerUI());

        ui.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    }

    @Override
    protected JComponent getComponentToFocus() {
        return null;
    }

    @Override
    public void onCloseUI() {

    }

    @Override
    public SwingValidator<TuttiActionUIModel> getValidator() {
        return null;
    }

    //------------------------------------------------------------------------//
    //-- Internal methods                                                   --//
    //------------------------------------------------------------------------//

    protected void hideAction() {
        ui.setVisible(false);
    }

    protected void showAction(AbstractTuttiAction action) {
        ui.setTitle(_("tutti.main.title.action",
                      getConfig().getVersion(),
                      action.getActionDescription()));
        ui.getGlobalActionLabel().setText(
                _("tutti.message.action.running",
                  action.getActionDescription()));
        ui.pack();

        MainUI mainUI = getContext().getMainUI();
        if (mainUI != null) {
            mainUI.addComponentListener(listener);

            setLocation(mainUI);
            setSize(mainUI);
        }
        try {
            ui.setVisible(true);
        } finally {
            if (mainUI != null) {
                mainUI.removeComponentListener(listener);
            }
        }
    }

    protected void setLocation(MainUI mainUI) {
        Container component = mainUI.getBody();
        StatusMessagePanel status = mainUI.getStatus();
        int width = component == null ? 0 : component.getWidth();
        int height = component == null ? 0 : component.getHeight() + status.getHeight();

        int x;
        int y;
        if (height == 0) {
            x = mainUI.getX() + 5;
            y = mainUI.getY() + 15;
        } else {
            x = mainUI.getX() + (mainUI.getWidth() - width);
            y = mainUI.getY() + (mainUI.getHeight() - height);
        }
        ui.setLocation(x, y);
    }

    protected void setSize(MainUI mainUI) {
        // Better to let his own size to the action progress bar
        // see http://forge.codelutin.com/issues/3263
//        Container component = mainUI.getBody();
//        int width = component == null ? 0 : component.getWidth();

        ui.pack();

//        if (width != 0 && ui.getWidth() < width) {
//            ui.setSize(width, ui.getHeight());
//        }
    }
}
