package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.TableViewMode;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static fr.ifremer.tutti.ui.swing.util.TuttiUIUtil.getWeightStringValue;
import static org.nuiton.i18n.I18n._;

public class SpeciesBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<SpeciesBatchUIModel, SpeciesBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREATE_SPECIES_BATCH_BUTTON_ENABLED = "createSpeciesBatchButton.enabled";
    public static final String BINDING_CREATE_SPECIES_MELAG_MENU_ENABLED = "createSpeciesMelagMenu.enabled";
    public static final String BINDING_EDIT_FREQUENCIES_MENU_ENABLED = "editFrequenciesMenu.enabled";
    public static final String BINDING_FILTER_SPECIES_BATCH_ALL_BUTTON_SELECTED = "filterSpeciesBatchAllButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_LEAF_BUTTON_SELECTED = "filterSpeciesBatchLeafButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_SELECTED = "filterSpeciesBatchRootButton.selected";
    public static final String BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_TEXT = "filterSpeciesBatchRootButton.text";
    public static final String BINDING_REMOVE_SPECIES_BATCH_MENU_ENABLED = "removeSpeciesBatchMenu.enabled";
    public static final String BINDING_REMOVE_SPECIES_SUB_BATCH_MENU_ENABLED = "removeSpeciesSubBatchMenu.enabled";
    public static final String BINDING_RENAME_SPECIES_BATCH_MENU_ENABLED = "renameSpeciesBatchMenu.enabled";
    public static final String BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_BEAN = "speciesTotalInertWeightField.bean";
    public static final String BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_MODEL = "speciesTotalInertWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalInertWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_BEAN = "speciesTotalLivingNotItemizedWeightField.bean";
    public static final String BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_MODEL = "speciesTotalLivingNotItemizedWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalLivingNotItemizedWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT = "speciesTotalSampleSortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_BEAN = "speciesTotalSortedWeightField.bean";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL = "speciesTotalSortedWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalSortedWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "speciesTotalUnsortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_WEIGHT_FIELD_TEXT = "speciesTotalWeightField.text";
    public static final String BINDING_SPLIT_SPECIES_BATCH_MENU_ENABLED = "splitSpeciesBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SpeciesBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton createSpeciesBatchButton;
    protected JMenuItem createSpeciesMelagMenu;
    protected JMenuItem editFrequenciesMenu;
    protected SpeciesBatchUI editSpeciesBatchTopPanel = this;
    protected JButton exportMultiPostButton;
    protected JRadioButton filterSpeciesBatchAllButton;
    protected JLabel filterSpeciesBatchLabel;
    protected JRadioButton filterSpeciesBatchLeafButton;
    protected JAXXButtonGroup filterSpeciesBatchMode;
    protected JRadioButton filterSpeciesBatchRootButton;
    protected JPanel filterTablePane;
    protected Table form;
    protected SpeciesBatchUIHandler handler;
    protected JButton importMultiPostButton;
    protected JButton importPupitriButton;
    protected SpeciesBatchUIModel model;
    protected JMenuItem removeSpeciesBatchMenu;
    protected JMenuItem removeSpeciesSubBatchMenu;
    protected JMenuItem renameSpeciesBatchMenu;
    protected JToolBar speciesBatchTabToolBar;
    protected TuttiComputedOrNotDataEditor speciesTotalInertWeightField;
    protected JLabel speciesTotalInertWeightLabel;
    protected TuttiComputedOrNotDataEditor speciesTotalLivingNotItemizedWeightField;
    protected JLabel speciesTotalLivingNotItemizedWeightLabel;
    protected JTextField speciesTotalSampleSortedWeightField;
    protected JLabel speciesTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalSortedWeight",  editorName = "speciesTotalSortedWeightField")
    protected TuttiComputedOrNotDataEditor speciesTotalSortedWeightField;
    protected JLabel speciesTotalSortedWeightLabel;
    protected JTextField speciesTotalUnsortedWeightField;
    protected JLabel speciesTotalUnsortedWeightLabel;
    protected JTextField speciesTotalWeightField;
    protected JLabel speciesTotalWeightLabel;
    protected JMenuItem splitSpeciesBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<SpeciesBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SpeciesBatchUI(EditCatchesUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            SpeciesBatchUIHandler handler = new SpeciesBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public SpeciesBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI() {
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__createSpeciesBatchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createBatch();
    }

    public void doActionPerformed__on__editFrequenciesMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.editFrequencies();
    }

    public void doActionPerformed__on__filterSpeciesBatchAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ALL);
    }

    public void doActionPerformed__on__filterSpeciesBatchLeafButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.LEAF);
    }

    public void doActionPerformed__on__filterSpeciesBatchRootButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ROOT);
    }

    public void doActionPerformed__on__splitSpeciesBatchMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.splitBatch();
    }

    public void doKeyPressed__on__table(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCreateSpeciesBatchButton() {
        return createSpeciesBatchButton;
    }

    public JMenuItem getCreateSpeciesMelagMenu() {
        return createSpeciesMelagMenu;
    }

    public JMenuItem getEditFrequenciesMenu() {
        return editFrequenciesMenu;
    }

    public JButton getExportMultiPostButton() {
        return exportMultiPostButton;
    }

    public JRadioButton getFilterSpeciesBatchAllButton() {
        return filterSpeciesBatchAllButton;
    }

    public JLabel getFilterSpeciesBatchLabel() {
        return filterSpeciesBatchLabel;
    }

    public JRadioButton getFilterSpeciesBatchLeafButton() {
        return filterSpeciesBatchLeafButton;
    }

    public JAXXButtonGroup getFilterSpeciesBatchMode() {
        return filterSpeciesBatchMode;
    }

    public JRadioButton getFilterSpeciesBatchRootButton() {
        return filterSpeciesBatchRootButton;
    }

    public JPanel getFilterTablePane() {
        return filterTablePane;
    }

    public Table getForm() {
        return form;
    }

    public SpeciesBatchUIHandler getHandler() {
        return handler;
    }

    public JButton getImportMultiPostButton() {
        return importMultiPostButton;
    }

    public JButton getImportPupitriButton() {
        return importPupitriButton;
    }

    public SpeciesBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveSpeciesBatchMenu() {
        return removeSpeciesBatchMenu;
    }

    public JMenuItem getRemoveSpeciesSubBatchMenu() {
        return removeSpeciesSubBatchMenu;
    }

    public JMenuItem getRenameSpeciesBatchMenu() {
        return renameSpeciesBatchMenu;
    }

    public JToolBar getSpeciesBatchTabToolBar() {
        return speciesBatchTabToolBar;
    }

    public TuttiComputedOrNotDataEditor getSpeciesTotalInertWeightField() {
        return speciesTotalInertWeightField;
    }

    public JLabel getSpeciesTotalInertWeightLabel() {
        return speciesTotalInertWeightLabel;
    }

    public TuttiComputedOrNotDataEditor getSpeciesTotalLivingNotItemizedWeightField() {
        return speciesTotalLivingNotItemizedWeightField;
    }

    public JLabel getSpeciesTotalLivingNotItemizedWeightLabel() {
        return speciesTotalLivingNotItemizedWeightLabel;
    }

    public JTextField getSpeciesTotalSampleSortedWeightField() {
        return speciesTotalSampleSortedWeightField;
    }

    public JLabel getSpeciesTotalSampleSortedWeightLabel() {
        return speciesTotalSampleSortedWeightLabel;
    }

    public TuttiComputedOrNotDataEditor getSpeciesTotalSortedWeightField() {
        return speciesTotalSortedWeightField;
    }

    public JLabel getSpeciesTotalSortedWeightLabel() {
        return speciesTotalSortedWeightLabel;
    }

    public JTextField getSpeciesTotalUnsortedWeightField() {
        return speciesTotalUnsortedWeightField;
    }

    public JLabel getSpeciesTotalUnsortedWeightLabel() {
        return speciesTotalUnsortedWeightLabel;
    }

    public JTextField getSpeciesTotalWeightField() {
        return speciesTotalWeightField;
    }

    public JLabel getSpeciesTotalWeightLabel() {
        return speciesTotalWeightLabel;
    }

    public JMenuItem getSplitSpeciesBatchMenu() {
        return splitSpeciesBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<SpeciesBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditSpeciesBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(speciesBatchTabToolBar);
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToFilterSpeciesBatchAllButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchAllButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchAllButton); }
    }

    protected void addChildrenToFilterSpeciesBatchLeafButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchLeafButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchLeafButton); }
    }

    protected void addChildrenToFilterSpeciesBatchRootButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterSpeciesBatchMode; filterSpeciesBatchRootButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterSpeciesBatchRootButton); }
    }

    protected void addChildrenToFilterTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        filterTablePane.add(filterSpeciesBatchLabel);
        filterTablePane.add(filterSpeciesBatchAllButton);
        filterTablePane.add(filterSpeciesBatchLeafButton);
        filterTablePane.add(filterSpeciesBatchRootButton);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(speciesTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSortedWeightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(speciesTotalSortedWeightField), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSampleSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalSampleSortedWeightField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalUnsortedWeightLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalUnsortedWeightField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalInertWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalInertWeightField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalLivingNotItemizedWeightLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(speciesTotalLivingNotItemizedWeightField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(tableToolbar, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToSpeciesBatchTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        speciesBatchTabToolBar.add(importPupitriButton);
        speciesBatchTabToolBar.add(importMultiPostButton);
        speciesBatchTabToolBar.add(exportMultiPostButton);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(splitSpeciesBatchMenu);
        tablePopup.add(removeSpeciesBatchMenu);
        tablePopup.add(removeSpeciesSubBatchMenu);
        tablePopup.add(renameSpeciesBatchMenu);
        tablePopup.add(createSpeciesMelagMenu);
        tablePopup.add(editFrequenciesMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
        tableToolbar.add(filterTablePane, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editSpeciesBatch.help"));
    }

    protected void createCreateSpeciesBatchButton() {
        $objectMap.put("createSpeciesBatchButton", createSpeciesBatchButton = new JButton());
        
        createSpeciesBatchButton.setName("createSpeciesBatchButton");
        createSpeciesBatchButton.setText(_("tutti.editSpeciesBatch.action.createBatch"));
        createSpeciesBatchButton.setToolTipText(_("tutti.editSpeciesBatch.action.createBatch.tip"));
        createSpeciesBatchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createSpeciesBatchButton"));
        createSpeciesBatchButton.putClientProperty("help", "tutti.editSpeciesBatch.action.createBatch.help");
    }

    protected void createCreateSpeciesMelagMenu() {
        $objectMap.put("createSpeciesMelagMenu", createSpeciesMelagMenu = new JMenuItem());
        
        createSpeciesMelagMenu.setName("createSpeciesMelagMenu");
        createSpeciesMelagMenu.setText(_("tutti.editSpeciesBatch.action.createMelag"));
        createSpeciesMelagMenu.setToolTipText(_("tutti.editSpeciesBatch.action.createMelag.tip"));
        createSpeciesMelagMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.createMelag.help");
        createSpeciesMelagMenu.putClientProperty("tuttiAction", CreateSpeciesMelagAction.class);
    }

    protected void createEditFrequenciesMenu() {
        $objectMap.put("editFrequenciesMenu", editFrequenciesMenu = new JMenuItem());
        
        editFrequenciesMenu.setName("editFrequenciesMenu");
        editFrequenciesMenu.setText(_("tutti.editSpeciesBatch.action.editFrequencies"));
        editFrequenciesMenu.setToolTipText(_("tutti.editSpeciesBatch.action.editFrequencies.tip"));
        editFrequenciesMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editFrequenciesMenu"));
        editFrequenciesMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.editFrequencies.help");
    }

    protected void createExportMultiPostButton() {
        $objectMap.put("exportMultiPostButton", exportMultiPostButton = new JButton());
        
        exportMultiPostButton.setName("exportMultiPostButton");
        exportMultiPostButton.setText(_("tutti.editSpeciesBatch.action.exportMultiPost"));
        exportMultiPostButton.setToolTipText(_("tutti.editSpeciesBatch.action.exportMultiPost.tip"));
        exportMultiPostButton.putClientProperty("help", "tutti.editSpeciesBatch.action.exportMultiPost.help");
        exportMultiPostButton.putClientProperty("tuttiAction", ExportMultiPostAction.class);
    }

    protected void createFilterSpeciesBatchAllButton() {
        $objectMap.put("filterSpeciesBatchAllButton", filterSpeciesBatchAllButton = new JRadioButton());
        
        filterSpeciesBatchAllButton.setName("filterSpeciesBatchAllButton");
        filterSpeciesBatchAllButton.setText(_("tutti.editSpeciesBatch.filterBatch.mode.all"));
        { filterSpeciesBatchAllButton.putClientProperty("$value", "all");  Object $buttonGroup = filterSpeciesBatchAllButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchAllButton.setToolTipText(_("tutti.editSpeciesBatch.filterBatch.mode.all.tip"));
        filterSpeciesBatchAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchAllButton"));
    }

    protected void createFilterSpeciesBatchLabel() {
        $objectMap.put("filterSpeciesBatchLabel", filterSpeciesBatchLabel = new JLabel());
        
        filterSpeciesBatchLabel.setName("filterSpeciesBatchLabel");
        filterSpeciesBatchLabel.setText(_("tutti.editSpeciesBatch.filterBatch"));
        filterSpeciesBatchLabel.setToolTipText(_("tutti.editSpeciesBatch.filterSpeciesBatch.tip"));
        filterSpeciesBatchLabel.putClientProperty("help", "tutti.editSpeciesBatch.filterSpeciesBatch.help");
        filterSpeciesBatchLabel.putClientProperty("strongStyle", true);
    }

    protected void createFilterSpeciesBatchLeafButton() {
        $objectMap.put("filterSpeciesBatchLeafButton", filterSpeciesBatchLeafButton = new JRadioButton());
        
        filterSpeciesBatchLeafButton.setName("filterSpeciesBatchLeafButton");
        filterSpeciesBatchLeafButton.setText(_("tutti.editSpeciesBatch.filterBatch.mode.leaf"));
        { filterSpeciesBatchLeafButton.putClientProperty("$value", "leaf");  Object $buttonGroup = filterSpeciesBatchLeafButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchLeafButton.setToolTipText(_("tutti.editSpeciesBatch.filterBatch.mode.leaf.tip"));
        filterSpeciesBatchLeafButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchLeafButton"));
    }

    protected void createFilterSpeciesBatchMode() {
        $objectMap.put("filterSpeciesBatchMode", filterSpeciesBatchMode = new JAXXButtonGroup());
    }

    protected void createFilterSpeciesBatchRootButton() {
        $objectMap.put("filterSpeciesBatchRootButton", filterSpeciesBatchRootButton = new JRadioButton());
        
        filterSpeciesBatchRootButton.setName("filterSpeciesBatchRootButton");
        { filterSpeciesBatchRootButton.putClientProperty("$value", "root");  Object $buttonGroup = filterSpeciesBatchRootButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterSpeciesBatchRootButton.setToolTipText(_("tutti.editSpeciesBatch.filterBatch.mode.root.tip"));
        filterSpeciesBatchRootButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterSpeciesBatchRootButton"));
    }

    protected void createFilterTablePane() {
        $objectMap.put("filterTablePane", filterTablePane = new JPanel());
        
        filterTablePane.setName("filterTablePane");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SpeciesBatchUIHandler.class));
    }

    protected void createImportMultiPostButton() {
        $objectMap.put("importMultiPostButton", importMultiPostButton = new JButton());
        
        importMultiPostButton.setName("importMultiPostButton");
        importMultiPostButton.setText(_("tutti.editSpeciesBatch.action.importMultiPost"));
        importMultiPostButton.setToolTipText(_("tutti.editSpeciesBatch.action.importMultiPost.tip"));
        importMultiPostButton.putClientProperty("help", "tutti.editSpeciesBatch.action.importMultiPost.help");
        importMultiPostButton.putClientProperty("tuttiAction", ImportMultiPostAction.class);
    }

    protected void createImportPupitriButton() {
        $objectMap.put("importPupitriButton", importPupitriButton = new JButton());
        
        importPupitriButton.setName("importPupitriButton");
        importPupitriButton.setText(_("tutti.editSpeciesBatch.action.importPupitri"));
        importPupitriButton.setToolTipText(_("tutti.editSpeciesBatch.action.importPupitri.tip"));
        importPupitriButton.putClientProperty("help", "tutti.editSpeciesBatch.action.importPupitri.help");
        importPupitriButton.putClientProperty("tuttiAction", ImportPupitriAction.class);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SpeciesBatchUIModel.class));
    }

    protected void createRemoveSpeciesBatchMenu() {
        $objectMap.put("removeSpeciesBatchMenu", removeSpeciesBatchMenu = new JMenuItem());
        
        removeSpeciesBatchMenu.setName("removeSpeciesBatchMenu");
        removeSpeciesBatchMenu.setText(_("tutti.editSpeciesBatch.action.removeBatch"));
        removeSpeciesBatchMenu.setToolTipText(_("tutti.editSpeciesBatch.action.removeBatch.tip"));
        removeSpeciesBatchMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.removeBatch.help");
        removeSpeciesBatchMenu.putClientProperty("tuttiAction", RemoveSpeciesBatchAction.class);
    }

    protected void createRemoveSpeciesSubBatchMenu() {
        $objectMap.put("removeSpeciesSubBatchMenu", removeSpeciesSubBatchMenu = new JMenuItem());
        
        removeSpeciesSubBatchMenu.setName("removeSpeciesSubBatchMenu");
        removeSpeciesSubBatchMenu.setText(_("tutti.editSpeciesBatch.action.removeSubBatch"));
        removeSpeciesSubBatchMenu.setToolTipText(_("tutti.editSpeciesBatch.action.removeSubBatch.tip"));
        removeSpeciesSubBatchMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.removeSubBatch.help");
        removeSpeciesSubBatchMenu.putClientProperty("tuttiAction", RemoveSpeciesSubBatchAction.class);
    }

    protected void createRenameSpeciesBatchMenu() {
        $objectMap.put("renameSpeciesBatchMenu", renameSpeciesBatchMenu = new JMenuItem());
        
        renameSpeciesBatchMenu.setName("renameSpeciesBatchMenu");
        renameSpeciesBatchMenu.setText(_("tutti.editSpeciesBatch.action.renameBatch"));
        renameSpeciesBatchMenu.setToolTipText(_("tutti.editSpeciesBatch.action.renameBatch.tip"));
        renameSpeciesBatchMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.renameBatch.help");
        renameSpeciesBatchMenu.putClientProperty("tuttiAction", RenameSpeciesBatchAction.class);
    }

    protected void createSpeciesBatchTabToolBar() {
        $objectMap.put("speciesBatchTabToolBar", speciesBatchTabToolBar = new JToolBar());
        
        speciesBatchTabToolBar.setName("speciesBatchTabToolBar");
        speciesBatchTabToolBar.setFloatable(false);
        speciesBatchTabToolBar.setOpaque(false);
        speciesBatchTabToolBar.setBorderPainted(false);
    }

    protected void createSpeciesTotalInertWeightField() {
        $objectMap.put("speciesTotalInertWeightField", speciesTotalInertWeightField = new TuttiComputedOrNotDataEditor(this));
        
        speciesTotalInertWeightField.setName("speciesTotalInertWeightField");
        speciesTotalInertWeightField.setDecimalNumber(3);
        speciesTotalInertWeightField.setUseFloat(true);
        speciesTotalInertWeightField.setShowReset(true);
        speciesTotalInertWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createSpeciesTotalInertWeightLabel() {
        $objectMap.put("speciesTotalInertWeightLabel", speciesTotalInertWeightLabel = new JLabel());
        
        speciesTotalInertWeightLabel.setName("speciesTotalInertWeightLabel");
        speciesTotalInertWeightLabel.setText(_("tutti.editSpeciesBatch.field.speciesTotalInertWeight"));
        speciesTotalInertWeightLabel.setToolTipText(_("tutti.editSpeciesBatch.field.speciesTotalInertWeight.tip"));
        speciesTotalInertWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalInertWeight.help");
        speciesTotalInertWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalLivingNotItemizedWeightField() {
        $objectMap.put("speciesTotalLivingNotItemizedWeightField", speciesTotalLivingNotItemizedWeightField = new TuttiComputedOrNotDataEditor(this));
        
        speciesTotalLivingNotItemizedWeightField.setName("speciesTotalLivingNotItemizedWeightField");
        speciesTotalLivingNotItemizedWeightField.setDecimalNumber(3);
        speciesTotalLivingNotItemizedWeightField.setUseFloat(true);
        speciesTotalLivingNotItemizedWeightField.setShowReset(true);
        speciesTotalLivingNotItemizedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createSpeciesTotalLivingNotItemizedWeightLabel() {
        $objectMap.put("speciesTotalLivingNotItemizedWeightLabel", speciesTotalLivingNotItemizedWeightLabel = new JLabel());
        
        speciesTotalLivingNotItemizedWeightLabel.setName("speciesTotalLivingNotItemizedWeightLabel");
        speciesTotalLivingNotItemizedWeightLabel.setText(_("tutti.editSpeciesBatch.field.speciesTotalLivingNotItemizedWeight"));
        speciesTotalLivingNotItemizedWeightLabel.setToolTipText(_("tutti.editSpeciesBatch.field.speciesTotalLivingNotItemizedWeight.tip"));
        speciesTotalLivingNotItemizedWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalLivingNotItemizedWeight.help");
        speciesTotalLivingNotItemizedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalSampleSortedWeightField() {
        $objectMap.put("speciesTotalSampleSortedWeightField", speciesTotalSampleSortedWeightField = new JTextField());
        
        speciesTotalSampleSortedWeightField.setName("speciesTotalSampleSortedWeightField");
        speciesTotalSampleSortedWeightField.setColumns(15);
        speciesTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalSampleSortedWeightLabel() {
        $objectMap.put("speciesTotalSampleSortedWeightLabel", speciesTotalSampleSortedWeightLabel = new JLabel());
        
        speciesTotalSampleSortedWeightLabel.setName("speciesTotalSampleSortedWeightLabel");
        speciesTotalSampleSortedWeightLabel.setText(_("tutti.editSpeciesBatch.field.speciesTotalSampleSortedWeight"));
        speciesTotalSampleSortedWeightLabel.setToolTipText(_("tutti.editSpeciesBatch.field.speciesTotalSampleSortedWeight.tip"));
        speciesTotalSampleSortedWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalSampleSortedWeight.help");
        speciesTotalSampleSortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalSortedWeightField() {
        $objectMap.put("speciesTotalSortedWeightField", speciesTotalSortedWeightField = new TuttiComputedOrNotDataEditor(this));
        
        speciesTotalSortedWeightField.setName("speciesTotalSortedWeightField");
        speciesTotalSortedWeightField.setDecimalNumber(3);
        speciesTotalSortedWeightField.setUseFloat(true);
        speciesTotalSortedWeightField.setShowReset(true);
        speciesTotalSortedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createSpeciesTotalSortedWeightLabel() {
        $objectMap.put("speciesTotalSortedWeightLabel", speciesTotalSortedWeightLabel = new JLabel());
        
        speciesTotalSortedWeightLabel.setName("speciesTotalSortedWeightLabel");
        speciesTotalSortedWeightLabel.setText(_("tutti.editSpeciesBatch.field.speciesTotalSortedWeight"));
        speciesTotalSortedWeightLabel.setToolTipText(_("tutti.editSpeciesBatch.field.speciesTotalSortedWeight.tip"));
        speciesTotalSortedWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalSortedWeight.help");
        speciesTotalSortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalUnsortedWeightField() {
        $objectMap.put("speciesTotalUnsortedWeightField", speciesTotalUnsortedWeightField = new JTextField());
        
        speciesTotalUnsortedWeightField.setName("speciesTotalUnsortedWeightField");
        speciesTotalUnsortedWeightField.setColumns(15);
        speciesTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalUnsortedWeightLabel() {
        $objectMap.put("speciesTotalUnsortedWeightLabel", speciesTotalUnsortedWeightLabel = new JLabel());
        
        speciesTotalUnsortedWeightLabel.setName("speciesTotalUnsortedWeightLabel");
        speciesTotalUnsortedWeightLabel.setText(_("tutti.editSpeciesBatch.field.speciesTotalUnsortedWeight"));
        speciesTotalUnsortedWeightLabel.setToolTipText(_("tutti.editSpeciesBatch.field.speciesTotalUnsortedWeight.tip"));
        speciesTotalUnsortedWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalUnsortedWeight.help");
        speciesTotalUnsortedWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSpeciesTotalWeightField() {
        $objectMap.put("speciesTotalWeightField", speciesTotalWeightField = new JTextField());
        
        speciesTotalWeightField.setName("speciesTotalWeightField");
        speciesTotalWeightField.setColumns(15);
        speciesTotalWeightField.putClientProperty("computed", true);
    }

    protected void createSpeciesTotalWeightLabel() {
        $objectMap.put("speciesTotalWeightLabel", speciesTotalWeightLabel = new JLabel());
        
        speciesTotalWeightLabel.setName("speciesTotalWeightLabel");
        speciesTotalWeightLabel.setText(_("tutti.editSpeciesBatch.field.speciesTotalWeight"));
        speciesTotalWeightLabel.setToolTipText(_("tutti.editSpeciesBatch.field.speciesTotalWeight.tip"));
        speciesTotalWeightLabel.putClientProperty("help", "tutti.editSpeciesBatch.field.speciesTotalWeight.help");
        speciesTotalWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getSpeciesWeightUnit());
    }

    protected void createSplitSpeciesBatchMenu() {
        $objectMap.put("splitSpeciesBatchMenu", splitSpeciesBatchMenu = new JMenuItem());
        
        splitSpeciesBatchMenu.setName("splitSpeciesBatchMenu");
        splitSpeciesBatchMenu.setText(_("tutti.editSpeciesBatch.action.splitBatch"));
        splitSpeciesBatchMenu.setToolTipText(_("tutti.editSpeciesBatch.action.splitBatch.tip"));
        splitSpeciesBatchMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__splitSpeciesBatchMenu"));
        splitSpeciesBatchMenu.putClientProperty("help", "tutti.editSpeciesBatch.action.splitBatch.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editSpeciesBatch.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SpeciesBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditSpeciesBatchTopPanel();
        addChildrenToValidator();
        addChildrenToSpeciesBatchTabToolBar();
        addChildrenToTablePopup();
        addChildrenToForm();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createSpeciesBatchButton);
        addChildrenToFilterTablePane();
        addChildrenToFilterSpeciesBatchAllButton();
        addChildrenToFilterSpeciesBatchLeafButton();
        addChildrenToFilterSpeciesBatchRootButton();
        addChildrenToTableScrollPane();
        
        // apply 23 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 43 property setters
        importPupitriButton.setIcon(SwingUtil.createActionIcon("pupitri-import"));
        importPupitriButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editSpeciesBatch.action.importPupitri.mnemonic"),'Z'));
        importMultiPostButton.setIcon(SwingUtil.createActionIcon("import"));
        importMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editSpeciesBatch.action.importMultiPost.mnemonic"),'Z'));
        exportMultiPostButton.setIcon(SwingUtil.createActionIcon("export"));
        exportMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editSpeciesBatch.action.exportMultiPost.mnemonic"),'Z'));
        splitSpeciesBatchMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        splitSpeciesBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editSpeciesBatch.action.splitBatch.mnemonic"),'Z'));
        removeSpeciesBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeSpeciesBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editSpeciesBatch.action.removeBatch.mnemonic"),'Z'));
        removeSpeciesSubBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeSpeciesSubBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editSpeciesBatch.action.removeSubBatch.mnemonic"),'Z'));
        renameSpeciesBatchMenu.setIcon(SwingUtil.createActionIcon("batch-rename"));
        renameSpeciesBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editSpeciesBatch.action.renameBatch.mnemonic"),'Z'));
        createSpeciesMelagMenu.setIcon(SwingUtil.createActionIcon("batch-rename"));
        createSpeciesMelagMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editSpeciesBatch.action.createMelag.mnemonic"),'Z'));
        editFrequenciesMenu.setIcon(SwingUtil.createActionIcon("show-frequency"));
        editFrequenciesMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editSpeciesBatch.action.editFrequencies.mnemonic"),'Z'));
        speciesTotalWeightLabel.setLabelFor(speciesTotalWeightField);
        speciesTotalSortedWeightLabel.setLabelFor(speciesTotalSortedWeightField);
        speciesTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalSortedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        speciesTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalSampleSortedWeightLabel.setLabelFor(speciesTotalSampleSortedWeightField);
        speciesTotalUnsortedWeightLabel.setLabelFor(speciesTotalUnsortedWeightField);
        speciesTotalInertWeightLabel.setLabelFor(speciesTotalInertWeightField);
        speciesTotalInertWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalInertWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        speciesTotalInertWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalLivingNotItemizedWeightLabel.setLabelFor(speciesTotalLivingNotItemizedWeightField);
        speciesTotalLivingNotItemizedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalLivingNotItemizedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        speciesTotalLivingNotItemizedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        createSpeciesBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        createSpeciesBatchButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editSpeciesBatch.action.createBatch.mnemonic"),'Z'));
        filterTablePane.setBorder(new TitledBorder(null, ""));
        filterSpeciesBatchLabel.setIcon(SwingUtil.createActionIcon("filter"));
        table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editSpeciesBatchTopPanel, "tutti.editSpeciesBatch.help");
        registerHelpId(_broker, importPupitriButton, "tutti.editSpeciesBatch.action.importPupitri.help");
        registerHelpId(_broker, importMultiPostButton, "tutti.editSpeciesBatch.action.importMultiPost.help");
        registerHelpId(_broker, exportMultiPostButton, "tutti.editSpeciesBatch.action.exportMultiPost.help");
        registerHelpId(_broker, splitSpeciesBatchMenu, "tutti.editSpeciesBatch.action.splitBatch.help");
        registerHelpId(_broker, removeSpeciesBatchMenu, "tutti.editSpeciesBatch.action.removeBatch.help");
        registerHelpId(_broker, removeSpeciesSubBatchMenu, "tutti.editSpeciesBatch.action.removeSubBatch.help");
        registerHelpId(_broker, renameSpeciesBatchMenu, "tutti.editSpeciesBatch.action.renameBatch.help");
        registerHelpId(_broker, createSpeciesMelagMenu, "tutti.editSpeciesBatch.action.createMelag.help");
        registerHelpId(_broker, editFrequenciesMenu, "tutti.editSpeciesBatch.action.editFrequencies.help");
        registerHelpId(_broker, speciesTotalWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalWeight.help");
        registerHelpId(_broker, speciesTotalSortedWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalSortedWeight.help");
        registerHelpId(_broker, speciesTotalSampleSortedWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalSampleSortedWeight.help");
        registerHelpId(_broker, speciesTotalUnsortedWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalUnsortedWeight.help");
        registerHelpId(_broker, speciesTotalInertWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalInertWeight.help");
        registerHelpId(_broker, speciesTotalLivingNotItemizedWeightLabel, "tutti.editSpeciesBatch.field.speciesTotalLivingNotItemizedWeight.help");
        registerHelpId(_broker, createSpeciesBatchButton, "tutti.editSpeciesBatch.action.createBatch.help");
        registerHelpId(_broker, filterSpeciesBatchLabel, "tutti.editSpeciesBatch.filterSpeciesBatch.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editSpeciesBatchTopPanel", editSpeciesBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createSpeciesBatchTabToolBar();
        createImportPupitriButton();
        createImportMultiPostButton();
        createExportMultiPostButton();
        createTablePopup();
        createSplitSpeciesBatchMenu();
        createRemoveSpeciesBatchMenu();
        createRemoveSpeciesSubBatchMenu();
        createRenameSpeciesBatchMenu();
        createCreateSpeciesMelagMenu();
        createEditFrequenciesMenu();
        createForm();
        createSpeciesTotalWeightLabel();
        createSpeciesTotalWeightField();
        createSpeciesTotalSortedWeightLabel();
        createSpeciesTotalSortedWeightField();
        createSpeciesTotalSampleSortedWeightLabel();
        createSpeciesTotalSampleSortedWeightField();
        createSpeciesTotalUnsortedWeightLabel();
        createSpeciesTotalUnsortedWeightField();
        createSpeciesTotalInertWeightLabel();
        createSpeciesTotalInertWeightField();
        createSpeciesTotalLivingNotItemizedWeightLabel();
        createSpeciesTotalLivingNotItemizedWeightField();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateSpeciesBatchButton();
        createFilterTablePane();
        createFilterSpeciesBatchLabel();
        createFilterSpeciesBatchAllButton();
        createFilterSpeciesBatchLeafButton();
        createFilterSpeciesBatchRootButton();
        createTableScrollPane();
        createTable();
        createFilterSpeciesBatchMode();
        // inline creation of editSpeciesBatchTopPanel
        setName("editSpeciesBatchTopPanel");
        setLayout(new BorderLayout());
        editSpeciesBatchTopPanel.putClientProperty("help", "tutti.editSpeciesBatch.help");
        
        // registers 23 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 23 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPLIT_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("splitBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    splitSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isSplitBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("splitBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_SPECIES_SUB_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeSubBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeSpeciesSubBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveSubBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeSubBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RENAME_SPECIES_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("renameBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    renameSpeciesBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRenameBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("renameBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_SPECIES_MELAG_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("createMelagEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    createSpeciesMelagMenu.setEnabled(!model.isTableViewModeLeaf() && model.isCreateMelagEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("createMelagEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_FREQUENCIES_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("editFrequenciesEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editFrequenciesMenu.setEnabled(model.isTableViewModeAll() && model.isEditFrequenciesEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("editFrequenciesEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalWeightField, getWeightStringValue(model.getSpeciesTotalComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setModel(model.getSpeciesTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setBean(model.getSpeciesTotalSortedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalSortedWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSampleSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalSampleSortedWeightField, getWeightStringValue(model.getSpeciesTotalSampleSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSampleSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalUnsortedWeightField, getWeightStringValue(model.getSpeciesTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalInertWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalInertWeightField.setModel(model.getSpeciesTotalInertWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalInertWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalInertComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalInertWeightField.setBean(model.getSpeciesTotalInertComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalInertComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_INERT_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalInertWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalLivingNotItemizedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalLivingNotItemizedWeightField.setModel(model.getSpeciesTotalLivingNotItemizedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalLivingNotItemizedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalLivingNotItemizedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalLivingNotItemizedWeightField.setBean(model.getSpeciesTotalLivingNotItemizedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalLivingNotItemizedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalLivingNotItemizedWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_SPECIES_BATCH_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("createBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    createSpeciesBatchButton.setEnabled(model.isCreateBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("createBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ALL_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchAllButton.setSelected(model.isTableViewModeAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_LEAF_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchLeafButton.setSelected(model.isTableViewModeLeaf());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rootNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchRootButton.setText(_(handler.getFilterSpeciesBatchRootButtonText(model.getRootNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rootNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_SPECIES_BATCH_ROOT_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeRoot", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterSpeciesBatchRootButton.setSelected(model.isTableViewModeRoot());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeRoot", this);
                }
            }
        });
    }

}