/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import liquibase.change.AbstractChange;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.SQLiteDatabase;
import liquibase.database.structure.Index;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DropColumnStatement;
import liquibase.statement.core.ReorganizeTableStatement;
import liquibase.util.StringUtils;

public class DropColumnChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String columnName;

    public DropColumnChange() {
        super("dropColumn", "Drop Column", 1);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public SqlStatement[] generateStatements(Database database) {
        ArrayList<AbstractSqlStatement> statements = new ArrayList<AbstractSqlStatement>();
        String schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        statements.add(new DropColumnStatement(schemaName, this.getTableName(), this.getColumnName()));
        if (database instanceof DB2Database) {
            statements.add(new ReorganizeTableStatement(schemaName, this.getTableName()));
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor rename_alter_visitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            public boolean createThisColumn(ColumnConfig column) {
                return !column.getName().equals(DropColumnChange.this.getColumnName());
            }

            public boolean copyThisColumn(ColumnConfig column) {
                return !column.getName().equals(DropColumnChange.this.getColumnName());
            }

            public boolean createThisIndex(Index index) {
                return !index.getColumns().contains(DropColumnChange.this.getColumnName());
            }
        };
        try {
            statements.addAll(SQLiteDatabase.getAlterTableStatements(rename_alter_visitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    public String getConfirmationMessage() {
        return "Column " + this.getTableName() + "." + this.getColumnName() + " dropped";
    }
}

