/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.caracteristics;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapCellComponent;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapColumnRowModel;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorRowModel;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorTableModel;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorUI;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorUIModel;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueEditor;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueRenderer;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class CaracteristicMapEditorUIHandler
extends AbstractTuttiTableUIHandler<CaracteristicMapEditorRowModel, CaracteristicMapEditorUIModel, CaracteristicMapEditorUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(CaracteristicMapEditorUIHandler.class);
    protected CaracteristicMapCellComponent.CaracteristicMapCellEditor caracteristicMapCellEditor;

    public CaracteristicMapEditorUIHandler(TuttiUI parentUi, CaracteristicMapEditorUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui, "value");
    }

    public CaracteristicMapEditorTableModel getTableModel() {
        return (CaracteristicMapEditorTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((CaracteristicMapEditorUI)this.ui).getCaracteristicMapEditorTable();
    }

    @Override
    protected boolean isRowValid(CaracteristicMapEditorRowModel row) {
        return row.getKey() != null && row.getValue() != null;
    }

    @Override
    protected void onRowModified(int rowIndex, CaracteristicMapEditorRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        super.onRowModified(rowIndex, row, propertyName, oldValue, newValue);
        this.saveSelectedRowIfNeeded();
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, CaracteristicMapEditorRowModel oldRow, int newRowIndex, CaracteristicMapEditorRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        ((CaracteristicMapEditorUIModel)this.getModel()).setRemoveCaracteristicEnabled(newRowIndex >= 0);
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<CaracteristicMapEditorRowModel> rowMonitor, CaracteristicMapEditorRowModel row) {
        if (row.isValid() && rowMonitor.wasModified()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Row " + row + " was modified, will save it"));
            }
            this.saveRow(row);
        }
    }

    @Override
    public void beforeInitUI() {
        CaracteristicMapEditorUIModel model = new CaracteristicMapEditorUIModel();
        ((CaracteristicMapEditorUI)this.getUI()).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI((TuttiUI)this.getUI());
        this.initBeanFilterableComboBox(this.getKeyCombo(), Lists.newArrayList(), null);
        ((CaracteristicMapEditorUIModel)this.getModel()).setAvailableCaracteristics(Lists.newArrayList((Iterable)this.getDataContext().getCaracteristicWithProtected()));
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Caracteristic.class, "withUnit"), CaracteristicMapEditorTableModel.KEY);
        this.addColumnToModel((TableColumnModel)columnModel, new CaracteristicValueEditor(this.context), new CaracteristicValueRenderer(this.context), CaracteristicMapEditorTableModel.VALUE);
        CaracteristicMapEditorTableModel tableModel = new CaracteristicMapEditorTableModel((TableColumnModelExt)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((CaracteristicMapEditorUI)this.getUI()).getNewRowKey();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.caracteristicMapCellEditor.closeEditor();
    }

    @Override
    public SwingValidator<CaracteristicMapEditorUIModel> getValidator() {
        return null;
    }

    @Override
    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cancel UI " + this.ui));
        }
        this.closeUI(this.ui);
    }

    protected BeanFilterableComboBox<Caracteristic> getKeyCombo() {
        return ((CaracteristicMapEditorUI)this.ui).getNewRowKey();
    }

    protected void saveRow(CaracteristicMapEditorRowModel row) {
        if (row.isValid()) {
            CaracteristicMap caracteristics = ((CaracteristicMapEditorUIModel)this.getModel()).getCaracteristicMap();
            Preconditions.checkNotNull((Object)caracteristics);
            caracteristics.put(row.getKey(), row.getValue());
        }
    }

    public void addRow() {
        BeanFilterableComboBox<Caracteristic> keyCombo = this.getKeyCombo();
        Caracteristic selectedItem = (Caracteristic)keyCombo.getSelectedItem();
        CaracteristicMapEditorTableModel tableModel = this.getTableModel();
        CaracteristicMapEditorRowModel row = tableModel.createNewRow();
        row.setKey(selectedItem);
        ((CaracteristicMapEditorUIModel)this.getModel()).getRows().add(row);
        int rowIndex = tableModel.getRowCount() - 1;
        tableModel.fireTableRowsInserted(rowIndex, rowIndex);
        keyCombo.getHandler().removeItem((Object)selectedItem);
        CaracteristicMapEditorUIModel model = (CaracteristicMapEditorUIModel)this.getModel();
        model.setModify(true);
        this.recomputeRowValidState(row);
    }

    public void editBatch(CaracteristicMapColumnRowModel caracteristicMapColumnRowModel, CaracteristicMapCellComponent.CaracteristicMapCellEditor caracteristicMapCellEditor, Set<Caracteristic> caracteristicsUsed) {
        this.caracteristicMapCellEditor = caracteristicMapCellEditor;
        CaracteristicMapEditorTableModel tableModel = this.getTableModel();
        CaracteristicMapEditorUIModel model = (CaracteristicMapEditorUIModel)this.getModel();
        CaracteristicMap caracteristicMap = caracteristicMapColumnRowModel.getCaracteristics();
        if (MapUtils.isEmpty((Map)caracteristicMap)) {
            caracteristicMap = new CaracteristicMap();
            caracteristicMap.putAll(Maps.asMap(caracteristicsUsed, (Function)Functions.constant((Object)null)));
        }
        model.setCaracteristicMap(caracteristicMap);
        ArrayList rows = Lists.newArrayList();
        ArrayList caracteristics = Lists.newArrayList(caracteristicMap.keySet());
        List<Caracteristic> availableCaracteristics = model.getAvailableCaracteristics();
        for (Caracteristic key : caracteristics) {
            CaracteristicMapEditorRowModel newRow = tableModel.createNewRow();
            newRow.setKey(key);
            newRow.setValue((Serializable)caracteristicMap.get(key));
            rows.add(newRow);
        }
        model.setRows(rows);
        caracteristics.add(caracteristicMapColumnRowModel.getLengthStepCaracteristic());
        ArrayList caracteristicList = Lists.newArrayList();
        for (Caracteristic caracteristic : availableCaracteristics) {
            if (caracteristics.contains(caracteristic)) continue;
            caracteristicList.add(caracteristic);
        }
        BeanFilterableComboBox<Caracteristic> keyCombo = this.getKeyCombo();
        keyCombo.setData((List)caracteristicList);
        keyCombo.getHandler().reset();
        model.setModify(false);
    }

    public void removeCaracteristic() {
        int rowIndex = this.getTable().getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove caracteristic if no caracteristic selected");
        CaracteristicMapEditorRowModel row = (CaracteristicMapEditorRowModel)this.getTableModel().getEntry(rowIndex);
        CaracteristicMap caracteristicMap = ((CaracteristicMapEditorUIModel)this.getModel()).getCaracteristicMap();
        if (caracteristicMap != null) {
            caracteristicMap.remove(row.getKey());
        }
        BeanFilterableComboBox<Caracteristic> keyCombo = this.getKeyCombo();
        keyCombo.addItem((Object)row.getKey());
        keyCombo.getHandler().reset();
        ((CaracteristicMapEditorUIModel)this.getModel()).getRows().remove(rowIndex);
        this.getTableModel().fireTableRowsDeleted(rowIndex, rowIndex);
        ((CaracteristicMapEditorUIModel)this.getModel()).removeRowInError(row);
    }

    public void save() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save UI " + this.ui));
        }
        this.caracteristicMapCellEditor.validateEdition((CaracteristicMapEditorUIModel)this.getModel());
        this.closeUI(this.ui);
    }
}

