/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.multipost.TuttiMultiPostImportService;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import java.io.File;
import org.jdesktop.beans.AbstractBean;

public abstract class AbstractImportMultiPostAction<M extends AbstractBean, UI extends TuttiUI<M, ?>, H extends AbstractTuttiUIHandler<M, UI>>
extends AbstractTuttiAction<M, UI, H> {
    protected File file;
    protected EditFishingOperationAction editAction;
    protected TuttiMultiPostImportService multiPostImportExportService = this.getContext().getMultiPostImportService();

    public AbstractImportMultiPostAction(H handler) {
        super(handler, false);
    }

    public EditFishingOperationAction getEditAction() {
        FishingOperationsUI parentUI = (FishingOperationsUI)this.getUI().getParentContainer(FishingOperationsUI.class);
        if (this.editAction == null) {
            this.editAction = TuttiActionHelper.createLogicAction(parentUI.getHandler(), EditFishingOperationAction.class);
        }
        return this.editAction;
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.chooseFile(this.getFileChooserTitle(), this.getFileChooserButton(), "^.*\\." + this.getFileExtension(), this.getFileExtensionDescription());
            doAction = this.file != null;
        }
        return doAction;
    }

    protected abstract String getFileExtension();

    protected abstract String getFileExtensionDescription();

    protected abstract String getFileChooserTitle();

    protected abstract String getFileChooserButton();

    @Override
    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        EditCatchesUI editCatchesUI = (EditCatchesUI)this.getUI().getParentContainer(EditCatchesUI.class);
        EditCatchesUIModel editCatchesUIModel = editCatchesUI.getModel();
        FishingOperation operation = editCatchesUIModel.getFishingOperation();
        this.importBatches(operation);
        this.getEditAction().loadCatchBatch(operation);
    }

    protected abstract void importBatches(FishingOperation var1);
}

