package fr.ifremer.tutti.ui.swing.util.table;

/*
 * #%L
 * Tutti :: UI
 * $Id: MoveToPreviousEditableRowAction.java 1160 2013-07-27 21:21:41Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.4/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/table/MoveToPreviousEditableRowAction.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JTable;
import java.awt.event.ActionEvent;

/**
 * Action to select previous editable row in a table.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class MoveToPreviousEditableRowAction<M extends AbstractTuttiTableModel> extends AbstractSelectTableAction<M> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(MoveToPreviousEditableRowAction.class);

    public static <M extends AbstractTuttiTableModel> MoveToPreviousEditableRowAction<M> newAction(M model, JTable table) {
        return new MoveToPreviousEditableRowAction<M>(model, table);
    }

    protected MoveToPreviousEditableRowAction(M model, JTable table) {
        super(model, table);
    }

    @Override
    public void actionPerformed(ActionEvent e) {

        int currentRow = getSelectedRow();
        int currentColumn = getSelectedColumn();

        if (log.isDebugEnabled()) {
            log.debug("Move to previous row editable cell " +
                      getCellCoordinate(currentRow, currentColumn));
        }

        int rowCount = getRowCount();

        // I commented the part of the code to skip the not editable cells (ref #2704)
//        while (currentRow > 0) {
        if (currentRow > 0) {

            // go to next cell
            currentRow--;
//            boolean canSelect = isCellEditable(currentRow, currentColumn);
//
//            if (canSelect) {
            doSelectCell(currentRow, currentColumn);

//                break;
//            } else {
//                if (log.isDebugEnabled()) {
//                    log.debug("Cell not editable at " +
//                                      getCellCoordinate(currentRow, currentColumn));
//                }
//            }
        }
    }
}
