package fr.ifremer.tutti.ui.swing.content.protocol;

/*
 * #%L
 * Tutti :: UI
 * $Id: RemoveSpeciesProtocolAction.java 1170 2013-09-13 16:21:34Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.4/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/protocol/RemoveSpeciesProtocolAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;

import javax.swing.JTable;
import java.util.Collections;
import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * To add a new species protocol.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class RemoveSpeciesProtocolAction extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {

    public RemoveSpeciesProtocolAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {

        JTable table = handler.getSpeciesTable();

        int rowIndex = table.getSelectedRow();

        Preconditions.checkState(rowIndex != -1,
                                 "Cant remove species if no species selected");

        EditProtocolSpeciesTableModel tableModel = handler.getSpeciesTableModel();

        EditProtocolSpeciesRowModel selectedRow = tableModel.getEntry(rowIndex);

        // re-add all synonym of this taxon to the species / benthos combobox
        Species species = selectedRow.getSpecies();
        getUI().getBenthosComboBox().addItem(species);
        getUI().getSpeciesComboBox().addItem(species);

        EditProtocolUIModel model = getModel();
        Integer taxonId = species.getReferenceTaxonId();
        List<Species> allSynonyms = Lists.newArrayList(
                model.getAllSynonyms(String.valueOf(taxonId)));
        allSynonyms.remove(species);
        model.getAllSynonyms().addAll(allSynonyms);
        // reorder the list by name, otherwise,
        // all the species without a reftax code will be at the end
        Collections.sort(model.getAllSynonyms(), TuttiEntities.SPECIES_BY_NAME_COMPARATOR);

        table.clearSelection();
        // remove the row from the model(do it after treating the comboBox which can be long)
        tableModel.removeRow(rowIndex);

        String speciesStr = decorate(selectedRow.getSpecies());
        sendMessage(_("tutti.flash.info.species.remove.from.protocol",
                      speciesStr));
    }

}
