package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.TabContentModel;
import org.apache.commons.collections.CollectionUtils;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.4
 */
public class IndividualObservationBatchUIModel extends AbstractTuttiBatchUIModel<IndividualObservationBatchRowModel, IndividualObservationBatchUIModel>
        implements TabContentModel {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_REMOVE_BATCH_ENABLED = "removeBatchEnabled";

    /** Can user remove a selected batch? */
    protected boolean removeBatchEnabled;

    public IndividualObservationBatchUIModel(EditCatchesUIModel catchesUIModel) {
        super(catchesUIModel,
              EditCatchesUIModel.PROPERTY_BATCH_UPDATED);
    }

    public boolean isRemoveBatchEnabled() {
        return removeBatchEnabled;
    }

    public void setRemoveBatchEnabled(boolean removeBatchEnabled) {
        Object oldValue = isRemoveBatchEnabled();
        this.removeBatchEnabled = removeBatchEnabled;
        firePropertyChange(PROPERTY_REMOVE_BATCH_ENABLED, oldValue, removeBatchEnabled);
    }

    public Species getLastSpeciesUsed() {
        Species result = null;
        if (!rows.isEmpty()) {
            result = rows.get(rows.size() - 1).getSpecies();
        }
        return result;
    }

    public Caracteristic getLastLengthStepCaracteristicUsed() {
        Caracteristic result = null;
        if (!rows.isEmpty()) {
            result = rows.get(rows.size() - 1).getLengthStepCaracteristic();
        }
        return result;
    }

    //------------------------------------------------------------------------//
    //-- TabContentModel                                                    --//
    //------------------------------------------------------------------------//

    @Override
    public boolean isEmpty() {
        boolean result = true;
        if (CollectionUtils.isNotEmpty(getRows())) {

            // check if every line is not valid
            for (IndividualObservationBatchRowModel row : rows) {
                if (row.isValid()) {

                    // found a valid row so not empty
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public String getTitle() {
        return n_("tutti.label.tab.individualObservations");
    }

    @Override
    public String getIcon() {
        return null;
    }
}
