/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.config;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicBean;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.config.SampleOrderButton;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class SampleOrderIdsTableCell {
    protected final Decorator<CaracteristicBean> decorator;
    protected final Map<Integer, SampleCategoryEnum> mapping;
    protected final Map<Integer, Caracteristic> caracteristicMap;
    private final TuttiUIContext context;

    public SampleOrderIdsTableCell(TuttiUIContext context) {
        this.context = context;
        this.mapping = SampleCategoryEnum.toIdMapping();
        this.caracteristicMap = Maps.newTreeMap();
        PersistenceService persistenceService = context.getPersistenceService();
        this.caracteristicMap.put(SampleCategoryEnum.size.getFieldValue(), persistenceService.getSizeCategoryCaracteristic());
        this.caracteristicMap.put(SampleCategoryEnum.sex.getFieldValue(), persistenceService.getSexCaracteristic());
        this.caracteristicMap.put(SampleCategoryEnum.maturity.getFieldValue(), persistenceService.getMaturityCaracteristic());
        this.caracteristicMap.put(SampleCategoryEnum.age.getFieldValue(), persistenceService.getAgeCaracteristic());
        this.decorator = context.getDecoratorService().getDecoratorByType(CaracteristicBean.class, "parameterOnly");
    }

    public TableCellEditor getNewTableCellEditor() {
        return new SampleOrderCellEditor(this.context);
    }

    public TableCellRenderer getNewTableCellRenderer() {
        return new SamplingOrderIdsTableCellRenderer();
    }

    public class SampleOrderCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        protected Integer rowIndex;
        protected Integer columnIndex;
        protected final SampleOrderButton editorButton;

        protected SampleOrderCellEditor(TuttiUIContext context) {
            this.editorButton = new SampleOrderButton(context, null);
            this.editorButton.setBorder(new LineBorder(Color.BLACK));
            this.addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingStopped(ChangeEvent e) {
                    SampleOrderCellEditor.this.editorButton.setSelected(false);
                }

                @Override
                public void editingCanceled(ChangeEvent e) {
                    SampleOrderCellEditor.this.editorButton.setSelected(false);
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Integer[] ids = (Integer[])value;
            this.rowIndex = row;
            this.columnIndex = column;
            ArrayList result = Lists.newArrayList();
            for (Integer id : ids) {
                SampleCategoryEnum sampleCategoryEnum = SampleOrderIdsTableCell.this.mapping.get(id);
                if (sampleCategoryEnum == null) {
                    throw new TuttiTechnicalException(I18n._((String)"tutti.sampleOrder.caracteristicNotFound", (Object[])new Object[]{id}));
                }
                Caracteristic caracteristic = SampleOrderIdsTableCell.this.caracteristicMap.get(id);
                result.add(caracteristic);
            }
            this.editorButton.init(result);
            return this.editorButton;
        }

        @Override
        public Object getCellEditorValue() {
            ArrayList l = Lists.newArrayList();
            List<Caracteristic> model = this.editorButton.getBean();
            for (Caracteristic caracteristic : model) {
                String id = caracteristic.getId();
                l.add(Integer.valueOf(id));
            }
            return l.toArray(new Integer[l.size()]);
        }

        @Override
        public boolean stopCellEditing() {
            boolean b = super.stopCellEditing();
            if (b) {
                this.editorButton.setSelected(false);
            }
            return b;
        }

        @Override
        public void cancelCellEditing() {
            this.editorButton.setSelected(false);
            super.cancelCellEditing();
        }
    }

    protected class SamplingOrderIdsTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        protected SamplingOrderIdsTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Integer[] ids = (Integer[])value;
            ArrayList texts = Lists.newArrayListWithCapacity((int)ids.length);
            for (Integer id : ids) {
                Caracteristic caracteristic = SampleOrderIdsTableCell.this.caracteristicMap.get(id);
                texts.add(SampleOrderIdsTableCell.this.decorator.toString((Object)caracteristic));
            }
            String text = Joiner.on((String)",").join((Iterable)texts);
            return super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
        }
    }
}

