/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export;

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.export.CatchExportRow;
import fr.ifremer.tutti.service.export.ExportSampleCategory;
import fr.ifremer.tutti.service.export.TuttiExportService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.util.csv.ValueFormatter;

public class CatchExportModel
extends TuttiCsvUtil.AbstractTuttiExportModel<CatchExportRow> {
    public static final String WEIGHT_OR_VOL_TYPE = "Poids";
    Map<SampleCategoryEnum, Caracteristic> sampleCategoryToCaracteristics;

    public CatchExportModel(char separator, List<SampleCategoryEnum> samplingOrder, Map<SampleCategoryEnum, Caracteristic> sampleCategoryToCaracteristics) {
        super(separator);
        this.sampleCategoryToCaracteristics = sampleCategoryToCaracteristics;
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", "name");
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newColumnForExport("Engin", "gear", "name");
        this.newColumnForExport("Id_Operation", "stationNumber");
        this.newColumnForExport("NumOrdre_Station", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newColumnForExport("Navire", "vessel", "name");
        this.newColumnForExport("Taxon", "species.referenceTaxonId", (ValueFormatter)TuttiCsvUtil.INTEGER);
        for (SampleCategoryEnum sampleCategoryEnum : samplingOrder) {
            switch (sampleCategoryEnum) {
                case sortedUnsorted: {
                    this.addSampleCategory("VracHorsVrac", "sortedUnsortedSampleCategory");
                    break;
                }
                case size: {
                    this.addSampleCategory("Cat_Tri", "sizeSampleCategory");
                    break;
                }
                case sex: {
                    this.addSampleCategory("Sexe", "sexSampleCategory");
                    break;
                }
                case maturity: {
                    this.addSampleCategory("Maturite", "maturitySampleCategory");
                    break;
                }
                case age: {
                    this.addSampleCategory("Age", "ageSampleCategory");
                }
            }
        }
        this.newNullableColumnForExport("Code_Longueur", "frequency.lengthStepCaracteristic.id");
        this.newNullableColumnForExport("Taille", "frequency.lengthStep", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("NumOrdre_Taille_H2", "frequency.rankOrder", TuttiCsvUtil.INTEGER);
        this.newNullableColumnForExport("Poids_Classe_Taille", "frequency.weight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Unite_Taille", "frequency.lengthStepCaracteristic.unit");
        this.newNullableColumnForExport("Precision_Mesure", "frequency.lengthStepCaracteristic.precision", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Nbr", "batchNumber", TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poids_Reference", "referenceWeight", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_FLOAT);
        this.newColumnForExport("Coef_Final_Elevation", "raisingFactor", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_FLOAT);
    }

    public void prepareRows(PersistenceService persistenceService, List<CatchExportRow> rows, Cruise cruise, FishingOperation operation, BatchContainer<SpeciesBatch> rootSpeciesBatch, BatchContainer<BenthosBatch> rootBenthosBatch, Float speciesCatchRaisingFactor, Float benthosCatchRaisingFactor) {
        Float speciesTotalWeight;
        CatchExportRow row;
        for (SpeciesBatch speciesBatch : rootSpeciesBatch.getChildren()) {
            row = new CatchExportRow();
            row.setCruise(cruise);
            row.setFishingOperation(operation);
            row.setSpecies(speciesBatch.getSpecies());
            if (TuttiEntities.isVracSpeciesBatch((SpeciesBatch)speciesBatch)) {
                speciesTotalWeight = speciesBatch.getSampleCategoryWeight();
                if (speciesTotalWeight == null) {
                    speciesTotalWeight = speciesBatch.getSampleCategoryComputedWeight();
                }
                this.prepareSortedRows(persistenceService, row, rows, speciesBatch, Float.valueOf(speciesCatchRaisingFactor.floatValue() / speciesTotalWeight.floatValue()));
                continue;
            }
            this.prepareUnsortedRows(row, rows, speciesBatch);
        }
        for (BenthosBatch benthosBatch : rootBenthosBatch.getChildren()) {
            row = new CatchExportRow();
            row.setCruise(cruise);
            row.setFishingOperation(operation);
            row.setSpecies(benthosBatch.getSpecies());
            if (TuttiEntities.isVracBenthosBatch((BenthosBatch)benthosBatch)) {
                speciesTotalWeight = benthosBatch.getSampleCategoryWeight();
                if (speciesTotalWeight == null) {
                    speciesTotalWeight = benthosBatch.getSampleCategoryComputedWeight();
                }
                this.prepareSortedRows(persistenceService, row, rows, benthosBatch, Float.valueOf(benthosCatchRaisingFactor.floatValue() / speciesTotalWeight.floatValue()));
                continue;
            }
            this.prepareUnsortedRows(row, rows, benthosBatch);
        }
    }

    protected void prepareSortedRows(PersistenceService persistenceService, CatchExportRow currentRow, List<CatchExportRow> rows, SpeciesBatch speciesBatch, Float catchRaisingFactor) {
        this.prepareBatch(currentRow, speciesBatch.getSampleCategoryType(), speciesBatch.getSampleCategoryValue(), speciesBatch.getSampleCategoryWeight(), speciesBatch.getSampleCategoryComputedWeight(), speciesBatch.getWeight(), speciesBatch.getNumber(), speciesBatch.getRankOrder());
        if (speciesBatch.isChildBatchsEmpty()) {
            List<SpeciesBatchFrequency> speciesBatchFrequency = persistenceService.getAllSpeciesBatchFrequency(speciesBatch.getId());
            if (CollectionUtils.isEmpty(speciesBatchFrequency)) {
                CatchExportRow row = currentRow.copy();
                Float referenceWeight = speciesBatch.getWeight();
                if (referenceWeight == null) {
                    referenceWeight = speciesBatch.getSampleCategoryWeight();
                }
                if (referenceWeight == null) {
                    referenceWeight = speciesBatch.getSampleCategoryComputedWeight();
                }
                this.computeRaisingFactor(row, catchRaisingFactor.floatValue(), referenceWeight.floatValue());
                rows.add(row);
            } else {
                Float referenceWeight = null;
                if (speciesBatchFrequency.get(0).getWeight() == null) {
                    referenceWeight = speciesBatch.getWeight();
                    if (referenceWeight == null) {
                        referenceWeight = speciesBatch.getSampleCategoryWeight();
                    }
                    if (referenceWeight == null) {
                        referenceWeight = speciesBatch.getSampleCategoryComputedWeight();
                    }
                }
                for (SpeciesBatchFrequency batchFrequency : speciesBatchFrequency) {
                    CatchExportRow row = currentRow.copy();
                    row.setSpeciesFrequency(batchFrequency);
                    rows.add(row);
                    if (referenceWeight == null) {
                        referenceWeight = batchFrequency.getWeight();
                    }
                    this.computeRaisingFactor(row, catchRaisingFactor.floatValue(), referenceWeight.floatValue());
                }
            }
        } else {
            for (SpeciesBatch childBatch : speciesBatch.getChildBatchs()) {
                this.prepareSortedRows(persistenceService, currentRow, rows, childBatch, catchRaisingFactor);
            }
        }
    }

    protected void prepareUnsortedRows(CatchExportRow currentRow, List<CatchExportRow> rows, SpeciesBatch speciesBatch) {
        this.prepareBatch(currentRow, speciesBatch.getSampleCategoryType(), speciesBatch.getSampleCategoryValue(), speciesBatch.getSampleCategoryWeight(), speciesBatch.getSampleCategoryComputedWeight(), speciesBatch.getWeight(), speciesBatch.getNumber(), speciesBatch.getRankOrder());
        CatchExportRow row = currentRow.copy();
        float referenceWeight = TuttiExportService.getValueOrComputedValue(speciesBatch.getSampleCategoryWeight(), speciesBatch.getSampleCategoryComputedWeight()).floatValue();
        row.setReferenceWeight(referenceWeight);
        row.setRaisingFactor(1.0f);
        rows.add(row);
    }

    protected void prepareSortedRows(PersistenceService persistenceService, CatchExportRow currentRow, List<CatchExportRow> rows, BenthosBatch benthosBatch, Float catchRaisingFactor) {
        this.prepareBatch(currentRow, benthosBatch.getSampleCategoryType(), benthosBatch.getSampleCategoryValue(), benthosBatch.getSampleCategoryWeight(), benthosBatch.getSampleCategoryComputedWeight(), benthosBatch.getWeight(), benthosBatch.getNumber(), benthosBatch.getRankOrder());
        if (benthosBatch.isChildBatchsEmpty()) {
            List<BenthosBatchFrequency> benthosBatchFrequency = persistenceService.getAllBenthosBatchFrequency(benthosBatch.getId());
            if (CollectionUtils.isEmpty(benthosBatchFrequency)) {
                CatchExportRow row = currentRow.copy();
                Float referenceWeight = benthosBatch.getWeight();
                if (referenceWeight == null) {
                    referenceWeight = benthosBatch.getSampleCategoryWeight();
                }
                if (referenceWeight == null) {
                    referenceWeight = benthosBatch.getSampleCategoryComputedWeight();
                }
                this.computeRaisingFactor(row, catchRaisingFactor.floatValue(), referenceWeight.floatValue());
                rows.add(row);
            } else {
                Float referenceWeight = null;
                if (benthosBatchFrequency.get(0).getWeight() == null) {
                    referenceWeight = benthosBatch.getWeight();
                    if (referenceWeight == null) {
                        referenceWeight = benthosBatch.getSampleCategoryWeight();
                    }
                    if (referenceWeight == null) {
                        referenceWeight = benthosBatch.getSampleCategoryComputedWeight();
                    }
                }
                for (BenthosBatchFrequency batchFrequency : benthosBatchFrequency) {
                    CatchExportRow row = currentRow.copy();
                    row.setBenthosFrequency(batchFrequency);
                    rows.add(row);
                    if (referenceWeight == null) {
                        referenceWeight = batchFrequency.getWeight();
                    }
                    this.computeRaisingFactor(row, catchRaisingFactor.floatValue(), referenceWeight.floatValue());
                }
            }
        } else {
            for (BenthosBatch childBatch : benthosBatch.getChildBatchs()) {
                this.prepareSortedRows(persistenceService, currentRow, rows, childBatch, catchRaisingFactor);
            }
        }
    }

    protected void prepareUnsortedRows(CatchExportRow currentRow, List<CatchExportRow> rows, BenthosBatch benthosBatch) {
        this.prepareBatch(currentRow, benthosBatch.getSampleCategoryType(), benthosBatch.getSampleCategoryValue(), benthosBatch.getSampleCategoryWeight(), benthosBatch.getSampleCategoryComputedWeight(), benthosBatch.getWeight(), benthosBatch.getNumber(), benthosBatch.getRankOrder());
        CatchExportRow row = currentRow.copy();
        float referenceWeight = TuttiExportService.getValueOrComputedValue(benthosBatch.getSampleCategoryWeight(), benthosBatch.getSampleCategoryComputedWeight()).floatValue();
        row.setReferenceWeight(referenceWeight);
        row.setRaisingFactor(1.0f);
        rows.add(row);
    }

    protected void computeRaisingFactor(CatchExportRow row, float catchRaisingFactor, float referenceWeight) {
        float raisingFactor = referenceWeight / catchRaisingFactor;
        row.setReferenceWeight(referenceWeight);
        row.setRaisingFactor(raisingFactor);
    }

    protected void prepareBatch(CatchExportRow currentRow, SampleCategoryEnum sampleCategoryType, Serializable sampleCategoryValue, Float sampleCategoryWeight, Float sampleCategoryComputedWeight, Float batchWeight, Integer batchNumber, Integer batchRankOrder) {
        currentRow.setBatchNumber(batchNumber);
        ExportSampleCategory sampleCategory = new ExportSampleCategory();
        Caracteristic caracteristic = this.sampleCategoryToCaracteristics.get(sampleCategoryType);
        sampleCategory.setCategoryCaracteristic(caracteristic);
        sampleCategory.setCategoryType(sampleCategoryType);
        sampleCategory.setCategoryValue(sampleCategoryValue);
        sampleCategory.setCategoryWeight(sampleCategoryWeight);
        sampleCategory.setSampleWeight(batchWeight);
        sampleCategory.setComputedWeight(sampleCategoryComputedWeight);
        sampleCategory.setWeightOrVolType(WEIGHT_OR_VOL_TYPE);
        sampleCategory.setRankOrder(batchRankOrder);
        currentRow.addCategory(sampleCategory);
    }

    protected void addSampleCategory(String headerPrefix, String categoryName) {
        this.newNullableColumnForExport(headerPrefix, categoryName + "." + "categoryValue", TuttiCsvUtil.CARACTERISTIC_VALUE_FORMATTER);
        this.newNullableColumnForExport("Num_Ordre_" + headerPrefix + "_H2", categoryName + "." + "rankOrder", TuttiCsvUtil.INTEGER);
        this.newNullableColumnForExport("Tot_" + headerPrefix, categoryName + "." + "categoryWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Ech_" + headerPrefix, categoryName + "." + "sampleWeight", TuttiCsvUtil.FLOAT);
        this.newNullableColumnForExport("Type_Volume_Poids_" + headerPrefix, categoryName + "." + "weightOrVolType");
        this.newNullableColumnForExport("Unite_Volume_Poids_" + headerPrefix, categoryName + "." + "categoryCaracteristic" + "." + "unit");
    }
}

