/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches.multipost;

import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.catches.multipost.CatchRow;
import java.io.Serializable;
import org.nuiton.util.csv.ValueFormatter;

public class CatchRowModel
extends TuttiCsvUtil.AbstractTuttiExportModel<CatchRow> {
    public CatchRowModel(char separator) {
        super(separator);
        ValueFormatter<Serializable> caracteristicValueFormatter = new ValueFormatter<Serializable>(){

            public String format(Serializable value) {
                String result = "";
                if (value != null) {
                    if (CaracteristicQualitativeValue.class.isAssignableFrom(value.getClass())) {
                        CaracteristicQualitativeValue cqv = (CaracteristicQualitativeValue)value;
                        result = cqv.getId();
                    } else {
                        result = String.valueOf(value);
                    }
                }
                return result;
            }
        };
        this.newColumnForExport("id", "id");
        this.newColumnForExport("species", "species", (ValueFormatter)new ValueFormatter<Species>(){

            public String format(Species value) {
                return value != null ? String.valueOf(value.getReferenceTaxonId()) : null;
            }
        });
        this.newColumnForExport("sortedUnsortedSampleCategory", "sortedUnsortedSampleCategory", (ValueFormatter)caracteristicValueFormatter);
        this.newColumnForExport("sizeSampleCategory", "sizeSampleCategory", (ValueFormatter)caracteristicValueFormatter);
        this.newColumnForExport("sexSampleCategory", "sexSampleCategory", (ValueFormatter)caracteristicValueFormatter);
        this.newColumnForExport("maturitySampleCategory", "maturitySampleCategory", (ValueFormatter)caracteristicValueFormatter);
        this.newColumnForExport("ageSampleCategory", "ageSampleCategory", (ValueFormatter)caracteristicValueFormatter);
        this.newColumnForExport("categoryWeight", "categoryWeight", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("weight", "weight", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("number", "number", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("comment", "comment");
        this.newColumnForExport("toConfirm", "toConfirm", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_BOOLEAN);
    }
}

