/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxonImpl;
import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.BenthosBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import fr.ifremer.tutti.persistence.service.batch.BatchPersistenceHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service(value="benthosBatchPersistenceService")
public class BenthosBatchPersistenceServiceImpl
extends AbstractPersistenceService
implements BenthosBatchPersistenceService {
    private static final Log log = LogFactory.getLog(BenthosBatchPersistenceServiceImpl.class);
    @Autowired
    protected ReferentialPersistenceService referentialService;
    @Resource(name="batchPersistenceHelper")
    protected BatchPersistenceHelper batchHelper;

    @Override
    public BatchContainer<BenthosBatch> getRootBenthosBatch(String fishingOperationId) {
        SortingBatch horsVracBenthosBatch;
        Preconditions.checkNotNull((Object)fishingOperationId);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(fishingOperationId, false);
        SortingBatch vracBenthosBatch = this.batchHelper.getSortingBatch((Batch)catchBatch, "Vrac > Benthos > Alive Itemized", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_ITEMIZED);
        BatchContainer<BenthosBatch> result = new BatchContainer<BenthosBatch>();
        if (vracBenthosBatch != null) {
            result.setId(vracBenthosBatch.getId());
            for (Batch batch : vracBenthosBatch.getChildBatchs()) {
                SortingBatch source = (SortingBatch)batch;
                ReferenceTaxon referenceTaxon = source.getReferenceTaxon();
                Preconditions.checkNotNull((Object)referenceTaxon, (Object)("Can't have a rootBenthosBatch with a null taxon, but was for " + batch.getId()));
                Species species = this.referentialService.getSpeciesByReferenceTaxonId(referenceTaxon.getId());
                if (species == null) {
                    throw new TuttiBusinessException(I18n._((String)"tutti.persistence.batch.validation.unkonwn.taxon", (Object[])new Object[]{source.getId(), referenceTaxon.getId()}));
                }
                BenthosBatch target = TuttiBeanFactory.newBenthosBatch();
                target.setSpecies(species);
                this.entityToBenthosBatch(source, target);
                result.addChildren(target);
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Loaded CatchBatch Vrac > Benthos > Alive Itemized > " + target.getSpecies().getReferenceTaxonId() + ": " + target.getId()));
            }
        }
        if ((horsVracBenthosBatch = this.batchHelper.getSortingBatch((Batch)catchBatch, "Hors Vrac > Benthos", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS)) != null) {
            for (Batch batch : horsVracBenthosBatch.getChildBatchs()) {
                SortingBatch source = (SortingBatch)batch;
                ReferenceTaxon referenceTaxon = source.getReferenceTaxon();
                Preconditions.checkNotNull((Object)referenceTaxon, (Object)("Can't have a rootSpeciesBatch with a null taxon, but was for " + source.getId()));
                Species species = this.referentialService.getSpeciesByReferenceTaxonId(referenceTaxon.getId());
                BenthosBatch target = TuttiBeanFactory.newBenthosBatch();
                target.setSpecies(species);
                this.entityToBenthosBatch(source, target);
                result.addChildren(target);
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Loaded CatchBatch Hors Vrac > Benthos > " + target.getSpecies().getReferenceTaxonId() + ": " + target.getId()));
            }
        }
        return result;
    }

    @Override
    public BenthosBatch createBenthosBatch(BenthosBatch bean, String parentBatchId) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bean.getSpecies());
        Preconditions.checkNotNull((Object)bean.getSpecies().getId());
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(bean.getFishingOperation().getId(), false);
        SortingBatch batch = SortingBatch.Factory.newInstance();
        this.benthosBatchToEntity(bean, batch, parentBatchId, catchBatch);
        bean = this.batchHelper.createSortingBatch(bean, catchBatch, batch);
        return bean;
    }

    @Override
    public BenthosBatch saveBenthosBatch(BenthosBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getId());
        Integer batchId = bean.getIdAsInt();
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(batchId);
        SortingBatch batch = this.batchHelper.getSortingBatchById(catchBatch, batchId);
        String parentBatchId = null;
        if (bean.getParentBatch() != null) {
            parentBatchId = bean.getParentBatch().getId();
        }
        this.benthosBatchToEntity(bean, batch, parentBatchId, catchBatch);
        this.batchHelper.updateSortingBatch(batch, catchBatch);
        return bean;
    }

    @Override
    public void deleteBenthosBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        Integer batchId = Integer.valueOf(id);
        this.batchHelper.removeWithChildren(batchId);
    }

    @Override
    public void deleteBenthosSubBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        Integer benthosBatchId = Integer.valueOf(id);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(benthosBatchId);
        SortingBatch sortingBatch = this.batchHelper.getSortingBatchById(catchBatch, benthosBatchId);
        Collection childBatchs = sortingBatch.getChildBatchs();
        if (CollectionUtils.isNotEmpty((Collection)childBatchs)) {
            for (Batch childBatch : childBatchs) {
                Integer childBatchId = childBatch.getId();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Delete child [" + childBatchId + "] of species batch: " + id));
                }
                this.batchHelper.removeWithChildren(childBatchId);
            }
        }
    }

    @Override
    public void changeBenthosBatchSpecies(String batchId, Species species) {
        Preconditions.checkNotNull((Object)batchId);
        Preconditions.checkNotNull((Object)species);
        Preconditions.checkNotNull((Object)species.getReferenceTaxonId());
        this.batchHelper.setSortingBatchReferenceTaxon(batchId, species.getReferenceTaxonId());
    }

    @Override
    public List<BenthosBatchFrequency> getAllBenthosBatchFrequency(String benthosBatchId) {
        Preconditions.checkNotNull((Object)benthosBatchId);
        List<SortingBatch> frequencyChilds = this.batchHelper.getFrequencies(benthosBatchId);
        ArrayList results = Lists.newArrayList();
        for (SortingBatch child : frequencyChilds) {
            BenthosBatchFrequency target = TuttiBeanFactory.newBenthosBatchFrequency();
            this.entityToBenthosBatchFrequency(child, target);
            results.add(target);
        }
        return Collections.unmodifiableList(results);
    }

    @Override
    public List<BenthosBatchFrequency> saveBenthosBatchFrequency(String benthosBatchId, List<BenthosBatchFrequency> frequencies) {
        Preconditions.checkNotNull((Object)benthosBatchId);
        Preconditions.checkNotNull(frequencies);
        String pmfmId = null;
        for (BenthosBatchFrequency source : frequencies) {
            if (pmfmId == null) {
                pmfmId = source.getLengthStepCaracteristic().getId();
                continue;
            }
            if (pmfmId.equals(source.getLengthStepCaracteristic().getId())) continue;
            throw new DataIntegrityViolationException("Batch frequencies under one Speciesbatch must have all the same lengthStepCaracteristic");
        }
        Integer sortingBatchId = Integer.valueOf(benthosBatchId);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(sortingBatchId);
        if (catchBatch == null) {
            return frequencies;
        }
        SortingBatch parentBatch = this.batchHelper.getSortingBatchById(catchBatch, sortingBatchId);
        ArrayList notUpdatedChildIds = Lists.newArrayList();
        List<SortingBatch> frequencyChilds = this.batchHelper.getFrequencyChilds(parentBatch);
        for (SortingBatch child : frequencyChilds) {
            notUpdatedChildIds.add(child.getId());
        }
        short rankOrder = 0;
        ArrayList batchsToUpdate = Lists.newArrayList();
        for (BenthosBatchFrequency source : frequencies) {
            SortingBatch target;
            rankOrder = (short)(rankOrder + 1);
            if (source.getId() == null) {
                target = SortingBatch.Factory.newInstance();
                this.benthosBatchFrequencyToEntity(source, target, parentBatch, rankOrder);
                this.batchHelper.createSortingBatch(source, catchBatch, target);
                continue;
            }
            target = this.batchHelper.getSortingBatchById(catchBatch, source.getIdAsInt());
            this.benthosBatchFrequencyToEntity(source, target, parentBatch, rankOrder);
            batchsToUpdate.add(target);
            notUpdatedChildIds.remove(target.getId());
        }
        if (batchsToUpdate.size() > 0) {
            this.batchHelper.updateSortingBatch(batchsToUpdate, catchBatch);
        }
        if (notUpdatedChildIds.size() > 0) {
            for (Integer batchId : notUpdatedChildIds) {
                this.batchHelper.removeWithChildren(batchId, catchBatch);
            }
        }
        return Collections.unmodifiableList(frequencies);
    }

    protected BenthosBatch entityToBenthosBatch(SortingBatch source, BenthosBatch target) {
        QualityFlag qualityFlag;
        SampleCategoryEnum sampleCategory;
        Preconditions.checkNotNull((Object)target.getSpecies());
        target.setId(source.getId().toString());
        target.setRankOrder((int)source.getRankOrder());
        target.setNumber(source.getIndividualCount());
        if (source.getWeight() != null && source.getWeightBeforeSampling() == null) {
            target.setSampleCategoryWeight(source.getWeight());
        } else {
            target.setWeight(source.getWeight());
            target.setSampleCategoryWeight(source.getWeightBeforeSampling());
        }
        target.setComment(source.getComments());
        SortingMeasurement sm = null;
        if (source.getSortingMeasurements().size() == 1) {
            sm = (SortingMeasurement)source.getSortingMeasurements().iterator().next();
        } else if (source.getReferenceTaxon() != null && source.getReferenceTaxon().getId() != null) {
            sm = this.batchHelper.getInheritedSortingMeasurement(source);
        }
        if (sm != null && (sampleCategory = this.enumeration.getSampleCategoryByPmfmId(sm.getPmfm().getId())) != null) {
            Integer qualitativeId = null;
            if (sm.getQualitativeValue() != null) {
                qualitativeId = sm.getQualitativeValue().getId();
            }
            this.setSampleCategoryQualitative(target, sm.getPmfm().getId(), sm.getNumericalValue(), sm.getAlphanumericalValue(), qualitativeId);
        }
        if (target.getSampleCategoryType() != null) {
            ArrayList targetChilds = Lists.newArrayList();
            for (Batch batch : source.getChildBatchs()) {
                SortingBatch sourceChild = (SortingBatch)batch;
                BenthosBatch targetChild = TuttiBeanFactory.newBenthosBatch();
                targetChild.setSpecies(target.getSpecies());
                this.entityToBenthosBatch(sourceChild, targetChild);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Loaded CatchBatch Hors Vrac > (Species|Benthos) > " + targetChild.getSpecies().getReferenceTaxonId() + " : " + target.getId()));
                }
                if (targetChild.getSampleCategoryValue() == null) continue;
                targetChilds.add(targetChild);
                targetChild.setParentBatch(target);
            }
            target.setChildBatchs(targetChilds);
        }
        target.setSpeciesToConfirm((qualityFlag = source.getQualityFlag()) != null && this.enumeration.QUALITY_FLAG_CODE_DOUBTFUL.equals(qualityFlag.getCode()));
        return target;
    }

    protected void entityToBenthosBatchFrequency(SortingBatch source, BenthosBatchFrequency target) {
        target.setId(source.getId());
        target.setRankOrder((int)source.getRankOrder());
        target.setNumber(source.getIndividualCount());
        target.setWeight(source.getWeight());
        Preconditions.checkState((source.getSortingMeasurements().size() == 1 ? 1 : 0) != 0, (Object)("SortingBatch [" + source.getId() + "] need exactly one sortingMeasurement (to store the length step category), but had " + source.getSortingMeasurements().size()));
        SortingMeasurement sm = (SortingMeasurement)source.getSortingMeasurements().iterator().next();
        Preconditions.checkNotNull((Object)sm.getPmfm(), (Object)("SortingMeasurement [" + sm.getId() + "] can not have a null pmfm"));
        Preconditions.checkNotNull((Object)sm.getPmfm().getId(), (Object)("SortingMeasurement [" + sm.getId() + "] can not have a pmfm with null id"));
        Caracteristic lengthStepCaracteristic = this.referentialService.getCaracteristic(sm.getPmfm().getId());
        target.setLengthStepCaracteristic(lengthStepCaracteristic);
        target.setLengthStep(sm.getNumericalValue());
    }

    protected void benthosBatchToEntity(BenthosBatch source, SortingBatch target, String parentBatchId, CatchBatch catchBatch) {
        Integer pmfmId;
        Preconditions.checkNotNull((Object)source.getFishingOperation());
        Preconditions.checkNotNull((Object)source.getFishingOperation().getId());
        Collection quantificationMeasurements = target.getQuantificationMeasurements();
        Collection sortingMeasurements = target.getSortingMeasurements();
        HashSet notChangedQuantificationMeasurements = Sets.newHashSet();
        if (quantificationMeasurements != null) {
            notChangedQuantificationMeasurements.addAll(quantificationMeasurements);
        }
        HashSet notChangedSortingMeasurements = Sets.newHashSet();
        if (sortingMeasurements != null) {
            notChangedSortingMeasurements.addAll(sortingMeasurements);
        }
        if (target.getId() == null || target.getRootBatch() == null || target.getParentBatch() != null && !target.getParentBatch().getId().toString().equals(parentBatchId)) {
            this.batchHelper.setBenthosBatchParents(source.getSampleCategoryType(), source.getSampleCategoryValue(), target, parentBatchId, catchBatch);
        }
        if (target.getRankOrder() == null) {
            short rankOrder = 1;
            if (source.getParentBatch() != null && source.getParentBatch().getChildBatchs() != null) {
                rankOrder = (short)(rankOrder + (short)source.getParentBatch().getChildBatchs().size());
            } else if (target.getParentBatch() != null && target.getParentBatch().getChildBatchs() != null) {
                rankOrder = (short)(rankOrder + (short)target.getParentBatch().getChildBatchs().size());
            }
            target.setRankOrder(Short.valueOf(rankOrder));
        }
        target.setSubgroupCount(Float.valueOf(1.0f));
        if (source.getWeight() != null || source.getSampleCategoryWeight() != null) {
            if (source.getSampleCategoryWeight() != null && source.getWeight() == null) {
                QuantificationMeasurement quantificationMeasurement = this.batchHelper.setWeightMeasurementQuantificationMeasurement((Batch)target, source.getSampleCategoryWeight());
                notChangedQuantificationMeasurements.remove(quantificationMeasurement);
            } else if (source.getWeight() != null && source.getSampleCategoryWeight() == null) {
                QuantificationMeasurement quantificationMeasurement = this.batchHelper.setWeightMeasurementQuantificationMeasurement((Batch)target, source.getWeight());
                notChangedQuantificationMeasurements.remove(quantificationMeasurement);
            }
        }
        if (source.getSampleCategoryWeight() == null || source.getWeight() == null) {
            target.setSamplingRatio(null);
            target.setSamplingRatioText(null);
        } else {
            String samplingRatioText = source.getWeight() + "/" + source.getSampleCategoryWeight();
            samplingRatioText = samplingRatioText.replaceAll(",", ".");
            target.setSamplingRatioText(samplingRatioText);
            target.setSamplingRatio(Float.valueOf(source.getWeight().floatValue() / source.getSampleCategoryWeight().floatValue()));
            QuantificationMeasurement quantificationMeasurement = this.batchHelper.setWeightMeasurementQuantificationMeasurement((Batch)target, source.getWeight());
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if (source.getSampleCategoryType() != null && source.getSampleCategoryValue() != null && !(pmfmId = source.getSampleCategoryType().getFieldValue()).equals(this.enumeration.PMFM_ID_SORTED_UNSORTED)) {
            SortingMeasurement sortingMeasurement = this.batchHelper.setSortingMeasurement(target, source.getSampleCategoryType(), source.getSampleCategoryValue());
            notChangedSortingMeasurements.remove(sortingMeasurement);
        }
        target.setIndividualCount(source.getNumber());
        ReferenceTaxon referenceTaxon = source.getSpecies() == null || parentBatchId != null ? null : (ReferenceTaxon)this.load(ReferenceTaxonImpl.class, source.getSpecies().getReferenceTaxonId());
        target.setReferenceTaxon(referenceTaxon);
        String qualityFlag = source.isSpeciesToConfirm() ? this.enumeration.QUALITY_FLAG_CODE_DOUBTFUL : this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED;
        target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)qualityFlag)));
        target.setComments(source.getComment());
        target.setExhaustiveInventory(Boolean.valueOf(true));
        if (quantificationMeasurements != null) {
            quantificationMeasurements.removeAll(notChangedQuantificationMeasurements);
        }
        if (sortingMeasurements != null) {
            sortingMeasurements.removeAll(notChangedSortingMeasurements);
        }
    }

    protected void benthosBatchFrequencyToEntity(BenthosBatchFrequency source, SortingBatch target, SortingBatch parentBatch, short rankOrder) {
        Preconditions.checkNotNull((Object)source.getBatch());
        Preconditions.checkNotNull((Object)source.getBatch().getId());
        Collection quantificationMeasurements = target.getQuantificationMeasurements();
        Collection sortingMeasurements = target.getSortingMeasurements();
        HashSet notChangedQuantificationMeasurements = Sets.newHashSet();
        if (quantificationMeasurements != null) {
            notChangedQuantificationMeasurements.addAll(quantificationMeasurements);
        }
        HashSet notChangedSortingMeasurements = Sets.newHashSet();
        if (sortingMeasurements != null) {
            notChangedSortingMeasurements.addAll(sortingMeasurements);
        }
        if (target.getId() == null || target.getRootBatch() == null || target.getParentBatch() != null && !target.getParentBatch().getId().equals(parentBatch.getId())) {
            target.setParentBatch((Batch)parentBatch);
            target.setRootBatch(parentBatch.getRootBatch());
        }
        target.setRankOrder(Short.valueOf(rankOrder));
        if (source.getWeight() != null) {
            QuantificationMeasurement quantificationMeasurement = this.batchHelper.setWeightMeasurementQuantificationMeasurement((Batch)target, source.getWeight());
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if (source.getLengthStepCaracteristic() != null && source.getLengthStep() != null) {
            Integer pmfmId = source.getLengthStepCaracteristic().getIdAsInt();
            SortingMeasurement sortingMeasurement = this.batchHelper.setSortingMeasurement(target, pmfmId, (Serializable)source.getLengthStep());
            notChangedSortingMeasurements.remove(sortingMeasurement);
        }
        target.setIndividualCount(source.getNumber());
        target.setReferenceTaxon(null);
        target.setQualityFlag(parentBatch.getQualityFlag());
        target.setExhaustiveInventory(Boolean.valueOf(true));
        if (quantificationMeasurements != null) {
            quantificationMeasurements.removeAll(notChangedQuantificationMeasurements);
        }
        if (sortingMeasurements != null) {
            sortingMeasurements.removeAll(notChangedSortingMeasurements);
        }
    }

    public void setSampleCategoryQualitative(BenthosBatch target, Integer pmfmId, Float numericalvalue, String alphanumericalValue, Integer qualitativeValueId) {
        if (pmfmId == null || pmfmId.equals(this.enumeration.PMFM_ID_SORTING_TYPE)) {
            return;
        }
        SampleCategoryEnum sampleCategory = this.enumeration.getSampleCategoryByPmfmId(pmfmId);
        Preconditions.checkNotNull((Object)sampleCategory, (Object)("Unable to find corresponding SampleCategoryEnum for PMFM.ID : " + pmfmId));
        target.setSampleCategoryType(sampleCategory);
        Serializable categoryValue = this.batchHelper.getSampleCategoryQualitative(pmfmId, numericalvalue, alphanumericalValue, qualitativeValueId);
        target.setSampleCategoryValue(categoryValue);
    }
}

