/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryColumnIdentifier;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.TableViewMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.CreateSpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellEditor;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataTableCell;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUIModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class SpeciesBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<SpeciesBatchRowModel, SpeciesBatchUIModel, SpeciesBatchUI> {
    private static final Log log = LogFactory.getLog(SpeciesBatchUIHandler.class);
    public static final Set<String> SAMPLING_PROPERTIES = Sets.newHashSet((Object[])new String[]{"sampleCategory", "species", "sortedUnsortedCategory", "sizeCategory", "sexCategory", "maturityCategory", "ageCategory", "sortedUnsortedCategoryWeight", "sizeCategoryWeight", "sexCategoryWeight", "maturityCategoryWeight", "ageCategoryWeight"});
    public static final Set<String> SAMPLING_WEIGHT_PROPERTIES = Sets.newHashSet((Object[])new String[]{"sortedUnsortedCategoryWeight", "sizeCategoryWeight", "sexCategoryWeight", "maturityCategoryWeight", "ageCategoryWeight"});
    private final EnumMap<TableViewMode, RowFilter<SpeciesBatchTableModel, Integer>> tableFilters = new EnumMap(TableViewMode.class);

    public SpeciesBatchUIHandler(TuttiUI<?, ?> parentUi, SpeciesBatchUI ui) {
        super(parentUi, ui, "species", "sortedUnsortedCategory", "sortedUnsortedCategoryWeight", "sizeCategory", "sizeCategoryWeight", "sexCategory", "sexCategoryWeight", "maturityCategory", "maturityCategoryWeight", "ageCategory", "ageCategoryWeight", "weight", "number", "comment", "attachment", "frequency", "speciesToConfirm");
        this.tableFilters.put(TableViewMode.ALL, new RowFilter<SpeciesBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SpeciesBatchTableModel, ? extends Integer> entry) {
                return true;
            }
        });
        this.tableFilters.put(TableViewMode.ROOT, new RowFilter<SpeciesBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SpeciesBatchTableModel, ? extends Integer> entry) {
                boolean result = false;
                Integer rowIndex = entry.getIdentifier();
                if (rowIndex != null) {
                    SpeciesBatchTableModel model = entry.getModel();
                    SpeciesBatchRowModel row = (SpeciesBatchRowModel)model.getEntry(rowIndex);
                    result = row != null && row.isBatchRoot();
                }
                return result;
            }
        });
        this.tableFilters.put(TableViewMode.LEAF, new RowFilter<SpeciesBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SpeciesBatchTableModel, ? extends Integer> entry) {
                boolean result = false;
                Integer rowIndex = entry.getIdentifier();
                if (rowIndex != null) {
                    SpeciesBatchTableModel model = entry.getModel();
                    SpeciesBatchRowModel row = (SpeciesBatchRowModel)model.getEntry(rowIndex);
                    result = row != null && row.isBatchLeaf();
                }
                return result;
            }
        });
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        if (empty) {
            rows = null;
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Get species batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            model.removeAllAttachment(model.getAttachment());
            if (!TuttiEntities.isNew((TuttiEntity)bean)) {
                BatchContainer rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(bean.getId());
                model.setRootBatchId(rootSpeciesBatch.getIdAsInt());
                List attachments = this.persistenceService.getAllAttachments(model.getObjectType(), model.getObjectId());
                model.addAllAttachment(attachments);
                if (log.isInfoEnabled()) {
                    log.info((Object)("species root batch id: " + model.getRootBatchId()));
                }
                List catches = rootSpeciesBatch.getChildren();
                for (SpeciesBatch aBatch : catches) {
                    Preconditions.checkState((aBatch.getSampleCategoryType() == SampleCategoryEnum.sortedUnsorted ? 1 : 0) != 0, (Object)("Root species batch must be a sortedUnsorted sample category but was:" + aBatch.getSampleCategoryType()));
                    SpeciesBatchRowModel rootRow = this.loadBatch(aBatch, null, rows);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Loaded root batch " + this.decorate(rootRow.getSpecies(), "fromProtocol") + " - " + this.decorate(rootRow.getSortedUnsortedCategoryValue())));
                }
            }
        }
        model.setRows(rows);
        this.recomputeBatchActionEnable();
    }

    public SpeciesBatchTableModel getTableModel() {
        return (SpeciesBatchTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((SpeciesBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(SpeciesBatchRowModel row) {
        TuttiProtocol protocol;
        boolean result;
        Species species = row.getSpecies();
        boolean bl = result = species != null;
        if (result && row.isBatchLeaf() && "validate".equals(this.getContext().getValidationContext()) && (protocol = this.getDataContext().getProtocol()) != null) {
            List speciesProtocols = protocol.getSpecies();
            for (SpeciesProtocol speciesProtocol : speciesProtocols) {
                if (!species.getReferenceTaxonId().equals(speciesProtocol.getSpeciesReferenceTaxonId())) continue;
                result = !(speciesProtocol.isSizeEnabled() && row.getSizeCategoryValue() == null || speciesProtocol.isSexEnabled() && row.getSexCategoryValue() == null || speciesProtocol.isMaturityEnabled() && row.getMaturityCategoryValue() == null || speciesProtocol.isAgeEnabled() && row.getAgeCategoryValue() == null || speciesProtocol.isCountIfNoFrequencyEnabled() && !CollectionUtils.isNotEmpty(row.getFrequency()) && row.getNumber() == null);
            }
        }
        return result;
    }

    @Override
    protected void onRowModified(int rowIndex, SpeciesBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        SampleCategoryColumnIdentifier<SpeciesBatchRowModel> sampleCategoryColumnIdentifier;
        SampleCategoryEnum sampleCategoryType;
        SampleCategory<?> sampleCategory;
        SpeciesBatchRowModel firstAncestorRow;
        SpeciesBatchTableModel tableModel;
        int firstAncestorIndex;
        this.recomputeRowValidState(row);
        if (SAMPLING_WEIGHT_PROPERTIES.contains(propertyName) && rowIndex != (firstAncestorIndex = (tableModel = this.getTableModel()).getRowIndex(firstAncestorRow = row.getFirstAncestor(sampleCategory = row.getSampleCategory(sampleCategoryType = (sampleCategoryColumnIdentifier = tableModel.getCategoryIdentifierForWeightProperty(propertyName)).getSampleCategoryType()))))) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Sample category " + sampleCategoryType + " weight was modified, First ancestor row: " + firstAncestorIndex + " will save it"));
            }
            this.saveRow(firstAncestorRow);
            this.recomputeBatchActionEnable();
            this.cleanrRowMonitor();
            return;
        }
        this.saveSelectedRowIfNeeded();
        this.recomputeBatchActionEnable();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SpeciesBatchRowModel> rowMonitor, SpeciesBatchRowModel row) {
        if (rowMonitor.wasModified()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Row " + row + " was modified, will save it"));
            }
            this.showInformationMessage("[ Captures - Esp\u00e8ces ] Sauvegarde des modifications de " + row + '.');
            rowMonitor.setBean(null);
            this.saveRow(row);
            rowMonitor.setBean(row);
            rowMonitor.clearModified();
        }
    }

    @Override
    protected void onModelRowsChanged(List<SpeciesBatchRowModel> rows) {
        super.onModelRowsChanged(rows);
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.setRootNumber(0);
        for (SpeciesBatchRowModel row : rows) {
            this.updateTotalFromFrequencies(row);
            if (!row.isBatchRoot()) continue;
            this.addToSpeciesUsed(row);
        }
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, SpeciesBatchRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        this.recomputeBatchActionEnable();
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, SpeciesBatchRowModel oldRow, int newRowIndex, SpeciesBatchRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        this.recomputeBatchActionEnable();
    }

    @Override
    protected void addHighlighters(JXTable table) {
        super.addHighlighters(table);
        Color toConfirmColor = this.getConfig().getColorRowToConfirm();
        Highlighter confirmHighlighter = TuttiUIUtil.newBackgroundColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                SpeciesBatchRowModel row = (SpeciesBatchRowModel)SpeciesBatchUIHandler.this.getTableModel().getEntry(adapter.row);
                return row.isSpeciesToConfirm();
            }
        }, toConfirmColor);
        table.addHighlighter(confirmHighlighter);
        Highlighter selectedHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.IS_SELECTED, new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{SpeciesBatchTableModel.SPECIES})}), UIManager.getColor("Table[Enabled+Selected].textBackground"));
        table.addHighlighter(selectedHighlighter);
        Highlighter confirmNotEditableHighlighter = TuttiUIUtil.newBackgroundColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                SpeciesBatchRowModel row = (SpeciesBatchRowModel)SpeciesBatchUIHandler.this.getTableModel().getEntry(adapter.row);
                return row.isSpeciesToConfirm() && !adapter.isEditable();
            }
        }, toConfirmColor.darker());
        table.addHighlighter(confirmNotEditableHighlighter);
        Color cellWithValueColor = this.getConfig().getColorCellWithValue();
        Highlighter commentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{SpeciesBatchTableModel.COMMENT}), new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                String value = (String)adapter.getValue();
                return StringUtils.isNotBlank((CharSequence)value);
            }
        }}), cellWithValueColor);
        table.addHighlighter(commentHighlighter);
        Highlighter attachmentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{SpeciesBatchTableModel.ATTACHMENT}), new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                Collection attachments = (Collection)adapter.getValue();
                return CollectionUtils.isNotEmpty((Collection)attachments);
            }
        }}), cellWithValueColor);
        table.addHighlighter(attachmentHighlighter);
    }

    @Override
    public SwingValidator<SpeciesBatchUIModel> getValidator() {
        return ((SpeciesBatchUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("beforeInit: " + this.ui));
        }
        EditCatchesUIModel catchesUIModel = ((SpeciesBatchUI)this.ui).getContextValue(EditCatchesUIModel.class);
        SpeciesBatchUIModel model = new SpeciesBatchUIModel(catchesUIModel);
        model.setTableViewMode(TableViewMode.ALL);
        ((SpeciesBatchUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("afterInit: " + this.ui));
        }
        this.initUI(this.ui);
        Map categoryEnumMap = SampleCategoryEnum.toIdMapping();
        ArrayList samplingOrder = Lists.newArrayList();
        List samplingOrderIds = this.getConfig().getServiceConfig().getSamplingOrderIds();
        for (Integer id : samplingOrderIds) {
            samplingOrder.add(categoryEnumMap.get(id));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use sampling order: " + samplingOrder));
        }
        JXTable table = this.getTable();
        table.setColumnControlVisible(true);
        TableCellRenderer defaultRenderer = table.getDefaultRenderer(Object.class);
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        Decorator<CaracteristicQualitativeValue> caracteristicDecorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        Color computedDataColor = this.getConfig().getColorComputedWeights();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Species.class, "fromProtocol"), SpeciesBatchTableModel.SPECIES);
        this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SORTED_UNSORTED_CATEGORY, caracteristicDecorator, defaultRenderer);
        for (SampleCategoryEnum sampleCategoryType : samplingOrder) {
            switch (sampleCategoryType) {
                case size: {
                    this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SIZE_CATEGORY, caracteristicDecorator, defaultRenderer);
                    break;
                }
                case sex: {
                    this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SEX_CATEGORY, caracteristicDecorator, defaultRenderer);
                    break;
                }
                case maturity: {
                    this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.MATURITY_CATEGORY, caracteristicDecorator, defaultRenderer);
                    break;
                }
                case age: {
                    this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.AGE_CATEGORY, this.getDecorator(Float.class, null), defaultRenderer);
                }
            }
        }
        this.addColumnToModel((TableColumnModel)columnModel, TuttiComputedOrNotDataTableCell.newEditor(Float.class, false, true, 3, computedDataColor), TuttiComputedOrNotDataTableCell.newRender(defaultRenderer, true, 3, computedDataColor), SpeciesBatchTableModel.WEIGHT);
        this.addColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyCellComponent.newEditor((SpeciesBatchUI)this.ui, computedDataColor), SpeciesFrequencyCellComponent.newRender(computedDataColor), SpeciesBatchTableModel.COMPUTED_NUMBER);
        this.addColumnToModel((TableColumnModel)columnModel, CommentCellEditor.newEditor(this.ui), CommentCellRenderer.newRender(), SpeciesBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor(this.ui), AttachmentCellRenderer.newRender(this.getDecorator(Attachment.class, null)), SpeciesBatchTableModel.ATTACHMENT);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SPECIES_TO_CONFIRM, (JTable)this.getTable());
        SpeciesBatchTableModel tableModel = new SpeciesBatchTableModel((TableColumnModelExt)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initBatchTable(table, (TableColumnModel)columnModel, tableModel);
        ((SpeciesBatchUIModel)this.getModel()).addPropertyChangeListener("tableViewMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableViewMode tableViewMode = (TableViewMode)((Object)evt.getNewValue());
                if (tableViewMode == null) {
                    tableViewMode = TableViewMode.ALL;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will use rowfilter for viewMode: " + (Object)((Object)tableViewMode)));
                }
                RowFilter filter = (RowFilter)SpeciesBatchUIHandler.this.tableFilters.get((Object)tableViewMode);
                SpeciesBatchUIHandler.this.getTable().setRowFilter(filter);
            }
        });
        this.recomputeBatchActionEnable();
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((SpeciesBatchUI)this.getUI()).getTable();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing: " + this.ui));
        }
        ((SpeciesBatchUI)this.ui).getSpeciesBatchAttachmentsButton().onCloseUI();
    }

    public void createBatch() {
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        CreateSpeciesBatchUI createBatchEditor = parent.getSpeciesTabCreateBatch();
        createBatchEditor.getHandler().openUI((SpeciesBatchUIModel)this.getModel());
        parent.getHandler().setSpeciesSelectedCard("createBatch");
    }

    public void addBatch(CreateSpeciesBatchUIModel speciesBatchRootRowModel) {
        if (speciesBatchRootRowModel.isValid()) {
            SpeciesBatchTableModel tableModel = this.getTableModel();
            SpeciesBatchRowModel newRow = tableModel.createNewRow();
            Species species = speciesBatchRootRowModel.getSpecies();
            newRow.setSpecies(species);
            CaracteristicQualitativeValue sortedUnsortedCategory = speciesBatchRootRowModel.getSortedUnsortedCategory();
            SampleCategory<CaracteristicQualitativeValue> category = newRow.getSortedUnsortedCategory();
            category.setCategoryValue((Serializable)sortedUnsortedCategory);
            category.setCategoryWeight(speciesBatchRootRowModel.getBatchWeight());
            newRow.setSampleCategory(category);
            this.recomputeRowValidState(newRow);
            this.saveRow(newRow);
            tableModel.addNewRow(newRow);
            AbstractSelectTableAction.doSelectCell((JTable)this.getTable(), tableModel.getRowCount() - 1, 0);
            this.addToSpeciesUsed(newRow);
        }
        this.recomputeBatchActionEnable();
    }

    public void splitBatch() {
        JXTable table = this.getTable();
        int rowIndex = table.getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant split batch if no batch selected");
        SpeciesBatchTableModel tableModel = this.getTableModel();
        SpeciesBatchRowModel parentBatch = (SpeciesBatchRowModel)tableModel.getEntry(rowIndex);
        boolean split = true;
        if (parentBatch.getWeight() != null) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n._((String)"tutti.editSpeciesBatch.split.weightNotNull.message", (Object[])new Object[0]), I18n._((String)"tutti.editSpeciesBatch.split.weightNotNull.help", (Object[])new Object[0]));
            int i = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n._((String)"tutti.editSpeciesBatch.split.weightNotNull.title", (Object[])new Object[0]), 2);
            if (i == 0) {
                parentBatch.setWeight(null);
            } else {
                split = false;
            }
        }
        if (split) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Open split batch ui for row [" + rowIndex + ']'));
            }
            EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
            SplitSpeciesBatchUI splitBatchEditor = parent.getSpeciesTabSplitBatch();
            splitBatchEditor.getHandler().editBatch(parentBatch);
            parent.getHandler().setSpeciesSelectedCard("splitBatch");
        }
    }

    public void splitBatch(SampleCategoryEnum sampleCategoryEnum, List<SplitSpeciesBatchRowModel> rows, Float totalRowWeight) {
        JXTable table = this.getTable();
        int insertRow = table.getSelectedRow();
        SpeciesBatchTableModel tableModel = this.getTableModel();
        SpeciesBatchRowModel parentBatch = (SpeciesBatchRowModel)tableModel.getEntry(insertRow);
        Float parentWeight = parentBatch.getFinestCategory().getNotNullWeight();
        boolean subSample = parentWeight != null && totalRowWeight != null && parentWeight.floatValue() > totalRowWeight.floatValue();
        ArrayList newBatches = Lists.newArrayList();
        for (SplitSpeciesBatchRowModel row : rows) {
            if (!row.isValid()) continue;
            SpeciesBatchRowModel newBatch = tableModel.createNewRow();
            this.loadBatchRow(parentBatch, newBatch, sampleCategoryEnum, row.getCategoryValue(), row.getWeight(), null);
            newBatch.getFinestCategory().setSubSample(subSample);
            this.recomputeRowValidState(newBatch);
            newBatches.add(newBatch);
            tableModel.addNewRow(++insertRow, newBatch);
            AbstractSelectTableAction.doSelectCell((JTable)this.getTable(), insertRow, 0);
        }
        parentBatch.setChildBatch(newBatches);
        this.saveRows(newBatches);
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.setLeafNumber(model.getLeafNumber() + newBatches.size() - 1);
        this.recomputeBatchActionEnable();
    }

    public void updateTotalFromFrequencies(SpeciesBatchRowModel row) {
        List<SpeciesFrequencyRowModel> frequency = row.getFrequency();
        Integer totalNumber = 0;
        boolean onlyOneFrequency = false;
        if (CollectionUtils.isNotEmpty(frequency)) {
            for (SpeciesFrequencyRowModel frequencyModel : frequency) {
                if (frequencyModel.getNumber() == null) continue;
                totalNumber = totalNumber + frequencyModel.getNumber();
            }
            onlyOneFrequency = frequency.size() == 1;
        }
        row.setComputedNumber(totalNumber);
        row.getFinestCategory().setOnlyOneFrequency(onlyOneFrequency);
    }

    public void saveRows(Iterable<SpeciesBatchRowModel> rows) {
        for (SpeciesBatchRowModel row : rows) {
            this.saveRow(row);
        }
    }

    protected void saveRow(SpeciesBatchRowModel row) {
        FishingOperation fishingOperation = ((SpeciesBatchUIModel)this.getModel()).getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        Preconditions.checkNotNull((Object)row.getSpecies());
        SampleCategory<?> sampleCategory = row.getSampleCategory();
        Preconditions.checkNotNull(sampleCategory);
        Preconditions.checkNotNull((Object)sampleCategory.getCategoryType());
        Preconditions.checkNotNull((Object)sampleCategory.getCategoryValue());
        SpeciesBatch catchBean = (SpeciesBatch)row.toBean();
        catchBean.setFishingOperation(fishingOperation);
        SpeciesBatchRowModel parent = row.getParentBatch();
        if (parent != null) {
            catchBean.setParentBatch((SpeciesBatch)parent.toBean());
        }
        catchBean.setSampleCategoryType(sampleCategory.getCategoryType());
        catchBean.setSampleCategoryValue(sampleCategory.getCategoryValue());
        catchBean.setSampleCategoryWeight(sampleCategory.getCategoryWeight());
        if (TuttiEntities.isNew((TuttiEntity)catchBean)) {
            String parentBatchId = null;
            if (parent != null) {
                parentBatchId = parent.getId();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Persist new species batch with parentId: " + parentBatchId));
            }
            catchBean = this.persistenceService.createSpeciesBatch(catchBean, parentBatchId);
            row.setId(catchBean.getId());
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Persist existing species batch: " + catchBean.getId() + " (parent : " + catchBean.getParentBatch() + ")"));
            }
            this.persistenceService.saveSpeciesBatch(catchBean);
        }
        List<SpeciesFrequencyRowModel> frequencyRows = row.getFrequency();
        List frequency = SpeciesFrequencyRowModel.toBeans(frequencyRows, catchBean);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will save " + frequency.size() + " frequencies."));
        }
        frequency = this.persistenceService.saveSpeciesBatchFrequency(catchBean.getId(), frequency);
        frequencyRows = SpeciesFrequencyRowModel.fromBeans(frequency);
        row.setFrequency(frequencyRows);
    }

    public String getFilterSpeciesBatchRootButtonText(int rootNumber) {
        return I18n._((String)"tutti.editSpeciesBatch.filterBatch.mode.root", (Object[])new Object[]{rootNumber});
    }

    protected void recomputeBatchActionEnable() {
        int rowIndex = this.getTable().getSelectedRow();
        boolean enableAdd = true;
        boolean enableRename = false;
        boolean enableSplit = false;
        boolean enableRemove = false;
        boolean enableRemoveSub = false;
        boolean enableCreateMelag = false;
        if (rowIndex != -1) {
            SpeciesBatchTableModel tableModel = this.getTableModel();
            SpeciesBatchRowModel row = (SpeciesBatchRowModel)tableModel.getEntry(rowIndex);
            int selectedRowCount = this.getTable().getSelectedRowCount();
            if (row.getSpecies() != null) {
                enableSplit = true;
                enableRemove = true;
                enableRemoveSub = true;
                enableRename = true;
                enableCreateMelag = true;
            }
            if (enableSplit) {
                boolean bl = enableSplit = row.isBatchLeaf() && selectedRowCount == 1 && row.getNumber() == null && (row.getComputedNumber() == null || row.getComputedNumber() == 0);
            }
            if (enableRename) {
                boolean bl = enableRename = row.isBatchRoot() && selectedRowCount == 1;
            }
            if (enableRemove) {
                boolean bl = enableRemove = selectedRowCount == 1;
            }
            if (enableRemoveSub) {
                boolean bl = enableRemoveSub = !row.isBatchLeaf() && selectedRowCount == 1;
            }
            if (enableCreateMelag) {
                JXTable table = this.getTable();
                if (selectedRowCount < 2) {
                    enableCreateMelag = false;
                } else {
                    int[] selectedRows;
                    for (int selectedRowIndex : selectedRows = table.getSelectedRows()) {
                        SpeciesBatchRowModel selectedRow = (SpeciesBatchRowModel)tableModel.getEntry(selectedRowIndex);
                        if (selectedRow.isBatchRoot()) continue;
                        enableCreateMelag = false;
                        break;
                    }
                }
            }
        }
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.setCreateBatchEnabled(enableAdd);
        model.setSplitBatchEnabled(enableSplit);
        model.setRemoveBatchEnabled(enableRemove);
        model.setRemoveSubBatchEnabled(enableRemoveSub);
        model.setRenameSpeciesBatchEnabled(enableRename);
        model.setCreateSpeciesMelagEnabled(enableCreateMelag);
    }

    public void collectChildren(SpeciesBatchRowModel row, Set<SpeciesBatchRowModel> collectedRows) {
        if (!row.isBatchLeaf()) {
            for (SpeciesBatchRowModel batchChild : row.getChildBatch()) {
                collectedRows.add(batchChild);
                this.collectChildren(batchChild, collectedRows);
            }
        }
    }

    public SpeciesBatchRowModel loadBatch(SpeciesBatch aBatch, SpeciesBatchRowModel parentRow, List<SpeciesBatchRowModel> rows) {
        List speciesList;
        int i;
        String id = aBatch.getId();
        List frequencies = this.persistenceService.getAllSpeciesBatchFrequency(id);
        SpeciesBatchRowModel newRow = new SpeciesBatchRowModel(aBatch, frequencies);
        List attachments = this.persistenceService.getAllAttachments(newRow.getObjectType(), newRow.getObjectId());
        newRow.addAllAttachment(attachments);
        if (parentRow == null && this.context.isProtocolFilled() && (i = (speciesList = this.getDataContext().getReferentSpeciesWithSurveyCode()).indexOf(newRow.getSpecies())) > -1) {
            newRow.setSpecies((Species)speciesList.get(i));
        }
        SampleCategoryEnum sampleCategoryEnum = aBatch.getSampleCategoryType();
        Preconditions.checkNotNull((Object)sampleCategoryEnum, (Object)("Can't have a batch with no sample category, but was: " + aBatch));
        this.loadBatchRow(parentRow, newRow, sampleCategoryEnum, aBatch.getSampleCategoryValue(), aBatch.getSampleCategoryWeight(), aBatch.getSampleCategoryComputedWeight());
        rows.add(newRow);
        if (!aBatch.isChildBatchsEmpty()) {
            ArrayList batchChilds = Lists.newArrayListWithCapacity((int)aBatch.sizeChildBatchs());
            Float childrenWeights = Float.valueOf(0.0f);
            for (SpeciesBatch childBatch : aBatch.getChildBatchs()) {
                SpeciesBatchRowModel childRow = this.loadBatch(childBatch, newRow, rows);
                if (childrenWeights != null) {
                    Float weight = childRow.getFinestCategory().getNotNullWeight();
                    childrenWeights = weight == null ? null : Float.valueOf(childrenWeights.floatValue() + weight.floatValue());
                }
                batchChilds.add(childRow);
            }
            Float rowWeight = newRow.getFinestCategory().getNotNullWeight();
            boolean subSample = rowWeight != null && childrenWeights != null && childrenWeights.floatValue() < rowWeight.floatValue();
            for (SpeciesBatchRowModel childRow : batchChilds) {
                childRow.getFinestCategory().setSubSample(subSample);
            }
            newRow.setChildBatch(batchChilds);
        }
        return newRow;
    }

    protected void loadBatchRow(SpeciesBatchRowModel parentRow, SpeciesBatchRowModel newRow, SampleCategoryEnum sampleCategoryEnum, Serializable categoryValue, Float categoryWeight, Float categoryComputedWeight) {
        SampleCategory<?> sampleCategory = newRow.getSampleCategory(sampleCategoryEnum);
        sampleCategory.setCategoryValue(categoryValue);
        sampleCategory.setCategoryWeight(categoryWeight);
        sampleCategory.setComputedWeight(categoryComputedWeight);
        newRow.setSampleCategory(sampleCategory);
        if (parentRow != null) {
            newRow.setSpecies(parentRow.getSpecies());
            newRow.setSpeciesToConfirm(parentRow.isSpeciesToConfirm());
            newRow.setParentBatch(parentRow);
            newRow.setSpecies(parentRow.getSpecies());
            if (sampleCategoryEnum != SampleCategoryEnum.sortedUnsorted) {
                newRow.setSortedUnsortedCategory(parentRow.getSortedUnsortedCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.size) {
                newRow.setSizeCategory(parentRow.getSizeCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.sex) {
                newRow.setSexCategory(parentRow.getSexCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.maturity) {
                newRow.setMaturityCategory(parentRow.getMaturityCategory());
            }
            if (sampleCategoryEnum != SampleCategoryEnum.age) {
                newRow.setAgeCategory(parentRow.getAgeCategory());
            }
        }
    }

    protected <C extends Serializable> void addSampleCategoryColumnToModel(TableColumnModel columnModel, ColumnIdentifier<SpeciesBatchRowModel> columnIdentifier, Decorator<C> decorator, TableCellRenderer defaultRenderer) {
        this.addColumnToModel(columnModel, SampleCategoryComponent.newEditor(decorator), SampleCategoryComponent.newRender(defaultRenderer, decorator, this.getConfig().getColorComputedWeights()), columnIdentifier);
    }

    public void removeFromSpeciesUsed(SpeciesBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getSpecies());
        Preconditions.checkNotNull((Object)row.getSortedUnsortedCategoryValue());
        if (log.isInfoEnabled()) {
            log.info((Object)("Remove from speciesUsed: " + this.decorate(row.getSortedUnsortedCategoryValue()) + " - " + this.decorate(row.getSpecies())));
        }
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.getSpeciesUsed().remove((Object)row.getSortedUnsortedCategoryValue(), (Object)row.getSpecies());
        if (row.isBatchRoot()) {
            model.setRootNumber(model.getRootNumber() - 1);
        }
    }

    protected void addToSpeciesUsed(SpeciesBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getSpecies());
        Preconditions.checkNotNull((Object)row.getSortedUnsortedCategoryValue());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add to speciesUsed: " + this.decorate(row.getSortedUnsortedCategoryValue()) + " - " + this.decorate(row.getSpecies())));
        }
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.getSpeciesUsed().put((Object)row.getSortedUnsortedCategoryValue(), (Object)row.getSpecies());
        model.setRootNumber(model.getRootNumber() + 1);
    }

    public Species openAddSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUI dialogContent = new SelectSpeciesUI(this.ui);
        SelectSpeciesUIModel model = dialogContent.getModel();
        model.setSelectedSpecies(null);
        model.setSpecies(species);
        this.openDialog(dialogContent, title, new Dimension(400, 130));
        return model.getSelectedSpecies();
    }
}

