/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUIModel;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class CreateIndividualObservationBatchUIHandler
extends AbstractTuttiUIHandler<CreateIndividualObservationBatchUIModel, CreateIndividualObservationBatchUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(CreateIndividualObservationBatchUIHandler.class);

    public CreateIndividualObservationBatchUIHandler(TuttiUI parentUi, CreateIndividualObservationBatchUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui);
    }

    @Override
    public void beforeInitUI() {
        CreateIndividualObservationBatchUIModel model = new CreateIndividualObservationBatchUIModel();
        ((CreateIndividualObservationBatchUI)this.ui).setContextValue(model);
        this.listModelIsModify(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        this.initBeanFilterableComboBox(((CreateIndividualObservationBatchUI)this.ui).getIndividualObservationSpeciesComboBox(), Lists.newArrayList((Iterable)this.getDataContext().getReferentSpeciesWithSurveyCode()), null);
        List lengthStepCaracteristics = this.getDataContext().getLengthStepCaracteristics();
        this.initBeanFilterableComboBox(((CreateIndividualObservationBatchUI)this.ui).getIndividualObservationLengthStepCaracteristicComboBox(), Lists.newArrayList((Iterable)lengthStepCaracteristics), null);
        if (this.context.isProtocolFilled()) {
            TuttiProtocol protocol = this.getDataContext().getProtocol();
            Preconditions.checkNotNull((Object)protocol, (Object)"Could not find protocol in ui context");
            final HashMap speciesProtocolMap = Maps.newHashMap();
            for (SpeciesProtocol sp : protocol.getSpecies()) {
                speciesProtocolMap.put(sp.getSpeciesReferenceTaxonId(), sp);
            }
            final Map lengthStepCaracteristicMap = TuttiEntities.splitById((Iterable)lengthStepCaracteristics);
            ((CreateIndividualObservationBatchUIModel)((Object)this.getModel())).addPropertyChangeListener("species", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SpeciesProtocol speciesProtocol;
                    Species species = (Species)evt.getNewValue();
                    if (species != null && (speciesProtocol = (SpeciesProtocol)speciesProtocolMap.get(species.getReferenceTaxonId())) != null) {
                        String lengthStepPmfmId = speciesProtocol.getLengthStepPmfmId();
                        Caracteristic lengthStepCaracteristic = (Caracteristic)lengthStepCaracteristicMap.get(lengthStepPmfmId);
                        ((CreateIndividualObservationBatchUIModel)((Object)CreateIndividualObservationBatchUIHandler.this.getModel())).setLengthStepCaracteristic(lengthStepCaracteristic);
                    }
                }
            });
        }
        this.listenValidatorValid((SimpleBeanValidator)((CreateIndividualObservationBatchUI)this.ui).getValidator(), (AbstractTuttiBeanUIModel)((Object)this.getModel()));
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((CreateIndividualObservationBatchUI)this.getUI()).getIndividualObservationSpeciesComboBox();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        ((CreateIndividualObservationBatchUI)this.ui).getValidator().setBean(null);
        ((CreateIndividualObservationBatchUIModel)((Object)this.getModel())).setValid(false);
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getHandler().setIndividualObservationSelectedCard("main");
    }

    @Override
    public SwingValidator<CreateIndividualObservationBatchUIModel> getValidator() {
        return ((CreateIndividualObservationBatchUI)this.ui).getValidator();
    }

    @Override
    public void cancel() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Cancel UI " + this.ui));
        }
        this.closeUI(this.ui);
    }

    public void openUI(IndividualObservationBatchUIModel batchModel) {
        CreateIndividualObservationBatchUIModel model = (CreateIndividualObservationBatchUIModel)((Object)this.getModel());
        ((CreateIndividualObservationBatchUI)this.ui).getValidator().setBean((Object)model);
        model.reset();
        model.setSpecies(batchModel.getLastSpeciesUsed());
        model.setAvailableSpecies(this.getDataContext().getReferentSpeciesWithSurveyCode());
    }

    public void save() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Save UI " + this.ui));
        }
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getIndividualObservationTabContent().getHandler().addBatch((CreateIndividualObservationBatchUIModel)((Object)this.getModel()));
        this.closeUI(this.ui);
    }

    public Species openAddSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUI dialogContent = new SelectSpeciesUI(this.ui);
        SelectSpeciesUIModel model = dialogContent.getModel();
        model.setSelectedSpecies(null);
        model.setSpecies(species);
        this.openDialog(dialogContent, title, new Dimension(400, 130));
        Species result = model.getSelectedSpecies();
        return result;
    }
}

