/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.export.CatchExportModel;
import fr.ifremer.tutti.service.export.OperationExportModel;
import fr.ifremer.tutti.service.export.ParameterExportModel;
import fr.ifremer.tutti.service.export.SurveyExportModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.csv.Export;
import org.nuiton.util.csv.ExportModel;

public class TuttiExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(TuttiExportService.class);
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;
    protected char csvSeparator;
    private Caracteristic verticalOpeningCaracteristic;
    private Caracteristic horizontalOpeningWingCaracteristic;
    private Caracteristic horizontalOpeningDoorCaracteristic;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        this.csvSeparator = context.getConfig().getCsvSeparator();
        this.verticalOpeningCaracteristic = this.persistenceService.getVerticalOpeningCaracteristic();
        this.horizontalOpeningWingCaracteristic = this.persistenceService.getHorizontalOpeningWingCaracteristic();
        this.horizontalOpeningDoorCaracteristic = this.persistenceService.getHorizontalOpeningDoorCaracteristic();
    }

    public void exportCruise(String cruiseId, File exportFile) {
        Preconditions.checkNotNull((Object)cruiseId);
        Preconditions.checkNotNull((Object)exportFile);
        Cruise cruise = this.persistenceService.getCruise(cruiseId);
        Preconditions.checkNotNull((Object)cruise);
        List<FishingOperation> operations = this.persistenceService.getAllFishingOperation(cruiseId);
        File basedir = new File(this.context.getConfig().newTempFile("exportCruise"), "exportCruise-" + cruiseId);
        TuttiIOUtil.forceMkdir((File)basedir, (String)"Could not create directory");
        File surveyFile = new File(basedir, "survey.csv");
        this.exportSurvey(surveyFile, cruise);
        File operationFile = new File(basedir, "operation.csv");
        this.exportOperations(operationFile, cruise, operations);
        File parameterFile = new File(basedir, "parameter.csv");
        this.exportParameters(parameterFile, cruise, operations);
        TuttiIOUtil.zip((File)basedir, (File)exportFile, (String)"Could not create export zip");
    }

    public void exportSurvey(File file, Cruise cruise) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export survey to file: " + file));
        }
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
            SurveyExportModel model = new SurveyExportModel(this.csvSeparator);
            ArrayList rows = Lists.newArrayList();
            model.prepareRows(rows, cruise);
            Export export = Export.newExport((ExportModel)model, (Iterable)rows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not export survey to file: " + file, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public void exportOperations(File file, Cruise cruise, List<FishingOperation> operations) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export operations to file: " + file));
        }
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
            OperationExportModel model = new OperationExportModel(this.csvSeparator, this.verticalOpeningCaracteristic, this.horizontalOpeningWingCaracteristic, this.horizontalOpeningDoorCaracteristic);
            ArrayList rows = Lists.newArrayList();
            model.prepareRows(rows, cruise, operations);
            Export export = Export.newExport((ExportModel)model, (Iterable)rows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not export operations to file: " + file, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public void exportParameters(File file, Cruise cruise, List<FishingOperation> operations) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export parameters to file: " + file));
        }
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
            ParameterExportModel model = new ParameterExportModel(this.csvSeparator, this.decoratorService);
            TuttiCsvUtil.TuttiRepeatableExport export = TuttiCsvUtil.newRepeatableExport(model);
            for (FishingOperation operation : operations) {
                ArrayList rows = Lists.newArrayList();
                model.prepareRows(rows, cruise, operation);
                export.write(rows, writer);
            }
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not export parameters to file: " + file, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public void exportCatches(File file, Cruise cruise, List<FishingOperation> operations) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export catches to file: " + file));
        }
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
            CatchExportModel model = new CatchExportModel(this.csvSeparator);
            TuttiCsvUtil.TuttiRepeatableExport export = TuttiCsvUtil.newRepeatableExport(model);
            for (FishingOperation operation : operations) {
                BatchContainer<SpeciesBatch> rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(operation.getId());
                ArrayList rows = Lists.newArrayList();
                model.prepareRows(rows, cruise, operation, rootSpeciesBatch);
                export.write(rows, writer);
            }
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException("Could not export catches to file: " + file, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }
}

