/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches;

import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SortedUnsortedEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.ValidationService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorResult;

public class TuttiWeightComputingService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(TuttiWeightComputingService.class);
    protected PersistenceService persistenceService;
    protected ValidationService validationService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.validationService = this.getService(ValidationService.class);
    }

    public void computeCatchBatchWeights(CatchBatch catchBatch, BatchContainer<SpeciesBatch> rootSpeciesBatch, BatchContainer<SpeciesBatch> rootBenthosBatch) {
        Float speciesTotalComputedSortedWeight = Float.valueOf(0.0f);
        Float speciesTotalComputedUnsortedWeight = Float.valueOf(0.0f);
        for (int i = 0; i < rootSpeciesBatch.getChildren().size(); ++i) {
            SpeciesBatch row = (SpeciesBatch)rootSpeciesBatch.getChildren().get(i);
            Float weight = row.getSampleCategoryWeight();
            if (weight == null) {
                weight = row.getSampleCategoryComputedWeight();
            }
            if (weight == null) {
                return;
            }
            CaracteristicQualitativeValue value = (CaracteristicQualitativeValue)row.getSampleCategoryValue();
            if (SortedUnsortedEnum.SORTED.matchValue(value)) {
                speciesTotalComputedSortedWeight = Float.valueOf(speciesTotalComputedSortedWeight.floatValue() + weight.floatValue());
                continue;
            }
            speciesTotalComputedUnsortedWeight = Float.valueOf(speciesTotalComputedUnsortedWeight.floatValue() + weight.floatValue());
        }
        Float inertWeight = catchBatch.getSpeciesTotalInertWeight();
        if (inertWeight != null) {
            speciesTotalComputedSortedWeight = Float.valueOf(speciesTotalComputedSortedWeight.floatValue() + ((Number)inertWeight).floatValue());
        } else {
            catchBatch.setSpeciesTotalInertComputedWeight(Float.valueOf(0.0f));
        }
        Float livingNotItemizedWeight = catchBatch.getSpeciesTotalLivingNotItemizedWeight();
        if (livingNotItemizedWeight != null) {
            speciesTotalComputedSortedWeight = Float.valueOf(speciesTotalComputedSortedWeight.floatValue() + ((Number)livingNotItemizedWeight).floatValue());
        } else {
            catchBatch.setSpeciesTotalLivingNotItemizedComputedWeight(Float.valueOf(0.0f));
        }
        catchBatch.setSpeciesTotalSampleSortedComputedWeight(speciesTotalComputedSortedWeight);
        Float speciesTotalSortedWeight = catchBatch.getSpeciesTotalSortedWeight();
        if (speciesTotalSortedWeight == null) {
            speciesTotalSortedWeight = speciesTotalComputedSortedWeight;
            catchBatch.setSpeciesTotalSortedComputedWeight(speciesTotalSortedWeight);
        } else if (speciesTotalSortedWeight.floatValue() < speciesTotalComputedSortedWeight.floatValue()) {
            throw new TuttiBusinessException(I18n._((String)"tutti.service.catches.computeWeights.error.incoherentSpeciesTotalSorted", (Object[])new Object[0]));
        }
        catchBatch.setSpeciesTotalUnsortedComputedWeight(speciesTotalComputedUnsortedWeight);
        if (speciesTotalSortedWeight == null) {
            speciesTotalSortedWeight = catchBatch.getSpeciesTotalSortedComputedWeight();
        }
        Float speciesTotalWeight = Float.valueOf(speciesTotalComputedUnsortedWeight.floatValue() + speciesTotalSortedWeight.floatValue());
        catchBatch.setSpeciesTotalComputedWeight(speciesTotalWeight);
        Float benthosTotalComputedSortedWeight = Float.valueOf(0.0f);
        Float benthosTotalComputedUnsortedWeight = Float.valueOf(0.0f);
        for (int i = 0; i < rootBenthosBatch.getChildren().size(); ++i) {
            SpeciesBatch row = (SpeciesBatch)rootBenthosBatch.getChildren().get(i);
            Float weight = row.getSampleCategoryWeight();
            if (weight == null) {
                weight = row.getSampleCategoryComputedWeight();
            }
            if (weight == null) {
                return;
            }
            CaracteristicQualitativeValue value = (CaracteristicQualitativeValue)row.getSampleCategoryValue();
            if (SortedUnsortedEnum.SORTED.matchValue(value)) {
                benthosTotalComputedSortedWeight = Float.valueOf(benthosTotalComputedSortedWeight.floatValue() + weight.floatValue());
                continue;
            }
            benthosTotalComputedUnsortedWeight = Float.valueOf(benthosTotalComputedUnsortedWeight.floatValue() + weight.floatValue());
        }
        inertWeight = catchBatch.getBenthosTotalInertWeight();
        if (inertWeight != null) {
            benthosTotalComputedSortedWeight = Float.valueOf(benthosTotalComputedSortedWeight.floatValue() + ((Number)inertWeight).floatValue());
        } else {
            catchBatch.setBenthosTotalInertComputedWeight(Float.valueOf(0.0f));
        }
        livingNotItemizedWeight = catchBatch.getBenthosTotalLivingNotItemizedWeight();
        if (livingNotItemizedWeight != null) {
            benthosTotalComputedSortedWeight = Float.valueOf(benthosTotalComputedSortedWeight.floatValue() + ((Number)livingNotItemizedWeight).floatValue());
        } else {
            catchBatch.setBenthosTotalLivingNotItemizedComputedWeight(Float.valueOf(0.0f));
        }
        catchBatch.setBenthosTotalSampleSortedComputedWeight(benthosTotalComputedSortedWeight);
        Float benthosTotalSortedWeight = catchBatch.getBenthosTotalSortedWeight();
        if (benthosTotalSortedWeight == null) {
            benthosTotalSortedWeight = benthosTotalComputedSortedWeight;
            catchBatch.setBenthosTotalSortedComputedWeight(benthosTotalSortedWeight);
        } else if (benthosTotalSortedWeight.floatValue() < benthosTotalComputedSortedWeight.floatValue()) {
            throw new TuttiBusinessException(I18n._((String)"tutti.service.catches.computeWeights.error.incoherentBenthosTotalSorted", (Object[])new Object[0]));
        }
        catchBatch.setBenthosTotalUnsortedComputedWeight(benthosTotalComputedUnsortedWeight);
        if (benthosTotalSortedWeight == null) {
            benthosTotalSortedWeight = catchBatch.getBenthosTotalSortedComputedWeight();
        }
        Float benthosTotalWeight = Float.valueOf(benthosTotalComputedUnsortedWeight.floatValue() + benthosTotalSortedWeight.floatValue());
        catchBatch.setBenthosTotalComputedWeight(benthosTotalWeight);
        Float totalUnsortedWeight = Float.valueOf(catchBatch.getSpeciesTotalUnsortedComputedWeight().floatValue() + catchBatch.getBenthosTotalUnsortedComputedWeight().floatValue());
        Float totalSortedWeight = Float.valueOf(speciesTotalSortedWeight.floatValue() + benthosTotalSortedWeight.floatValue());
        catchBatch.setCatchTotalSortedComputedWeight(totalSortedWeight);
        catchBatch.setCatchTotalUnsortedComputedWeight(totalUnsortedWeight);
        Float totalWeight = catchBatch.getCatchTotalWeight();
        Float rejectedWeight = catchBatch.getCatchTotalRejectedWeight();
        if (rejectedWeight == null && totalWeight != null) {
            if (!totalWeight.equals(Float.valueOf(totalUnsortedWeight.floatValue() + totalSortedWeight.floatValue()))) {
                throw new TuttiBusinessException(I18n._((String)"tutti.service.catches.computeWeights.error.incoherentTotal", (Object[])new Object[0]));
            }
            catchBatch.setCatchTotalRejectedComputedWeight(Float.valueOf(totalWeight.floatValue() - totalUnsortedWeight.floatValue() - totalSortedWeight.floatValue()));
        } else if (totalWeight == null) {
            if (rejectedWeight == null) {
                rejectedWeight = Float.valueOf(0.0f);
                catchBatch.setCatchTotalRejectedComputedWeight(Float.valueOf(0.0f));
            }
            catchBatch.setCatchTotalComputedWeight(Float.valueOf(totalUnsortedWeight.floatValue() + totalSortedWeight.floatValue() + rejectedWeight.floatValue()));
        } else if (!totalWeight.equals(Float.valueOf(totalUnsortedWeight.floatValue() + totalSortedWeight.floatValue() + rejectedWeight.floatValue()))) {
            throw new TuttiBusinessException(I18n._((String)"tutti.service.catches.computeWeights.error.incoherentTotal", (Object[])new Object[0]));
        }
    }

    public BatchContainer<SpeciesBatch> getComputedSpeciesBatches(FishingOperation operation) {
        BatchContainer<SpeciesBatch> rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(operation.getId());
        if (rootSpeciesBatch != null) {
            List roots = rootSpeciesBatch.getChildren();
            for (int i = 0; i < roots.size(); ++i) {
                SpeciesBatch batch = (SpeciesBatch)roots.get(i);
                this.computeSpeciesBatch(batch);
            }
        }
        return rootSpeciesBatch;
    }

    public BatchContainer<SpeciesBatch> getComputedBenthosBatches(FishingOperation operation) {
        BatchContainer<SpeciesBatch> rootBenthosBatch = this.persistenceService.getRootBenthosBatch(operation.getId());
        List roots = rootBenthosBatch.getChildren();
        for (int i = 0; i < roots.size(); ++i) {
            SpeciesBatch batch = (SpeciesBatch)roots.get(i);
            this.computeSpeciesBatch(batch);
        }
        return rootBenthosBatch;
    }

    protected Float computeSpeciesBatch(SpeciesBatch batch) {
        Float result = null;
        Float categoryWeight = batch.getSampleCategoryWeight();
        Float rowWeight = batch.getWeight();
        NuitonValidatorResult validation = this.validationService.validateSpeciesBatch(batch);
        if (!validation.isValid()) {
            List messages = validation.getErrorMessages("weight");
            throw new TuttiBusinessException(I18n._((String)((String)messages.get(0)), (Object[])new Object[0]));
        }
        List children = batch.getChildBatchs();
        if (batch.sizeChildBatchs() > 0) {
            Float sum = Float.valueOf(0.0f);
            for (SpeciesBatch child : children) {
                Float weight = this.computeSpeciesBatch(child);
                if (weight == null) {
                    sum = null;
                    break;
                }
                sum = Float.valueOf(sum.floatValue() + weight.floatValue());
            }
            if (sum != null) {
                if (categoryWeight == null) {
                    batch.setSampleCategoryComputedWeight(sum);
                } else {
                    if (categoryWeight.floatValue() < sum.floatValue()) {
                        throw new TuttiBusinessException(I18n._((String)"tutti.service.catches.computeWeights.error.incoherentParentCategoryWeight", (Object[])new Object[0]));
                    }
                    sum = categoryWeight;
                }
                result = sum;
            }
        } else {
            batch.setComputedWeight(null);
            List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllSpeciesBatchFrequency(batch.getId());
            if (CollectionUtils.isNotEmpty(frequencies)) {
                Float frequencyWeight = Float.valueOf(0.0f);
                for (SpeciesBatchFrequency frequency : frequencies) {
                    Float w = frequency.getWeight();
                    if (w == null) {
                        frequencyWeight = null;
                        break;
                    }
                    if (frequencyWeight == null) continue;
                    frequencyWeight = Float.valueOf(frequencyWeight.floatValue() + w.floatValue());
                }
                if (categoryWeight != null || rowWeight == null) {
                    if (categoryWeight == null && frequencyWeight != null) {
                        batch.setSampleCategoryComputedWeight(frequencyWeight);
                        result = frequencyWeight;
                    } else if (frequencyWeight != null && !frequencyWeight.equals(categoryWeight)) {
                        if (frequencyWeight.floatValue() > categoryWeight.floatValue()) {
                            throw new TuttiBusinessException(I18n._((String)"tutti.service.catches.computeWeights.error.incoherentCategoryWeight", (Object[])new Object[0]));
                        }
                        if (rowWeight == null) {
                            batch.setComputedWeight(frequencyWeight);
                        } else if (!rowWeight.equals(frequencyWeight)) {
                            throw new TuttiBusinessException(I18n._((String)"tutti.service.catches.computeWeights.error.incoherentRowWeightFrequency", (Object[])new Object[0]));
                        }
                        result = categoryWeight;
                    } else {
                        result = categoryWeight;
                    }
                }
            } else {
                result = categoryWeight;
            }
        }
        return result;
    }
}

