/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.spatial.SexagecimalPosition;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TabContentModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import fr.ifremer.tutti.ui.swing.util.editor.CoordinateEditorType;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DateUtil;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class EditFishingOperationUIModel
extends AbstractTuttiBeanUIModel<FishingOperation, EditFishingOperationUIModel>
implements AttachmentModelAware,
TabContentModel,
FishingOperation {
    private static final long serialVersionUID = 1L;
    public static final String TITLE = I18n.n_((String)"tutti.editFishingOperation.tab.general", (Object[])new Object[0]);
    public static final String PROPERTY_PERSISTED = "persisted";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DEGREE = "gearShootingStartLatitudeDegree";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_MINUTE = "gearShootingStartLatitudeMinute";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DECIMAL_MINUTE = "gearShootingStartLatitudeDecimalMinute";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_SECOND = "gearShootingStartLatitudeSecond";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DEGREE = "gearShootingStartLongitudeDegree";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_MINUTE = "gearShootingStartLongitudeMinute";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DECIMAL_MINUTE = "gearShootingStartLongitudeDecimalMinute";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_SECOND = "gearShootingStartLongitudeSecond";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DEGREE = "gearShootingEndLatitudeDegree";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_MINUTE = "gearShootingEndLatitudeMinute";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DECIMAL_MINUTE = "gearShootingEndLatitudeDecimalMinute";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_SECOND = "gearShootingEndLatitudeSecond";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DEGREE = "gearShootingEndLongitudeDegree";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_MINUTE = "gearShootingEndLongitudeMinute";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DECIMAL_MINUTE = "gearShootingEndLongitudeDecimalMinute";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_SECOND = "gearShootingEndLongitudeSecond";
    public static final String PROPERTY_VALIDATION_CONTEXT = "validationContext";
    protected final FishingOperation editObject = TuttiBeanFactory.newFishingOperation();
    protected SexagecimalPosition gearShootingStartLatitudeAsSexagecimal;
    protected SexagecimalPosition gearShootingStartLongitudeAsSexagecimal;
    protected SexagecimalPosition gearShootingEndLatitudeAsSexagecimal;
    protected SexagecimalPosition gearShootingEndLongitudeAsSexagecimal;
    protected final List<Attachment> attachment = Lists.newArrayList();
    protected FishingOperation fishingOperation;
    protected String validationContext;
    protected CoordinateEditorType coordinateEditorType;
    protected static Binder<EditFishingOperationUIModel, FishingOperation> toBeanBinder = BinderFactory.newBinder(EditFishingOperationUIModel.class, FishingOperation.class);
    protected static Binder<FishingOperation, EditFishingOperationUIModel> fromBeanBinder = BinderFactory.newBinder(FishingOperation.class, EditFishingOperationUIModel.class);

    public EditFishingOperationUIModel() {
        super(FishingOperation.class, fromBeanBinder, toBeanBinder);
        this.gearShootingStartLatitudeAsSexagecimal = SexagecimalPosition.valueOf(this.getGearShootingStartLatitude());
        this.gearShootingStartLongitudeAsSexagecimal = SexagecimalPosition.valueOf(this.getGearShootingStartLongitude());
        this.gearShootingEndLatitudeAsSexagecimal = SexagecimalPosition.valueOf(this.getGearShootingEndLatitude());
        this.gearShootingEndLongitudeAsSexagecimal = SexagecimalPosition.valueOf(this.getGearShootingEndLongitude());
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getIcon() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.getStationNumber()) && this.getFishingOperationNumber() == null && this.getStrata() == null && this.getSubStrata() == null && this.getLocation() == null && this.gearShootingStartLatitudeAsSexagecimal.isNull() && this.gearShootingStartLongitudeAsSexagecimal.isNull() && this.getGearShootingStartDate() == null && this.gearShootingEndLatitudeAsSexagecimal.isNull() && this.gearShootingEndLongitudeAsSexagecimal.isNull() && this.getGearShootingEndDate() == null && !this.isFishingOperationRectiligne() && this.getTrawlDistance() == null && this.getFishingOperationValid() == null && CollectionUtils.isEmpty(this.getRecorderPerson()) && this.getGear() == null && StringUtils.isEmpty((CharSequence)this.getComment()) && CollectionUtils.isEmpty(this.getAttachment());
    }

    @Override
    protected FishingOperation newEntity() {
        return this.fishingOperation;
    }

    public FishingOperation getFishingOperation() {
        return this.fishingOperation;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
        this.firePropertyChange(PROPERTY_PERSISTED, null, this.isPersisted());
    }

    public boolean isPersisted() {
        return this.fishingOperation != null && !TuttiEntities.isNew(this.fishingOperation);
    }

    public Integer getGearShootingStartLatitudeDegree() {
        Integer result = this.gearShootingStartLatitudeAsSexagecimal.getDegre();
        if (this.gearShootingStartLatitudeAsSexagecimal.isSign()) {
            result = result * -1;
        }
        return result;
    }

    public Integer getGearShootingStartLatitudeDecimalDegree() {
        return this.getGearShootingStartLatitudeDegree();
    }

    public void setGearShootingStartLatitudeDegree(Integer degree) {
        boolean sign;
        Integer oldValue = this.getGearShootingStartLatitudeDegree();
        boolean bl = sign = degree != null && degree < 0;
        if (degree != null) {
            degree = Math.abs(degree);
        }
        this.gearShootingStartLatitudeAsSexagecimal.setSign(sign);
        this.gearShootingStartLatitudeAsSexagecimal.setDegre(degree);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DEGREE, oldValue, degree);
    }

    public void setGearShootingStartLatitudeDecimalDegree(Integer degree) {
        this.setGearShootingStartLatitudeDegree(degree);
    }

    public Integer getGearShootingStartLatitudeMinute() {
        return this.gearShootingStartLatitudeAsSexagecimal.getMinute();
    }

    public void setGearShootingStartLatitudeMinute(Integer minute) {
        Integer oldValue = this.getGearShootingStartLatitudeMinute();
        this.gearShootingStartLatitudeAsSexagecimal.setMinute(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_MINUTE, oldValue, minute);
    }

    public Float getGearShootingStartLatitudeDecimalMinute() {
        return this.gearShootingStartLatitudeAsSexagecimal.getMinuteDecimale();
    }

    public void setGearShootingStartLatitudeDecimalMinute(Float decimalMinute) {
        this.gearShootingStartLatitudeAsSexagecimal.setMinuteDecimale(decimalMinute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DECIMAL_MINUTE, null, decimalMinute);
    }

    public Integer getGearShootingStartLatitudeSecond() {
        return this.gearShootingStartLatitudeAsSexagecimal.getSeconde();
    }

    public void setGearShootingStartLatitudeSecond(Integer second) {
        Integer oldValue = this.getGearShootingStartLatitudeSecond();
        this.gearShootingStartLatitudeAsSexagecimal.setSeconde(second);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_SECOND, oldValue, second);
    }

    public Integer getGearShootingStartLongitudeDegree() {
        Integer result = this.gearShootingStartLongitudeAsSexagecimal.getDegre();
        if (this.gearShootingStartLongitudeAsSexagecimal.isSign()) {
            result = result * -1;
        }
        return result;
    }

    public Integer getGearShootingStartLongitudeDecimalDegree() {
        return this.getGearShootingStartLongitudeDegree();
    }

    public void setGearShootingStartLongitudeDegree(Integer degree) {
        boolean sign;
        Integer oldValue = this.getGearShootingStartLongitudeDegree();
        boolean bl = sign = degree != null && degree < 0;
        if (degree != null) {
            degree = Math.abs(degree);
        }
        this.gearShootingStartLongitudeAsSexagecimal.setSign(sign);
        this.gearShootingStartLongitudeAsSexagecimal.setDegre(degree);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DEGREE, oldValue, degree);
    }

    public void setGearShootingStartLongitudeDecimalDegree(Integer degree) {
        this.setGearShootingStartLongitudeDegree(degree);
    }

    public Integer getGearShootingStartLongitudeMinute() {
        return this.gearShootingStartLongitudeAsSexagecimal.getMinute();
    }

    public void setGearShootingStartLongitudeMinute(Integer minute) {
        Integer oldValue = this.getGearShootingStartLongitudeMinute();
        this.gearShootingStartLongitudeAsSexagecimal.setMinute(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_MINUTE, oldValue, minute);
    }

    public Float getGearShootingStartLongitudeDecimalMinute() {
        return this.gearShootingStartLongitudeAsSexagecimal.getMinuteDecimale();
    }

    public void setGearShootingStartLongitudeDecimalMinute(Float decimalMinute) {
        this.gearShootingStartLongitudeAsSexagecimal.setMinuteDecimale(decimalMinute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DECIMAL_MINUTE, null, decimalMinute);
    }

    public Integer getGearShootingStartLongitudeSecond() {
        return this.gearShootingStartLongitudeAsSexagecimal.getSeconde();
    }

    public void setGearShootingStartLongitudeSecond(Integer second) {
        Integer oldValue = this.getGearShootingStartLongitudeSecond();
        this.gearShootingStartLongitudeAsSexagecimal.setSeconde(second);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_SECOND, oldValue, second);
    }

    public void setGearShootingStartTime(Date gearShootingStartDate) {
        Date oldValue = this.getGearShootingStartDate();
        if (oldValue != null) {
            this.setGearShootingStartDate(gearShootingStartDate);
        }
    }

    public Integer getGearShootingEndLatitudeDegree() {
        Integer result = this.gearShootingEndLatitudeAsSexagecimal.getDegre();
        if (this.gearShootingEndLatitudeAsSexagecimal.isSign()) {
            result = result * -1;
        }
        return result;
    }

    public Integer getGearShootingEndLatitudeDecimalDegree() {
        return this.getGearShootingEndLatitudeDegree();
    }

    public void setGearShootingEndLatitudeDegree(Integer degree) {
        boolean sign;
        Integer oldValue = this.getGearShootingEndLatitudeDegree();
        boolean bl = sign = degree != null && degree < 0;
        if (degree != null) {
            degree = Math.abs(degree);
        }
        this.gearShootingEndLatitudeAsSexagecimal.setSign(sign);
        this.gearShootingEndLatitudeAsSexagecimal.setDegre(degree);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DEGREE, oldValue, degree);
    }

    public void setGearShootingEndLatitudeDecimalDegree(Integer degree) {
        this.setGearShootingEndLatitudeDegree(degree);
    }

    public Integer getGearShootingEndLatitudeMinute() {
        return this.gearShootingEndLatitudeAsSexagecimal.getMinute();
    }

    public void setGearShootingEndLatitudeMinute(Integer minute) {
        Integer oldValue = this.getGearShootingEndLatitudeMinute();
        this.gearShootingEndLatitudeAsSexagecimal.setMinute(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_MINUTE, oldValue, minute);
    }

    public Float getGearShootingEndLatitudeDecimalMinute() {
        return this.gearShootingEndLatitudeAsSexagecimal.getMinuteDecimale();
    }

    public void setGearShootingEndLatitudeDecimalMinute(Float decimalMinute) {
        this.gearShootingEndLatitudeAsSexagecimal.setMinuteDecimale(decimalMinute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DECIMAL_MINUTE, null, decimalMinute);
    }

    public Integer getGearShootingEndLatitudeSecond() {
        return this.gearShootingEndLatitudeAsSexagecimal.getSeconde();
    }

    public void setGearShootingEndLatitudeSecond(Integer second) {
        Integer oldValue = this.getGearShootingEndLatitudeSecond();
        this.gearShootingEndLatitudeAsSexagecimal.setSeconde(second);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_SECOND, oldValue, second);
    }

    public Integer getGearShootingEndLongitudeDegree() {
        Integer result = this.gearShootingEndLongitudeAsSexagecimal.getDegre();
        if (this.gearShootingEndLongitudeAsSexagecimal.isSign()) {
            result = result * -1;
        }
        return result;
    }

    public Integer getGearShootingEndLongitudeDecimalDegree() {
        return this.getGearShootingEndLongitudeDegree();
    }

    public void setGearShootingEndLongitudeDegree(Integer degree) {
        boolean sign;
        Integer oldValue = this.getGearShootingEndLongitudeDegree();
        boolean bl = sign = degree != null && degree < 0;
        if (degree != null) {
            degree = Math.abs(degree);
        }
        this.gearShootingEndLongitudeAsSexagecimal.setSign(sign);
        this.gearShootingEndLongitudeAsSexagecimal.setDegre(degree);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DEGREE, oldValue, degree);
    }

    public void setGearShootingEndLongitudeDecimalDegree(Integer degree) {
        this.setGearShootingEndLongitudeDegree(degree);
    }

    public Integer getGearShootingEndLongitudeMinute() {
        return this.gearShootingEndLongitudeAsSexagecimal.getMinute();
    }

    public void setGearShootingEndLongitudeMinute(Integer minute) {
        Integer oldValue = this.getGearShootingEndLongitudeMinute();
        this.gearShootingEndLongitudeAsSexagecimal.setMinute(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_MINUTE, oldValue, minute);
    }

    public Float getGearShootingEndLongitudeDecimalMinute() {
        return this.gearShootingEndLongitudeAsSexagecimal.getMinuteDecimale();
    }

    public void setGearShootingEndLongitudeDecimalMinute(Float decimalMinute) {
        this.gearShootingEndLongitudeAsSexagecimal.setMinuteDecimale(decimalMinute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DECIMAL_MINUTE, null, decimalMinute);
    }

    public Integer getGearShootingEndLongitudeSecond() {
        return this.gearShootingEndLongitudeAsSexagecimal.getSeconde();
    }

    public void setGearShootingEndLongitudeSecond(Integer second) {
        Integer oldValue = this.getGearShootingEndLongitudeSecond();
        this.gearShootingEndLongitudeAsSexagecimal.setSeconde(second);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_SECOND, oldValue, second);
    }

    public void setGearShootingEndTime(Date gearShootingEndDate) {
        Date oldValue = this.getGearShootingEndDate();
        if (oldValue != null) {
            this.setGearShootingEndDate(gearShootingEndDate);
        }
    }

    public String getValidationContext() {
        return this.validationContext;
    }

    public void setValidationContext(String validationContext) {
        String oldValue = this.getValidationContext();
        this.validationContext = validationContext;
        this.firePropertyChange(PROPERTY_VALIDATION_CONTEXT, oldValue, validationContext);
    }

    public CoordinateEditorType getCoordinateEditorType() {
        return this.coordinateEditorType;
    }

    public void setCoordinateEditorType(CoordinateEditorType coordinateEditorType) {
        this.coordinateEditorType = coordinateEditorType;
    }

    public boolean isDateInCruise(Date date) {
        return DateUtil.between((Date)date, (Date)this.getCruise().getBeginDate(), (Date)this.getCruise().getEndDate());
    }

    public boolean isValidDuration() {
        int minutes = DateUtil.getDifferenceInMinutes((Date)this.getGearShootingStartDate(), (Date)this.getGearShootingEndDate());
        return minutes <= 45 && minutes >= 20;
    }

    public void convertGearShootingCoordinatesDDToDMS() {
        SexagecimalPosition position = SexagecimalPosition.valueOf(this.getGearShootingStartLatitude());
        Integer degree = position.getDegre();
        if (degree != null) {
            degree = degree * (position.isSign() ? -1 : 1);
        }
        this.setGearShootingStartLatitudeDegree(degree);
        this.setGearShootingStartLatitudeMinute(position.getMinute());
        this.setGearShootingStartLatitudeSecond(position.getSeconde());
        this.setGearShootingStartLatitudeDecimalMinute(position.getMinuteDecimale());
        position = SexagecimalPosition.valueOf(this.getGearShootingStartLongitude());
        degree = position.getDegre();
        if (degree != null) {
            degree = degree * (position.isSign() ? -1 : 1);
        }
        this.setGearShootingStartLongitudeDegree(degree);
        this.setGearShootingStartLongitudeMinute(position.getMinute());
        this.setGearShootingStartLongitudeSecond(position.getSeconde());
        this.setGearShootingStartLongitudeDecimalMinute(position.getMinuteDecimale());
        position = SexagecimalPosition.valueOf(this.getGearShootingEndLatitude());
        degree = position.getDegre();
        if (degree != null) {
            degree = degree * (position.isSign() ? -1 : 1);
        }
        if (position.getDegre() != null) {
            // empty if block
        }
        this.setGearShootingEndLatitudeDegree(degree);
        this.setGearShootingEndLatitudeMinute(position.getMinute());
        this.setGearShootingEndLatitudeSecond(position.getSeconde());
        this.setGearShootingEndLatitudeDecimalMinute(position.getMinuteDecimale());
        position = SexagecimalPosition.valueOf(this.getGearShootingEndLongitude());
        degree = position.getDegre();
        if (degree != null) {
            degree = degree * (position.isSign() ? -1 : 1);
        }
        this.setGearShootingEndLongitudeDegree(degree);
        this.setGearShootingEndLongitudeMinute(position.getMinute());
        this.setGearShootingEndLongitudeSecond(position.getSeconde());
        this.setGearShootingEndLongitudeDecimalMinute(position.getMinuteDecimale());
    }

    public void convertGearShootingCoordinatesDMSToDD() {
        Float decimalValue = this.gearShootingStartLatitudeAsSexagecimal.toDecimal();
        this.editObject.setGearShootingStartLatitude(decimalValue);
        decimalValue = this.gearShootingStartLongitudeAsSexagecimal.toDecimal();
        this.editObject.setGearShootingStartLongitude(decimalValue);
        decimalValue = this.gearShootingEndLatitudeAsSexagecimal.toDecimal();
        this.editObject.setGearShootingEndLatitude(decimalValue);
        decimalValue = this.gearShootingEndLongitudeAsSexagecimal.toDecimal();
        this.editObject.setGearShootingEndLongitude(decimalValue);
    }

    public void computeDistance() {
        if (this.coordinateEditorType != CoordinateEditorType.DD) {
            this.convertGearShootingCoordinatesDMSToDD();
        }
        if (this.getGearShootingStartLatitude() != null && this.getGearShootingStartLongitude() != null && this.getGearShootingEndLatitude() != null && this.getGearShootingEndLongitude() != null) {
            Integer distance = TuttiUIUtil.computeDistanceInMeters(this.getGearShootingStartLatitude(), this.getGearShootingStartLongitude(), this.getGearShootingEndLatitude(), this.getGearShootingEndLongitude());
            this.setTrawlDistance(Float.valueOf(distance.floatValue()));
        }
    }

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.OPERATION;
    }

    @Override
    public String getObjectId() {
        return this.getId();
    }

    @Override
    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public Cruise getCruise() {
        return this.editObject.getCruise();
    }

    @Override
    public void setCruise(Cruise cruise) {
        this.editObject.setCruise(cruise);
    }

    @Override
    public String getStationNumber() {
        return this.editObject.getStationNumber();
    }

    @Override
    public void setStationNumber(String stationNumber) {
        String oldValue = this.getStationNumber();
        this.editObject.setStationNumber(stationNumber);
        this.firePropertyChange("stationNumber", oldValue, stationNumber);
    }

    @Override
    public Integer getFishingOperationNumber() {
        return this.editObject.getFishingOperationNumber();
    }

    @Override
    public void setFishingOperationNumber(Integer fishingOperationNumber) {
        Integer oldValue = this.getFishingOperationNumber();
        this.editObject.setFishingOperationNumber(fishingOperationNumber);
        this.firePropertyChange("fishingOperationNumber", oldValue, fishingOperationNumber);
    }

    @Override
    public TuttiLocation getStrata() {
        return this.editObject.getStrata();
    }

    @Override
    public void setStrata(TuttiLocation strata) {
        TuttiLocation oldValue = this.getStrata();
        this.editObject.setStrata(strata);
        this.firePropertyChange("strata", oldValue, strata);
    }

    @Override
    public TuttiLocation getSubStrata() {
        return this.editObject.getSubStrata();
    }

    @Override
    public void setSubStrata(TuttiLocation subStrata) {
        TuttiLocation oldValue = this.getSubStrata();
        this.editObject.setSubStrata(subStrata);
        this.firePropertyChange("subStrata", oldValue, subStrata);
    }

    @Override
    public Float getGearShootingStartLatitude() {
        return this.editObject.getGearShootingStartLatitude();
    }

    @Override
    public void setGearShootingStartLatitude(Float gearShootingStartLatitude) {
        Float oldValue = this.getGearShootingStartLatitude();
        this.editObject.setGearShootingStartLatitude(gearShootingStartLatitude);
        this.firePropertyChange("gearShootingStartLatitude", oldValue, gearShootingStartLatitude);
    }

    @Override
    public Float getGearShootingStartLongitude() {
        return this.editObject.getGearShootingStartLongitude();
    }

    @Override
    public void setGearShootingStartLongitude(Float gearShootingStartLongitude) {
        Float oldValue = this.getGearShootingStartLongitude();
        this.editObject.setGearShootingStartLongitude(gearShootingStartLongitude);
        this.firePropertyChange("gearShootingStartLongitude", oldValue, gearShootingStartLongitude);
    }

    @Override
    public Date getGearShootingStartDate() {
        return this.editObject.getGearShootingStartDate();
    }

    @Override
    public void setGearShootingStartDate(Date gearShootingStartDate) {
        Date oldValue = this.getGearShootingStartDate();
        if (gearShootingStartDate != null) {
            Calendar calendar = DateUtil.getDefaultCalendar((Date)gearShootingStartDate);
            calendar.set(13, 0);
            this.editObject.setGearShootingStartDate(calendar.getTime());
        } else {
            this.editObject.setGearShootingStartDate(null);
        }
        this.firePropertyChange("gearShootingStartDate", oldValue, this.getGearShootingStartDate());
    }

    @Override
    public Float getGearShootingEndLatitude() {
        return this.editObject.getGearShootingEndLatitude();
    }

    @Override
    public void setGearShootingEndLatitude(Float gearShootingEndLatitude) {
        Float oldValue = this.getGearShootingEndLatitude();
        this.editObject.setGearShootingEndLatitude(gearShootingEndLatitude);
        this.firePropertyChange("gearShootingEndLatitude", oldValue, gearShootingEndLatitude);
    }

    @Override
    public Float getGearShootingEndLongitude() {
        return this.editObject.getGearShootingEndLongitude();
    }

    @Override
    public void setGearShootingEndLongitude(Float gearShootingEndLongitude) {
        Float oldValue = this.getGearShootingEndLongitude();
        this.editObject.setGearShootingEndLongitude(gearShootingEndLongitude);
        this.firePropertyChange("gearShootingEndLongitude", oldValue, gearShootingEndLongitude);
    }

    @Override
    public Date getGearShootingEndDate() {
        return this.editObject.getGearShootingEndDate();
    }

    @Override
    public void setGearShootingEndDate(Date gearShootingEndDate) {
        Date oldValue = this.getGearShootingEndDate();
        if (gearShootingEndDate != null) {
            Calendar calendar = DateUtil.getDefaultCalendar((Date)gearShootingEndDate);
            calendar.set(13, 0);
            this.editObject.setGearShootingEndDate(calendar.getTime());
        } else {
            this.editObject.setGearShootingEndDate(null);
        }
        this.firePropertyChange("gearShootingEndDate", oldValue, this.getGearShootingEndDate());
    }

    @Override
    public boolean isFishingOperationRectiligne() {
        return this.editObject.isFishingOperationRectiligne();
    }

    @Override
    public void setFishingOperationRectiligne(boolean fishingOperationRectiligne) {
        Boolean oldValue = this.isFishingOperationRectiligne();
        this.editObject.setFishingOperationRectiligne(fishingOperationRectiligne);
        this.firePropertyChange("fishingOperationRectiligne", oldValue, fishingOperationRectiligne);
    }

    @Override
    public Float getTrawlDistance() {
        return this.editObject.getTrawlDistance();
    }

    @Override
    public void setTrawlDistance(Float trawlDistance) {
        Float oldValue = this.getTrawlDistance();
        this.editObject.setTrawlDistance(trawlDistance);
        this.firePropertyChange("trawlDistance", oldValue, trawlDistance);
    }

    @Override
    public Boolean getFishingOperationValid() {
        return this.editObject.getFishingOperationValid();
    }

    @Override
    public void setFishingOperationValid(Boolean fishingOperationValid) {
        Boolean oldValue = this.getFishingOperationValid();
        this.editObject.setFishingOperationValid(fishingOperationValid);
        this.firePropertyChange("fishingOperationValid", oldValue, fishingOperationValid);
    }

    @Override
    public TuttiLocation getLocation() {
        return this.editObject.getLocation();
    }

    @Override
    public void setLocation(TuttiLocation location) {
        TuttiLocation oldValue = this.getLocation();
        this.editObject.setLocation(location);
        this.firePropertyChange("location", oldValue, location);
    }

    @Override
    public String getComment() {
        return this.editObject.getComment();
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.editObject.setComment(comment);
        this.firePropertyChange("comment", oldValue, comment);
    }

    @Override
    public List<Person> getRecorderPerson() {
        return this.editObject.getRecorderPerson();
    }

    @Override
    public void setRecorderPerson(List<Person> recorderPerson) {
        ArrayList oldValue = null;
        List<Person> oldRecorderPerson = this.getRecorderPerson();
        if (oldRecorderPerson != null) {
            oldValue = Lists.newArrayList(oldRecorderPerson);
        }
        this.editObject.setRecorderPerson(Lists.newArrayList());
        if (recorderPerson != null) {
            this.getRecorderPerson().addAll(recorderPerson);
        }
        this.firePropertyChange("recorderPerson", oldValue, recorderPerson);
    }

    @Override
    public Gear getGear() {
        return this.editObject.getGear();
    }

    @Override
    public void setGear(Gear gear) {
        Gear oldValue = this.getGear();
        this.editObject.setGear(gear);
        this.firePropertyChange("gear", oldValue, gear);
    }

    @Override
    public Vessel getVessel() {
        return this.editObject.getVessel();
    }

    @Override
    public void setVessel(Vessel vessel) {
        Vessel oldValue = this.getVessel();
        this.editObject.setVessel(vessel);
        this.firePropertyChange("vessel", oldValue, vessel);
    }

    @Override
    public String getMultirigAggregation() {
        return this.editObject.getMultirigAggregation();
    }

    @Override
    public void setMultirigAggregation(String multirigAggregation) {
        String oldValue = this.getMultirigAggregation();
        this.editObject.setMultirigAggregation(multirigAggregation);
        this.firePropertyChange("multirigAggregation", oldValue, multirigAggregation);
    }

    @Override
    public boolean isPlanktonObserved() {
        return false;
    }

    @Override
    public void setPlanktonObserved(boolean planktonObserved) {
    }

    @Override
    public CaracteristicMap getVesselUseFeatures() {
        return null;
    }

    @Override
    public void setVesselUseFeatures(CaracteristicMap vesselUseFeatures) {
    }

    @Override
    public CaracteristicMap getGearUseFeatures() {
        return null;
    }

    @Override
    public void setGearUseFeatures(CaracteristicMap gearUseFeatures) {
    }

    @Override
    public boolean isAccidentalObserved() {
        return false;
    }

    @Override
    public void setAccidentalObserved(boolean accidentalObserved) {
    }

    @Override
    public Person getRecorderPerson(int index) {
        return null;
    }

    @Override
    public boolean isRecorderPersonEmpty() {
        return false;
    }

    @Override
    public int sizeRecorderPerson() {
        return 0;
    }

    @Override
    public void addRecorderPerson(Person recorderPerson) {
    }

    @Override
    public void addAllRecorderPerson(Collection<Person> recorderPerson) {
    }

    @Override
    public boolean removeRecorderPerson(Person recorderPerson) {
        return false;
    }

    @Override
    public boolean removeAllRecorderPerson(Collection<Person> recorderPerson) {
        return false;
    }

    @Override
    public boolean containsRecorderPerson(Person recorderPerson) {
        return false;
    }

    @Override
    public boolean containsAllRecorderPerson(Collection<Person> recorderPerson) {
        return false;
    }
}

