/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.action;

import fr.ifremer.tutti.persistence.entities.referential.ObjectType;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionException;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionSwingWorker;
import java.awt.event.ActionEvent;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TuttiUIAction<A extends AbstractTuttiAction>
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(TuttiUIAction.class);
    public static final ExecutorService waitingThread = Executors.newSingleThreadExecutor();
    private static final String LOGIC_ACTION = "logicAction";
    private final Object lock = new ObjectType();
    private boolean wait;

    public TuttiUIAction(AbstractButton button, A action) {
        this.putValue(LOGIC_ACTION, action);
        this.setActionKey(action.getClass().getName());
        if (button != null) {
            this.setActionIcon(button.getIcon());
            this.setActionName(button.getText());
            this.setActionDescription(button.getToolTipText());
            this.setActionMnemonic(button.getMnemonic());
        }
    }

    public void launchActionAndWait() {
        this.wait = true;
        this.actionPerformed(null);
        this.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void actionPerformed(ActionEvent event) {
        boolean doAction;
        if (log.isInfoEnabled()) {
            log.info((Object)("Task [" + this + "] starting"));
        }
        A action = this.getLogicAction();
        ((AbstractTuttiAction)((Object)action)).sendMessage("");
        try {
            doAction = ((AbstractTuttiAction)((Object)action)).prepareAction();
        }
        catch (Exception e) {
            ((AbstractTuttiAction)((Object)action)).releaseAction();
            throw TuttiActionException.propagateError(action, e);
        }
        if (doAction) {
            final TuttiActionSwingWorker<A> worker = new TuttiActionSwingWorker<A>(action);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    worker.updateBusyState(true);
                }
            });
            if (log.isInfoEnabled()) {
                log.info((Object)("Before execute of action " + action));
            }
            worker.execute();
            waitingThread.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object action = TuttiUIAction.this.getLogicAction();
                    try {
                        try {
                            worker.get();
                        }
                        catch (ExecutionException e) {
                        }
                        catch (CancellationException e) {
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (log.isInfoEnabled()) {
                            log.info((Object)("After execute of action " + action + " (worker done? " + worker.isDone() + ")"));
                        }
                        if (worker.isFailed()) {
                            throw TuttiActionException.propagateError(action, worker.getError());
                        }
                    }
                    finally {
                        TuttiUIAction.this.unlock();
                    }
                }
            });
        } else {
            try {
                ((AbstractTuttiAction)((Object)action)).releaseAction();
            }
            finally {
                this.unlock();
            }
        }
    }

    public void setActionIcon(Icon actionIcon) {
        this.putValue("SmallIcon", actionIcon);
        this.putValue("SwingLargeIconKey", actionIcon);
    }

    public void setActionKey(String actionKey) {
        this.putValue("ActionCommandKey", actionKey);
    }

    public void setActionName(String actionName) {
        this.putValue("Name", actionName);
    }

    public void setActionDescription(String actionDescription) {
        this.putValue("ShortDescription", actionDescription);
        ((AbstractTuttiAction)((Object)this.getLogicAction())).setActionDescription(actionDescription);
    }

    public void setActionMnemonic(int key) {
        this.putValue("MnemonicKey", key);
    }

    public A getLogicAction() {
        return (A)((Object)((AbstractTuttiAction)((Object)this.getValue(LOGIC_ACTION))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lock() {
        if (this.wait) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw TuttiActionException.propagateError(this.getLogicAction(), e);
                }
                finally {
                    this.wait = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlock() {
        if (this.wait) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }
}

