/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.measure.photo;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.data.measure.photo.Photo;
import fr.ifremer.adagio.core.dao.data.measure.photo.PhotoDao;
import fr.ifremer.adagio.core.dao.data.measure.photo.PhotoImpl;
import fr.ifremer.adagio.core.dao.referential.ObjectType;
import fr.ifremer.adagio.core.dao.referential.PhotoType;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class PhotoDaoBase
extends HibernateDaoSupport
implements PhotoDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Photo.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(PhotoImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (Photo)entity);
    }

    @Override
    public Photo load(Integer id) {
        return (Photo)this.load(0, id);
    }

    @Override
    public Collection<Photo> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(PhotoImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Photo create(Photo photo) {
        return (Photo)this.create(0, photo);
    }

    @Override
    public Object create(int transform, Photo photo) {
        if (photo == null) {
            throw new IllegalArgumentException("Photo.create - 'photo' can not be null");
        }
        this.getHibernateTemplate().save((Object)photo);
        return this.transformEntity(transform, photo);
    }

    @Override
    public Collection<Photo> create(Collection<Photo> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Photo> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Photo.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    PhotoDaoBase.this.create(transform, (Photo)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Photo create(Integer objectId, String name, String directionDescription, String comments, String path, Date photoDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, QualityFlag qualityFlag, Department department, PhotoType photoType, ObjectType objectType) {
        return (Photo)this.create(0, objectId, name, directionDescription, comments, path, photoDate, validationDate, qualificationDate, qualificationComments, updateDate, qualityFlag, department, photoType, objectType);
    }

    @Override
    public Object create(int transform, Integer objectId, String name, String directionDescription, String comments, String path, Date photoDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, QualityFlag qualityFlag, Department department, PhotoType photoType, ObjectType objectType) {
        PhotoImpl entity = new PhotoImpl();
        entity.setObjectId(objectId);
        entity.setName(name);
        entity.setDirectionDescription(directionDescription);
        entity.setComments(comments);
        entity.setPath(path);
        entity.setPhotoDate(photoDate);
        entity.setValidationDate(validationDate);
        entity.setQualificationDate(qualificationDate);
        entity.setQualificationComments(qualificationComments);
        entity.setUpdateDate(updateDate);
        entity.setQualityFlag(qualityFlag);
        entity.setDepartment(department);
        entity.setPhotoType(photoType);
        entity.setObjectType(objectType);
        return this.create(transform, entity);
    }

    @Override
    public Photo create(Integer objectId, ObjectType objectType, String path, PhotoType photoType, QualityFlag qualityFlag) {
        return (Photo)this.create(0, objectId, objectType, path, photoType, qualityFlag);
    }

    @Override
    public Object create(int transform, Integer objectId, ObjectType objectType, String path, PhotoType photoType, QualityFlag qualityFlag) {
        PhotoImpl entity = new PhotoImpl();
        entity.setObjectId(objectId);
        entity.setObjectType(objectType);
        entity.setPath(path);
        entity.setPhotoType(photoType);
        entity.setQualityFlag(qualityFlag);
        return this.create(transform, entity);
    }

    @Override
    public void update(Photo photo) {
        if (photo == null) {
            throw new IllegalArgumentException("Photo.update - 'photo' can not be null");
        }
        this.getHibernateTemplate().update((Object)photo);
    }

    @Override
    public void update(final Collection<Photo> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Photo.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    PhotoDaoBase.this.update((Photo)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Photo photo) {
        if (photo == null) {
            throw new IllegalArgumentException("Photo.remove - 'photo' can not be null");
        }
        this.getHibernateTemplate().delete((Object)photo);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Photo.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        Photo entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Photo> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Photo.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Photo entity) {
        Photo target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Photo toEntity(Object[] row) {
        Photo target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Photo)) continue;
                target = (Photo)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), PhotoImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), PhotoImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Photo> search(Search search) {
        return this.search(0, search);
    }
}

