/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.TuttiPersistenceNoDbImpl;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MacroWasteBatch;
import fr.ifremer.tutti.persistence.entities.data.PlanktonBatch;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Country;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.ObjectType;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Zone;
import fr.ifremer.tutti.persistence.service.TuttiPersistenceServiceLocator;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.config.TuttiServiceConfig;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;

public class PersistenceService
extends AbstractTuttiService
implements TuttiPersistence {
    private static final Log log = LogFactory.getLog(PersistenceService.class);
    protected TuttiPersistence driver;
    public static final DateFormat EXPORT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final String EXPORT_DIRECTORY_FORMAT = "tutti-%s-%s";

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.init();
    }

    public String getImplementationName() {
        return "Tutti Persistence Service";
    }

    public void clearAllCaches() {
        this.driver.clearAllCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDb(File file) {
        Preconditions.checkState((!this.isDbLoaded() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)file);
        TuttiServiceConfig config = this.context.getConfig();
        String directoryName = String.format(EXPORT_DIRECTORY_FORMAT, config.getVersion(), EXPORT_DATE_FORMAT.format(this.context.currentDate()));
        File structureDirectory = new File(config.newTempFile("exportdb"), directoryName);
        try {
            TuttiIOUtil.forceMkdir((File)structureDirectory, (String)"Could not create directory");
            if (log.isInfoEnabled()) {
                log.info((Object)("Export directory: " + structureDirectory));
            }
            TuttiPersistenceConfig pConfig = config.getPersistenceConfig();
            TuttiIOUtil.copyDirectory((File)pConfig.getDbDirectory(), (File)new File(structureDirectory, "db"), (String)"Could not copy db directory");
            TuttiIOUtil.copyDirectory((File)pConfig.getProtocolDirectory(), (File)new File(structureDirectory, "protocol"), (String)"Could not copy db protocol directory");
            TuttiIOUtil.copyDirectory((File)pConfig.getDbAttachmentDirectory(), (File)new File(structureDirectory, "meas_files"), (String)"Could not copy db attachment directory");
            TuttiIOUtil.zip((File)structureDirectory, (File)file, (String)("Could not create archive at " + file));
        }
        finally {
            TuttiIOUtil.forceDeleteOnExit((File)structureDirectory, (String)("could not delete on exit temporary file " + structureDirectory));
        }
    }

    public void checkImportStructure(File file) {
        if (!file.exists()) {
            throw new TuttiBusinessException("Db archive " + file + " does not exists");
        }
        FileObject fileObject = TuttiIOUtil.resolveFile((String)("zip:" + file.getAbsolutePath()), (String)"could not obtain archive");
        FileObject[] children = TuttiIOUtil.getChildren((FileObject)fileObject, (String)"Could not open archive");
        if (children.length != 1) {
            throw new TuttiBusinessException("Db archive " + file + " should have only one children");
        }
        fileObject = children[0];
        this.checkArchiveDb(file, fileObject, "db");
        this.checkArchiveDb(file, fileObject, "meas_files");
        this.checkArchiveDb(file, fileObject, "protocol");
    }

    protected void checkArchiveDb(File file, FileObject fileObject, String dir) {
        FileObject directory = TuttiIOUtil.getChild((FileObject)fileObject, (String)dir, (String)(" could not obtain child " + dir));
        if (directory == null) {
            throw new TuttiBusinessException("Db archive " + file + " does not contains a " + dir + " directory.");
        }
    }

    public void importDb(File file) {
        Preconditions.checkState((!this.isDbLoaded() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)file);
        TuttiServiceConfig config = this.context.getConfig();
        File target = config.getDataDirectory();
        if (log.isInfoEnabled()) {
            log.info((Object)("Import db to " + target));
        }
        FileObject fileObject = TuttiIOUtil.resolveFile((String)("zip:" + file.getAbsolutePath()), (String)"could not obtain archive");
        FileObject[] children = TuttiIOUtil.getChildren((FileObject)fileObject, (String)"Could not open archive");
        fileObject = children[0];
        TuttiIOUtil.explode((FileObject)fileObject, (File)target, (FileSelector)new AllFileSelector(), (String)("Could not decompress archive " + file));
    }

    public boolean isDbLoaded() {
        return !(this.driver instanceof TuttiPersistenceNoDbImpl);
    }

    public void init() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Open persistence service");
        }
        TuttiServiceConfig serviceConfig = this.context.getConfig();
        TuttiPersistenceConfig config = serviceConfig.getPersistenceConfig();
        TuttiPersistenceConfig.setInstance((TuttiPersistenceConfig)config);
        if (config.isDbExists()) {
            String jdbcUrl = config.getJdbcUrl();
            if (log.isInfoEnabled()) {
                log.info((Object)("Using database at " + jdbcUrl));
            }
            this.driver = TuttiPersistenceServiceLocator.getPersistenceService();
        } else {
            this.driver = new TuttiPersistenceNoDbImpl();
            this.driver.init();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Persistence driver *" + this.driver.getImplementationName() + "* opened."));
        }
    }

    @Override
    public void close() throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Close persistence Service");
        }
        IOUtils.closeQuietly((Closeable)this.driver);
        if (log.isInfoEnabled()) {
            log.info((Object)("Persistence driver *" + this.driver.getImplementationName() + "* closed."));
        }
    }

    public List<Vessel> getAllScientificVessel() {
        return this.driver.getAllScientificVessel();
    }

    public List<Vessel> getAllFishingVessel() {
        return this.driver.getAllFishingVessel();
    }

    public List<Species> getAllSpecies() {
        return this.driver.getAllSpecies();
    }

    public List<Species> getAllReferentSpecies() {
        return this.driver.getAllReferentSpecies();
    }

    public List<Species> getAllSpecies(TuttiProtocol protocol) {
        return this.driver.getAllSpecies(protocol);
    }

    public List<Species> getAllReferentSpecies(TuttiProtocol protocol) {
        return this.driver.getAllReferentSpecies(protocol);
    }

    public List<Caracteristic> getAllCaracteristic() {
        return this.driver.getAllCaracteristic();
    }

    public List<Caracteristic> getAllNumericCaracteristic() {
        return this.driver.getAllNumericCaracteristic();
    }

    public List<Zone> getAllProgramZone() {
        return this.driver.getAllProgramZone();
    }

    public List<Country> getAllCountry() {
        return this.driver.getAllCountry();
    }

    public List<Gear> getAllScientificGear() {
        return this.driver.getAllScientificGear();
    }

    public List<Gear> getAllFishingGear() {
        return this.driver.getAllFishingGear();
    }

    public List<Person> getAllPerson() {
        return this.driver.getAllPerson();
    }

    public List<ObjectType> getAllObjectType() {
        return this.driver.getAllObjectType();
    }

    public List<FishingOperationLocation> getAllFishingOperationStrata(String zoneId) {
        return this.driver.getAllFishingOperationStrata(zoneId);
    }

    public List<FishingOperationLocation> getAllFishingOperationSubStrata(String zoneId, String strataId) {
        return this.driver.getAllFishingOperationSubStrata(zoneId, strataId);
    }

    public List<FishingOperationLocation> getAllFishingOperationLocation(String zoneId, String strataId, String subStrataId) {
        return this.driver.getAllFishingOperationLocation(zoneId, strataId, subStrataId);
    }

    public Caracteristic getSizeCategoryCaracteristic() {
        return this.driver.getSizeCategoryCaracteristic();
    }

    public Caracteristic getSexCaracteristic() {
        return this.driver.getSexCaracteristic();
    }

    public Caracteristic getSortedUnsortedCaracteristic() {
        return this.driver.getSortedUnsortedCaracteristic();
    }

    public Caracteristic getMaturityCaracteristic() {
        return this.driver.getMaturityCaracteristic();
    }

    public Caracteristic getAgeCaracteristic() {
        return this.driver.getAgeCaracteristic();
    }

    public Caracteristic getMacroWasteCategoryCaracteristic() {
        return this.driver.getMacroWasteCategoryCaracteristic();
    }

    public Caracteristic getMacroWasteSizeCategoryCaracteristic() {
        return this.driver.getMacroWasteSizeCategoryCaracteristic();
    }

    public Vessel getVessel(String vesselCode) {
        return this.driver.getVessel(vesselCode);
    }

    public boolean isSortedQualitativeValue(CaracteristicQualitativeValue value) {
        return this.driver.isSortedQualitativeValue(value);
    }

    public Person getPerson(Integer personId) {
        return this.driver.getPerson(personId);
    }

    public Gear getGear(Integer gearCode) {
        return this.driver.getGear(gearCode);
    }

    public ObjectType getObjectType(String objectTypeCode) {
        return this.driver.getObjectType(objectTypeCode);
    }

    public List<Species> importTemporarySpecies(List<Species> species) {
        return this.driver.importTemporarySpecies(species);
    }

    public List<Vessel> importTemporaryVessel(List<Vessel> vessels) {
        return this.driver.importTemporaryVessel(vessels);
    }

    public List<Person> importTemporaryPerson(List<Person> persons) {
        return this.driver.importTemporaryPerson(persons);
    }

    public List<Gear> importTemporaryGear(List<Gear> gears) {
        return this.driver.importTemporaryGear(gears);
    }

    public List<Attachment> getAllAttachments(Integer objectId) {
        return this.driver.getAllAttachments(objectId);
    }

    public File getAttachmentFile(String attachmentId) {
        return this.driver.getAttachmentFile(attachmentId);
    }

    public Attachment createAttachment(Attachment attachment, File file) {
        return this.driver.createAttachment(attachment, file);
    }

    public Attachment saveAttachment(Attachment attachment) {
        return this.driver.saveAttachment(attachment);
    }

    public void deleteAttachment(String attachmentId) {
        this.driver.deleteAttachment(attachmentId);
    }

    public List<Program> getAllProgram() {
        return this.driver.getAllProgram();
    }

    public Program getProgram(String id) {
        return this.driver.getProgram(id);
    }

    public Program createProgram(Program bean) {
        return this.driver.createProgram(bean);
    }

    public Program saveProgram(Program bean) {
        return this.driver.saveProgram(bean);
    }

    public List<Cruise> getAllCruise(String programId) {
        return this.driver.getAllCruise(programId);
    }

    public Cruise getCruise(String id) {
        return this.driver.getCruise(id);
    }

    public Cruise createCruise(Cruise bean) {
        return this.driver.createCruise(bean);
    }

    public Cruise saveCruise(Cruise bean) {
        return this.driver.saveCruise(bean);
    }

    public boolean isProtocolExist(String id) {
        return this.driver.isProtocolExist(id);
    }

    public List<String> getAllProtocolNames() {
        return this.driver.getAllProtocolNames();
    }

    public List<TuttiProtocol> getAllProtocol() {
        return this.driver.getAllProtocol();
    }

    public TuttiProtocol getProtocol(String id) {
        return this.driver.getProtocol(id);
    }

    public TuttiProtocol createProtocol(TuttiProtocol bean) {
        return this.driver.createProtocol(bean);
    }

    public TuttiProtocol saveProtocol(TuttiProtocol bean) {
        return this.driver.saveProtocol(bean);
    }

    public void deleteProtocol(String id) {
        this.driver.deleteProtocol(id);
    }

    public List<FishingOperation> getAllFishingOperation(String cruiseId) {
        return this.driver.getAllFishingOperation(cruiseId);
    }

    public FishingOperation getFishingOperation(String id) {
        FishingOperation bean = this.driver.getFishingOperation(id);
        if (bean.getGearShootingEndDate() == null) {
            bean.setGearShootingEndDate(bean.getGearShootingStartDate());
        }
        return bean;
    }

    public FishingOperation createFishingOperation(FishingOperation bean) {
        if (ObjectUtils.equals((Object)bean.getGearShootingStartDate(), (Object)bean.getGearShootingEndDate())) {
            bean.setGearShootingEndDate(null);
        }
        return this.driver.createFishingOperation(bean);
    }

    public FishingOperation saveFishingOperation(FishingOperation bean) {
        if (ObjectUtils.equals((Object)bean.getGearShootingStartDate(), (Object)bean.getGearShootingEndDate())) {
            bean.setGearShootingEndDate(null);
        }
        return this.driver.saveFishingOperation(bean);
    }

    public CatchBatch getCatchBatchFromFishingOperation(String id) throws InvalidBatchModelException {
        return this.driver.getCatchBatchFromFishingOperation(id);
    }

    public CatchBatch createCatchBatch(CatchBatch bean) {
        return this.driver.createCatchBatch(bean);
    }

    public CatchBatch saveCatchBatch(CatchBatch bean) {
        return this.driver.saveCatchBatch(bean);
    }

    public BatchContainer<SpeciesBatch> getRootSpeciesBatch(String fishingOperationId) {
        return this.driver.getRootSpeciesBatch(fishingOperationId);
    }

    public SpeciesBatch createSpeciesBatch(SpeciesBatch bean, String parentBatchId) {
        return this.driver.createSpeciesBatch(bean, parentBatchId);
    }

    public SpeciesBatch saveSpeciesBatch(SpeciesBatch bean) {
        return this.driver.saveSpeciesBatch(bean);
    }

    public void deleteSpeciesBatch(String id) {
        this.driver.deleteSpeciesBatch(id);
    }

    public void deleteSpeciesSubBatch(String id) {
        this.driver.deleteSpeciesSubBatch(id);
    }

    public void changeSpeciesBatchSpecies(String batchId, Species species) {
        this.driver.changeSpeciesBatchSpecies(batchId, species);
    }

    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(String speciesBatchId) {
        return this.driver.getAllSpeciesBatchFrequency(speciesBatchId);
    }

    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(String speciesBatchId, List<SpeciesBatchFrequency> frequencies) {
        return this.driver.saveSpeciesBatchFrequency(speciesBatchId, frequencies);
    }

    public List<SpeciesBatch> getAllRootBenthosBatch(String fishingOperationId) {
        return this.driver.getAllRootBenthosBatch(fishingOperationId);
    }

    public SpeciesBatch createBenthosBatch(SpeciesBatch bean, String parentBatchId) {
        return this.driver.createBenthosBatch(bean, parentBatchId);
    }

    public SpeciesBatch saveBenthosBatch(SpeciesBatch bean) {
        return this.driver.saveBenthosBatch(bean);
    }

    public void deleteBenthosBatch(String id) {
        this.driver.deleteBenthosBatch(id);
    }

    public void deleteBenthosSubBatch(String id) {
        this.driver.deleteBenthosSubBatch(id);
    }

    public void changeBenthosBatchSpecies(String batchId, Species species) {
        this.driver.changeBenthosBatchSpecies(batchId, species);
    }

    public List<SpeciesBatchFrequency> getAllBenthosBatchFrequency(String benthosBatchId) {
        return this.driver.getAllBenthosBatchFrequency(benthosBatchId);
    }

    public List<SpeciesBatchFrequency> saveBenthosBatchFrequency(String benthosBatchId, List<SpeciesBatchFrequency> frequencies) {
        return this.driver.saveBenthosBatchFrequency(benthosBatchId, frequencies);
    }

    public List<PlanktonBatch> getAllPlanktonBatch(String fishingOperationId) {
        return this.driver.getAllPlanktonBatch(fishingOperationId);
    }

    public PlanktonBatch getPlanktonBatch(String id) {
        return this.driver.getPlanktonBatch(id);
    }

    public PlanktonBatch createPlanktonBatch(PlanktonBatch bean) {
        return this.driver.createPlanktonBatch(bean);
    }

    public PlanktonBatch savePlanktonBatch(PlanktonBatch bean) {
        return this.driver.savePlanktonBatch(bean);
    }

    public void deletePlanktonBatch(String id) {
        this.driver.deletePlanktonBatch(id);
    }

    public List<MacroWasteBatch> getAllMacroWasteBatch(String fishingOperationId) {
        return this.driver.getAllMacroWasteBatch(fishingOperationId);
    }

    public MacroWasteBatch getMacroWasteBatch(String id) {
        return this.driver.getMacroWasteBatch(id);
    }

    public MacroWasteBatch createMacroWasteBatch(MacroWasteBatch bean) {
        return this.driver.createMacroWasteBatch(bean);
    }

    public MacroWasteBatch saveMacroWasteBatch(MacroWasteBatch bean) {
        return this.driver.saveMacroWasteBatch(bean);
    }

    public void deleteMacroWasteBatch(String id) {
        this.driver.deleteMacroWasteBatch(id);
    }

    public List<AccidentalBatch> getAllAccidentalBatch(String fishingOperationId) {
        return this.driver.getAllAccidentalBatch(fishingOperationId);
    }

    public AccidentalBatch getAccidentalBatch(String id) {
        return this.driver.getAccidentalBatch(id);
    }

    public AccidentalBatch createAccidentalBatch(AccidentalBatch bean) {
        return this.driver.createAccidentalBatch(bean);
    }

    public AccidentalBatch saveAccidentalBatch(AccidentalBatch bean) {
        return this.driver.saveAccidentalBatch(bean);
    }

    public void deleteAccidentalBatch(String id) {
        this.driver.deleteAccidentalBatch(id);
    }
}

