/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportDbAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(ExportDbAction.class);
    protected File file;

    public ExportDbAction(MainUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        this.file = null;
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.dbManager.title.choose.dbExportFile", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.chooseDbExportFile", (Object[])new Object[0]), "^.*\\.zip", I18n._((String)"tutti.common.file.zip", (Object[])new Object[0]));
            if (this.file == null) {
                doAction = false;
            } else {
                this.file = TuttiIOUtil.addExtensionIfMissing(this.file, ".zip");
                doAction = ((MainUIHandler)this.getHandler()).askOverwriteFile(this.file);
            }
        }
        return doAction;
    }

    @Override
    protected void doAction() {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export db to " + this.file));
        }
        ProgressionModel progressionModel = new ProgressionModel();
        this.setProgressionModel(progressionModel);
        progressionModel.setTotal(3);
        progressionModel.setMessage("Fermuture de la base courante");
        this.getContext().setDbLoaded(false);
        ((MainUIHandler)this.getHandler()).reloadPersistenceService();
        progressionModel.increments(1);
        progressionModel.setMessage("Cr\u00e9ation de l'archive " + this.file);
        this.getContext().getPersistenceService().exportDb(this.file);
        progressionModel.increments(1);
        progressionModel.setMessage("R\u00e9ouverture de la base courante");
        this.getContext().setDbLoaded(true);
        ((MainUIHandler)this.getHandler()).reloadPersistenceService();
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n._((String)"tutti.flash.info.db.exported", (Object[])new Object[]{this.file}));
        ((MainUI)this.getUI()).getHandler().changeTitle();
    }
}

