/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting.GearShootingRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting.GearShootingTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting.GearShootingTabUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting.GearShootingTableModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueEditor;
import fr.ifremer.tutti.ui.swing.util.editor.CaracteristicValueRenderer;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;

public class GearShootingTabUIHandler
extends AbstractTuttiTableUIHandler<GearShootingRowModel, GearShootingTabUIModel> {
    private static final Log log = LogFactory.getLog(GearShootingTabUIHandler.class);
    protected final GearShootingTabUI ui;

    public GearShootingTabUIHandler(EditFishingOperationUI parentUi, GearShootingTabUI ui) {
        super(parentUi.getHandler().getContext(), "value");
        this.ui = ui;
    }

    protected GearShootingTableModel getTableModel() {
        return (GearShootingTableModel)this.getTable().getModel();
    }

    @Override
    protected JXTable getTable() {
        return this.ui.getGearShootingTable();
    }

    @Override
    protected boolean isRowValid(GearShootingRowModel row) {
        return row.getValue() != null;
    }

    @Override
    protected void onRowModified(int rowIndex, GearShootingRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        super.onRowModified(rowIndex, row, propertyName, oldValue, newValue);
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<GearShootingRowModel> rowMonitor, GearShootingRowModel row) {
        if (row.isValid() && rowMonitor.wasModified()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Row " + (Object)((Object)row) + " was modified, will save it"));
            }
            this.showInformationMessage("[ Trait - Engin ] Sauvegarde des modifications de " + (Object)((Object)row) + ".");
            this.saveRow(row);
            rowMonitor.clearModified();
            this.getModel().setModify(false);
        }
    }

    @Override
    protected GearShootingTabUIModel getModel() {
        return this.ui.getModel();
    }

    @Override
    public void beforeInitUI() {
        GearShootingTabUIModel model = new GearShootingTabUIModel();
        this.ui.setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        this.initBeanComboBox(this.ui.getNewRowKey(), Lists.newArrayList(), null);
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Caracteristic.class, "withUnit"), GearShootingTableModel.KEY);
        this.addColumnToModel((TableColumnModel)columnModel, new CaracteristicValueEditor(this.context), new CaracteristicValueRenderer(this.context), GearShootingTableModel.VALUE);
        GearShootingTableModel tableModel = new GearShootingTableModel((TableColumnModel)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, GearShootingRowModel oldRow, int newRowIndex, GearShootingRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        this.getModel().setRemoveCaracteristicEnabled(newRow != null);
    }

    public void addRow() {
        BeanComboBox<Caracteristic> keyCombo = this.ui.getNewRowKey();
        Caracteristic selectedItem = (Caracteristic)keyCombo.getSelectedItem();
        GearShootingRowModel row = this.getTableModel().createNewRow();
        row.setKey(selectedItem);
        this.getModel().getRows().add(row);
        GearShootingTableModel tableModel = this.getTableModel();
        int rowIndex = tableModel.getRowCount() - 1;
        tableModel.fireTableRowsInserted(rowIndex, rowIndex);
        keyCombo.removeItem((Object)selectedItem);
        this.selectFirstInCombo(keyCombo);
        GearShootingTabUIModel model = this.getModel();
        model.setModify(true);
        model.setValid(row.isValid());
    }

    public void reset(FishingOperation fishingOperation) {
        List protocolGearPmfmId;
        GearShootingTableModel tableModel = this.getTableModel();
        GearShootingTabUIModel model = this.getModel();
        model.setFishingOperation(fishingOperation);
        CaracteristicMap gearShootingCaracteristics = fishingOperation.getGearShootingCaracteristics();
        if (gearShootingCaracteristics == null) {
            gearShootingCaracteristics = new CaracteristicMap();
        }
        TuttiProtocol protocol = this.ui.getContextValue(TuttiProtocol.class);
        ArrayList gearPmfmIds = Lists.newArrayList();
        if (protocol != null && (protocolGearPmfmId = protocol.getGearPmfmId()) != null) {
            gearPmfmIds.addAll(protocolGearPmfmId);
        }
        ArrayList rows = Lists.newArrayList();
        ArrayList caracteristics = Lists.newArrayList((Iterable)gearShootingCaracteristics.keySet());
        List<Caracteristic> availableCaracteristics = model.getAvailableCaracteristics();
        for (String id : gearPmfmIds) {
            Caracteristic caracteristic = (Caracteristic)TuttiEntities.findById(availableCaracteristics, (String)id);
            if (caracteristics.contains(caracteristic)) continue;
            caracteristics.add(caracteristic);
        }
        for (Caracteristic key : caracteristics) {
            GearShootingRowModel newRow = tableModel.createNewRow();
            newRow.setKey(key);
            newRow.setValue((Serializable)gearShootingCaracteristics.get((Object)key));
            rows.add(newRow);
        }
        model.setRows(rows);
        ArrayList caracteristicList = Lists.newArrayList();
        for (Caracteristic caracteristic : availableCaracteristics) {
            if (caracteristics.contains(caracteristic)) continue;
            caracteristicList.add(caracteristic);
        }
        this.ui.getNewRowKey().setData((List)caracteristicList);
        this.selectFirstInCombo(this.ui.getNewRowKey());
        model.setModify(false);
    }

    public void removeCaracteristic() {
        int rowIndex = this.getTable().getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove caracteristic if no caracteristic selected");
        GearShootingRowModel row = (GearShootingRowModel)((Object)this.getTableModel().getEntry(rowIndex));
        FishingOperation fishingOperation = this.getModel().getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        fishingOperation.getGearShootingCaracteristics().remove((Object)row.getKey());
        if (TuttiEntities.isNew((IdAware)fishingOperation)) {
            fishingOperation = this.persistenceService.createFishingOperation(fishingOperation);
        } else {
            this.persistenceService.saveFishingOperation(fishingOperation);
        }
        BeanComboBox<Caracteristic> keyCombo = this.ui.getNewRowKey();
        keyCombo.addItem((Object)row.getKey());
        this.selectFirstInCombo(keyCombo);
        this.getModel().getRows().remove(rowIndex);
        this.getTableModel().fireTableRowsDeleted(rowIndex, rowIndex);
    }

    protected void saveRow(GearShootingRowModel row) {
        FishingOperation fishingOperation = this.getModel().getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        if (fishingOperation.getGearShootingCaracteristics() == null) {
            fishingOperation.setGearShootingCaracteristics(new CaracteristicMap());
        }
        fishingOperation.getGearShootingCaracteristics().put((Object)row.getKey(), (Object)row.getValue());
        if (TuttiEntities.isNew((IdAware)fishingOperation)) {
            fishingOperation = this.persistenceService.createFishingOperation(fishingOperation);
        } else {
            this.persistenceService.saveFishingOperation(fishingOperation);
        }
    }
}

